/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.eventQueue;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.eventQueue.EventFrame;
import org.brailleblaster.perspectives.braille.eventQueue.EventQueue;
import org.brailleblaster.perspectives.braille.eventQueue.RedoQueue;
import org.brailleblaster.perspectives.braille.eventQueue.UndoQueue;
import org.brailleblaster.perspectives.braille.eventQueue.ViewEvent;
import org.brailleblaster.perspectives.braille.mapping.maps.MapList;
import org.brailleblaster.perspectives.braille.viewInitializer.ViewInitializer;
import org.brailleblaster.perspectives.mvc.events.ModularEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0014\u001a\u0004\u0018\u00010\fJ\b\u0010\u0015\u001a\u0004\u0018\u00010\fJ\u0006\u0010\u0016\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/brailleblaster/perspectives/braille/eventQueue/QueueManager;", "", "<init>", "()V", "undoQueue", "Lorg/brailleblaster/perspectives/braille/eventQueue/EventQueue;", "redoQueue", "swapFrame", "", "addUndoEvent", "", "f", "Lorg/brailleblaster/perspectives/braille/eventQueue/EventFrame;", "addRedoEvent", "clearViewEvents", "q", "undo", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "redo", "peekUndoEvent", "peekRedoEvent", "popUndoEvent", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nQueueManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueueManager.kt\norg/brailleblaster/perspectives/braille/eventQueue/QueueManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class QueueManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventQueue undoQueue = new UndoQueue();
    @NotNull
    private final EventQueue redoQueue = new RedoQueue();
    private boolean swapFrame;
    private static final int FIRST_ITEM_ID = 1;

    public final void addUndoEvent(@NotNull EventFrame f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        if (f.peek() instanceof ModularEvent) {
            this.clearViewEvents(this.undoQueue);
        }
        if (this.undoQueue.empty()) {
            f.setId(1);
            if (!this.redoQueue.empty() && !this.swapFrame) {
                this.redoQueue.clear();
            }
        } else {
            EventFrame eventFrame = this.undoQueue.peek();
            Intrinsics.checkNotNull((Object)eventFrame);
            int id = eventFrame.getId() + 1;
            if (!this.redoQueue.empty()) {
                EventFrame eventFrame2 = this.redoQueue.peek();
                Intrinsics.checkNotNull((Object)eventFrame2);
                if (eventFrame2.getId() == id) {
                    this.redoQueue.clear();
                }
            }
            f.setId(id);
        }
        this.undoQueue.add(f);
    }

    public final void addRedoEvent(@NotNull EventFrame f) {
        int n;
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        if (f.peek() instanceof ModularEvent) {
            this.clearViewEvents(this.redoQueue);
        }
        if (this.undoQueue.empty()) {
            n = 1;
        } else {
            EventFrame eventFrame = this.undoQueue.peek();
            Intrinsics.checkNotNull((Object)eventFrame);
            n = eventFrame.getId() + 1;
        }
        int id = n;
        f.setId(id);
        this.redoQueue.add(f);
    }

    private final void clearViewEvents(EventQueue q) {
        while (true) {
            boolean bl;
            if ((EventFrame)q.peekLast() != null) {
                EventFrame it;
                boolean bl2 = false;
                bl = !it.empty() && it.get(0) instanceof ViewEvent;
            } else {
                bl = false;
            }
            if (!bl) break;
            q.removeLast();
        }
    }

    public final void undo(@NotNull Manager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        ViewInitializer viewInitializer = manager.getViewInitializer();
        Intrinsics.checkNotNullExpressionValue((Object)viewInitializer, (String)"getViewInitializer(...)");
        MapList mapList = manager.getMapList();
        Intrinsics.checkNotNullExpressionValue((Object)mapList, (String)"getMapList(...)");
        this.undoQueue.popEvent(viewInitializer, mapList, manager);
    }

    public final void redo(@NotNull Manager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.swapFrame = true;
        ViewInitializer viewInitializer = manager.getViewInitializer();
        Intrinsics.checkNotNullExpressionValue((Object)viewInitializer, (String)"getViewInitializer(...)");
        MapList mapList = manager.getMapList();
        Intrinsics.checkNotNullExpressionValue((Object)mapList, (String)"getMapList(...)");
        this.redoQueue.popEvent(viewInitializer, mapList, manager);
        this.swapFrame = false;
    }

    @Nullable
    public final EventFrame peekUndoEvent() {
        return this.undoQueue.peek();
    }

    @Nullable
    public final EventFrame peekRedoEvent() {
        return this.redoQueue.peek();
    }

    @NotNull
    public final EventFrame popUndoEvent() {
        Object e = this.undoQueue.removeLast();
        Intrinsics.checkNotNullExpressionValue(e, (String)"removeLast(...)");
        return (EventFrame)e;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/brailleblaster/perspectives/braille/eventQueue/QueueManager$Companion;", "", "<init>", "()V", "FIRST_ITEM_ID", "", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

