/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.eventQueue;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.eventQueue.Event;
import org.brailleblaster.perspectives.braille.eventQueue.EventFrame;
import org.brailleblaster.perspectives.braille.eventQueue.EventQueue;
import org.brailleblaster.perspectives.braille.eventQueue.EventTypes;
import org.brailleblaster.perspectives.braille.mapping.maps.MapList;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.braille.stylers.TextUpdateHandler;
import org.brailleblaster.perspectives.braille.viewInitializer.ViewInitializer;
import org.brailleblaster.perspectives.mvc.events.ModularEvent;
import org.brailleblaster.perspectives.mvc.events.Queuer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/brailleblaster/perspectives/braille/eventQueue/UndoQueue;", "Lorg/brailleblaster/perspectives/braille/eventQueue/EventQueue;", "<init>", "()V", "handleEvent", "", "frame", "Lorg/brailleblaster/perspectives/braille/eventQueue/EventFrame;", "vi", "Lorg/brailleblaster/perspectives/braille/viewInitializer/ViewInitializer;", "list", "Lorg/brailleblaster/perspectives/braille/mapping/maps/MapList;", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "Companion", "brailleblaster-core"})
public final class UndoQueue
extends EventQueue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger logger = LoggerFactory.getLogger(UndoQueue.class);

    @Override
    protected void handleEvent(@NotNull EventFrame frame, @NotNull ViewInitializer vi, @NotNull MapList list, @NotNull Manager manager) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)vi, (String)"vi");
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        while (!frame.empty()) {
            Event event = frame.get(frame.size() - 1);
            if (event instanceof ModularEvent) {
                Queuer q = new Queuer(manager);
                q.handleEvent(frame, Sender.UNDO_QUEUE);
                continue;
            }
            if (event.getEventType() == EventTypes.Edit) {
                TextUpdateHandler editHandler = new TextUpdateHandler(manager, vi, list);
                editHandler.undoEdit(frame);
                continue;
            }
            logger.warn("Uncaught event for " + event.getEventType());
            frame.pop();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/brailleblaster/perspectives/braille/eventQueue/UndoQueue$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

