/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.mapping.elements;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.document.BrailleDocument;
import org.brailleblaster.perspectives.braille.mapping.elements.BoxLineTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.FormattingWhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.elements.ReadOnlyTableTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TableTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.interfaces.Deletable;
import org.brailleblaster.perspectives.braille.messages.AdjustLocalStyleMessage;
import org.brailleblaster.tools.PageBreakTool;
import org.brailleblaster.utd.IStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0003\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/brailleblaster/perspectives/braille/mapping/elements/PageBreakWhiteSpaceElement;", "Lorg/brailleblaster/perspectives/braille/mapping/elements/FormattingWhiteSpaceElement;", "Lorg/brailleblaster/perspectives/braille/mapping/interfaces/Deletable;", "<init>", "()V", "start", "", "end", "(II)V", "deleteNode", "Lnu/xom/ParentNode;", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "findParent", "Lnu/xom/Element;", "t", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nPageBreakWhiteSpaceElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PageBreakWhiteSpaceElement.kt\norg/brailleblaster/perspectives/braille/mapping/elements/PageBreakWhiteSpaceElement\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1#2:72\n*E\n"})
public final class PageBreakWhiteSpaceElement
extends FormattingWhiteSpaceElement
implements Deletable {
    public PageBreakWhiteSpaceElement() {
    }

    public PageBreakWhiteSpaceElement(int start, int end) {
        super(start, end);
    }

    @Override
    @Nullable
    public ParentNode deleteNode(@NotNull Manager m) {
        IStyle style;
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        int pbIndex = m.getMapList().indexOf(this);
        if (!(pbIndex != -1)) {
            boolean $i$a$-require-PageBreakWhiteSpaceElement$deleteNode$22 = false;
            String $i$a$-require-PageBreakWhiteSpaceElement$deleteNode$22 = "PageBreakWhiteSpaceElement not in MapList";
            throw new IllegalArgumentException($i$a$-require-PageBreakWhiteSpaceElement$deleteNode$22.toString());
        }
        TextMapElement prev = m.getMapList().findPreviousNonWhitespace(pbIndex);
        TextMapElement next = m.getMapList().findNextNonWhitespace(pbIndex);
        if (prev != null) {
            Element element = this.findParent(prev, m);
            Intrinsics.checkNotNull((Object)element);
            style = m.getStyle((Node)element);
            if (style != null && style.getNewPagesAfter() > 0) {
                if (prev instanceof TableTextMapElement || prev instanceof ReadOnlyTableTextMapElement) {
                    PageBreakTool.changePagesOfTable(Manager.getTableParent(prev.getNode()), style.getNewPagesBefore(), style.getNewPagesAfter() - 1, m);
                } else {
                    Element element2 = this.findParent(prev, m);
                    Intrinsics.checkNotNull((Object)element2);
                    m.dispatch(AdjustLocalStyleMessage.Companion.adjustPages(element2, style.getNewPagesBefore(), style.getNewPagesAfter() - 1));
                }
            }
        }
        if (next != null) {
            Element element = this.findParent(next, m);
            Intrinsics.checkNotNull((Object)element);
            style = m.getStyle((Node)element);
            if (style != null && style.getNewPagesBefore() > 0) {
                if (next instanceof TableTextMapElement || next instanceof ReadOnlyTableTextMapElement) {
                    PageBreakTool.changePagesOfTable(Manager.getTableParent(next.getNode()), style.getNewPagesBefore() - 1, style.getNewPagesAfter(), m);
                } else {
                    Element element3 = this.findParent(next, m);
                    Intrinsics.checkNotNull((Object)element3);
                    m.dispatch(AdjustLocalStyleMessage.Companion.adjustPages(element3, style.getNewPagesBefore() - 1, style.getNewPagesAfter()));
                }
            }
        }
        return null;
    }

    private final Element findParent(TextMapElement t, Manager m) {
        Element element;
        if (t instanceof ReadOnlyTableTextMapElement) {
            return Manager.getTableParent(((ReadOnlyTableTextMapElement)t).getNode());
        }
        if (t instanceof BoxLineTextMapElement) {
            element = ((BoxLineTextMapElement)t).getNodeParent();
        } else {
            BrailleDocument brailleDocument = m.getDocument();
            Node node = t.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
            element = brailleDocument.getParent(node);
        }
        return element;
    }
}

