/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.mapping.elements;

import java.util.Collections;
import java.util.LinkedList;
import java.util.stream.Stream;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.perspectives.braille.mapping.elements.AbstractMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.BrailleMapElement;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.jetbrains.annotations.Nullable;

public class TextMapElement
extends AbstractMapElement {
    public LinkedList<BrailleMapElement> brailleList;
    private boolean readOnly = false;
    private boolean fullyVisible;
    private String invisibleText;
    private Node node;

    public TextMapElement(int start, int end, Node n) {
        super(start, end);
        this.node = n;
        this.brailleList = new LinkedList();
        this.fullyVisible = true;
        this.invisibleText = "";
    }

    public TextMapElement(Node n) {
        this.node = n;
        this.brailleList = new LinkedList();
        this.fullyVisible = true;
        this.invisibleText = "";
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public int textLength() {
        return this.getNode().getValue().length();
    }

    public void sort() {
        for (int i = 0; i < this.brailleList.size() - 1; ++i) {
            if (this.brailleList.get(i).getVPos() == null || this.brailleList.get(i + 1).getVPos() == null || !this.brailleList.get(i).getVPos().equals(this.brailleList.get(i + 1).getVPos()) || this.brailleList.get(i).getHPos() == null || this.brailleList.get(i + 1).getHPos() == null || !(this.brailleList.get(i).getHPos() > this.brailleList.get(i + 1).getHPos())) continue;
            Collections.swap(this.brailleList, i, i + 1);
        }
    }

    public boolean isSpatialMath() {
        Node node = this.getNode();
        return this.getNode() != null && node.getDocument() != null && MathModuleUtils.isSpatialMath(node);
    }

    public boolean isMathML() {
        Node node = this.getNode();
        return node instanceof Element && ((Element)node).getLocalName().equals("math");
    }

    public boolean ancestorIsMath(Node text) {
        return XMLHandler.Companion.ancestorVisitorElement(text, n -> n.getLocalName().equals("math")) != null;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isFullyVisible() {
        return this.fullyVisible;
    }

    public void setFullyVisible(boolean fullyVisible) {
        this.fullyVisible = fullyVisible;
    }

    public String getInvisibleText() {
        return this.invisibleText;
    }

    public void appendInvisibleText(String invisibleText) {
        this.invisibleText = this.invisibleText + invisibleText;
    }

    @Nullable
    public Element getBlock() {
        Element p = this.getNodeParent();
        return Stream.iterate(p, e -> e instanceof Element, Node::getParent).filter(e -> "BLOCK".equals(((Element)e).getLocalName())).findFirst().orElse(null);
    }
}

