/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.mapping.maps;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.StreamSupport;
import kotlin.sequences.Sequence;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.exceptions.OutdatedMapListException;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.document.BrailleDocument;
import org.brailleblaster.perspectives.braille.mapping.elements.AbstractMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.BoxLineTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.BrailleMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.LineBreakElement;
import org.brailleblaster.perspectives.braille.mapping.elements.NewPageBrlMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.PageIndicatorTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.PaintedWhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TableTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.WhiteSpaceElement;
import org.brailleblaster.perspectives.braille.messages.Message;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.utd.utils.TableUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapList
extends LinkedList<TextMapElement> {
    @NotNull
    final Manager dm;
    private TextMapElement current;
    private int currentIndex = -1;
    private int prevEnd;
    private int nextStart;
    private int prevBraille;
    private int nextBraille;

    public MapList(@NotNull Manager dm) {
        this.dm = dm;
    }

    public int findClosest(int offset, TextMapElement treeSelection, int low, int high) {
        int nodeIndex = this.getNodeIndex(treeSelection);
        int index = this.findClosestHelper(offset, nodeIndex, low, high);
        if (this.get(index) instanceof LineBreakElement && ((LineBreakElement)this.get(index)).isEndOfLine() && index > 0 && ((TextMapElement)this.get(index - 1)).getEnd(this) == ((TextMapElement)this.get(index)).getStart(this)) {
            --index;
        }
        return index;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int findClosestHelper(int location, int nodeIndex, int low, int high) {
        int mid;
        block16: {
            if (location <= ((TextMapElement)this.get(0)).getStart(this)) {
                return 0;
            }
            if (location >= ((TextMapElement)this.getLast()).getEnd(this)) {
                return this.indexOf(this.getLast());
            }
            mid = low + (high - low) / 2;
            TextMapElement currentElement = (TextMapElement)this.get(mid);
            if (location >= currentElement.getStart(this) && location <= currentElement.getEnd(this)) {
                if (location == currentElement.getEnd(this) && location == ((TextMapElement)this.get(mid + 1)).getStart(this)) {
                    if (mid == nodeIndex) {
                        return mid;
                    }
                    if (mid + 1 == nodeIndex) {
                        return mid + 1;
                    }
                    break block16;
                } else {
                    if (location == currentElement.getStart(this) && location == ((TextMapElement)this.get(mid - 1)).getEnd(this)) {
                        if (nodeIndex == mid - 1) {
                            return mid - 1;
                        }
                        return mid;
                    }
                    return mid;
                }
            }
            if (location > currentElement.getEnd(this) && location < ((TextMapElement)this.get(mid + 1)).getStart(this)) {
                if (location - currentElement.getEnd(this) < ((TextMapElement)this.get(mid + 1)).getStart(this) - location) {
                    return mid;
                }
                if (location - currentElement.getEnd(this) > ((TextMapElement)this.get(mid + 1)).getStart(this) - location) {
                    return mid + 1;
                }
                if (mid == nodeIndex) {
                    return mid;
                }
                if (mid + 1 == nodeIndex) {
                    return mid + 1;
                }
                return mid;
            }
        }
        if (low > high) {
            return -1;
        }
        if (location < ((TextMapElement)this.get(mid)).getStart(this)) {
            return this.findClosestHelper(location, nodeIndex, low, mid - 1);
        }
        return this.findClosestHelper(location, nodeIndex, mid + 1, high);
    }

    public int findClosestBraille(int offset, TextMapElement treeSelection) {
        int nodeIndex = this.getNodeIndex(treeSelection);
        return this.findClosestBrailleHelper(offset, nodeIndex);
    }

    private int findClosestBrailleHelper(int location, int nodeIndex) {
        if (!((TextMapElement)this.getFirst()).brailleList.isEmpty() && location <= ((TextMapElement)this.getFirst()).brailleList.getFirst().getStart(this)) {
            return 0;
        }
        if (!((TextMapElement)this.getLast()).brailleList.isEmpty() && location >= ((TextMapElement)this.getLast()).brailleList.getLast().getEnd(this)) {
            return this.indexOf(this.getLast());
        }
        for (int i = 0; i < this.size(); ++i) {
            int nextStart;
            if (!(this.get(i) instanceof TableTextMapElement) && ((TextMapElement)this.get((int)i)).brailleList.isEmpty()) continue;
            int start = this.getStartBrailleOffset((TextMapElement)this.get(i));
            int end = this.getEndBrailleOffset((TextMapElement)this.get(i));
            if (location >= start && location <= end) {
                return i;
            }
            if (i + 1 >= this.size() || (nextStart = this.getStartBrailleOffset((TextMapElement)this.get(i + 1))) == -1 || location <= end || location >= nextStart) continue;
            if (location - end > nextStart - location) {
                return i + 1;
            }
            if (location - end < nextStart - location) {
                return i;
            }
            if (i == nodeIndex) {
                return i;
            }
            if (i + 1 == nodeIndex) {
                return i + 1;
            }
            return i;
        }
        return 0;
    }

    private int getStartBrailleOffset(TextMapElement tme) {
        if (tme instanceof TableTextMapElement && !((TableTextMapElement)tme).tableElements.isEmpty() && !((TableTextMapElement)tme).tableElements.getFirst().brailleList.isEmpty()) {
            return ((BrailleMapElement)((TableTextMapElement)tme).tableElements.getFirst().brailleList.getFirst()).getStart(this);
        }
        if (!tme.brailleList.isEmpty()) {
            return tme.brailleList.getFirst().getStart(this);
        }
        return -1;
    }

    private int getEndBrailleOffset(TextMapElement tme) {
        if (tme instanceof TableTextMapElement && !((TableTextMapElement)tme).tableElements.isEmpty() && !((TableTextMapElement)tme).tableElements.getFirst().brailleList.isEmpty()) {
            return ((BrailleMapElement)((TableTextMapElement)tme).tableElements.getLast().brailleList.getLast()).getEnd(this);
        }
        if (!tme.brailleList.isEmpty()) {
            return tme.brailleList.getLast().getEnd(this);
        }
        return -1;
    }

    public TextMapElement getElementInRange(int offset) {
        int index = this.findClosest(offset, this.getCurrent(), 0, this.size() - 1);
        TextMapElement t = null;
        if (index != -1) {
            t = (TextMapElement)this.get(index);
        }
        if (t != null && offset >= t.getStart(this) && offset <= t.getEnd(this)) {
            return t;
        }
        return null;
    }

    public Set<TextMapElement> getElementInSelectedRange(int start, int end) {
        LinkedHashSet<TextMapElement> elementSelectedSet = new LinkedHashSet<TextMapElement>();
        LinkedHashSet<Element> parentElement = new LinkedHashSet<Element>();
        int j = start;
        while (j < end) {
            TextMapElement t = this.getElementInRange(j);
            if (t != null && !(t instanceof WhiteSpaceElement)) {
                Element currentParent;
                Element element = currentParent = t instanceof BoxLineTextMapElement ? t.getNodeParent() : this.dm.getDocument().getParent(t.getNode());
                if (!parentElement.contains(currentParent)) {
                    parentElement.add(currentParent);
                    elementSelectedSet.add(t);
                }
                j = t.getEnd(this) + 1;
                continue;
            }
            ++j;
        }
        return elementSelectedSet;
    }

    public Set<TextMapElement> getElementsOneByOne(int start, int end) {
        LinkedHashSet<TextMapElement> elementSelectedSet = new LinkedHashSet<TextMapElement>();
        for (int i = start; i < end; ++i) {
            TextMapElement t = this.getClosest(i, true);
            if (t == null || t instanceof WhiteSpaceElement) continue;
            elementSelectedSet.add(t);
        }
        return elementSelectedSet;
    }

    public void adjustOffsets(String type, int index, int position) {
        TextMapElement t = (TextMapElement)this.get(index);
        if (type.equals("start")) {
            t.setStart(t.getStart(this) - position);
            if (!t.brailleList.isEmpty()) {
                t.brailleList.getFirst().setStart(t.brailleList.getFirst().getStart(this) - position);
            }
        }
        if (type.equals("end")) {
            t.setEnd(t.getEnd(this) + position);
            if (!t.brailleList.isEmpty()) {
                t.brailleList.getLast().setEnd(t.brailleList.getLast().getEnd(this) + position);
            }
        }
    }

    @NotNull
    public TextMapElement setCurrent(int index) {
        TextMapElement result;
        this.current = result = (TextMapElement)this.get(index);
        this.currentIndex = index;
        this.prevEnd = index > 0 && this.getPrevious(false) != null ? this.getPrevious(false).getEnd(this) : -1;
        this.nextStart = index != this.size() - 1 && this.getNext(false) != null ? this.getNext(false).getStart(this) : -1;
        this.nextBraille = this.getNextBraille(index);
        this.prevBraille = this.getPreviousBraille(index);
        return result;
    }

    @NotNull
    public TextMapElement getCurrent() {
        if (this.current != null) {
            return this.current;
        }
        try {
            return this.setCurrent(0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new OutdatedMapListException("MapList is empty", (Throwable)e);
        }
    }

    public int getCurrentIndex() {
        if (this.isEmpty()) {
            return -1;
        }
        if (this.current == null) {
            this.currentIndex = this.findClosest(((TextMapElement)this.getFirst()).getStart(this), (TextMapElement)this.getFirst(), 0, this.size() - 1);
        }
        return this.currentIndex;
    }

    public int getCurrentBrailleEnd() {
        if (this.current.brailleList.isEmpty()) {
            if (this.currentIndex > 0) {
                TextMapElement t = (TextMapElement)this.get(this.currentIndex - 1);
                if (!t.brailleList.isEmpty()) {
                    return t.brailleList.getLast().getEnd(this);
                }
            }
            return 0;
        }
        return this.current.brailleList.getLast().getEnd(this);
    }

    public int getCurrentBrailleOffset() {
        for (int i = 0; i < this.current.brailleList.size(); ++i) {
            if (this.current.brailleList.get(i) instanceof NewPageBrlMapElement || this.current.brailleList.get(i).getStart(this) == -1) continue;
            return this.current.brailleList.get(i).getStart(this);
        }
        return 0;
    }

    private int getNextBraille(int index) {
        TextMapElement tme = this.getNext(index, false);
        if (tme != null && !tme.brailleList.isEmpty()) {
            return tme.brailleList.getFirst().getStart(this);
        }
        return -1;
    }

    private int getPreviousBraille(int index) {
        int localIndex;
        for (localIndex = index - 1; localIndex >= 0 && ((TextMapElement)this.get((int)localIndex)).brailleList.isEmpty(); --localIndex) {
        }
        if (localIndex >= 0) {
            return ((TextMapElement)this.get((int)localIndex)).brailleList.getLast().getEnd(this);
        }
        return -1;
    }

    public void getCurrentNodeData(Message m, int offset, TextMapElement treeSelection, Sender sender) {
        if (this.current == null) {
            int index = sender.equals((Object)Sender.BRAILLE) ? this.findClosestBraille(offset, treeSelection) : this.findClosest(offset, treeSelection, 0, this.size() - 1);
            this.setCurrent(index);
        }
        m.put("start", this.current.getStart(this));
        m.put("end", this.current.getEnd(this));
        m.put("previous", this.prevEnd);
        m.put("next", this.nextStart);
        m.put("brailleStart", this.getCurrentBrailleOffset());
        m.put("brailleEnd", this.getCurrentBrailleEnd());
        m.put("nextBrailleStart", this.nextBraille);
        m.put("previousBrailleEnd", this.prevBraille);
        m.put("currentElement", this.current);
    }

    public int getNodeIndex(TextMapElement t) {
        return this.indexOf(t);
    }

    public void findTextMapElements(ArrayList<Node> textList, ArrayList<TextMapElement> itemList) {
        int pos = 0;
        block0: for (Node node : textList) {
            for (int j = pos; j < this.size(); ++j) {
                if (this.get(j) instanceof TableTextMapElement && node.equals((Object)((TextMapElement)this.get(j)).getNodeParent())) {
                    itemList.add((TextMapElement)this.get(j));
                    pos = j + 1;
                    continue block0;
                }
                if (this.get(j) instanceof BoxLineTextMapElement && node.equals((Object)((TextMapElement)this.get(j)).getNode())) {
                    itemList.add((TextMapElement)this.get(j));
                    pos = j + 1;
                    continue block0;
                }
                if (!node.equals((Object)((TextMapElement)this.get(j)).getNode())) continue;
                itemList.add((TextMapElement)this.get(j));
                pos = j + 1;
                continue block0;
            }
        }
    }

    public List<TextMapElement> findTextMapElements(int index, Element parent) {
        ArrayList<TextMapElement> list = new ArrayList<TextMapElement>();
        BrailleDocument doc = this.dm.getDocument();
        int countUp = index + 1;
        for (int countDown = index - 1; countDown >= 0 && ((TextMapElement)this.get(countDown)).getNodeParent() != null && !(this.get(countDown) instanceof PageIndicatorTextMapElement) && doc.getParent(((TextMapElement)this.get(countDown)).getNode()).equals((Object)parent); --countDown) {
            list.addFirst((TextMapElement)this.get(countDown));
        }
        list.add((TextMapElement)this.get(index));
        while (countUp < this.size() && ((TextMapElement)this.get(countUp)).getNodeParent() != null && !(this.get(countUp) instanceof PageIndicatorTextMapElement) && doc.getParent(((TextMapElement)this.get(countUp)).getNode()).equals((Object)parent)) {
            list.add((TextMapElement)this.get(countUp));
            ++countUp;
        }
        return list;
    }

    public List<Integer> findTextMapElementRange(int index, Element parent) {
        parent = this.dm.getDocument().getParent((Node)parent);
        ArrayList<Integer> list = new ArrayList<Integer>();
        BrailleDocument doc = this.dm.getDocument();
        int countUp = index + 1;
        for (int countDown = index - 1; countDown >= 0 && ((TextMapElement)this.get(countDown)).getNodeParent() != null && doc.getParent(((TextMapElement)this.get(countDown)).getNode()).equals((Object)parent); --countDown) {
            list.addFirst(countDown);
        }
        list.add(index);
        while (countUp < this.size() && ((TextMapElement)this.get(countUp)).getNodeParent() != null && doc.getParent(((TextMapElement)this.get(countUp)).getNode()).equals((Object)parent)) {
            list.add(countUp);
            ++countUp;
        }
        return list;
    }

    @Nullable
    public TextMapElement findNode(Node n) {
        int index = this.findNodeIndex(n, 0);
        if (index == -1) {
            return null;
        }
        return (TextMapElement)this.get(index);
    }

    public int findNodeIndex(Node n, int startIndex) {
        ParentNode parent;
        int index;
        Node potentialTable;
        Element usableElement = (Element)(n instanceof Text ? n.getParent() : n);
        if (usableElement.getNamespaceURI().equals("http://www.w3.org/1998/Math/MathML")) {
            n = XMLHandler.Companion.ancestorVisitor(n, curAncestor -> BBX.INLINE.MATHML.isA((Node)curAncestor.getParent()));
        }
        if ((potentialTable = XMLHandler.Companion.ancestorVisitor(Objects.requireNonNull(n), e -> BBX.CONTAINER.TABLE.isA((Node)e) && "simple".equals(((Element)e).getAttributeValue("format")))) != null) {
            n = potentialTable;
        }
        if (BBX.CONTAINER.TABLE.isA(n) && !TableUtils.isTableCopy((Element)((Element)n)) && (index = (parent = n.getParent()).indexOf(n)) + 1 < parent.getChildCount() && BBX.CONTAINER.TABLE.isA(parent.getChild(index + 1)) && TableUtils.isTableCopy((Element)((Element)parent.getChild(index + 1)))) {
            n = parent.getChild(index + 1);
        }
        ArrayList<Node> children = new ArrayList<Node>();
        children.add(n);
        if (n instanceof Element && !BBX.CONTAINER.TABLE.isA(n)) {
            children.addAll(StreamSupport.stream(((Iterable)() -> ((Sequence)FastXPath.descendant((Node)n)).iterator()).spliterator(), false).filter(node -> XMLHandler.Companion.ancestorElementNot(node, arg_0 -> ((UTDElements)UTDElements.BRL).isA(arg_0))).toList());
        }
        for (int i = startIndex; i < this.size(); ++i) {
            Node node2 = ((TextMapElement)this.get(i)).getNode();
            if (node2 == null) continue;
            for (Node child : children) {
                if (!node2.equals((Object)child)) continue;
                return i;
            }
        }
        return -1;
    }

    public void clearList() {
        this.clear();
        this.current = null;
        this.currentIndex = -1;
    }

    public void resetList() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ((TextMapElement)this.get(i)).resetOffsets();
            for (int j = 0; j < ((TextMapElement)this.get((int)i)).brailleList.size(); ++j) {
                ((TextMapElement)this.get((int)i)).brailleList.get(j).setOffsets(0, 0);
            }
        }
    }

    public boolean inPrintPageRange(int offset) {
        int index;
        if (this.size() > 0 && this.get(index = this.findClosest(offset, null, 0, this.size() - 1)) instanceof PageIndicatorTextMapElement) {
            return offset >= ((TextMapElement)this.get(index)).getStart(this) && offset <= ((TextMapElement)this.get(index)).getEnd(this);
        }
        return false;
    }

    public boolean inBraillePageRange(int offset) {
        int index;
        if (this.size() > 0 && this.get(index = this.findClosestBraille(offset, null)) instanceof PageIndicatorTextMapElement) {
            return offset >= ((TextMapElement)this.get((int)index)).brailleList.getFirst().getStart(this) && offset <= ((TextMapElement)this.get((int)index)).brailleList.getLast().getEnd(this);
        }
        return false;
    }

    @Nullable
    public BoxLineTextMapElement findJoiningBoxline(BoxLineTextMapElement b) {
        block3: {
            block2: {
                int index = this.indexOf(b);
                if (b.getNodeParent().indexOf(b.getNode()) != 0) break block2;
                for (int i = index + 1; i < this.size(); ++i) {
                    if (!(this.get(i) instanceof BoxLineTextMapElement) || !((TextMapElement)this.get(i)).getNodeParent().equals((Object)b.getNodeParent())) continue;
                    return (BoxLineTextMapElement)this.get(i);
                }
                break block3;
            }
            if (b.getNodeParent().indexOf(b.getNode()) != b.getNodeParent().getChildCount() - 1) break block3;
            for (int i = index - 1; i >= 0; --i) {
                if (!(this.get(i) instanceof BoxLineTextMapElement) || !((TextMapElement)this.get(i)).getNodeParent().equals((Object)b.getNodeParent())) continue;
                return (BoxLineTextMapElement)this.get(i);
            }
        }
        return null;
    }

    @Nullable
    public TextMapElement findClosestNonWhitespace(WhiteSpaceElement wse) {
        TextMapElement first = null;
        TextMapElement last = null;
        int index = this.indexOf(wse);
        if (index == 0) {
            last = this.findNextNonWhitespace(index);
        } else if (index == this.size() - 1) {
            first = this.findPreviousNonWhitespace(index);
        } else {
            last = this.findNextNonWhitespace(index);
            first = this.findPreviousNonWhitespace(index);
        }
        if (first != null) {
            if (last == null) {
                return first;
            }
            if (first instanceof PageIndicatorTextMapElement) {
                return last;
            }
            if (last instanceof PageIndicatorTextMapElement) {
                return first;
            }
            if (wse.getStart(this) - first.getEnd(this) <= last.getStart(this) - wse.getEnd(this)) {
                return first;
            }
            return last;
        }
        return last;
    }

    @Nullable
    public TextMapElement findPreviousNonWhitespace(int index) {
        TextMapElement t = null;
        while (index >= 0 && t == null) {
            if (!(this.get(index) instanceof WhiteSpaceElement)) {
                t = (TextMapElement)this.get(index);
            }
            --index;
        }
        return t;
    }

    @Nullable
    private TextMapElement findPrevious(int index) {
        TextMapElement t = null;
        while (index >= 0 && t == null) {
            if (!this.isIgnorableWhiteSpace((TextMapElement)this.get(index))) {
                t = (TextMapElement)this.get(index);
            }
            --index;
        }
        return t;
    }

    public TextMapElement findNextNonWhitespace(int index) {
        TextMapElement t = null;
        while (index < this.size() && t == null) {
            if (!(this.get(index) instanceof WhiteSpaceElement)) {
                t = (TextMapElement)this.get(index);
            }
            ++index;
        }
        return t;
    }

    private TextMapElement findNext(int index) {
        TextMapElement t = null;
        while (index < this.size() && t == null) {
            if (!this.isIgnorableWhiteSpace((TextMapElement)this.get(index))) {
                t = (TextMapElement)this.get(index);
            }
            ++index;
        }
        return t;
    }

    private boolean isIgnorableWhiteSpace(TextMapElement tme) {
        return tme instanceof LineBreakElement && ((LineBreakElement)tme).isEndOfLine() || tme instanceof PaintedWhiteSpaceElement;
    }

    public String printContents(boolean showBrailleList) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.size()) {
            TextMapElement curTME = (TextMapElement)this.get(i);
            sb.append(curTME.getClass().getSimpleName()).append(" -- Index:").append(i).append("  Offsets:").append(curTME.getStart(this)).append("-").append(curTME.getEnd(this)).append(". Braillelist size: ").append(curTME.brailleList.size()).append(" Node: ").append(curTME.getNode() == null ? "null" : XMLHandler.toXMLSimple((Node)curTME.getNode())).append("\n");
            ++i;
            if (!showBrailleList) continue;
            int subI = 0;
            for (BrailleMapElement brailleMapElement : curTME.brailleList) {
                sb.append("-").append(brailleMapElement.getClass().getSimpleName()).append(" -- Index:").append(subI).append(" Braille: ").append(brailleMapElement.getNode() == null ? "null" : XMLHandler.toXMLSimple((Node)brailleMapElement.getNode())).append("\n");
                ++subI;
            }
        }
        return sb.toString();
    }

    public TextMapElement getPrevious(boolean ignoreWhitespace) {
        return this.getPrevious(this.getCurrentIndex(), ignoreWhitespace);
    }

    public TextMapElement getPrevious(int index, boolean ignoreWhitespace) {
        if (ignoreWhitespace) {
            return this.findPreviousNonWhitespace(index - 1);
        }
        if (index > 0) {
            return this.findPrevious(index - 1);
        }
        return null;
    }

    public TextMapElement getNext(boolean ignoreWhitespace) {
        return this.getNext(this.getCurrentIndex(), ignoreWhitespace);
    }

    @Nullable
    public TextMapElement getNext(int index, boolean ignoreWhitespace) {
        if (ignoreWhitespace) {
            return this.findNextNonWhitespace(index + 1);
        }
        if (!this.isEmpty() && index < this.size() - 1) {
            return this.findNext(index + 1);
        }
        return null;
    }

    public TextMapElement getClosest(int offset, boolean ignoreWhitespace) {
        TextMapElement t;
        if (ignoreWhitespace) {
            t = (TextMapElement)this.get(this.findClosest(offset, null, 0, this.size() - 1));
            if (t instanceof WhiteSpaceElement) {
                t = this.findClosestNonWhitespace((WhiteSpaceElement)t);
            }
        } else {
            t = (TextMapElement)this.get(this.findClosest(offset, null, 0, this.size() - 1));
        }
        return t;
    }

    @NotNull
    public TextMapElement getCurrentNonWhitespace(int pos) {
        return this.getClosest(pos, true);
    }

    public TextMapElement getFirstUsable() {
        return this.stream().filter(textMapElement -> !(textMapElement instanceof PaintedWhiteSpaceElement) && !(textMapElement instanceof LineBreakElement)).findFirst().orElse(null);
    }

    public TextMapElement getLastUsable() {
        return this.stream().filter(textMapElement -> !(textMapElement instanceof PaintedWhiteSpaceElement) && !(textMapElement instanceof LineBreakElement)).reduce((first, second) -> second).orElse(null);
    }

    public int getPageCount() {
        return (int)this.stream().filter(e -> e instanceof PageIndicatorTextMapElement).count();
    }

    public boolean containsNode(Node n) {
        return this.stream().map(AbstractMapElement::getNode).anyMatch(node -> node != null && node.equals((Object)n));
    }

    public int getPrevEnd() {
        return this.prevEnd;
    }

    public int getNextStart() {
        return this.nextStart;
    }

    public int getNextBraille() {
        return this.nextBraille;
    }
}

