/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.searcher;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.BrailleMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.PageIndicatorTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.PrintPageBrlMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.maps.MapList;
import org.brailleblaster.utd.exceptions.NodeException;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.properties.UTDElements;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\r\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0006J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0006\u00a8\u0006\u000f"}, d2={"Lorg/brailleblaster/perspectives/braille/searcher/Searcher;", "", "<init>", "()V", "streamCurrentBufferFromCurrentCursor", "", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "streamCurrentBufferFrom", "tme", "streamCurrentBufferReverseFromCurrentCursor", "streamCurrentBufferReverseFrom", "Filters", "Mappers", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Searcher.kt\norg/brailleblaster/perspectives/braille/searcher/Searcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1#2:114\n*E\n"})
public final class Searcher {
    @NotNull
    public static final Searcher INSTANCE = new Searcher();

    private Searcher() {
    }

    @JvmStatic
    @NotNull
    public static final Iterable<TextMapElement> streamCurrentBufferFromCurrentCursor(@NotNull Manager m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        TextMapElement textMapElement = m.getMapList().getCurrent();
        Intrinsics.checkNotNullExpressionValue((Object)textMapElement, (String)"getCurrent(...)");
        return INSTANCE.streamCurrentBufferFrom(m, textMapElement);
    }

    @NotNull
    public final Iterable<TextMapElement> streamCurrentBufferFrom(@NotNull Manager m, @NotNull TextMapElement tme) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Intrinsics.checkNotNullParameter((Object)tme, (String)"tme");
        int tmeIndex = m.getMapList().indexOf(tme);
        if (!(tmeIndex != -1)) {
            boolean bl = false;
            String string = "tme not found in current buffer " + tme;
            throw new IllegalArgumentException(string.toString());
        }
        List list = m.getMapList().subList(tmeIndex, m.getMapList().size());
        Intrinsics.checkNotNullExpressionValue(list, (String)"subList(...)");
        return list;
    }

    @JvmStatic
    @NotNull
    public static final Iterable<TextMapElement> streamCurrentBufferReverseFromCurrentCursor(@NotNull Manager m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        TextMapElement textMapElement = m.getMapList().getCurrent();
        Intrinsics.checkNotNullExpressionValue((Object)textMapElement, (String)"getCurrent(...)");
        return INSTANCE.streamCurrentBufferReverseFrom(m, textMapElement);
    }

    @NotNull
    public final Iterable<TextMapElement> streamCurrentBufferReverseFrom(@NotNull Manager m, @NotNull TextMapElement tme) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Intrinsics.checkNotNullParameter((Object)tme, (String)"tme");
        MapList mapList = m.getMapList();
        Intrinsics.checkNotNullExpressionValue((Object)mapList, (String)"getMapList(...)");
        List reverseList = CollectionsKt.reversed((Iterable)mapList);
        int tmeIndex = reverseList.indexOf(tme);
        if (!(tmeIndex != -1)) {
            boolean bl = false;
            String string = "tme not found in current buffer " + tme;
            throw new IllegalArgumentException(string.toString());
        }
        return reverseList.subList(tmeIndex, reverseList.size());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u0012\u0010\u000b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007\u00a8\u0006\f"}, d2={"Lorg/brailleblaster/perspectives/braille/searcher/Searcher$Filters;", "", "<init>", "()V", "braillePrintPageIndicator", "", "tme", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "noUTDAncestor", "node", "Lnu/xom/Node;", "isElement", "brailleblaster-core"})
    @SourceDebugExtension(value={"SMAP\nSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Searcher.kt\norg/brailleblaster/perspectives/braille/searcher/Searcher$Filters\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1807#2,3:114\n*S KotlinDebug\n*F\n+ 1 Searcher.kt\norg/brailleblaster/perspectives/braille/searcher/Searcher$Filters\n*L\n63#1:114,3\n*E\n"})
    public static final class Filters {
        @NotNull
        public static final Filters INSTANCE = new Filters();

        private Filters() {
        }

        public final boolean braillePrintPageIndicator(@NotNull TextMapElement tme) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)tme, (String)"tme");
                LinkedList<BrailleMapElement> linkedList = tme.brailleList;
                Intrinsics.checkNotNullExpressionValue(linkedList, (String)"brailleList");
                Iterable $this$any$iv = linkedList;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        BrailleMapElement brlTme = (BrailleMapElement)element$iv;
                        boolean bl2 = false;
                        if (!(brlTme instanceof PrintPageBrlMapElement)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @JvmStatic
        public static final boolean noUTDAncestor(@NotNull Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return XMLHandler.Companion.ancestorElementNot(node, Filters::noUTDAncestor$lambda$0);
        }

        @JvmStatic
        public static final boolean isElement(@Nullable Node node) {
            return node instanceof Element;
        }

        private static final boolean noUTDAncestor$lambda$0(Element curElem) {
            Intrinsics.checkNotNullParameter((Object)curElem, (String)"curElem");
            return Intrinsics.areEqual((Object)curElem.getNamespaceURI(), (Object)"http://brailleblaster.org/ns/utd");
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lorg/brailleblaster/perspectives/braille/searcher/Searcher$Mappers;", "", "<init>", "()V", "printPageNum", "", "tme", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "toElement", "Lnu/xom/Element;", "node", "Lnu/xom/Node;", "brailleblaster-core"})
    public static final class Mappers {
        @NotNull
        public static final Mappers INSTANCE = new Mappers();

        private Mappers() {
        }

        @NotNull
        public final String printPageNum(@Nullable TextMapElement tme) {
            String attributeValue;
            TextMapElement textMapElement = tme;
            if (textMapElement == null) {
                throw new NullPointerException("tme");
            }
            if (textMapElement instanceof PageIndicatorTextMapElement) {
                LinkedList linkedList = ((PageIndicatorTextMapElement)tme).brailleList;
                Intrinsics.checkNotNullExpressionValue((Object)linkedList, (String)"brailleList");
                Node brl = ((BrailleMapElement)CollectionsKt.first((List)linkedList)).getNode();
                while (!UTDElements.BRL.isA(brl)) {
                    brl = (Node)brl.getParent();
                }
                Node node = brl;
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
                attributeValue = ((Element)node).getAttributeValue("printPage");
                CharSequence charSequence = attributeValue;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    throw new NodeException("Missing printPage attribute", brl, null, 4, null);
                }
            } else {
                Iterator iterator = tme.brailleList.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    BrailleMapElement curBrailleElement = (BrailleMapElement)iterator2.next();
                    if (!(curBrailleElement instanceof PrintPageBrlMapElement)) continue;
                    String string = ((PrintPageBrlMapElement)curBrailleElement).getNode().getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                    return string;
                }
                throw new IllegalArgumentException("Not a print page num " + tme);
            }
            return attributeValue;
        }

        @JvmStatic
        @NotNull
        public static final Element toElement(@NotNull Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return (Element)node;
        }
    }
}

