/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.stylers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.brailleblaster.BBIni;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.document.BrailleDocument;
import org.brailleblaster.perspectives.braille.mapping.elements.AbstractMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.BoxLineTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.PageIndicatorTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.WhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.maps.MapList;
import org.brailleblaster.perspectives.braille.stylers.Handler;
import org.brailleblaster.perspectives.braille.viewInitializer.ViewInitializer;
import org.brailleblaster.utd.actions.IAction;
import org.brailleblaster.utd.actions.SkipAction;
import org.brailleblaster.utd.properties.UTDElements;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002J&\u0010\u0014\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0017H\u0002J\b\u0010\"\u001a\u00020\u0011H\u0002R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006#"}, d2={"Lorg/brailleblaster/perspectives/braille/stylers/HideActionHandler;", "Lorg/brailleblaster/perspectives/braille/stylers/Handler;", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "vi", "Lorg/brailleblaster/perspectives/braille/viewInitializer/ViewInitializer;", "list", "Lorg/brailleblaster/perspectives/braille/mapping/maps/MapList;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;Lorg/brailleblaster/perspectives/braille/viewInitializer/ViewInitializer;Lorg/brailleblaster/perspectives/braille/mapping/maps/MapList;)V", "boxlineAdded", "", "getBoxlineAdded", "()Z", "setBoxlineAdded", "(Z)V", "hideText", "", "hideSingleElement", "hideMultipleElements", "checkSelection", "itemSet", "", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "start", "", "end", "hide", "t", "removeBraille", "e", "Lnu/xom/Element;", "getParent", "current", "invalidSelection", "brailleblaster-core"})
public final class HideActionHandler
extends Handler {
    private boolean boxlineAdded;

    public HideActionHandler(@Nullable Manager manager, @Nullable ViewInitializer vi, @Nullable MapList list) {
        Manager manager2 = manager;
        Intrinsics.checkNotNull((Object)manager2);
        ViewInitializer viewInitializer = vi;
        Intrinsics.checkNotNull((Object)viewInitializer);
        MapList mapList = list;
        Intrinsics.checkNotNull((Object)mapList);
        super(manager2, viewInitializer, mapList);
    }

    public final boolean getBoxlineAdded() {
        return this.boxlineAdded;
    }

    public final void setBoxlineAdded(boolean bl) {
        this.boxlineAdded = bl;
    }

    public final void hideText() {
        if (!this.list.isEmpty() && this.text.getView().getCharCount() > 0) {
            if (this.text.isMultiSelected()) {
                this.hideMultipleElements();
            } else if (!(this.list.getCurrent() instanceof BoxLineTextMapElement)) {
                this.hideSingleElement();
            } else {
                this.invalidSelection();
            }
        }
    }

    private final void hideSingleElement() {
        this.text.update(false);
        this.boxlineAdded = false;
        TextMapElement textMapElement = this.manager.getMapList().getCurrent();
        Intrinsics.checkNotNullExpressionValue((Object)textMapElement, (String)"getCurrent(...)");
        TextMapElement t = textMapElement;
        if (t instanceof WhiteSpaceElement) {
            TextMapElement textMapElement2 = this.manager.getMapList().findClosestNonWhitespace((WhiteSpaceElement)t);
            Intrinsics.checkNotNull((Object)textMapElement2);
            t = textMapElement2;
            this.manager.getMapList().setCurrent(this.manager.getMapList().indexOf(t));
        }
        TextMapElement textMapElement3 = this.list.getCurrent();
        Intrinsics.checkNotNullExpressionValue((Object)textMapElement3, (String)"getCurrent(...)");
        this.hide(textMapElement3);
        Element element = this.list.getCurrent().getNodeParent();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getNodeParent(...)");
        this.reformat((Node)element, false);
    }

    private final void hideMultipleElements() {
        int start = this.text.getSelectedText()[0];
        int end = this.text.getSelectedText()[0] + this.text.getSelectedText()[1];
        Set<TextMapElement> itemSet = this.manager.getMapList().getElementInSelectedRange(start, end);
        Intrinsics.checkNotNull(itemSet);
        boolean invalid = this.checkSelection(itemSet, start, end);
        Integer index = null;
        if (!invalid) {
            Iterator<TextMapElement> itr = itemSet.iterator();
            this.boxlineAdded = false;
            while (itr.hasNext()) {
                TextMapElement tempElement = itr.next();
                if (index == null) {
                    index = this.list.indexOf(tempElement);
                }
                Intrinsics.checkNotNull((Object)tempElement);
                this.hide(tempElement);
            }
            Element element = this.list.getCurrent().getNodeParent();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getNodeParent(...)");
            this.reformat((Node)element, false);
            this.text.setCurrentSelection(this.text.getView().getCaretOffset(), this.text.getView().getCaretOffset());
        }
    }

    private final boolean checkSelection(Set<TextMapElement> itemSet, int start, int end) {
        boolean invalid = false;
        ArrayList<BoxLineTextMapElement> addToSet = new ArrayList<BoxLineTextMapElement>();
        for (TextMapElement tempElement : itemSet) {
            if (!(tempElement instanceof BoxLineTextMapElement)) continue;
            BoxLineTextMapElement b = this.list.findJoiningBoxline((BoxLineTextMapElement)tempElement);
            if (b == null || b.getStart(this.manager.getMapList()) > end || b.getEnd(this.manager.getMapList()) < start) {
                invalid = true;
                this.invalidSelection();
                break;
            }
            if (itemSet.contains(b)) continue;
            addToSet.add(b);
        }
        if (!((Collection)addToSet).isEmpty()) {
            itemSet.addAll((Collection<TextMapElement>)addToSet);
        }
        return invalid;
    }

    private final void hide(TextMapElement t) {
        Element block = this.getParent(t);
        if (this.isBoxLine(block)) {
            this.boxlineAdded = true;
        }
        this.removeBraille(block);
        this.manager.getDocument().changeAction((IAction)new SkipAction(), block);
        ParentNode parent = block.getParent();
        while (parent.getChildCount() == 1 && !BBX.SECTION.isA((Node)parent)) {
            BrailleDocument brailleDocument = this.manager.getDocument();
            IAction iAction = (IAction)new SkipAction();
            ParentNode parentNode = parent;
            Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
            brailleDocument.changeAction(iAction, (Element)parentNode);
            parent = ((Element)parent).getParent();
        }
    }

    private final void removeBraille(Element e) {
        Elements els = e.getChildElements();
        int n = els.size();
        for (int i = 0; i < n; ++i) {
            if (UTDElements.BRL.isA((Node)els.get(i))) {
                e.removeChild((Node)els.get(i));
                continue;
            }
            Element element = els.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"get(...)");
            this.removeBraille(element);
        }
    }

    private final Element getParent(TextMapElement current) {
        Element element;
        if (current instanceof PageIndicatorTextMapElement || current instanceof BoxLineTextMapElement) {
            element = ((AbstractMapElement)current).getNodeParent();
        } else {
            BrailleDocument brailleDocument = this.manager.getDocument();
            Node node = current.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
            element = brailleDocument.getParent(node);
        }
        Element parent = element;
        Intrinsics.checkNotNull((Object)parent);
        return parent;
    }

    private final void invalidSelection() {
        if (!BBIni.getDebugging()) {
            this.manager.notify("In order to hide a boxline both opening and closing boxlines must be selected");
        }
    }
}

