/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.stylers;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.document.BrailleDocument;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.maps.MapList;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.braille.messages.TabInsertionMessage;
import org.brailleblaster.perspectives.braille.stylers.Handler;
import org.brailleblaster.perspectives.braille.viewInitializer.ViewInitializer;
import org.brailleblaster.perspectives.mvc.events.ModifyEvent;
import org.brailleblaster.util.ConstantsKt;
import org.brailleblaster.utils.xom.TextSplitter;
import org.eclipse.swt.custom.StyledText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u001a\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u0016H\u0002J\u001a\u0010\u001a\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001b\u001a\u00020\u0010H\u0002\u00a8\u0006\u001c"}, d2={"Lorg/brailleblaster/perspectives/braille/stylers/TabInsertionHandler;", "Lorg/brailleblaster/perspectives/braille/stylers/Handler;", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "vi", "Lorg/brailleblaster/perspectives/braille/viewInitializer/ViewInitializer;", "list", "Lorg/brailleblaster/perspectives/braille/mapping/maps/MapList;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;Lorg/brailleblaster/perspectives/braille/viewInitializer/ViewInitializer;Lorg/brailleblaster/perspectives/braille/mapping/maps/MapList;)V", "insertTab", "", "m", "Lorg/brailleblaster/perspectives/braille/messages/TabInsertionMessage;", "adjustTab", "tabValue", "", "xInd", "currentElement", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "value", "t", "Lnu/xom/Element;", "removeTab", "findTab", "e", "calculateLineBreaks", "pos", "brailleblaster-core"})
public final class TabInsertionHandler
extends Handler {
    public TabInsertionHandler(@Nullable Manager manager, @Nullable ViewInitializer vi, @Nullable MapList list) {
        Manager manager2 = manager;
        Intrinsics.checkNotNull((Object)manager2);
        ViewInitializer viewInitializer = vi;
        Intrinsics.checkNotNull((Object)viewInitializer);
        MapList mapList = list;
        Intrinsics.checkNotNull((Object)mapList);
        super(manager2, viewInitializer, mapList);
    }

    public final void insertTab(@NotNull TabInsertionMessage m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        this.insertTab(m.tabValue, m.xIndex, m.currentElement);
    }

    public final void adjustTab(@NotNull TabInsertionMessage m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        this.adjustTab(m.tabValue, m.parent);
    }

    private final void insertTab(int tabValue, int xInd, TextMapElement currentElement) {
        int xIndex = xInd - this.calculateLineBreaks(currentElement, xInd);
        TextMapElement textMapElement = currentElement;
        Intrinsics.checkNotNull((Object)textMapElement);
        Node node = textMapElement.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
        TextSplitter split = new TextSplitter(xIndex, node);
        Element element = currentElement.getNodeParent();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getNodeParent(...)");
        ParentNode parent = (ParentNode)element;
        int curIndex = parent.indexOf(currentElement.getNode());
        parent.insertChild((Node)split.last, curIndex);
        if (xIndex > 0) {
            parent.insertChild((Node)split.first, curIndex);
        }
        parent.removeChild(currentElement.getNode());
        Element tab = BBX.SPAN.TAB.create();
        BBX.SPAN.TAB.ATTRIB_VALUE.set(tab, tabValue);
        curIndex = parent.indexOf((Node)split.last);
        parent.insertChild((Node)tab, curIndex);
        BrailleDocument brlDoc = this.manager.getDocument();
        Node node2 = brlDoc.getEngine().findTranslationBlock((Node)parent);
        Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element transBlock = (Element)node2;
        this.reformat((Node)transBlock, true);
    }

    private final void adjustTab(int value, Element t) {
        Element e = this.findTab(t);
        if (e != null) {
            int num = ((Number)BBX.SPAN.TAB.ATTRIB_VALUE.get(e)).intValue() + value;
            BBX.SPAN.TAB.ATTRIB_VALUE.set(e, num);
            this.manager.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.TAB, CollectionsKt.listOf((Object)e), true));
        }
    }

    public final void removeTab(@NotNull TabInsertionMessage m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Element e = m.getTab();
        if (e != null) {
            ParentNode p = e.getParent();
            p.removeChild((Node)e);
            Intrinsics.checkNotNull((Object)p);
            this.reformat((Node)p, false);
        }
    }

    private final Element findTab(Element e) {
        if (BBX.SPAN.TAB.isA((Node)e)) {
            return e;
        }
        Element element = e;
        Intrinsics.checkNotNull((Object)element);
        Elements els = element.getChildElements();
        int n = els.size();
        for (int i = 0; i < n; ++i) {
            if (!BBX.SPAN.TAB.isA((Node)els.get(i))) continue;
            return els.get(i);
        }
        return null;
    }

    private final int calculateLineBreaks(TextMapElement t, int pos) {
        StyledText styledText = this.manager.getText().getView();
        TextMapElement textMapElement = t;
        Intrinsics.checkNotNull((Object)textMapElement);
        String text = styledText.getTextRange(textMapElement.getStart(this.list), pos);
        int n = text.length();
        Intrinsics.checkNotNull((Object)text);
        return n - StringsKt.replace$default((String)text, (String)ConstantsKt.getLINE_BREAK(), (String)"", (boolean)false, (int)4, null).length();
    }
}

