/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.ui;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.BBXUtils;
import org.brailleblaster.bbx.BBXUtilsKt;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.mvc.XMLNodeCaret;
import org.brailleblaster.perspectives.mvc.XMLTextCaret;
import org.brailleblaster.perspectives.mvc.events.ModifyEvent;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.properties.EmphasisType;
import org.brailleblaster.util.Notify;
import org.brailleblaster.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0017H\u0002J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lorg/brailleblaster/perspectives/braille/ui/WrapSelectionInTextSymbols;", "", "start", "", "end", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "callback", "Lorg/brailleblaster/perspectives/braille/ui/WrapSelectionInTextSymbols$TextWrapCallBack;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/brailleblaster/perspectives/braille/Manager;Lorg/brailleblaster/perspectives/braille/ui/WrapSelectionInTextSymbols$TextWrapCallBack;)V", "getCallback", "()Lorg/brailleblaster/perspectives/braille/ui/WrapSelectionInTextSymbols$TextWrapCallBack;", "setCallback", "(Lorg/brailleblaster/perspectives/braille/ui/WrapSelectionInTextSymbols$TextWrapCallBack;)V", "add", "", "modifySameNodeText", "Lorg/brailleblaster/perspectives/mvc/XMLNodeCaret;", "modifySameNodeMath", "node", "endNode", "modifyElement", "", "modifyMath", "modifyText", "TextWrapCallBack", "Companion", "brailleblaster-core"})
public final class WrapSelectionInTextSymbols {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String start;
    @NotNull
    private final String end;
    @NotNull
    private final Manager m;
    @NotNull
    private TextWrapCallBack callback;
    @NotNull
    private static TextWrapCallBack defaultNoWrap = WrapSelectionInTextSymbols::defaultNoWrap$lambda$0;
    @NotNull
    private static TextWrapCallBack direct = WrapSelectionInTextSymbols::direct$lambda$0;

    public WrapSelectionInTextSymbols(@NotNull String start, @NotNull String end, @NotNull Manager m, @Nullable TextWrapCallBack callback) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        this.start = start;
        this.end = end;
        this.m = m;
        this.callback = defaultNoWrap;
        if (callback != null) {
            this.callback = callback;
        }
    }

    @NotNull
    public final TextWrapCallBack getCallback() {
        return this.callback;
    }

    public final void setCallback(@NotNull TextWrapCallBack textWrapCallBack) {
        Intrinsics.checkNotNullParameter((Object)textWrapCallBack, (String)"<set-?>");
        this.callback = textWrapCallBack;
    }

    public final void add() {
        if (this.m.getSimpleManager().getCurrentSelection().isTextNoSelection()) {
            return;
        }
        XMLNodeCaret startNode = this.m.getSimpleManager().getCurrentSelection().start;
        XMLNodeCaret endNode = this.m.getSimpleManager().getCurrentSelection().end;
        ParentNode parentNode = startNode.getNode().getParent();
        Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
        Node startParent = (Node)parentNode;
        ParentNode parentNode2 = endNode.getNode().getParent();
        Intrinsics.checkNotNullExpressionValue((Object)parentNode2, (String)"getParent(...)");
        Node endParent = (Node)parentNode2;
        boolean startIsUneditable = BBXUtils.INSTANCE.isUneditable(startNode.getNode());
        boolean endIsUneditable = BBXUtils.INSTANCE.isUneditable(endNode.getNode());
        if (startIsUneditable || endIsUneditable) {
            Notify.notify$default(Notify.INSTANCE, Notify.GENERIC_UNEDITABLE, Notify.ALERT_SHELL_NAME, false, 4, null);
            return;
        }
        boolean startIsText = startNode instanceof XMLTextCaret;
        boolean endIsText = endNode instanceof XMLTextCaret;
        boolean startIsMath = MathModuleUtils.isMath(startNode.getNode());
        boolean endIsMath = MathModuleUtils.isMath(endNode.getNode());
        boolean singleNode = this.m.getSimpleManager().getCurrentSelection().isSingleNode();
        if (singleNode && startIsText && endIsText) {
            this.modifySameNodeText(startNode, endNode);
        } else if (singleNode && startIsMath && endIsMath) {
            this.modifySameNodeMath(startNode, endNode);
        } else {
            if (startIsMath) {
                this.modifyMath(startNode, false);
            } else if (startIsText) {
                this.modifyText(startNode, false);
            } else {
                this.modifyElement(startNode, false);
            }
            if (endIsMath) {
                this.modifyMath(endNode, true);
            } else if (endIsText) {
                this.modifyText(endNode, true);
            } else {
                this.modifyElement(endNode, true);
            }
        }
        Node[] nodeArray = new Node[]{startParent, endParent};
        this.m.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.MATH, true, nodeArray));
    }

    private final void modifySameNodeText(XMLNodeCaret start, XMLNodeCaret end) {
        ParentNode parentNode;
        ParentNode newBlock;
        String string = start.getNode().getValue();
        Intrinsics.checkNotNull((Object)start, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.mvc.XMLTextCaret");
        int startIndex = ((XMLTextCaret)start).getOffset();
        Intrinsics.checkNotNull((Object)end, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.mvc.XMLTextCaret");
        int endIndex = ((XMLTextCaret)end).getOffset();
        Intrinsics.checkNotNull((Object)string);
        String startString = StringsKt.take((String)string, (int)startIndex);
        String string2 = string.substring(startIndex, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String middleString = string2;
        String endString = StringsKt.drop((String)string, (int)endIndex);
        ParentNode parent = ((XMLTextCaret)start).getNode().getParent();
        int index = parent.indexOf((Node)((XMLTextCaret)start).getNode());
        if (!BBX.BLOCK.isA((Node)((XMLTextCaret)start).getNode())) {
            newBlock = BBX.BLOCK.create(BBX.BLOCK.DEFAULT);
            parentNode = parent;
            Intrinsics.checkNotNull((Object)parentNode);
            Utils.insertChildCountSafe(parentNode, (Node)newBlock, index);
            parent = newBlock;
        }
        newBlock = parent;
        Intrinsics.checkNotNull((Object)newBlock);
        Utils.insertChildCountSafe(newBlock, (Node)new Text(startString), index++);
        Text newStart = new Text(this.start);
        parentNode = parent;
        Intrinsics.checkNotNull((Object)parentNode);
        Utils.insertChildCountSafe(parentNode, (Node)newStart, index++);
        this.callback.wrap((Node)newStart);
        parentNode = parent;
        Intrinsics.checkNotNull((Object)parentNode);
        Utils.insertChildCountSafe(parentNode, (Node)new Text(middleString), index++);
        Text newEnd = new Text(this.end);
        ParentNode parentNode2 = parent;
        Intrinsics.checkNotNull((Object)parentNode2);
        Utils.insertChildCountSafe(parentNode2, (Node)newEnd, index++);
        this.callback.wrap((Node)newEnd);
        parentNode2 = parent;
        Intrinsics.checkNotNull((Object)parentNode2);
        Utils.insertChildCountSafe(parentNode2, (Node)new Text(endString), index);
        ((XMLTextCaret)start).getNode().detach();
    }

    private final void modifySameNodeMath(XMLNodeCaret node, XMLNodeCaret endNode) {
        Text startText = new Text(this.start);
        Text endText = new Text(this.end);
        ParentNode parent = node.getNode().getParent();
        int index = parent.indexOf(node.getNode());
        Element parentBlock = BBXUtilsKt.findBlockOrNull(node.getNode());
        if (parentBlock != null) {
            index = BBXUtils.INSTANCE.getIndexInBlock(node.getNode());
            Utils.insertChildCountSafe((ParentNode)parentBlock, (Node)startText, index);
            Utils.insertChildCountSafe((ParentNode)parentBlock, (Node)endText, index + 2);
        } else {
            Element newStartBlock = BBX.BLOCK.create(BBX.BLOCK.DEFAULT);
            Element newEndBlock = BBX.BLOCK.create(BBX.BLOCK.DEFAULT);
            Intrinsics.checkNotNull((Object)parent);
            Utils.insertChildCountSafe(parent, (Node)newStartBlock, index);
            Utils.insertChildCountSafe(parent, (Node)newEndBlock, index + 2);
            Intrinsics.checkNotNull((Object)newStartBlock);
            Utils.insertChildCountSafe((ParentNode)newStartBlock, (Node)startText, 0);
            Intrinsics.checkNotNull((Object)newEndBlock);
            Utils.insertChildCountSafe((ParentNode)newEndBlock, (Node)endText, 0);
        }
        this.callback.wrap((Node)endText);
        this.callback.wrap((Node)startText);
    }

    private final void modifyElement(XMLNodeCaret node, boolean end) {
        Text newText = new Text(end ? this.end : this.start);
        ParentNode parent = node.getNode().getParent();
        int index = parent.indexOf(node.getNode()) + (end ? 1 : 0);
        if (BBX.BLOCK.isA(node.getNode())) {
            Intrinsics.checkNotNull((Object)parent);
            Utils.insertChildCountSafe(parent, (Node)newText, index);
        } else {
            Element newBlock = BBX.BLOCK.create(BBX.BLOCK.DEFAULT);
            Intrinsics.checkNotNull((Object)parent);
            Utils.insertChildCountSafe(parent, (Node)newBlock, index);
            Intrinsics.checkNotNull((Object)newBlock);
            Utils.insertChildCountSafe((ParentNode)newBlock, (Node)newText, 0);
        }
        this.callback.wrap((Node)newText);
    }

    private final void modifyMath(XMLNodeCaret node, boolean end) {
        Text newText = new Text(end ? this.end : this.start);
        ParentNode parent = node.getNode().getParent();
        int index = parent.indexOf(node.getNode()) + (end ? 1 : 0);
        Element parentBlock = BBXUtilsKt.findBlockOrNull(node.getNode());
        if (parentBlock != null) {
            index = BBXUtils.INSTANCE.getIndexInBlock(node.getNode()) + (end ? 1 : 0);
            Utils.insertChildCountSafe((ParentNode)parentBlock, (Node)newText, index);
        } else {
            Element newBlock = BBX.BLOCK.create(BBX.BLOCK.DEFAULT);
            Intrinsics.checkNotNull((Object)parent);
            Utils.insertChildCountSafe(parent, (Node)newBlock, index);
            Intrinsics.checkNotNull((Object)newBlock);
            Utils.insertChildCountSafe((ParentNode)newBlock, (Node)newText, 0);
        }
        this.callback.wrap((Node)newText);
    }

    private final void modifyText(XMLNodeCaret start, boolean end) {
        ParentNode parentNode;
        ParentNode newBlock;
        String string = start.getNode().getValue();
        Intrinsics.checkNotNull((Object)start, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.mvc.XMLTextCaret");
        int stringIndex = ((XMLTextCaret)start).getOffset();
        Intrinsics.checkNotNull((Object)string);
        String startString = StringsKt.take((String)string, (int)stringIndex);
        String endString = StringsKt.drop((String)string, (int)stringIndex);
        ParentNode parent = ((XMLTextCaret)start).getNode().getParent();
        int index = parent.indexOf((Node)((XMLTextCaret)start).getNode());
        if (!BBX.BLOCK.isA((Node)parent)) {
            newBlock = BBX.BLOCK.create(BBX.BLOCK.DEFAULT);
            parentNode = parent;
            Intrinsics.checkNotNull((Object)parentNode);
            Utils.insertChildCountSafe(parentNode, (Node)newBlock, !end ? index : index + 1);
            parent = newBlock;
        }
        newBlock = parent;
        Intrinsics.checkNotNull((Object)newBlock);
        Utils.insertChildCountSafe(newBlock, (Node)new Text(startString), index++);
        Text newText = new Text(end ? this.end : this.start);
        parentNode = parent;
        Intrinsics.checkNotNull((Object)parentNode);
        Utils.insertChildCountSafe(parentNode, (Node)newText, index++);
        this.callback.wrap((Node)newText);
        parentNode = parent;
        Intrinsics.checkNotNull((Object)parentNode);
        Utils.insertChildCountSafe(parentNode, (Node)new Text(endString), index);
        ((XMLTextCaret)start).getNode().detach();
    }

    private static final Node defaultNoWrap$lambda$0(Node n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        return n;
    }

    private static final Node direct$lambda$0(Node n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        EmphasisType[] emphasisTypeArray = new EmphasisType[]{EmphasisType.NO_TRANSLATE};
        Element element = BBX.INLINE.EMPHASIS.create(emphasisTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"create(...)");
        XMLHandler.Companion.wrapNodeWithElement(n, element);
        ParentNode parentNode = n.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
        return (Node)parentNode;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lorg/brailleblaster/perspectives/braille/ui/WrapSelectionInTextSymbols$Companion;", "", "<init>", "()V", "defaultNoWrap", "Lorg/brailleblaster/perspectives/braille/ui/WrapSelectionInTextSymbols$TextWrapCallBack;", "getDefaultNoWrap", "()Lorg/brailleblaster/perspectives/braille/ui/WrapSelectionInTextSymbols$TextWrapCallBack;", "setDefaultNoWrap", "(Lorg/brailleblaster/perspectives/braille/ui/WrapSelectionInTextSymbols$TextWrapCallBack;)V", "direct", "getDirect", "setDirect", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TextWrapCallBack getDefaultNoWrap() {
            return defaultNoWrap;
        }

        public final void setDefaultNoWrap(@NotNull TextWrapCallBack textWrapCallBack) {
            Intrinsics.checkNotNullParameter((Object)textWrapCallBack, (String)"<set-?>");
            defaultNoWrap = textWrapCallBack;
        }

        @NotNull
        public final TextWrapCallBack getDirect() {
            return direct;
        }

        public final void setDirect(@NotNull TextWrapCallBack textWrapCallBack) {
            Intrinsics.checkNotNullParameter((Object)textWrapCallBack, (String)"<set-?>");
            direct = textWrapCallBack;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0005\u00c0\u0006\u0001"}, d2={"Lorg/brailleblaster/perspectives/braille/ui/WrapSelectionInTextSymbols$TextWrapCallBack;", "", "wrap", "Lnu/xom/Node;", "textNode", "brailleblaster-core"})
    public static interface TextWrapCallBack {
        @NotNull
        public Node wrap(@NotNull Node var1);
    }
}

