/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.views.wp;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.exceptions.OutdatedMapListException;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.BrailleMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.ImagePlaceholderTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.NewPageBrlMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TableCellTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TableTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.WhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.maps.MapList;
import org.brailleblaster.perspectives.braille.views.wp.BrailleView;
import org.brailleblaster.perspectives.braille.views.wp.Renderer;
import org.brailleblaster.perspectives.braille.views.wp.RendererState;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.util.ColorManager;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00122\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/brailleblaster/perspectives/braille/views/wp/BrailleRenderer;", "Lorg/brailleblaster/perspectives/braille/views/wp/Renderer;", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "brailleView", "Lorg/brailleblaster/perspectives/braille/views/wp/BrailleView;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;Lorg/brailleblaster/perspectives/braille/views/wp/BrailleView;)V", "state", "Lorg/brailleblaster/perspectives/braille/views/wp/RendererState;", "getState", "()Lorg/brailleblaster/perspectives/braille/views/wp/RendererState;", "setState", "(Lorg/brailleblaster/perspectives/braille/views/wp/RendererState;)V", "pastFirstNewPage", "", "pastLastNewPage", "add", "", "t", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "setBraille", "addTable", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TableTextMapElement;", "finishRendering", "list", "Lorg/brailleblaster/perspectives/braille/mapping/maps/MapList;", "checkForMoveTo", "bme", "Lorg/brailleblaster/perspectives/braille/mapping/elements/BrailleMapElement;", "renderNewPages", "Companion", "brailleblaster-core"})
public final class BrailleRenderer
extends Renderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BrailleView brailleView;
    @NotNull
    private RendererState state;
    private boolean pastFirstNewPage;
    private boolean pastLastNewPage;

    public BrailleRenderer(@NotNull Manager manager, @NotNull BrailleView brailleView) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)brailleView, (String)"brailleView");
        super(manager, brailleView);
        this.brailleView = brailleView;
        this.state = new RendererState(manager.getSimpleManager().getUtdManager().getEngine());
        this.state.setLineIndentMode(false);
        this.pastFirstNewPage = false;
        this.pastLastNewPage = false;
    }

    @NotNull
    public final RendererState getState() {
        return this.state;
    }

    public final void setState(@NotNull RendererState rendererState) {
        Intrinsics.checkNotNullParameter((Object)rendererState, (String)"<set-?>");
        this.state = rendererState;
    }

    public final void add(@NotNull TextMapElement t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        TextMapElement textMapElement = t;
        if (textMapElement instanceof TableTextMapElement) {
            this.addTable((TableTextMapElement)t);
        } else {
            if (textMapElement instanceof ImagePlaceholderTextMapElement || textMapElement instanceof WhiteSpaceElement) {
                return;
            }
            this.setBraille(t);
        }
    }

    public final void setBraille(@NotNull TextMapElement t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Iterator iterator = t.brailleList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            BrailleMapElement bme = (BrailleMapElement)iterator2.next();
            if (bme instanceof NewPageBrlMapElement) {
                if (bme == this.firstPage) {
                    this.pastFirstNewPage = true;
                }
                if (bme == this.lastPage) {
                    this.pastLastNewPage = true;
                }
                Node node = ((NewPageBrlMapElement)bme).getNode();
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
                this.state.newPage((Element)node);
                ((NewPageBrlMapElement)bme).setOffsets(this.state.getCharCount(), this.state.getCharCount());
                continue;
            }
            if (!this.pastFirstNewPage || this.pastLastNewPage) {
                bme.setOffsets(this.state.getCharCount(), this.state.getCharCount());
                continue;
            }
            Intrinsics.checkNotNull((Object)bme);
            this.checkForMoveTo(bme);
            bme.setStart(this.state.getCharCount());
            String string = bme.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            this.state.addToLine(string);
            bme.setEnd(this.state.getCharCount());
        }
    }

    public final void addTable(@NotNull TableTextMapElement t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.state.setTableMode(true);
        for (TableCellTextMapElement tcme : t.tableElements) {
            this.setBraille(tcme);
        }
        this.state.setTableMode(false);
    }

    public final void finishRendering(@Nullable MapList list) {
        this.state.finishPage();
        String text = this.state.getText();
        this.brailleView.getView().setText(text);
        this.renderLineIndents(this.state.getLineIndents(), this.brailleView);
        this.renderNewPages();
        MapList mapList = list;
        Intrinsics.checkNotNull((Object)mapList);
        this.addLastPageIndicator(mapList, this.brailleView);
        BrailleRenderer.Companion.highlightUnknownCharacters(this.brailleView.getView(), text);
    }

    private final void checkForMoveTo(BrailleMapElement bme) {
        Element element = bme.getNodeParent();
        if (element == null) {
            throw new OutdatedMapListException("BME " + bme.getNode().toXML() + " has no grandparent", null, 2, null);
        }
        Element parent = element;
        int brlIndex = parent.indexOf(bme.getNode());
        if (brlIndex > 0 && UTDElements.MOVE_TO.isA(parent.getChild(brlIndex - 1))) {
            Node node = parent.getChild(brlIndex - 1);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            Element moveTo = (Element)node;
            this.state.moveTo(this.getHPos(moveTo), this.getVPos(moveTo));
        }
    }

    private final void renderNewPages() {
        List<Pair<Integer, Element>> newPages = this.state.getNewPages();
        for (Pair<Integer, Element> pair : newPages) {
            this.handleNewPageElement(((Number)pair.getFirst()).intValue(), (Element)pair.getSecond(), this.brailleView);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lorg/brailleblaster/perspectives/braille/views/wp/BrailleRenderer$Companion;", "", "<init>", "()V", "highlightUnknownCharacters", "", "view", "Lorg/eclipse/swt/custom/StyledText;", "text", "", "brailleblaster-core"})
    @SourceDebugExtension(value={"SMAP\nBrailleRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrailleRenderer.kt\norg/brailleblaster/perspectives/braille/views/wp/BrailleRenderer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1#2:142\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void highlightUnknownCharacters(StyledText view, String text) {
            int start = 0;
            while (true) {
                int end;
                int n;
                int it = n = StringsKt.indexOf$default((CharSequence)text, (String)"`.<", (int)start, (boolean)false, (int)4, null);
                boolean bl = false;
                start = it;
                if (n == -1 || (end = StringsKt.indexOf$default((CharSequence)text, (String)"`.>", (int)start, (boolean)false, (int)4, null)) == -1) break;
                StyleRange sr = new StyleRange();
                sr.background = ColorManager.INSTANCE.getColor(ColorManager.Colors.KHAKI, (Control)view);
                sr.start = start;
                sr.length = end - start + 3;
                try {
                    view.setStyleRange(sr);
                }
                catch (Exception e) {
                    throw new RuntimeException(sr.toString(), e);
                }
                start = end;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

