/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.views.wp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.BrailleMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.PageIndicatorTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.PaintedWhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.elements.ReadOnlyTableTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.WhiteSpaceElement;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.braille.views.style.BreadcrumbsToolbar;
import org.brailleblaster.perspectives.braille.views.wp.ViewStateObject;
import org.brailleblaster.perspectives.braille.views.wp.WPView;
import org.brailleblaster.perspectives.braille.views.wp.listeners.WPPaintListener;
import org.brailleblaster.perspectives.braille.views.wp.listeners.WPScrollListener;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.perspectives.mvc.events.XMLCaretEvent;
import org.brailleblaster.util.ConstantsKt;
import org.brailleblaster.utils.swt.AccessibilityUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u0015\n\u0002\b\u0006\u0018\u0000 <2\u00020\u0001:\u0002;<B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u0019H\u0016J\b\u0010\u001c\u001a\u00020\u0019H\u0002J\u001a\u0010\u001d\u001a\u00020\u00192\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020!2\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010&\u001a\u00020\u0019H\u0014J\u0016\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020$J\u0006\u0010*\u001a\u00020\u0019J\u0016\u0010+\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020$J\u0006\u0010-\u001a\u00020\u0019J\u0016\u0010.\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020$J\u0010\u0010/\u001a\u00020!2\u0006\u00100\u001a\u00020$H\u0002J\u0018\u00101\u001a\u00020$2\u0006\u0010(\u001a\u00020$2\u0006\u00100\u001a\u00020$H\u0002J\u0018\u00102\u001a\u00020$2\u0006\u00103\u001a\u00020$2\u0006\u00104\u001a\u00020$H\u0002J\u0018\u00105\u001a\u00020$2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020$H\u0002J\u0010\u00109\u001a\u00020\u00192\u0006\u0010:\u001a\u00020\u0005H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/brailleblaster/perspectives/braille/views/wp/BrailleView;", "Lorg/brailleblaster/perspectives/braille/views/wp/WPView;", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "sash", "Lorg/eclipse/swt/widgets/Composite;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;Lorg/eclipse/swt/widgets/Composite;)V", "stateObj", "Lorg/brailleblaster/perspectives/braille/views/wp/ViewStateObject;", "pageRanges", "Ljava/util/ArrayList;", "Lorg/brailleblaster/perspectives/braille/views/wp/BrailleView$PageRange;", "Lkotlin/collections/ArrayList;", "verifyListener", "Lorg/eclipse/swt/custom/VerifyKeyListener;", "mouseListener", "Lorg/eclipse/swt/events/MouseAdapter;", "caretListener", "Lorg/eclipse/swt/custom/CaretListener;", "selectionListener", "Lorg/eclipse/swt/events/SelectionAdapter;", "paintListener", "Lorg/eclipse/swt/events/PaintListener;", "addAccessibilityListener", "", "initializeListeners", "removeListeners", "setCurrent", "checkTme", "tme", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "foward", "", "isLastInView", "index", "", "isFirstInView", "setViewData", "setPageRange", "start", "end", "clearPageRange", "updateCursor", "offsetFromTMEStart", "setPositionFromStart", "updateCursorFromTME", "checkLineBreakOnWindows", "pos", "plusLineBreaks", "checkPageRange", "elementStart", "position", "findCurrentPosition", "indexes", "", "textPos", "resetView", "parent", "PageRange", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nBrailleView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrailleView.kt\norg/brailleblaster/perspectives/braille/views/wp/BrailleView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,330:1\n1#2:331\n*E\n"})
public final class BrailleView
extends WPView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ViewStateObject stateObj;
    @NotNull
    private final ArrayList<PageRange> pageRanges;
    @Nullable
    private VerifyKeyListener verifyListener;
    @Nullable
    private MouseAdapter mouseListener;
    @Nullable
    private CaretListener caretListener;
    @Nullable
    private SelectionAdapter selectionListener;
    @Nullable
    private PaintListener paintListener;
    @NotNull
    private static final String NAME = "Braille View";

    public BrailleView(@NotNull Manager manager, @NotNull Composite sash) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)sash, (String)"sash");
        super(manager, sash);
        this.stateObj = new ViewStateObject(0, 0, 0, 0, 0, 0, 0, 0, 0, 511, null);
        this.pageRanges = new ArrayList();
        this.addAccessibilityListener();
    }

    private final void addAccessibilityListener() {
        this.getView().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getDescription(AccessibleEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.result = BreadcrumbsToolbar.Companion.getEnabled() ? BreadcrumbsToolbar.Companion.getCrumb_string() : "";
            }
        });
    }

    @Override
    public void initializeListeners() {
        Object it;
        Object object;
        super.initializeListeners();
        VerifyKeyListener verifyKeyListener = object = arg_0 -> BrailleView.initializeListeners$lambda$0(this, arg_0);
        StyledText styledText = this.getView();
        boolean bl = false;
        this.verifyListener = it;
        styledText.addVerifyKeyListener(object);
        it = object = new MouseAdapter(this){
            final /* synthetic */ BrailleView this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseDown(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!this.this$0.getLock()) {
                    if (e.button == 2) {
                        return;
                    }
                    if (this.this$0.getView().getCaretOffset() > BrailleView.access$getStateObj$p(this.this$0).getCurrentEnd() || this.this$0.getView().getCaretOffset() < BrailleView.access$getStateObj$p(this.this$0).getCurrentStart()) {
                        BrailleView.access$setCurrent(this.this$0);
                    }
                    this.this$0.sendStatusBarUpdate(this.this$0.getView().getLineAtOffset(this.this$0.getView().getCaretOffset()));
                }
            }
        };
        styledText = this.getView();
        boolean bl2 = false;
        this.mouseListener = (MouseAdapter)it;
        styledText.addMouseListener((MouseListener)object);
        it = object = arg_0 -> BrailleView.initializeListeners$lambda$3(this, arg_0);
        styledText = this.getView();
        boolean bl3 = false;
        this.caretListener = it;
        styledText.addCaretListener((CaretListener)object);
        it = object = new WPScrollListener(this.getManager(), this, Sender.BRAILLE);
        styledText = this.getView().getVerticalBar();
        boolean bl4 = false;
        this.selectionListener = (SelectionAdapter)it;
        styledText.addSelectionListener((SelectionListener)object);
        it = object = new WPPaintListener(this, Sender.BRAILLE);
        styledText = this.getView();
        boolean bl5 = false;
        this.paintListener = (PaintListener)it;
        styledText.addPaintListener((PaintListener)object);
        this.getView().addModifyListener(this.getViewMod());
        AccessibilityUtils.setName((Control)((Control)this.getView()), (String)NAME);
    }

    @Override
    public void removeListeners() {
        super.removeListeners();
        this.getView().removeModifyListener(this.getViewMod());
        this.getView().removeVerifyKeyListener(this.verifyListener);
        this.getView().removeMouseListener((MouseListener)this.mouseListener);
        this.getView().removeCaretListener(this.caretListener);
        this.getView().getVerticalBar().removeSelectionListener((SelectionListener)this.selectionListener);
        this.getView().removePaintListener(this.paintListener);
        this.removeAllPaintedElements(this);
    }

    private final void setCurrent() {
        boolean firstRow;
        TextMapElement lastNNTme;
        int pos = this.getView().getCaretOffset();
        boolean forward = false;
        boolean specialTme = false;
        int tmeIndex = this.getManager().getMapList().findClosestBraille(pos, this.getManager().getMapList().getCurrent());
        if (this.stateObj.getCurrentChar() == 0x1000002 || this.stateObj.getCurrentChar() == 0x1000004) {
            forward = true;
        }
        TextMapElement textMapElement = tmeIndex == 0 ? this.getManager().getMapList().getCurrent() : (TextMapElement)this.getManager().getMapList().get(tmeIndex);
        Intrinsics.checkNotNull((Object)textMapElement);
        TextMapElement tme = lastNNTme = textMapElement;
        while (tme instanceof PaintedWhiteSpaceElement || tme instanceof WhiteSpaceElement || tme instanceof PageIndicatorTextMapElement || tme instanceof ReadOnlyTableTextMapElement) {
            this.checkTme(tme, forward);
            tme = forward ? this.getManager().getMapList().getNext(this.getManager().getMapList().indexOf(tme), true) : this.getManager().getMapList().getPrevious(this.getManager().getMapList().indexOf(tme), true);
            this.checkTme(tme, forward);
            if (tme != null) {
                lastNNTme = tme;
            }
            specialTme = true;
        }
        if (specialTme) {
            if (tme == null) {
                tme = lastNNTme;
            }
            this.getManager().getSimpleManager().dispatchEvent(new XMLCaretEvent(Sender.TEXT, this.createNodeCaret(tme, tme.getStart(this.getManager().getMapList())), null, 4, null));
            return;
        }
        tmeIndex = this.getManager().getMapList().getNodeIndex(tme);
        boolean bl = firstRow = this.getView().getLineAtOffset(pos) == 0;
        if ((this.isFirstInView(tmeIndex) || tme != null && !tme.isFullyVisible() || firstRow) && !forward) {
            this.getManager().decrementView();
            tme = this.getManager().getMapList().getFirstUsable();
            BBSimpleManager bBSimpleManager = this.getManager().getSimpleManager();
            TextMapElement textMapElement2 = tme;
            Intrinsics.checkNotNull((Object)textMapElement2);
            bBSimpleManager.dispatchEvent(new XMLCaretEvent(Sender.TEXT, this.createNodeCaret(textMapElement2, pos), null, 4, null));
        } else if ((this.isLastInView(tmeIndex) || tme != null && !tme.isFullyVisible()) && forward) {
            this.getManager().incrementView();
            tme = this.getManager().getMapList().getLastUsable();
            BBSimpleManager bBSimpleManager = this.getManager().getSimpleManager();
            TextMapElement textMapElement3 = tme;
            Intrinsics.checkNotNull((Object)textMapElement3);
            bBSimpleManager.dispatchEvent(new XMLCaretEvent(Sender.TEXT, this.createNodeCaret(textMapElement3, tme.getStart(this.getManager().getMapList())), null, 4, null));
        } else {
            int n;
            TextMapElement textMapElement4 = tme;
            Intrinsics.checkNotNull((Object)textMapElement4);
            LinkedList<BrailleMapElement> linkedList = textMapElement4.brailleList;
            Intrinsics.checkNotNullExpressionValue(linkedList, (String)"brailleList");
            if (!((Collection)linkedList).isEmpty()) {
                LinkedList<BrailleMapElement> linkedList2 = tme.brailleList;
                Intrinsics.checkNotNullExpressionValue(linkedList2, (String)"brailleList");
                n = ((BrailleMapElement)CollectionsKt.first((List)linkedList2)).getStart(this.getManager().getMapList());
            } else {
                n = 0;
            }
            int start = n;
            this.getManager().getSimpleManager().dispatchEvent(new XMLCaretEvent(Sender.BRAILLE, this.createNodeCaret(tme, pos - start), null, 4, null));
        }
    }

    private final void checkTme(TextMapElement tme, boolean foward) {
        block9: {
            block10: {
                int tmeIndex;
                block7: {
                    block8: {
                        tmeIndex = this.getManager().getMapList().getNodeIndex(tme);
                        if (tmeIndex == -1) {
                            return;
                        }
                        if (!foward) break block7;
                        if (this.isLastInView(tmeIndex)) break block8;
                        TextMapElement textMapElement = tme;
                        Intrinsics.checkNotNull((Object)textMapElement);
                        if (textMapElement.isFullyVisible()) break block9;
                    }
                    this.getManager().incrementView();
                    break block9;
                }
                if (this.isFirstInView(tmeIndex)) break block10;
                TextMapElement textMapElement = tme;
                Intrinsics.checkNotNull((Object)textMapElement);
                if (textMapElement.isFullyVisible() && tme.getStart(this.getManager().getMapList()) != 0) break block9;
            }
            this.getManager().decrementView();
        }
    }

    private final boolean isLastInView(int index) {
        return index == this.getManager().getMapList().size() - 1 && !this.getManager().getViewInitializer().getSectionList().get(this.getManager().getViewInitializer().getSectionList().size() - 1).isVisible();
    }

    private final boolean isFirstInView(int index) {
        return index == 0 && !this.getManager().getViewInitializer().getSectionList().get(0).isVisible();
    }

    @Override
    protected void setViewData() {
        this.stateObj.setCurrentStart(this.getManager().getMapList().getCurrentBrailleOffset());
        this.stateObj.setCurrentEnd(this.getManager().getMapList().getCurrentBrailleEnd());
        this.stateObj.setNextStart(this.getManager().getMapList().getNextBraille());
    }

    public final void setPageRange(int start, int end) {
        this.pageRanges.add(new PageRange(start, end));
    }

    public final void clearPageRange() {
        this.pageRanges.clear();
    }

    public final void updateCursor(@NotNull TextMapElement tme, int offsetFromTMEStart) {
        Intrinsics.checkNotNullParameter((Object)tme, (String)"tme");
        this.setListenerLock(true);
        BrailleView $this$updateCursor_u24lambda_u240 = this;
        boolean bl = false;
        $this$updateCursor_u24lambda_u240.stateObj.setCurrentStart($this$updateCursor_u24lambda_u240.getManager().getMapList().getCurrentBrailleOffset());
        $this$updateCursor_u24lambda_u240.stateObj.setCurrentEnd($this$updateCursor_u24lambda_u240.getManager().getMapList().getCurrentBrailleEnd());
        $this$updateCursor_u24lambda_u240.stateObj.setNextStart($this$updateCursor_u24lambda_u240.getManager().getMapList().getNextBraille());
        BrailleView $this$updateCursor_u24lambda_u241 = this;
        boolean bl2 = false;
        $this$updateCursor_u24lambda_u241.updateCursorFromTME(tme, offsetFromTMEStart);
        this.setListenerLock(false);
    }

    public final void setPositionFromStart() {
        this.setPositionFromStart(this.getView().getCaretOffset() - this.stateObj.getCurrentStart());
        if (this.getPositionFromStart() > 0 && this.stateObj.getCurrentStart() + this.getPositionFromStart() <= this.stateObj.getCurrentEnd()) {
            String text = this.getView().getTextRange(this.stateObj.getCurrentStart(), this.getPositionFromStart());
            int n = text.length();
            Intrinsics.checkNotNull((Object)text);
            CharSequence charSequence = text;
            Regex regex = new Regex(ConstantsKt.getLINE_BREAK());
            String string = "";
            int count = n - regex.replace(charSequence, string).length();
            this.setPositionFromStart(this.getPositionFromStart() - count);
            this.setPositionFromStart(this.getPositionFromStart() - this.checkPageRange(this.stateObj.getCurrentStart(), this.stateObj.getCurrentStart() + this.getPositionFromStart()));
            this.cursorOffset = count;
        } else if (this.getPositionFromStart() > 0 && this.stateObj.getCurrentStart() + this.getPositionFromStart() > this.stateObj.getCurrentEnd()) {
            this.cursorOffset = this.stateObj.getCurrentStart() + this.getPositionFromStart() - this.stateObj.getCurrentEnd();
            this.setPositionFromStart(99999);
        } else {
            this.cursorOffset = 0;
        }
    }

    public final void updateCursorFromTME(@NotNull TextMapElement tme, int offsetFromTMEStart) {
        Intrinsics.checkNotNullParameter((Object)tme, (String)"tme");
        int lastPositon = this.getManager().getText().getPositionFromStart();
        Node node = tme.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
        Element e = this.getBrlNode(node);
        int pos = 0;
        if (e != null) {
            int[] arr = this.getIndexArray(e);
            if (arr == null) {
                pos = lastPositon == 0 ? this.stateObj.getCurrentStart() : this.stateObj.getCurrentEnd();
            } else if (lastPositon < 0 && this.stateObj.getCurrentStart() > 0) {
                pos = this.stateObj.getCurrentStart() + lastPositon;
            } else if (lastPositon == 99999) {
                pos = this.stateObj.getCurrentEnd() + offsetFromTMEStart;
            } else {
                pos = this.stateObj.getCurrentStart() + this.findCurrentPosition(arr, offsetFromTMEStart);
                pos += this.plusLineBreaks(this.stateObj.getCurrentStart(), pos);
                pos += this.checkPageRange(this.stateObj.getCurrentStart(), pos);
            }
            if (pos <= this.getView().getCharCount() && this.checkLineBreakOnWindows(pos)) {
                ++pos;
            }
            this.getView().setCaretOffset(pos);
        }
    }

    private final boolean checkLineBreakOnWindows(int pos) {
        if (Intrinsics.areEqual((Object)SWT.getPlatform(), (Object)"win32")) {
            int line = this.getView().getLineAtOffset(pos);
            if (pos < this.getView().getCharCount() && line < this.getView().getLineCount() - 1) {
                return pos + 1 == this.getView().getOffsetAtLine(line + 1);
            }
        }
        return false;
    }

    private final int plusLineBreaks(int start, int pos) {
        int startLine = this.getView().getLineAtOffset(start);
        int endLine = this.getView().getLineAtOffset(pos);
        int diff = endLine - startLine;
        if (diff > 0) {
            return diff * ConstantsKt.getLINE_BREAK().length();
        }
        if (diff < 0) {
            System.out.println((Object)"Line cannot be below zero");
        }
        return 0;
    }

    private final int checkPageRange(int elementStart, int position) {
        int offset = 0;
        Iterator<PageRange> iterator = this.pageRanges.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<PageRange> iterator2 = iterator;
        while (iterator2.hasNext()) {
            PageRange pageRange;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (pageRange.getStart() < elementStart || position + offset <= pageRange.getStart()) continue;
            offset += pageRange.getEnd() - pageRange.getStart();
        }
        return offset;
    }

    private final int findCurrentPosition(int[] indexes, int textPos) {
        int n = indexes.length;
        for (int i = 0; i < n; ++i) {
            if (textPos == indexes[i]) {
                return i;
            }
            if (textPos >= indexes[i]) continue;
            return RangesKt.coerceAtLeast((int)(i - 1), (int)0);
        }
        return indexes.length;
    }

    @Override
    public void resetView(@NotNull Composite parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.recreateView(parent);
        this.stateObj.setOldCursorPosition(-1);
        this.clearPageRange();
    }

    private static final void initializeListeners$lambda$0(BrailleView this$0, VerifyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this$0.stateObj.setCurrentChar(e.keyCode);
        this$0.stateObj.setCurrentStateMask(e.stateMask);
        if (this$0.getManager().getMapList().inBraillePageRange(this$0.getView().getCaretOffset()) && e.keyCode == 0x1000002 && this$0.getView().getLineAtOffset(this$0.getView().getCaretOffset()) == this$0.getView().getLineCount() - 1) {
            this$0.getView().setCaretOffset(this$0.stateObj.getNextStart());
        }
        this$0.stateObj.setOldCursorPosition(this$0.getView().getCaretOffset());
    }

    private static final void initializeListeners$lambda$3(BrailleView this$0, CaretEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this$0.getLock()) {
            if (this$0.getManager().getStylePane().getUpdateStylePane() && !this$0.getManager().getTextView().isDisposed()) {
                this$0.getManager().getStylePane().updateCursor(this$0.getManager().getBrailleView().getLineAtOffset(this$0.getManager().getBrailleView().getCaretOffset()));
            }
            if (this$0.stateObj.getCurrentChar() == 0x1000002 || this$0.stateObj.getCurrentChar() == 0x1000003 || this$0.stateObj.getCurrentChar() == 0x1000004 || this$0.stateObj.getCurrentChar() == 0x1000001 || this$0.stateObj.getCurrentChar() == 0x1000006 || this$0.stateObj.getCurrentChar() == 0x1000005) {
                if (e.caretOffset >= this$0.stateObj.getCurrentEnd() || e.caretOffset < this$0.stateObj.getCurrentStart()) {
                    this$0.setCurrent();
                    this$0.stateObj.setCurrentChar(32);
                    this$0.stateObj.setCurrentStateMask(-1);
                }
                this$0.sendStatusBarUpdate(this$0.getView().getLineAtOffset(this$0.getView().getCaretOffset()));
            }
        }
    }

    public static final /* synthetic */ ViewStateObject access$getStateObj$p(BrailleView $this) {
        return $this.stateObj;
    }

    public static final /* synthetic */ void access$setCurrent(BrailleView $this) {
        $this.setCurrent();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/brailleblaster/perspectives/braille/views/wp/BrailleView$Companion;", "", "<init>", "()V", "NAME", "", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lorg/brailleblaster/perspectives/braille/views/wp/BrailleView$PageRange;", "", "start", "", "end", "<init>", "(II)V", "getStart", "()I", "setStart", "(I)V", "getEnd", "setEnd", "brailleblaster-core"})
    private static final class PageRange {
        private int start;
        private int end;

        public PageRange(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public final int getStart() {
            return this.start;
        }

        public final void setStart(int n) {
            this.start = n;
        }

        public final int getEnd() {
            return this.end;
        }

        public final void setEnd(int n) {
            this.end = n;
        }
    }
}

