/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.views.wp;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.brailleblaster.abstractClasses.ViewUtils;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.libembosser.spi.BrlCell;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.BrailleMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.BraillePageBrlMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.FormattingWhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.elements.LineBreakElement;
import org.brailleblaster.perspectives.braille.mapping.elements.NewPageBrlMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.PageIndicator;
import org.brailleblaster.perspectives.braille.mapping.elements.TableCellTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TableTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.WhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.maps.MapList;
import org.brailleblaster.perspectives.braille.views.wp.BrailleView;
import org.brailleblaster.perspectives.braille.views.wp.RendererState;
import org.brailleblaster.perspectives.braille.views.wp.Validator;
import org.brailleblaster.perspectives.braille.views.wp.WPView;
import org.brailleblaster.utd.properties.UTDElements;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010/\u001a\u00020\u0015H\u0002J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0004J\u0016\u00104\u001a\u00020!2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\tJ\u0010\u00104\u001a\u00020!2\u0006\u00108\u001a\u000209H\u0002J\u0012\u0010:\u001a\u00020!2\b\u0010;\u001a\u0004\u0018\u00010<H\u0004J\u0010\u0010=\u001a\u00020!2\u0006\u0010;\u001a\u00020<H\u0004J\u0012\u0010>\u001a\u0004\u0018\u00010<2\u0006\u00102\u001a\u000203H\u0002J\u001a\u0010?\u001a\u00020@2\b\u0010A\u001a\u0004\u0018\u00010-2\b\u0010B\u001a\u0004\u0018\u00010-J\u0010\u0010C\u001a\u0002012\u0006\u00108\u001a\u000209H\u0004J\u0010\u0010D\u001a\u0002012\u0006\u00108\u001a\u000209H\u0004J\u0010\u0010E\u001a\u0002012\u0006\u00108\u001a\u000209H\u0004J\u0010\u0010F\u001a\u0002012\u0006\u00102\u001a\u000203H\u0004J \u0010G\u001a\u00020\u00152\u0006\u0010H\u001a\u00020\u00152\u0006\u0010I\u001a\u00020!2\u0006\u0010J\u001a\u000203H\u0004J\"\u0010K\u001a\u00020@2\u0006\u0010L\u001a\u00020\t2\b\u0010M\u001a\u0004\u0018\u00010<2\u0006\u0010N\u001a\u00020\u0005H\u0004J\u0018\u0010O\u001a\u00020@2\u0006\u00105\u001a\u0002062\u0006\u0010N\u001a\u00020\u0005H\u0004J\u001e\u0010P\u001a\u00020@2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\t0R2\u0006\u0010N\u001a\u00020\u0005H\u0004J \u0010S\u001a\u00020@2\u0006\u0010T\u001a\u00020U2\b\u0010V\u001a\u0004\u0018\u00010W2\u0006\u00105\u001a\u000206J\u0012\u0010X\u001a\u0004\u0018\u0001092\u0006\u00105\u001a\u000206H\u0002R\u0012\u0010\u0002\u001a\u00020\u00038\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u001a\u0010\u0014\u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0012\u0010 \u001a\u00020!8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u000bR\u0012\u0010$\u001a\u00020%8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u00020\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u000b\"\u0004\b(\u0010\rR\u001c\u0010)\u001a\u0004\u0018\u00010\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0017\"\u0004\b+\u0010\u0019R\u0014\u0010,\u001a\u0004\u0018\u00010-8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\u0004\u0018\u00010-8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lorg/brailleblaster/perspectives/braille/views/wp/Renderer;", "", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "wpView", "Lorg/brailleblaster/perspectives/braille/views/wp/WPView;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;Lorg/brailleblaster/perspectives/braille/views/wp/WPView;)V", "spaceBeforeText", "", "getSpaceBeforeText", "()I", "setSpaceBeforeText", "(I)V", "spaceAfterText", "getSpaceAfterText", "setSpaceAfterText", "insertPosition", "getInsertPosition", "setInsertPosition", "indicatorWidth", "", "getIndicatorWidth", "()Ljava/lang/String;", "setIndicatorWidth", "(Ljava/lang/String;)V", "validator", "Lorg/brailleblaster/perspectives/braille/views/wp/Validator;", "getValidator", "()Lorg/brailleblaster/perspectives/braille/views/wp/Validator;", "setValidator", "(Lorg/brailleblaster/perspectives/braille/views/wp/Validator;)V", "vPos", "", "finalLineOfPage", "getFinalLineOfPage", "cell", "Lorg/brailleblaster/libembosser/spi/BrlCell;", "curBrlPage", "getCurBrlPage", "setCurBrlPage", "curBrlPageType", "getCurBrlPageType", "setCurBrlPageType", "firstPage", "Lorg/brailleblaster/perspectives/braille/mapping/elements/NewPageBrlMapElement;", "lastPage", "convertString", "moveToAfterNewPage", "", "n", "Lnu/xom/Node;", "findVPos", "list", "Lorg/brailleblaster/perspectives/braille/mapping/maps/MapList;", "index", "t", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "getVPos", "moveTo", "Lnu/xom/Element;", "getHPos", "getPrecedingElement", "setPageBounds", "", "upper", "lower", "tabbed", "isVolume", "onSameLine", "followsTab", "addGuideDotsToTableRow", "row", "hPos", "dots", "handleNewPageElement", "offset", "newPage", "view", "addLastPageIndicator", "renderLineIndents", "lineIndents", "", "addLineBreak", "lb", "Lorg/brailleblaster/perspectives/braille/mapping/elements/LineBreakElement;", "state", "Lorg/brailleblaster/perspectives/braille/views/wp/RendererState;", "getFinalNonWhiteSpaceElement", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Renderer.kt\norg/brailleblaster/perspectives/braille/views/wp/Renderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,232:1\n546#2,6:233\n*S KotlinDebug\n*F\n+ 1 Renderer.kt\norg/brailleblaster/perspectives/braille/views/wp/Renderer\n*L\n229#1:233,6\n*E\n"})
public class Renderer {
    @JvmField
    @NotNull
    protected Manager manager;
    @NotNull
    private final WPView wpView;
    private int spaceBeforeText;
    private int spaceAfterText;
    private int insertPosition;
    @NotNull
    private String indicatorWidth;
    @NotNull
    private Validator validator;
    @JvmField
    public double vPos;
    private final int finalLineOfPage;
    @JvmField
    @NotNull
    protected BrlCell cell;
    private int curBrlPage;
    @Nullable
    private String curBrlPageType;
    @JvmField
    @Nullable
    protected NewPageBrlMapElement firstPage;
    @JvmField
    @Nullable
    protected NewPageBrlMapElement lastPage;

    public Renderer(@NotNull Manager manager, @NotNull WPView wpView) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)wpView, (String)"wpView");
        this.manager = manager;
        this.wpView = wpView;
        this.validator = new Validator(this.manager, this.wpView.getView());
        this.cell = this.manager.getDocument().getEngine().getBrailleSettings().getCellType();
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(this.manager.getDocument().getEngine().getPageSettings().getDrawableHeight()));
        BigDecimal bigDecimal2 = this.cell.getHeight();
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"getHeight(...)");
        BigDecimal bigDecimal3 = bigDecimal.subtract(bigDecimal2);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"subtract(...)");
        this.finalLineOfPage = this.cell.getLinesForHeight(bigDecimal3);
        this.indicatorWidth = this.convertString();
        this.vPos = 0.0;
        this.curBrlPage = 1;
    }

    protected final int getSpaceBeforeText() {
        return this.spaceBeforeText;
    }

    protected final void setSpaceBeforeText(int n) {
        this.spaceBeforeText = n;
    }

    protected final int getSpaceAfterText() {
        return this.spaceAfterText;
    }

    protected final void setSpaceAfterText(int n) {
        this.spaceAfterText = n;
    }

    public final int getInsertPosition() {
        return this.insertPosition;
    }

    public final void setInsertPosition(int n) {
        this.insertPosition = n;
    }

    @NotNull
    protected final String getIndicatorWidth() {
        return this.indicatorWidth;
    }

    protected final void setIndicatorWidth(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.indicatorWidth = string;
    }

    @NotNull
    protected final Validator getValidator() {
        return this.validator;
    }

    protected final void setValidator(@NotNull Validator validator) {
        Intrinsics.checkNotNullParameter((Object)validator, (String)"<set-?>");
        this.validator = validator;
    }

    protected final int getFinalLineOfPage() {
        return this.finalLineOfPage;
    }

    protected final int getCurBrlPage() {
        return this.curBrlPage;
    }

    protected final void setCurBrlPage(int n) {
        this.curBrlPage = n;
    }

    @Nullable
    protected final String getCurBrlPageType() {
        return this.curBrlPageType;
    }

    protected final void setCurBrlPageType(@Nullable String string) {
        this.curBrlPageType = string;
    }

    private final String convertString() {
        StringBuilder line = new StringBuilder();
        double width = this.wpView.getView().getBounds().width;
        int cellsPerLine = this.cell.getCellsForWidth(new BigDecimal(String.valueOf(width)));
        line.append(StringsKt.repeat((CharSequence)" ", (int)RangesKt.coerceAtLeast((int)cellsPerLine, (int)0)));
        String string = line.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    protected final boolean moveToAfterNewPage(@NotNull Node n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        ParentNode parentNode = n.getParent();
        Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element parent = (Element)parentNode;
        int index = parent.indexOf(n);
        return index > 1 && ViewUtils.isElement(parent.getChild(index - 2)) && ViewUtils.followsMoveTo(n) ? UTDElements.NEW_PAGE.isA(parent.getChild(index - 2)) : false;
    }

    public final double findVPos(@NotNull MapList list, int index) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        double vPos = 0.0;
        if (!((Collection)list).isEmpty()) {
            int i = index;
            block0: while (i + 1 < list.size()) {
                LinkedList<BrailleMapElement> linkedList = ((TextMapElement)list.get((int)i)).brailleList;
                Intrinsics.checkNotNullExpressionValue(linkedList, (String)"brailleList");
                if (!((Collection)linkedList).isEmpty()) break;
                if (list.get(i) instanceof TableTextMapElement) {
                    Object e = list.get(i);
                    Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.braille.mapping.elements.TableTextMapElement");
                    for (TableCellTextMapElement tcme : ((TableTextMapElement)e).tableElements) {
                        LinkedList linkedList2 = tcme.brailleList;
                        Intrinsics.checkNotNullExpressionValue((Object)linkedList2, (String)"brailleList");
                        if (!(!((Collection)linkedList2).isEmpty())) continue;
                        break block0;
                    }
                }
                ++i;
            }
            Object e = list.get(i);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            vPos = this.findVPos((TextMapElement)e);
            if (i == 0 && this.manager.getSection(((TextMapElement)list.get(i)).getNode()) == 0) {
                vPos = 0.0;
            }
            return vPos;
        }
        return vPos;
    }

    private final double findVPos(TextMapElement t) {
        double vPos = 0.0;
        int n = ((Collection)t.brailleList).size();
        for (int i = 0; i < n; ++i) {
            Node node = t.brailleList.get(i).getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
            if (!ViewUtils.followsMoveTo(node)) {
                Node node2 = t.brailleList.get(i).getNode();
                Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"getNode(...)");
                if (!ViewUtils.followsNewPage(node2)) continue;
            }
            Node node3 = t.brailleList.get(i).getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node3, (String)"getNode(...)");
            return this.getVPos(this.getPrecedingElement(node3));
        }
        return vPos;
    }

    protected final double getVPos(@Nullable Element moveTo) {
        double vPos = 0.0;
        Element element = moveTo;
        Intrinsics.checkNotNull((Object)element);
        Attribute atr = element.getAttribute("vPos");
        if (atr != null) {
            String string = atr.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            vPos = Double.parseDouble(string);
        }
        return vPos;
    }

    protected final double getHPos(@NotNull Element moveTo) {
        Intrinsics.checkNotNullParameter((Object)moveTo, (String)"moveTo");
        double hPos = 0.0;
        Attribute atr = moveTo.getAttribute("hPos");
        if (atr != null) {
            String string = atr.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            hPos = Double.parseDouble(string);
        }
        return hPos;
    }

    private final Element getPrecedingElement(Node n) {
        Element element;
        ParentNode p = n.getParent();
        int index = p.indexOf(n);
        if (index > 0 && p.getChild(index - 1) instanceof Element) {
            Node node = p.getChild(index - 1);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            element = (Element)node;
        } else {
            element = null;
        }
        return element;
    }

    public final void setPageBounds(@Nullable NewPageBrlMapElement upper, @Nullable NewPageBrlMapElement lower) {
        this.firstPage = upper;
        this.lastPage = lower;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean tabbed(@NotNull TextMapElement t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        LinkedList<BrailleMapElement> linkedList = t.brailleList;
        Intrinsics.checkNotNullExpressionValue(linkedList, (String)"brailleList");
        if (((Collection)linkedList).isEmpty()) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!this.onSameLine(t)) return false;
        Node node = t.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
        if (!this.followsTab(node)) return false;
        return true;
    }

    protected final boolean isVolume(@NotNull TextMapElement t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        String string = t.getNodeParent().getLocalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalName(...)");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"Volume", (boolean)false, (int)2, null);
    }

    protected final boolean onSameLine(@NotNull TextMapElement t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        LinkedList<BrailleMapElement> linkedList = t.brailleList;
        Intrinsics.checkNotNullExpressionValue(linkedList, (String)"brailleList");
        BrailleMapElement b = (BrailleMapElement)CollectionsKt.first((List)linkedList);
        return Intrinsics.areEqual((Double)b.getVPos(), (double)this.vPos) ? b.getHPos() != null && b.getHPos() > 0.0 : false;
    }

    protected final boolean followsTab(@NotNull Node n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        ParentNode p = n.getParent();
        int index = p.indexOf(n);
        if (index > 0 && p.getChild(index - 1) instanceof Element) {
            Node node = p.getChild(index - 1);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            Element e = (Element)node;
            return BBX.SPAN.TAB.isA((Node)e);
        }
        return false;
    }

    @NotNull
    protected final String addGuideDotsToTableRow(@NotNull String row, double hPos, @NotNull Node dots) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)dots, (String)"dots");
        StringBuilder newRow = new StringBuilder(row);
        int dotsLength = dots.getValue().length();
        int hPosCells = this.cell.getCellsForWidth(new BigDecimal(String.valueOf(hPos)));
        int endPoint = hPosCells + dotsLength;
        if (hPosCells > newRow.length() - 1) {
            newRow.append(StringsKt.repeat((CharSequence)" ", (int)(hPosCells - newRow.length()))).append(StringsKt.repeat((CharSequence)"\"", (int)dotsLength));
            String string = newRow.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        int lastSpace = -1;
        for (int i = hPosCells; i < newRow.length() && i < endPoint; ++i) {
            if (newRow.charAt(i) != ' ' || i <= 1 || newRow.charAt(i - 1) != ' ') continue;
            lastSpace = i;
            break;
        }
        if (lastSpace == -1) {
            return row;
        }
        newRow.replace(lastSpace, endPoint, StringsKt.repeat((CharSequence)"\"", (int)(endPoint - lastSpace)));
        String string = newRow.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    protected final void handleNewPageElement(int offset, @Nullable Element newPage, @NotNull WPView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        int line = view.getView().getLineAtOffset(offset);
        PageIndicator pageIndicator = new PageIndicator(this.manager, line);
        if (!(view instanceof BrailleView)) {
            pageIndicator.findPageNums((Node)newPage);
        }
        view.paintedElements.add(pageIndicator);
        pageIndicator.startListener(view);
    }

    protected final void addLastPageIndicator(@NotNull MapList list, @NotNull WPView view) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        TextMapElement tme = this.getFinalNonWhiteSpaceElement(list);
        if (tme != null) {
            int n = ((Collection)tme.brailleList).size();
            for (int i = 0; i < n; ++i) {
                BrailleMapElement bme = tme.brailleList.get(i);
                if (!(bme instanceof BraillePageBrlMapElement)) continue;
                int n2 = view.getView().getCharCount();
                Node node = ((BraillePageBrlMapElement)bme).getNode();
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
                this.handleNewPageElement(n2, (Element)node, view);
            }
        }
    }

    protected final void renderLineIndents(@NotNull List<Integer> lineIndents, @NotNull WPView view) {
        Intrinsics.checkNotNullParameter(lineIndents, (String)"lineIndents");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Iterator iterator = ((Iterable)lineIndents).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int j = n++;
            int lineIndent = ((Number)iterator.next()).intValue();
            if (lineIndent == 0) continue;
            view.getView().setLineIndent(j, 1, lineIndent * view.getCharWidth());
        }
    }

    public final void addLineBreak(@NotNull LineBreakElement lb, @Nullable RendererState state, @NotNull MapList list) {
        Intrinsics.checkNotNullParameter((Object)lb, (String)"lb");
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        int index = list.indexOf(lb);
        if (index > 0 && !(list.get(index - 1) instanceof WhiteSpaceElement)) {
            lb.setEndOfLine(true);
        }
    }

    private final TextMapElement getFinalNonWhiteSpaceElement(MapList list) {
        Object v0;
        block1: {
            List $this$lastOrNull$iv = list;
            boolean $i$f$lastOrNull = false;
            ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                TextMapElement it = (TextMapElement)element$iv;
                boolean bl = false;
                if (!(!(it instanceof FormattingWhiteSpaceElement))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }
}

