/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.views.wp;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.BBXUtils;
import org.brailleblaster.bbx.BBXUtilsKt;
import org.brailleblaster.exceptions.EditingException;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.math.numberLine.NumberLine;
import org.brailleblaster.math.numberLine.NumberLineConstants;
import org.brailleblaster.math.spatial.Matrix;
import org.brailleblaster.math.spatial.MatrixConstants;
import org.brailleblaster.math.spatial.SpatialMathUtils;
import org.brailleblaster.math.template.Template;
import org.brailleblaster.math.template.TemplateConstants;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.AbstractMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.BoxLineTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.FormattingWhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.elements.ImagePlaceholderTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.LineBreakElement;
import org.brailleblaster.perspectives.braille.mapping.elements.PageBreakWhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.elements.PageIndicatorTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.PaintedWhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.elements.ReadOnlyFormattingWhiteSpace;
import org.brailleblaster.perspectives.braille.mapping.elements.TabTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.WhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.interfaces.Deletable;
import org.brailleblaster.perspectives.braille.mapping.interfaces.Uneditable;
import org.brailleblaster.perspectives.braille.mapping.maps.MapList;
import org.brailleblaster.perspectives.braille.messages.AdjustLocalStyleMessage;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.braille.messages.TabInsertionMessage;
import org.brailleblaster.perspectives.braille.stylers.MergeElementHandler;
import org.brailleblaster.perspectives.braille.views.wp.Selection;
import org.brailleblaster.perspectives.braille.views.wp.TextRenderer;
import org.brailleblaster.perspectives.braille.views.wp.TextView;
import org.brailleblaster.perspectives.braille.views.wp.Validator;
import org.brailleblaster.perspectives.braille.views.wp.ViewStateObject;
import org.brailleblaster.perspectives.braille.views.wp.formatters.EditRecorder;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.perspectives.mvc.XMLNodeCaret;
import org.brailleblaster.perspectives.mvc.XMLTextCaret;
import org.brailleblaster.perspectives.mvc.events.ModifyEvent;
import org.brailleblaster.perspectives.mvc.events.XMLCaretEvent;
import org.brailleblaster.perspectives.mvc.modules.misc.TableSelectionModule;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.tools.LineBreakTool;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.Style;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.utd.utils.UTDHelper;
import org.brailleblaster.util.ConstantsKt;
import org.brailleblaster.util.Notify;
import org.brailleblaster.util.SoundManager;
import org.brailleblaster.util.Utils;
import org.brailleblaster.util.WhitespaceUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0017\u0018\u0000 O2\u00020\u0001:\u0002NOB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010 \u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001c\u0010\"\u001a\u00020\u00142\b\u0010#\u001a\u0004\u0018\u00010\u001b2\b\u0010$\u001a\u0004\u0018\u00010\u001bH\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\u001b2\u0006\u0010&\u001a\u00020\u001bH\u0002J\u0018\u0010'\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010)\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0019H\u0002J\u0018\u0010.\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u0019H\u0002J\u0010\u0010/\u001a\u00020\u00142\u0006\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u000203H\u0002J\u0018\u00104\u001a\u00020\u00142\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0019H\u0002J)\u00104\u001a\u00020\u00142\u0006\u00107\u001a\u00020\u00192\u0012\u00108\u001a\n\u0012\u0006\b\u0001\u0012\u00020609\"\u000206H\u0002\u00a2\u0006\u0002\u0010:J\u0010\u0010;\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010<\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010=\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010>\u001a\u00020\u00192\b\u0010?\u001a\u0004\u0018\u00010\u001b2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010@\u001a\u00020\u00192\u0006\u0010A\u001a\u00020\u001bH\u0002J\u0010\u0010B\u001a\u00020\u00192\u0006\u0010C\u001a\u000206H\u0002J\u0010\u0010D\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010E\u001a\u00020\u0019H\u0002J\b\u0010F\u001a\u00020\u0019H\u0002J\u0018\u0010G\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u001bH\u0002J\u0012\u0010H\u001a\u00020\u00192\b\u0010?\u001a\u0004\u0018\u00010\u001bH\u0002J\u0018\u0010I\u001a\u00020\u00192\u0006\u0010J\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010K\u001a\u00020\u00192\u0006\u0010?\u001a\u00020\u001bH\u0002J\u0010\u0010L\u001a\u00020\u00192\u0006\u0010?\u001a\u00020\u001bH\u0002J\u0010\u0010M\u001a\u00020\u00192\u0006\u0010J\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lorg/brailleblaster/perspectives/braille/views/wp/TextVerifyKeyListener;", "Lorg/eclipse/swt/custom/VerifyKeyListener;", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "textView", "Lorg/brailleblaster/perspectives/braille/views/wp/TextView;", "stateObj", "Lorg/brailleblaster/perspectives/braille/views/wp/ViewStateObject;", "selection", "Lorg/brailleblaster/perspectives/braille/views/wp/Selection;", "validator", "Lorg/brailleblaster/perspectives/braille/views/wp/Validator;", "editRecorder", "Lorg/brailleblaster/perspectives/braille/views/wp/formatters/EditRecorder;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;Lorg/brailleblaster/perspectives/braille/views/wp/TextView;Lorg/brailleblaster/perspectives/braille/views/wp/ViewStateObject;Lorg/brailleblaster/perspectives/braille/views/wp/Selection;Lorg/brailleblaster/perspectives/braille/views/wp/Validator;Lorg/brailleblaster/perspectives/braille/views/wp/formatters/EditRecorder;)V", "overrides", "", "Lorg/brailleblaster/perspectives/braille/views/wp/TextVerifyKeyListener$OverrideKeyStroke;", "verifyKey", "", "e", "Lorg/eclipse/swt/events/VerifyEvent;", "recordLine", "atStart", "", "currentElement", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "caretOffset", "", "atEnd", "checkInlineEnter", "checkEnter", "checkLineBreak", "addLineBreak", "t1", "t2", "findWhitespace", "current", "checkBackspace", "checkDelete", "checkElementDeletion", "removeWhitespace", "wse", "Lorg/brailleblaster/perspectives/braille/mapping/elements/WhiteSpaceElement;", "delete", "removeWhitespaceInline", "removeTab", "tab", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TabTextMapElement;", "removeInlineWhitespace", "Lnu/xom/Element;", "dispatchModifyEvent", "modifiedNode", "Lnu/xom/Node;", "translate", "modifiedNodes", "", "(Z[Lnu/xom/Node;)V", "isEditingKey", "isDeletionKey", "readOnly", "isInline", "t", "followsWhiteSpace", "tme", "deletePrecedingInlineLineBreak", "n", "openSubmenu", "validCut", "validPaste", "validMerge", "isMergable", "atDocumentBoundary", "keyCode", "isBeginningOfDocument", "isEndOfDocument", "isArrowKey", "OverrideKeyStroke", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nTextVerifyKeyListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextVerifyKeyListener.kt\norg/brailleblaster/perspectives/braille/views/wp/TextVerifyKeyListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1144:1\n296#2,2:1145\n296#2,2:1147\n296#2,2:1149\n*S KotlinDebug\n*F\n+ 1 TextVerifyKeyListener.kt\norg/brailleblaster/perspectives/braille/views/wp/TextVerifyKeyListener\n*L\n272#1:1145,2\n850#1:1147,2\n857#1:1149,2\n*E\n"})
public final class TextVerifyKeyListener
implements VerifyKeyListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Manager manager;
    @NotNull
    private final TextView textView;
    @NotNull
    private final ViewStateObject stateObj;
    @NotNull
    private final Selection selection;
    @NotNull
    private final Validator validator;
    @NotNull
    private final EditRecorder editRecorder;
    @NotNull
    private final List<OverrideKeyStroke> overrides;
    @NotNull
    private static final Logger log;
    private static final int CTRL;
    private static final int SHIFT;
    @NotNull
    private static final Consumer<VerifyEvent> NO_ACTION;

    public TextVerifyKeyListener(@NotNull Manager manager, @NotNull TextView textView, @NotNull ViewStateObject stateObj, @NotNull Selection selection, @NotNull Validator validator, @NotNull EditRecorder editRecorder) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        Intrinsics.checkNotNullParameter((Object)stateObj, (String)"stateObj");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)validator, (String)"validator");
        Intrinsics.checkNotNullParameter((Object)editRecorder, (String)"editRecorder");
        this.manager = manager;
        this.textView = textView;
        this.stateObj = stateObj;
        this.selection = selection;
        this.validator = validator;
        this.editRecorder = editRecorder;
        Object[] objectArray = new OverrideKeyStroke[]{new OverrideKeyStroke(CTRL, 'a', NO_ACTION), new OverrideKeyStroke(CTRL + SHIFT, '\t', NO_ACTION), new OverrideKeyStroke(CTRL, 'x', arg_0 -> TextVerifyKeyListener._init_$lambda$0(this, arg_0), NO_ACTION), new OverrideKeyStroke(CTRL, 'v', arg_0 -> TextVerifyKeyListener._init_$lambda$1(this, arg_0), NO_ACTION), new OverrideKeyStroke(SHIFT, '\r', arg_0 -> TextVerifyKeyListener._init_$lambda$2(this, arg_0)), new OverrideKeyStroke(SHIFT, 0x1000050, arg_0 -> TextVerifyKeyListener._init_$lambda$3(this, arg_0)), new OverrideKeyStroke(0, '\r', arg_0 -> TextVerifyKeyListener._init_$lambda$4(this, arg_0)), new OverrideKeyStroke(0, 0x1000050, arg_0 -> TextVerifyKeyListener._init_$lambda$5(this, arg_0)), new OverrideKeyStroke(0, '\t', arg_0 -> TextVerifyKeyListener._init_$lambda$6(this, arg_0)), new OverrideKeyStroke(CTRL, ' ', arg_0 -> TextVerifyKeyListener._init_$lambda$7(this, arg_0)), new OverrideKeyStroke(CTRL + SHIFT, 0x1000007, arg_0 -> TextVerifyKeyListener._init_$lambda$8(this, arg_0)), new OverrideKeyStroke(CTRL + SHIFT, 0x1000008, arg_0 -> TextVerifyKeyListener._init_$lambda$9(this, arg_0)), new OverrideKeyStroke(0, 0x1000009, NO_ACTION), new OverrideKeyStroke(CTRL, '\b', arg_0 -> TextVerifyKeyListener._init_$lambda$10(this, arg_0)), new OverrideKeyStroke(CTRL, '\u007f', arg_0 -> TextVerifyKeyListener._init_$lambda$11(this, arg_0))};
        this.overrides = CollectionsKt.listOf((Object[])objectArray);
    }

    public void verifyKey(@NotNull VerifyEvent e) {
        block27: {
            Object v1;
            block26: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.stateObj.setOldCursorPosition(this.textView.getView().getCaretOffset());
                this.stateObj.setCurrentChar(e.keyCode);
                this.stateObj.setCurrentStateMask(e.stateMask);
                TextMapElement currentElement = this.textView.getCurrentElement();
                this.recordLine();
                if (this.textView.getUiLock()) {
                    e.doit = false;
                    return;
                }
                if (this.isArrowKey(e.keyCode) && e.stateMask != 131072) {
                    this.selection.setSelectionLength(0);
                }
                if (this.openSubmenu(e)) {
                    this.textView.updateContextMenu();
                    return;
                }
                if (this.isEditingKey(e) && currentElement instanceof Uneditable) {
                    ((Uneditable)((Object)currentElement)).blockEdit(this.manager);
                    e.doit = false;
                    return;
                }
                if ((this.isEditingKey(e) || this.isDeletionKey(e)) && this.manager.isTableSelected()) {
                    TableSelectionModule.Companion.displayInvalidTableMessage(this.manager.getWpManager().getShell());
                    e.doit = false;
                    return;
                }
                if (currentElement != null) {
                    if ((this.isEditingKey(e) || this.isDeletionKey(e) || e.character == '\r') && SpatialMathUtils.middleSpatialMathPage(currentElement)) {
                        log.error("Editing inside spatial math page on the border of two blocks");
                        Notify.notify$default(Notify.INSTANCE, SpatialMathUtils.USE_EDITOR_WARNING, Notify.ALERT_SHELL_NAME, false, 4, null);
                        e.doit = false;
                        return;
                    }
                    if ((this.isEditingKey(e) || this.isDeletionKey(e) || e.character == '\r') && NumberLine.Companion.middleNumberLine(currentElement)) {
                        log.error("Editing inside number line on the border of two blocks");
                        Notify.notify$default(Notify.INSTANCE, NumberLineConstants.USE_EDITOR_WARNING, Notify.ALERT_SHELL_NAME, false, 4, null);
                        e.doit = false;
                        return;
                    }
                    if ((this.isEditingKey(e) || this.isDeletionKey(e) || e.character == '\r') && Matrix.Companion.middleMatrix(currentElement)) {
                        log.error("Editing inside matrix on the border of two blocks");
                        Notify.notify$default(Notify.INSTANCE, MatrixConstants.INSTANCE.getUSE_EDITOR_WARNING(), Notify.ALERT_SHELL_NAME, false, 4, null);
                        e.doit = false;
                        return;
                    }
                    if ((this.isEditingKey(e) || this.isDeletionKey(e) || e.character == '\r') && Template.Companion.middleTemplate(currentElement)) {
                        log.error("Editing inside template on the border of two blocks");
                        Notify.notify$default(Notify.INSTANCE, TemplateConstants.INSTANCE.getUSE_EDITOR_WARNING(), Notify.ALERT_SHELL_NAME, false, 4, null);
                        e.doit = false;
                        return;
                    }
                    if (this.atDocumentBoundary(e.keyCode, currentElement)) {
                        SoundManager.INSTANCE.playSelectionBell();
                        return;
                    }
                    if (e.keyCode == 8) {
                        if (e.stateMask == CTRL) {
                            this.textView.getView().invokeAction(17170435);
                        }
                        if (this.selection.getSelectionLength() > 0 && !(currentElement instanceof PageIndicatorTextMapElement) && !this.validator.validBackspace(currentElement, this.stateObj, this.selection.selectionStart, this.selection.getSelectionLength())) {
                            e.doit = false;
                        } else {
                            try {
                                this.checkBackspace(e, this.stateObj.getOldCursorPosition());
                            }
                            catch (RuntimeException ex) {
                                throw new EditingException("An error occurred while processing backspace", (Throwable)ex);
                            }
                        }
                    } else if (e.keyCode == 127) {
                        if (e.stateMask == CTRL) {
                            this.textView.getView().invokeAction(17170436);
                        }
                        if (this.selection.getSelectionLength() > 0 && !(currentElement instanceof PageIndicatorTextMapElement) && !this.validator.validDelete(currentElement, this.stateObj, this.selection.selectionStart, this.selection.getSelectionLength())) {
                            e.doit = false;
                        } else {
                            try {
                                this.checkDelete(e);
                            }
                            catch (RuntimeException ex) {
                                throw new EditingException("An error occurred while processing delete", (Throwable)ex);
                            }
                        }
                    }
                }
                if (!e.doit) {
                    return;
                }
                Iterable $this$firstOrNull$iv = this.overrides;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    OverrideKeyStroke it = (OverrideKeyStroke)element$iv;
                    boolean bl = false;
                    boolean bl2 = it.getStateMask() == e.stateMask && it.getKeyCode() == e.keyCode && it.getCriteria().test(e);
                    if (!bl2) continue;
                    v1 = element$iv;
                    break block26;
                }
                v1 = null;
            }
            OverrideKeyStroke overrideKeyStroke = v1;
            if (overrideKeyStroke == null) break block27;
            OverrideKeyStroke it = overrideKeyStroke;
            boolean bl = false;
            it.getOnOverride().accept(e);
            e.doit = false;
        }
    }

    private final void recordLine() {
        if (this.selection.getSelectionLength() > 0) {
            this.editRecorder.recordLine(this.selection.selectionStart, this.selection.getSelectionEnd());
        } else {
            this.editRecorder.recordLine(this.textView.getView().getLine(this.textView.getView().getLineAtOffset(this.textView.getView().getCaretOffset())), this.textView.getView().getLineAtOffset(this.textView.getView().getCaretOffset()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean atStart(TextMapElement currentElement, int caretOffset) {
        if (currentElement instanceof WhiteSpaceElement) return true;
        if (caretOffset != currentElement.getStart(this.manager.getMapList())) return false;
        Node node = currentElement.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
        if (Companion.isBeginningOfBlock(node)) return true;
        if (currentElement instanceof BoxLineTextMapElement) return true;
        if (!(currentElement instanceof PageIndicatorTextMapElement)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean atEnd(TextMapElement currentElement, int caretOffset) {
        if (currentElement instanceof WhiteSpaceElement) return true;
        if (caretOffset != currentElement.getEnd(this.manager.getMapList())) return false;
        Node node = currentElement.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
        if (Companion.isEndOfBlock(node)) return true;
        if (currentElement instanceof BoxLineTextMapElement) return true;
        if (!(currentElement instanceof PageIndicatorTextMapElement)) return false;
        return true;
    }

    private final void checkInlineEnter(int caretOffset) {
        TextMapElement currentElement = this.manager.getMapList().getClosest(caretOffset, true);
        Intrinsics.checkNotNull((Object)currentElement);
        if (this.atStart(currentElement, caretOffset)) {
            this.checkLineBreak(caretOffset);
        } else if (this.atEnd(currentElement, caretOffset)) {
            this.checkLineBreak(caretOffset);
        } else {
            LineBreakTool.INSTANCE.insertInlineLineBreak(this.manager);
        }
    }

    private final void checkEnter(VerifyEvent e, int caretOffset) {
        try {
            this.checkLineBreak(this.textView.getView().getCaretOffset());
        }
        catch (RuntimeException ex) {
            throw new EditingException("An error occurred while processing a line break", (Throwable)ex);
        }
        e.doit = false;
    }

    private final void checkLineBreak(int caretOffset) {
        int n;
        if (this.textView.textChanged) {
            StyledText styledText = this.textView.getView();
            TextMapElement textMapElement = this.textView.getCurrentElement();
            Intrinsics.checkNotNull((Object)textMapElement);
            int n2 = textMapElement.getStart(this.manager.getMapList());
            int n3 = this.textView.getView().getCaretOffset();
            TextMapElement textMapElement2 = this.textView.getCurrentElement();
            Intrinsics.checkNotNull((Object)textMapElement2);
            String string = styledText.getTextRange(n2, n3 - textMapElement2.getStart(this.manager.getMapList()));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextRange(...)");
            String text = StringsKt.replace$default((String)string, (String)ConstantsKt.getLINE_BREAK(), (String)"", (boolean)false, (int)4, null);
            int realOffset = text.length();
            this.textView.update(false);
            this.textView.setCurrent(this.textView.getView().getCaretOffset());
            TextMapElement textMapElement3 = this.textView.getCurrentElement();
            Intrinsics.checkNotNull((Object)textMapElement3);
            if (textMapElement3.getNode() instanceof Text) {
                BBSimpleManager bBSimpleManager = this.manager.getSimpleManager();
                TextMapElement textMapElement4 = this.textView.getCurrentElement();
                Intrinsics.checkNotNull((Object)textMapElement4);
                Node node = textMapElement4.getNode();
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Text");
                bBSimpleManager.dispatchEvent(new XMLCaretEvent(Sender.NO_SENDER, new XMLTextCaret((Text)node, realOffset, null, 4, null), null, 4, null));
            }
            n = this.textView.getView().getCaretOffset();
        } else {
            n = caretOffset;
        }
        int calculatedCaretOffset = n;
        TextMapElement textMapElement = this.manager.getMapList().getCurrent();
        Intrinsics.checkNotNullExpressionValue((Object)textMapElement, (String)"getCurrent(...)");
        TextMapElement currentElement = textMapElement;
        boolean atEnd = this.atEnd(currentElement, calculatedCaretOffset);
        boolean atStart = this.atStart(currentElement, calculatedCaretOffset);
        if (currentElement instanceof WhiteSpaceElement) {
            if (currentElement instanceof Uneditable) {
                ((Uneditable)((Object)currentElement)).blockEdit(this.manager);
            } else {
                TextMapElement t;
                TextMapElement textMapElement5 = t = this.findWhitespace(currentElement);
                Intrinsics.checkNotNull((Object)textMapElement5);
                int newOffset = textMapElement5.getStart(this.manager.getMapList()) < currentElement.getStart(this.manager.getMapList()) ? t.getEnd(this.manager.getMapList()) : t.getStart(this.manager.getMapList());
                if (!(newOffset != calculatedCaretOffset)) {
                    boolean $i$a$-check-TextVerifyKeyListener$checkLineBreak$22 = false;
                    String $i$a$-check-TextVerifyKeyListener$checkLineBreak$22 = "Unable to add line break";
                    throw new IllegalStateException($i$a$-check-TextVerifyKeyListener$checkLineBreak$22.toString());
                }
                this.textView.setCurrent(newOffset);
                this.checkLineBreak(newOffset);
            }
        } else if (atEnd) {
            if (this.manager.getMapList().getNext(false) instanceof ReadOnlyFormattingWhiteSpace) {
                TextMapElement textMapElement6 = this.manager.getMapList().getNext(false);
                Intrinsics.checkNotNull((Object)textMapElement6, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.braille.mapping.elements.ReadOnlyFormattingWhiteSpace");
                ((ReadOnlyFormattingWhiteSpace)textMapElement6).blockEdit(this.manager);
                return;
            }
            this.addLineBreak(currentElement, this.manager.getMapList().findNextNonWhitespace(this.manager.getMapList().indexOf(currentElement) + 1));
            Element element = currentElement.getNodeParent();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getNodeParent(...)");
            this.dispatchModifyEvent((Node)element, false);
            if (this.manager.getMapList().getNext(false) != null) {
                TextMapElement nextTME = this.manager.getMapList().getNext(false);
                try {
                    this.textView.setCursor(nextTME.getStart(this.manager.getMapList()));
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed on TME " + nextTME, e);
                }
                this.textView.setCurrent(this.textView.getView().getCaretOffset());
            } else {
                Element element2;
                Node[] style;
                TextMapElement lastTME = this.manager.getMapList().findPreviousNonWhitespace(this.manager.getMapList().size() - 1);
                Element lastBlock = null;
                while (lastTME != null) {
                    Node node = lastTME.getNode();
                    Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
                    lastBlock = BBXUtilsKt.findBlock(node);
                    if (lastBlock != null) break;
                    lastTME = this.manager.getMapList().findPreviousNonWhitespace(this.manager.getMapList().indexOf(lastTME));
                }
                if (lastBlock == null) {
                    throw new RuntimeException("Could not find last block");
                }
                UTDManager uTDManager = this.manager.getDocument().getSettingsManager();
                IStyle iStyle = this.manager.getStyle((Node)lastBlock);
                Intrinsics.checkNotNull((Object)iStyle, (String)"null cannot be cast to non-null type org.brailleblaster.utd.Style");
                uTDManager.applyStyleWithOption((Style)iStyle, Style.StyleOption.NEW_PAGES_AFTER, 1, lastBlock);
                Node lastBlockParent = (Node)lastBlock.getParent();
                while (BBX.CONTAINER.isA(lastBlockParent)) {
                    Element element3 = lastBlock = (Element)lastBlockParent;
                    Intrinsics.checkNotNull((Object)element3);
                    lastBlockParent = (Node)element3.getParent();
                }
                String lastStyle = lastBlock.getAttributeValue("utd-style");
                if (lastStyle != null) {
                    style = this.manager.getSimpleManager().getUtdManager().getBaseStyle(lastStyle, (Node)lastBlock);
                    element2 = BBX.BLOCK.STYLE.create((String)style);
                } else {
                    element2 = BBX.BLOCK.DEFAULT.create();
                }
                Element newBlock = element2;
                newBlock.addAttribute(new Attribute("newPagePlaceholder", "true"));
                newBlock.appendChild("\u00b6");
                lastBlock.getParent().appendChild((Node)newBlock);
                style = new Node[2];
                style[0] = lastBlock;
                Intrinsics.checkNotNull((Object)newBlock);
                style[1] = newBlock;
                this.dispatchModifyEvent(true, style);
                TextMapElement pilcrowTME = this.manager.getMapList().getPrevious(this.manager.getMapList().size() - 1, true);
                try {
                    this.textView.setCursor(pilcrowTME.getStart(this.manager.getMapList()) + pilcrowTME.textLength());
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed on TME " + pilcrowTME, e);
                }
                this.textView.setCurrent(this.textView.getView().getCaretOffset());
            }
        } else if (atStart) {
            if (this.manager.getMapList().getPrevious(false) instanceof ReadOnlyFormattingWhiteSpace) {
                TextMapElement textMapElement7 = this.manager.getMapList().getPrevious(false);
                Intrinsics.checkNotNull((Object)textMapElement7, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.braille.mapping.elements.ReadOnlyFormattingWhiteSpace");
                ((ReadOnlyFormattingWhiteSpace)textMapElement7).blockEdit(this.manager);
            } else {
                this.addLineBreak(this.manager.getMapList().findPreviousNonWhitespace(this.manager.getMapList().indexOf(currentElement) - 1), currentElement);
                Element element = currentElement.getNodeParent();
                Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getNodeParent(...)");
                this.dispatchModifyEvent((Node)element, false);
                this.textView.setCursor(this.textView.getView().getCaretOffset() + ConstantsKt.getLINE_BREAK().length());
                this.textView.setCurrent(this.textView.getView().getCaretOffset());
            }
        } else if (currentElement instanceof Uneditable) {
            ((Uneditable)((Object)currentElement)).blockEdit(this.manager);
        } else {
            this.manager.splitElement();
        }
    }

    private final void addLineBreak(TextMapElement t1, TextMapElement t2) {
        boolean prepend = true;
        if (t2 instanceof BoxLineTextMapElement) {
            prepend = false;
        } else if (t2 == null) {
            return;
        }
        if (t1 != null) {
            MapList mapList = this.manager.getMapList();
            Intrinsics.checkNotNullExpressionValue((Object)mapList, (String)"getMapList(...)");
            WhitespaceUtils.convertWhiteSpaceToLineBreaks(t1, t2, mapList);
        }
        if (prepend) {
            Node node = t2.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
            WhitespaceUtils.prependLineBreakElement(node);
        } else if (t1 != null) {
            Node node = t1.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
            WhitespaceUtils.appendLineBreakElement(node);
        }
    }

    private final TextMapElement findWhitespace(TextMapElement current) {
        TextMapElement tme = this.manager.getMapList().getNext(true);
        if (tme == null) {
            tme = this.manager.getMapList().getPrevious(true);
        }
        return tme;
    }

    private final void checkBackspace(VerifyEvent e, int caretOffset) {
        TextMapElement currentElement = this.textView.getCurrentElement();
        if (caretOffset != this.stateObj.getCurrentStart() && this.checkElementDeletion(e)) {
            return;
        }
        if (this.selection.getSelectionLength() > 0) {
            return;
        }
        boolean cursorUpdated = false;
        if (caretOffset == this.stateObj.getCurrentStart()) {
            if (currentElement instanceof WhiteSpaceElement) {
                int currentOffset = this.textView.getView().getCaretOffset();
                this.removeWhitespace((WhiteSpaceElement)currentElement, false);
                if (currentOffset >= ConstantsKt.getLINE_BREAK().length()) {
                    this.textView.setCursor(currentOffset - ConstantsKt.getLINE_BREAK().length());
                    this.textView.setCurrent(this.textView.getView().getCaretOffset());
                }
                e.doit = false;
                return;
            }
            if (caretOffset != this.stateObj.getPreviousEnd()) {
                TextMapElement textMapElement = currentElement;
                Intrinsics.checkNotNull((Object)textMapElement);
                Element element = textMapElement.getNodeParent();
                Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getNodeParent(...)");
                ParentNode parent = (ParentNode)element;
                Node node = currentElement.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
                if (this.deletePrecedingInlineLineBreak(node)) {
                    ParentNode parentNode = parent.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
                    this.dispatchModifyEvent((Node)parentNode, true);
                    cursorUpdated = true;
                } else if (this.stateObj.getCurrentStart() != this.stateObj.getCurrentEnd() && this.followsWhiteSpace(currentElement)) {
                    TextMapElement textMapElement2 = this.manager.getMapList().getPrevious(false);
                    Intrinsics.checkNotNull((Object)textMapElement2, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.braille.mapping.elements.WhiteSpaceElement");
                    this.removeWhitespace((WhiteSpaceElement)textMapElement2, false);
                    if (currentElement.getNode() instanceof Text) {
                        BBSimpleManager bBSimpleManager = this.manager.getSimpleManager();
                        Node node2 = currentElement.getNode();
                        Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type nu.xom.Text");
                        bBSimpleManager.dispatchEvent(new XMLCaretEvent(Sender.NO_SENDER, new XMLTextCaret((Text)node2, 0, null, 4, null), null, 4, null));
                    } else if (e.keyCode == 8) {
                        this.textView.setCursor(this.textView.getView().getCaretOffset() - System.lineSeparator().length());
                        this.textView.setCurrent(this.textView.getView().getCaretOffset());
                    }
                    cursorUpdated = true;
                } else if (this.manager.getMapList().getPrevious(false) instanceof Deletable) {
                    this.textView.update(false);
                    Node current = this.manager.getMapList().getCurrent().getNode();
                    TextMapElement textMapElement3 = this.manager.getMapList().getPrevious(false);
                    Intrinsics.checkNotNull((Object)textMapElement3, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.braille.mapping.interfaces.Deletable");
                    Node modifiedNode = (Node)((Deletable)((Object)textMapElement3)).deleteNode(this.manager);
                    if (modifiedNode != null) {
                        Node[] nodeArray = new Node[]{modifiedNode};
                        this.manager.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.NO_SENDER, false, nodeArray));
                    }
                    if (current != null && this.manager.getMapList().findNode(current) != null) {
                        if (current instanceof Text) {
                            this.manager.getSimpleManager().dispatchEvent(new XMLCaretEvent(Sender.NO_SENDER, new XMLTextCaret((Text)current, 0, null, 4, null), null, 4, null));
                            cursorUpdated = true;
                        } else if (current instanceof Element) {
                            this.manager.getSimpleManager().dispatchEvent(new XMLCaretEvent(Sender.NO_SENDER, new XMLNodeCaret(current, null, 2, null), null, 4, null));
                            cursorUpdated = true;
                        }
                    }
                } else {
                    if (this.manager.getMapList().getPrevious(false) == null) {
                        SoundManager.INSTANCE.playSelectionBell();
                        e.doit = false;
                        return;
                    }
                    TextMapElement textMapElement4 = this.manager.getMapList().getPrevious(false);
                    Intrinsics.checkNotNullExpressionValue((Object)textMapElement4, (String)"getPrevious(...)");
                    if (this.validMerge(currentElement, textMapElement4)) {
                        this.textView.update(false);
                        Node node3 = currentElement.getNode();
                        TextMapElement textMapElement5 = this.textView.getCurrentElement();
                        Intrinsics.checkNotNull((Object)textMapElement5);
                        if (node3 == textMapElement5.getNode()) {
                            TextMapElement textMapElement6 = this.manager.getMapList().getPrevious(false);
                            Intrinsics.checkNotNullExpressionValue((Object)textMapElement6, (String)"getPrevious(...)");
                            TextMapElement textMapElement7 = this.textView.getCurrentElement();
                            Intrinsics.checkNotNull((Object)textMapElement7);
                            MergeElementHandler.Companion.merge(textMapElement6, textMapElement7, this.manager);
                        } else if (this.textView.getView().getCaretOffset() >= System.lineSeparator().length()) {
                            this.textView.setCurrent(this.textView.getView().getCaretOffset() - System.lineSeparator().length());
                            this.textView.setCursor(this.textView.getView().getCaretOffset() - System.lineSeparator().length());
                        }
                        cursorUpdated = true;
                    }
                }
                e.doit = false;
            } else if (this.manager.getMapList().getPrevious(false) instanceof TabTextMapElement) {
                TextMapElement textMapElement = this.manager.getMapList().getPrevious(false);
                Intrinsics.checkNotNull((Object)textMapElement, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.braille.mapping.elements.TabTextMapElement");
                this.removeTab((TabTextMapElement)textMapElement);
                e.doit = false;
                cursorUpdated = true;
            } else if (this.manager.getMapList().getPrevious(false) instanceof Uneditable) {
                e.doit = false;
                cursorUpdated = true;
            }
        } else if (currentElement instanceof WhiteSpaceElement && e.start == ((WhiteSpaceElement)currentElement).getStart(this.manager.getMapList())) {
            this.removeWhitespace((WhiteSpaceElement)currentElement, false);
            e.doit = false;
            cursorUpdated = true;
        }
        if (!cursorUpdated && caretOffset == this.textView.getView().getOffsetAtLine(this.textView.getView().getLineAtOffset(caretOffset))) {
            int line = this.textView.getView().getLineAtOffset(caretOffset);
            if (line > 0) {
                int newOffset = this.textView.getView().getOffsetAtLine(line - 1) + this.textView.getView().getLine(line - 1).length();
                this.textView.update(false);
                if (newOffset < this.textView.getView().getCharCount()) {
                    this.textView.setCurrent(newOffset);
                    this.textView.setCursor(newOffset);
                }
            }
            e.doit = false;
        }
    }

    private final void checkDelete(VerifyEvent e) {
        int caretOffset = this.stateObj.getOldCursorPosition();
        if (caretOffset != this.stateObj.getCurrentEnd() && this.checkElementDeletion(e)) {
            return;
        }
        if (this.selection.getSelectionLength() > 0) {
            return;
        }
        if (caretOffset + 1 >= this.textView.getView().getText().length()) {
            e.doit = false;
            return;
        }
        if (!(caretOffset != this.stateObj.getNextStart() || this.manager.getMapList().getNext(false) instanceof WhiteSpaceElement || this.manager.getMapList().getNext(false) instanceof Deletable || this.manager.getMapList().getNext(false) instanceof Uneditable)) {
            this.textView.update(false);
            caretOffset = this.stateObj.getOldCursorPosition();
        }
        if (caretOffset == this.stateObj.getCurrentEnd()) {
            int newOffset;
            Node currNode;
            e.doit = true;
            TextMapElement currentElement = this.textView.getCurrentElement();
            if (currentElement instanceof WhiteSpaceElement) {
                int currentOffset = this.textView.getView().getCaretOffset();
                this.removeWhitespace((WhiteSpaceElement)currentElement, true);
                if (currentOffset >= ConstantsKt.getLINE_BREAK().length()) {
                    this.textView.setCursor(currentOffset - ConstantsKt.getLINE_BREAK().length());
                    this.textView.setCurrent(this.textView.getView().getCaretOffset());
                }
                e.doit = false;
                return;
            }
            TextMapElement nextTME = this.manager.getMapList().getNext(false);
            if (nextTME.getNode() != null && Intrinsics.areEqual((Object)(currNode = nextTME.getNode()).getValue(), (Object)"\u00b6")) {
                ParentNode parentNode = currNode.getParent();
                Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
                if (((Element)parentNode).getAttribute("newPagePlaceholder") != null) {
                    ParentNode parentNode2 = currNode.getParent().getParent();
                    Intrinsics.checkNotNull((Object)parentNode2, (String)"null cannot be cast to non-null type nu.xom.Element");
                    Element parent = (Element)parentNode2;
                    nextTME.getNode().getParent().detach();
                    Node[] nodeArray = new Node[]{parent};
                    this.manager.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.NO_SENDER, false, nodeArray));
                    e.doit = false;
                    return;
                }
            }
            if (nextTME instanceof Deletable) {
                this.textView.update(false);
                if (this.manager.getMapList().contains(nextTME)) {
                    ParentNode modifiedNode = ((Deletable)((Object)nextTME)).deleteNode(this.manager);
                    if (modifiedNode == null) {
                        this.manager.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.NO_SENDER, false, new Node[0]));
                    } else {
                        Node[] nodeArray = new Node[]{modifiedNode};
                        this.manager.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.NO_SENDER, false, nodeArray));
                    }
                }
                e.doit = false;
                return;
            }
            if (this.textView.textChanged) {
                if (this.stateObj.getCurrentStart() == this.stateObj.getCurrentEnd()) {
                    e.doit = false;
                }
                this.textView.update(false);
                if (!e.doit) {
                    return;
                }
            }
            if ((newOffset = nextTME.getStart(this.manager.getMapList())) == caretOffset) {
                ++newOffset;
            }
            this.textView.getView().setRedraw(false);
            this.textView.setCurrentElement(newOffset);
            this.checkBackspace(e, newOffset);
            this.textView.setCurrentElement(caretOffset);
            this.textView.getView().setRedraw(true);
        }
    }

    private final boolean checkElementDeletion(VerifyEvent e) {
        TextMapElement currentElement = this.textView.getCurrentElement();
        if (this.textView.isMultiSelected()) {
            return false;
        }
        if (currentElement instanceof Deletable) {
            int elementStart = ((AbstractMapElement)currentElement).getStart(this.manager.getMapList());
            Node modifiedNode = (Node)((Deletable)((Object)currentElement)).deleteNode(this.manager);
            if (modifiedNode != null) {
                Node[] nodeArray = new Node[]{modifiedNode};
                this.manager.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.NO_SENDER, true, nodeArray));
            }
            this.textView.setCursor(elementStart);
            this.textView.setCurrent(this.textView.getView().getCaretOffset());
            e.doit = false;
            return true;
        }
        if (currentElement instanceof Uneditable) {
            ((Uneditable)((Object)currentElement)).blockEdit(this.manager);
            e.doit = false;
            return true;
        }
        return false;
    }

    private final void removeWhitespace(WhiteSpaceElement wse, boolean delete) {
        boolean converted;
        if (wse instanceof PageBreakWhiteSpaceElement) {
            ((PageBreakWhiteSpaceElement)wse).deleteNode(this.manager);
            return;
        }
        if (this.manager.getMapList().getNext(this.manager.getMapList().indexOf(wse), true) == null) {
            return;
        }
        if (this.removeWhitespaceInline(wse, delete)) {
            return;
        }
        int wseIndex = this.manager.getMapList().indexOf(wse);
        TextMapElement prev = this.manager.getMapList().findPreviousNonWhitespace(wseIndex);
        TextMapElement next = this.manager.getMapList().findNextNonWhitespace(wseIndex);
        if (this.isInline(prev, wse)) {
            TextMapElement textMapElement = prev;
            Intrinsics.checkNotNull((Object)textMapElement);
            Element element = textMapElement.getNodeParent();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getNodeParent(...)");
            this.removeInlineWhitespace(element);
            return;
        }
        if (this.isInline(next, wse)) {
            TextMapElement textMapElement = next;
            Intrinsics.checkNotNull((Object)textMapElement);
            Element element = textMapElement.getNodeParent();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getNodeParent(...)");
            this.removeInlineWhitespace(element);
            return;
        }
        boolean bl = converted = prev == null || next == null;
        if (!converted) {
            MapList mapList = this.manager.getMapList();
            Intrinsics.checkNotNullExpressionValue((Object)mapList, (String)"getMapList(...)");
            int i = CollectionsKt.indexOf((List)mapList, (Object)prev);
            int n = this.manager.getMapList().indexOf(next);
            if (i <= n) {
                while (true) {
                    if (this.manager.getMapList().get(i) instanceof LineBreakElement) {
                        converted = true;
                        break;
                    }
                    if (i == n) break;
                    ++i;
                }
            }
        }
        if (!converted) {
            TextMapElement textMapElement = prev;
            Intrinsics.checkNotNull((Object)textMapElement);
            TextMapElement textMapElement2 = next;
            Intrinsics.checkNotNull((Object)textMapElement2);
            MapList mapList = this.manager.getMapList();
            Intrinsics.checkNotNullExpressionValue((Object)mapList, (String)"getMapList(...)");
            WhitespaceUtils.convertWhiteSpaceToLineBreaks(textMapElement, textMapElement2, mapList);
        }
        TextMapElement lbe = null;
        Intrinsics.checkNotNullExpressionValue((Object)this.manager.getMapList(), (String)"getMapList(...)");
        int n = this.manager.getMapList().indexOf(next);
        for (int i = CollectionsKt.indexOf((List)(v156003), (Object)prev) + 1; i < n; ++i) {
            if (!(this.manager.getMapList().get(i) instanceof LineBreakElement)) continue;
            Object e = this.manager.getMapList().get(i);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.braille.mapping.elements.LineBreakElement");
            if (((LineBreakElement)e).isEndOfLine()) continue;
            Object e2 = this.manager.getMapList().get(i);
            Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.braille.mapping.elements.LineBreakElement");
            lbe = (LineBreakElement)e2;
            break;
        }
        if (lbe != null) {
            Node node;
            TextMapElement textMapElement = prev;
            if (textMapElement == null) {
                TextMapElement textMapElement3 = next;
                node = textMapElement3 == null ? (Node)((LineBreakElement)lbe).getNodeParent() : textMapElement3.getNode();
            } else {
                node = textMapElement.getNode();
            }
            Node modifyNode = node;
            lbe.getNode().detach();
            if (UTDElements.BRL.isA(modifyNode)) {
                modifyNode = (Node)modifyNode.getParent();
            }
            Node node2 = modifyNode;
            Intrinsics.checkNotNull((Object)node2);
            this.dispatchModifyEvent(node2, false);
        }
    }

    private final boolean removeWhitespaceInline(TextMapElement currentElement, boolean delete) {
        IStyle style;
        Node previousNode = null;
        Node nextNode = null;
        Node workNode = null;
        if (this.manager.getMapList().getPrevious(false) != null) {
            previousNode = this.manager.getMapList().getPrevious(false).getNode();
        }
        if (this.manager.getMapList().getNext(false) != null) {
            nextNode = this.manager.getMapList().getNext(false).getNode();
        }
        Node currentNode = this.manager.getSimpleManager().getCurrentSelection().start.getNode();
        if (currentElement instanceof FormattingWhiteSpaceElement) {
            if (this.manager.getMapList().getPrevious(true) != null) {
                previousNode = this.manager.getMapList().getPrevious(true).getNode();
            }
            if (this.manager.getMapList().getNext(true) != null) {
                nextNode = this.manager.getMapList().getNext(true).getNode();
            }
        } else if (this.manager.getMapList().getNext(false) instanceof FormattingWhiteSpaceElement && delete) {
            previousNode = currentNode;
            if (this.manager.getMapList().getNext(true) != null) {
                nextNode = this.manager.getMapList().getNext(true).getNode();
            }
        } else if (this.manager.getMapList().getPrevious(false) instanceof FormattingWhiteSpaceElement && !delete) {
            nextNode = currentNode;
            if (this.manager.getMapList().getPrevious(true) != null) {
                previousNode = this.manager.getMapList().getPrevious(true).getNode();
            }
        }
        if (previousNode == null || Intrinsics.areEqual((Object)previousNode, (Object)currentNode)) {
            Object v0;
            block19: {
                $this$firstOrNull$iv = FastXPath.INSTANCE.followingAndSelf(currentNode);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Node n = (Node)element$iv;
                    boolean bl = false;
                    if (!(BBX.INLINE.LINE_BREAK.isA(n) && !UTDElements.BRL.isA((Node)n.getParent()) && !UTDElements.BRL_PAGE_NUM.isA((Node)n.getParent()) && !UTDElements.BRLONLY.isA((Node)n.getParent()))) continue;
                    v0 = element$iv;
                    break block19;
                }
                v0 = null;
            }
            workNode = v0;
        } else if (nextNode == null || Intrinsics.areEqual((Object)nextNode, (Object)currentNode)) {
            Object v1;
            block20: {
                $this$firstOrNull$iv = FastXPath.INSTANCE.precedingAndSelf(currentNode);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Node n = (Node)element$iv;
                    boolean bl = false;
                    if (!(BBX.INLINE.LINE_BREAK.isA(n) && !UTDElements.BRL.isA((Node)n.getParent()) && !UTDElements.BRL_PAGE_NUM.isA((Node)n.getParent()) && !UTDElements.BRLONLY.isA((Node)n.getParent()))) continue;
                    v1 = element$iv;
                    break block20;
                }
                v1 = null;
            }
            workNode = v1;
        }
        if (workNode != null && BBX.INLINE.LINE_BREAK.isA(workNode) && (style = this.manager.getStyle(workNode)) != null && style.getLinesBefore() > 1) {
            try {
                this.manager.dispatch(new AdjustLocalStyleMessage.AdjustLinesMessage((Element)workNode, true, style.getLinesBefore() - 1));
                return true;
            }
            catch (RuntimeException e1) {
                throw new EditingException("An error occurred while processing Inline delete.", (Throwable)e1);
            }
        }
        return false;
    }

    private final void removeTab(TabTextMapElement tab) {
        this.textView.update(false);
        int newOffset = tab.getStart(this.manager.getMapList());
        Element parent = tab.getNodeParent();
        tab.getNode().detach();
        Intrinsics.checkNotNull((Object)parent);
        UTDHelper.stripUTDRecursive((Element)parent);
        Utils.combineAdjacentTextNodes((ParentNode)parent);
        this.dispatchModifyEvent((Node)parent, true);
        this.textView.setCursor(newOffset);
        this.textView.setCurrent(this.textView.getView().getCaretOffset());
    }

    private final void removeInlineWhitespace(Element e) {
        this.manager.dispatch(new TabInsertionMessage(-1, e));
    }

    private final void dispatchModifyEvent(Node modifiedNode, boolean translate) {
        Node[] nodeArray = new Node[]{modifiedNode};
        this.dispatchModifyEvent(translate, nodeArray);
    }

    private final void dispatchModifyEvent(boolean translate, Node ... modifiedNodes) {
        this.manager.stopFormatting();
        this.manager.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.NO_SENDER, translate, Arrays.copyOf(modifiedNodes, modifiedNodes.length)));
    }

    private final boolean isEditingKey(VerifyEvent e) {
        int n = e.keyCode;
        return (32 <= n ? n < 127 : false) || e.keyCode == 9 && e.stateMask != SWT.MOD1 && e.stateMask != SWT.MOD2;
    }

    private final boolean isDeletionKey(VerifyEvent e) {
        return e.keyCode == 127 || e.keyCode == 8;
    }

    private final boolean readOnly(VerifyEvent e) {
        TextMapElement t = this.textView.getCurrentElement();
        return t instanceof BoxLineTextMapElement || t instanceof PageIndicatorTextMapElement && e.keyCode != 8 && e.keyCode != 127 || t instanceof ImagePlaceholderTextMapElement;
    }

    private final boolean isInline(TextMapElement t, WhiteSpaceElement wse) {
        int line2;
        if (t == null) {
            return false;
        }
        int line1 = this.textView.getView().getLineAtOffset(t.getStart(this.manager.getMapList()));
        return line1 == (line2 = this.textView.getView().getLineAtOffset(wse.getStart(this.manager.getMapList())));
    }

    private final boolean followsWhiteSpace(TextMapElement tme) {
        int index = this.manager.getMapList().indexOf(tme);
        if (index == 0) {
            return false;
        }
        TextMapElement prev = this.manager.getMapList().getPrevious(index, false);
        return index > 0 && (prev instanceof LineBreakElement || prev instanceof FormattingWhiteSpaceElement && !(prev instanceof PaintedWhiteSpaceElement) && !(prev instanceof PageBreakWhiteSpaceElement));
    }

    private final boolean deletePrecedingInlineLineBreak(Node n) {
        for (Node node : FastXPath.INSTANCE.preceding(n)) {
            if (node.getParent() == null) {
                return false;
            }
            if (UTDElements.BRL.isA(node) || UTDElements.BRL.isA((Node)node.getParent()) || UTDElements.BRLONLY.isA((Node)node.getParent())) continue;
            if (node instanceof Text) {
                return false;
            }
            if (!BBX.INLINE.LINE_BREAK.isA(node)) continue;
            ParentNode parentNode = node.getParent();
            Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
            Element parent = (Element)parentNode;
            node.detach();
            UTDHelper.stripUTDRecursive((Element)parent);
            Utils.combineAdjacentTextNodes((ParentNode)parent);
            return true;
        }
        return false;
    }

    private final boolean openSubmenu(VerifyEvent e) {
        return e.stateMask == SWT.MOD2 && e.keyCode == 0x1000013;
    }

    private final boolean validCut() {
        TextMapElement textMapElement = this.textView.getCurrentElement();
        Intrinsics.checkNotNull((Object)textMapElement);
        return this.validator.validCut(textMapElement, this.stateObj, this.selection.selectionStart, this.selection.getSelectionLength());
    }

    private final boolean validPaste() {
        return this.validator.validPaste(this.textView.getCurrentElement(), this.stateObj, this.selection.selectionStart, this.selection.getSelectionLength());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean validMerge(TextMapElement t1, TextMapElement t2) {
        if (!this.isMergable(t1)) return false;
        if (!this.isMergable(t2)) return false;
        if (t1.getNode() == null) return false;
        if (t2.getNode() == null) return false;
        Node node = t1.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
        if (BBXUtilsKt.findBlock(node) == null) return false;
        Node node2 = t1.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"getNode(...)");
        Element element = BBXUtilsKt.findBlock(node2);
        Node node3 = t2.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)node3, (String)"getNode(...)");
        if (element == BBXUtilsKt.findBlock(node3)) return false;
        return true;
    }

    private final boolean isMergable(TextMapElement t) {
        return t != null && !(t instanceof BoxLineTextMapElement) && !(t instanceof PageIndicatorTextMapElement) && !(t instanceof WhiteSpaceElement);
    }

    private final boolean atDocumentBoundary(int keyCode, TextMapElement currentElement) {
        int n = keyCode;
        return n == 0x1000001 && this.isBeginningOfDocument(currentElement) ? true : (n == 0x1000003 && this.textView.getView().getCaretOffset() == 0 && this.isBeginningOfDocument(currentElement) ? true : (n == 0x1000002 && this.isEndOfDocument(currentElement) ? true : keyCode == 0x1000004 && this.textView.getView().getCaretOffset() == this.textView.getView().getCharCount() && this.isEndOfDocument(currentElement)));
    }

    private final boolean isBeginningOfDocument(TextMapElement t) {
        if (this.textView.getView().getLineAtOffset(this.textView.getView().getCaretOffset()) == 0) {
            return this.manager.indexOf(0, t) == 0;
        }
        return false;
    }

    private final boolean isEndOfDocument(TextMapElement t) {
        if (this.textView.getView().getLineAtOffset(this.textView.getView().getCaretOffset()) == this.textView.getView().getLineCount() - 1 && this.manager.getViewInitializer().findLast() == this.manager.getViewInitializer().getSectionList().size() - 1) {
            return this.manager.indexOf(this.manager.getViewInitializer().findLast(), t) == this.manager.getMapList().size() - 1;
        }
        return false;
    }

    private final boolean isArrowKey(int keyCode) {
        return keyCode == 0x1000002 || keyCode == 0x1000003 || keyCode == 0x1000004 || keyCode == 0x1000001;
    }

    private static final boolean _init_$lambda$0(TextVerifyKeyListener this$0, VerifyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return this$0.readOnly(e) && !this$0.validCut();
    }

    private static final boolean _init_$lambda$1(TextVerifyKeyListener this$0, VerifyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return this$0.readOnly(e) && !this$0.validPaste();
    }

    private static final void _init_$lambda$2(TextVerifyKeyListener this$0, VerifyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.checkInlineEnter(this$0.textView.getView().getCaretOffset());
    }

    private static final void _init_$lambda$3(TextVerifyKeyListener this$0, VerifyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.checkInlineEnter(this$0.textView.getView().getCaretOffset());
    }

    private static final void _init_$lambda$4(TextVerifyKeyListener this$0, VerifyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this$0.checkEnter(e, this$0.textView.getView().getCaretOffset());
    }

    private static final void _init_$lambda$5(TextVerifyKeyListener this$0, VerifyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this$0.checkEnter(e, this$0.textView.getView().getCaretOffset());
    }

    private static final void _init_$lambda$6(TextVerifyKeyListener this$0, VerifyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Point activeSelection = this$0.textView.getView().getSelection();
        int start = (int)Math.min((double)activeSelection.x, (double)activeSelection.y);
        String tabSpaces = "    ";
        this$0.textView.getView().insert(tabSpaces);
        this$0.textView.getView().setCaretOffset(start + tabSpaces.length());
    }

    private static final void _init_$lambda$7(TextVerifyKeyListener this$0, VerifyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Point activeSelection = this$0.textView.getView().getSelection();
        int start = (int)Math.min((double)activeSelection.x, (double)activeSelection.y);
        this$0.textView.getView().insert("\u00a0");
        StyleRange nbspRange = new StyleRange();
        nbspRange.start = start;
        nbspRange.length = 1;
        TextRenderer.Companion.setNonBreakingSpaceStyleRange(nbspRange);
        this$0.textView.getView().setStyleRange(nbspRange);
        this$0.textView.getView().setCaretOffset(start + 1);
    }

    private static final void _init_$lambda$8(TextVerifyKeyListener this$0, VerifyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.manager.home();
    }

    private static final void _init_$lambda$9(TextVerifyKeyListener this$0, VerifyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.manager.end();
    }

    private static final void _init_$lambda$10(TextVerifyKeyListener this$0, VerifyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.textView.getView().insert("");
        this$0.textView.update(true);
    }

    private static final void _init_$lambda$11(TextVerifyKeyListener this$0, VerifyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.textView.getView().insert("");
        this$0.textView.update(true);
    }

    private static final void NO_ACTION$lambda$0(VerifyEvent verifyEvent) {
        Intrinsics.checkNotNullParameter((Object)verifyEvent, (String)"<unused var>");
    }

    @JvmStatic
    public static final boolean isBeginningOfBlock(@NotNull Node n) {
        return Companion.isBeginningOfBlock(n);
    }

    @JvmStatic
    public static final boolean isEndOfBlock(@NotNull Node n) {
        return Companion.isEndOfBlock(n);
    }

    static {
        Logger logger = LoggerFactory.getLogger(TextVerifyKeyListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
        CTRL = SWT.MOD1;
        SHIFT = SWT.MOD2;
        NO_ACTION = TextVerifyKeyListener::NO_ACTION$lambda$0;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/brailleblaster/perspectives/braille/views/wp/TextVerifyKeyListener$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "CTRL", "", "SHIFT", "NO_ACTION", "Ljava/util/function/Consumer;", "Lorg/eclipse/swt/events/VerifyEvent;", "isBeginningOfBlock", "", "n", "Lnu/xom/Node;", "isEndOfBlock", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        @JvmStatic
        public final boolean isBeginningOfBlock(@NotNull Node n) {
            Intrinsics.checkNotNullParameter((Object)n, (String)"n");
            Node parent = n;
            if (BBX.CONTAINER.TABLE.isA(n)) {
                return true;
            }
            while (!BBX.BLOCK.isA(parent)) {
                ParentNode newParent = parent.getParent();
                int index = newParent.indexOf(parent);
                if (MathModuleUtils.isMath(n)) {
                    index = BBXUtils.INSTANCE.getIndexInBlock(n);
                }
                Intrinsics.checkNotNull((Object)newParent);
                parent = (Node)newParent;
                for (int sibling = index - 1; -1 < sibling; --sibling) {
                    Node siblingNode = newParent.getChild(sibling);
                    if (siblingNode instanceof Text) {
                        return false;
                    }
                    if (!(siblingNode instanceof Element) || UTDElements.BRL.isA(siblingNode) || XMLHandler.Companion.childrenRecursiveNodeVisitor(siblingNode, Companion::isBeginningOfBlock$lambda$0) == null) continue;
                    return false;
                }
            }
            return true;
        }

        @JvmStatic
        public final boolean isEndOfBlock(@NotNull Node n) {
            Intrinsics.checkNotNullParameter((Object)n, (String)"n");
            Node parent = n;
            if (BBX.CONTAINER.TABLE.isA(n)) {
                return true;
            }
            while (!BBX.BLOCK.isA(parent)) {
                ParentNode newParent;
                if (parent.getParent() == null) {
                    return true;
                }
                int index = newParent.indexOf(parent);
                if (MathModuleUtils.isMath(n)) {
                    index = BBXUtils.INSTANCE.getIndexInBlock(n);
                }
                parent = (Node)newParent;
                int n2 = newParent.getChildCount();
                for (int sibling = index + 1; sibling < n2; ++sibling) {
                    Node siblingNode = newParent.getChild(sibling);
                    if (siblingNode instanceof Text) {
                        return false;
                    }
                    if (!(siblingNode instanceof Element) || UTDElements.BRL.isA(siblingNode) || XMLHandler.Companion.childrenRecursiveNodeVisitor(siblingNode, Companion::isEndOfBlock$lambda$0) == null) continue;
                    return false;
                }
            }
            return true;
        }

        private static final boolean isBeginningOfBlock$lambda$0(Node c) {
            return c instanceof Text;
        }

        private static final boolean isEndOfBlock$lambda$0(Node c) {
            return c instanceof Text;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0004\b\n\u0010\u000bB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0004\b\n\u0010\rB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0004\b\n\u0010\u0010B5\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u000f\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0004\b\n\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lorg/brailleblaster/perspectives/braille/views/wp/TextVerifyKeyListener$OverrideKeyStroke;", "", "stateMask", "", "keyCode", "criteria", "Ljava/util/function/Predicate;", "Lorg/eclipse/swt/events/VerifyEvent;", "onOverride", "Ljava/util/function/Consumer;", "<init>", "(IILjava/util/function/Predicate;Ljava/util/function/Consumer;)V", "override", "(IILjava/util/function/Consumer;)V", "key", "", "(ICLjava/util/function/Consumer;)V", "test", "(ICLjava/util/function/Predicate;Ljava/util/function/Consumer;)V", "getStateMask", "()I", "getKeyCode", "getCriteria", "()Ljava/util/function/Predicate;", "getOnOverride", "()Ljava/util/function/Consumer;", "brailleblaster-core"})
    private static final class OverrideKeyStroke {
        private final int stateMask;
        private final int keyCode;
        @NotNull
        private final Predicate<VerifyEvent> criteria;
        @NotNull
        private final Consumer<VerifyEvent> onOverride;

        public OverrideKeyStroke(int stateMask, int keyCode, @NotNull Predicate<VerifyEvent> criteria, @NotNull Consumer<VerifyEvent> onOverride) {
            Intrinsics.checkNotNullParameter(criteria, (String)"criteria");
            Intrinsics.checkNotNullParameter(onOverride, (String)"onOverride");
            this.stateMask = stateMask;
            this.keyCode = keyCode;
            this.criteria = criteria;
            this.onOverride = onOverride;
        }

        public final int getStateMask() {
            return this.stateMask;
        }

        public final int getKeyCode() {
            return this.keyCode;
        }

        @NotNull
        public final Predicate<VerifyEvent> getCriteria() {
            return this.criteria;
        }

        @NotNull
        public final Consumer<VerifyEvent> getOnOverride() {
            return this.onOverride;
        }

        public OverrideKeyStroke(int stateMask, int keyCode, @NotNull Consumer<VerifyEvent> override) {
            Intrinsics.checkNotNullParameter(override, (String)"override");
            this(stateMask, keyCode, OverrideKeyStroke::_init_$lambda$0, override);
        }

        public OverrideKeyStroke(int stateMask, char key, @NotNull Consumer<VerifyEvent> override) {
            Intrinsics.checkNotNullParameter(override, (String)"override");
            this(stateMask, (int)key, OverrideKeyStroke::_init_$lambda$1, override);
        }

        public OverrideKeyStroke(int stateMask, char keyCode, @NotNull Predicate<VerifyEvent> test, @NotNull Consumer<VerifyEvent> override) {
            Intrinsics.checkNotNullParameter(test, (String)"test");
            Intrinsics.checkNotNullParameter(override, (String)"override");
            this(stateMask, (int)keyCode, test, override);
        }

        private static final boolean _init_$lambda$0(VerifyEvent it) {
            return true;
        }

        private static final boolean _init_$lambda$1(VerifyEvent it) {
            return true;
        }
    }
}

