/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.mvc.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.eventQueue.Event;
import org.brailleblaster.perspectives.braille.eventQueue.EventFrame;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.mvc.events.ModifyEvent;
import org.brailleblaster.perspectives.mvc.events.ModularEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012H\u0002J\u001c\u0010\u0014\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000fH\u0002J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/brailleblaster/perspectives/mvc/events/Queuer;", "", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;)V", "getManager", "()Lorg/brailleblaster/perspectives/braille/Manager;", "handleEvent", "", "f", "Lorg/brailleblaster/perspectives/braille/eventQueue/EventFrame;", "sender", "Lorg/brailleblaster/perspectives/braille/messages/Sender;", "replaceSection", "Lnu/xom/Element;", "e", "indexes", "", "", "replaceMaps", "styleMap", "actionMap", "getParent", "brailleblaster-core"})
public final class Queuer {
    @NotNull
    private final Manager manager;

    public Queuer(@NotNull Manager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.manager = manager;
    }

    @NotNull
    public final Manager getManager() {
        return this.manager;
    }

    public final void handleEvent(@NotNull EventFrame f, @NotNull Sender sender) {
        Event event;
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        Intrinsics.checkNotNullParameter((Object)((Object)sender), (String)"sender");
        List modNodes = new ArrayList();
        Integer pos = null;
        Integer sectionIndex = null;
        while ((event = f.peek()) instanceof ModularEvent) {
            f.pop();
            Element e = this.replaceSection(((ModularEvent)event).getElement(), ((ModularEvent)event).indexes);
            this.replaceMaps(((ModularEvent)event).getStyleMap(), ((ModularEvent)event).getActionMap());
            modNodes.add(e);
            sectionIndex = ((ModularEvent)event).sectionIndex;
            pos = ((ModularEvent)event).getTextOffset();
        }
        ModifyEvent ev = new ModifyEvent(sender, modNodes, false);
        if (sectionIndex != null && (sender == Sender.UNDO_QUEUE || sender == Sender.REDO_QUEUE)) {
            int n = sectionIndex;
            Integer n2 = pos;
            Intrinsics.checkNotNull(n2);
            ev.setQueueData(n, n2);
        }
        this.manager.getSimpleManager().dispatchEvent(ev);
        if (pos != null) {
            Integer n = sectionIndex;
            if (n == null || this.manager.getViewInitializer().getStartIndex() != n.intValue()) {
                Integer n3 = sectionIndex;
                Intrinsics.checkNotNull((Object)n3);
                this.manager.buffer(n3);
            }
            if (pos > this.manager.getText().getView().getCharCount()) {
                pos = this.manager.getText().getView().getCharCount();
            } else if (this.manager.getText().inLineBreak(pos)) {
                int n4 = pos;
                pos = n4 + 1;
            }
            this.manager.getText().setCurrentElement(pos);
        }
    }

    private final Element replaceSection(Element e, List<Integer> indexes) {
        Element currentSection;
        Element element = currentSection = this.getParent(indexes);
        Intrinsics.checkNotNull((Object)element);
        element.getParent().replaceChild((Node)currentSection, (Node)e);
        return e;
    }

    private final void replaceMaps(Element styleMap2, Element actionMap2) {
        Element root = this.manager.getDocument().getRootElement();
        Element element = root.getFirstChildElement("head", "http://brailleblaster.org/ns/bb");
        if (element == null) {
            return;
        }
        Element head = element;
        Element oldStyleMap = head.getFirstChildElement("styleMap", "http://brailleblaster.org/ns/utd");
        if (styleMap2 != null) {
            Element element2 = oldStyleMap;
            if (element2 != null) {
                element2.getParent().replaceChild((Node)oldStyleMap, (Node)styleMap2);
            } else {
                head.appendChild((Node)styleMap2);
            }
        } else if (oldStyleMap != null) {
            head.removeChild((Node)oldStyleMap);
        }
        Element oldActionMap = head.getFirstChildElement("actionMap", "http://brailleblaster.org/ns/utd");
        if (actionMap2 != null) {
            Element element3 = oldActionMap;
            if (element3 != null) {
                element3.getParent().replaceChild((Node)oldActionMap, (Node)actionMap2);
            } else {
                head.appendChild((Node)actionMap2);
            }
        } else if (oldActionMap != null) {
            head.removeChild((Node)oldActionMap);
        }
        this.manager.getDocument().getSettingsManager().reloadMapsFromDoc();
    }

    @Nullable
    public final Element getParent(@NotNull List<Integer> indexes) {
        Element element;
        Intrinsics.checkNotNullParameter(indexes, (String)"indexes");
        if (!((Collection)indexes).isEmpty()) {
            Document document = this.manager.getDocument().doc.getDocument();
            Integer n = indexes.get(0);
            Intrinsics.checkNotNull((Object)n);
            Node node = document.getChild(((Number)n).intValue());
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            element = (Element)node;
        } else {
            element = null;
        }
        Element e = element;
        int n = indexes.size();
        for (int i = 1; i < n; ++i) {
            Element element2 = e;
            Intrinsics.checkNotNull(element2);
            Integer n2 = indexes.get(i);
            Intrinsics.checkNotNull((Object)n2);
            Node node = element2.getChild(((Number)n2).intValue());
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            e = (Element)node;
        }
        return e;
    }
}

