/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.mvc.modules.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.BBIni;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.BBXUtils;
import org.brailleblaster.bbx.BBXUtilsKt;
import org.brailleblaster.exceptions.BBNotifyException;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.perspectives.mvc.SimpleEvent;
import org.brailleblaster.perspectives.mvc.XMLNodeCaret;
import org.brailleblaster.perspectives.mvc.XMLSelection;
import org.brailleblaster.perspectives.mvc.XMLTextCaret;
import org.brailleblaster.perspectives.mvc.events.BuildMenuEvent;
import org.brailleblaster.perspectives.mvc.events.ModifyEvent;
import org.brailleblaster.perspectives.mvc.menu.BBActionSelection;
import org.brailleblaster.perspectives.mvc.menu.BBSelectionData;
import org.brailleblaster.perspectives.mvc.menu.BBSeparator;
import org.brailleblaster.perspectives.mvc.menu.BBStyleOptionSelection;
import org.brailleblaster.perspectives.mvc.menu.BBStyleSelection;
import org.brailleblaster.perspectives.mvc.menu.MenuManager;
import org.brailleblaster.perspectives.mvc.menu.SharedItem;
import org.brailleblaster.perspectives.mvc.menu.TopMenu;
import org.brailleblaster.perspectives.mvc.modules.misc.StyleMenuBuilder;
import org.brailleblaster.perspectives.mvc.modules.misc.StylesMenuModule;
import org.brailleblaster.perspectives.mvc.modules.misc.TableSelectionModule;
import org.brailleblaster.perspectives.mvc.modules.views.EmphasisModule;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.tools.MenuToolModule;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.Style;
import org.brailleblaster.utd.exceptions.NodeException;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.internal.xml.XMLHandlerKt;
import org.brailleblaster.utd.properties.EmphasisType;
import org.brailleblaster.utd.utils.TableUtils;
import org.brailleblaster.utd.utils.UTDHelper;
import org.brailleblaster.utd.utils.dom.BoxUtils;
import org.brailleblaster.util.Notify;
import org.brailleblaster.utils.swt.EasySWT;
import org.brailleblaster.wordprocessor.WPManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u001c\u0018\u0000 S2\u00020\u0001:\u0002RSB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\tH\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cJ\"\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00152\b\u0010\u001f\u001a\u0004\u0018\u00010\u0015J\u0018\u0010 \u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0011J \u0010!\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011J$\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0015J\u001e\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u0015J \u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u0015H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0015H\u0002J\u0018\u0010-\u001a\u00020%2\u0006\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u00020%H\u0002J\u0016\u00106\u001a\u00020\t2\f\u00107\u001a\b\u0012\u0004\u0012\u00020%08H\u0002J\u0016\u00109\u001a\u00020\t2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J \u0010;\u001a\b\u0012\u0004\u0012\u00020%082\b\u0010\u001e\u001a\u0004\u0018\u00010\u00152\b\u0010\u001f\u001a\u0004\u0018\u00010\u0015J\u0010\u0010<\u001a\u00020+2\u0006\u0010\r\u001a\u00020\u0011H\u0002J\u0010\u0010=\u001a\u00020+2\u0006\u0010>\u001a\u00020\u0015H\u0002J\u0010\u0010?\u001a\u00020+2\u0006\u0010>\u001a\u00020\u0015H\u0002J\u0010\u0010=\u001a\u00020+2\u0006\u0010\r\u001a\u00020\u0011H\u0002J\u0010\u0010?\u001a\u00020+2\u0006\u0010\r\u001a\u00020\u0011H\u0002J\u0010\u0010@\u001a\u00020+2\u0006\u0010>\u001a\u00020\u0015H\u0002J\u0010\u0010A\u001a\u00020+2\u0006\u0010>\u001a\u00020\u0015H\u0002J\u0010\u0010@\u001a\u00020+2\u0006\u0010\r\u001a\u00020\u0011H\u0002J\u0010\u0010A\u001a\u00020+2\u0006\u0010\r\u001a\u00020\u0011H\u0002J\u0010\u0010B\u001a\u00020+2\u0006\u0010\r\u001a\u00020\u0011H\u0002J\u0010\u0010C\u001a\u00020+2\u0006\u0010\r\u001a\u00020\u0011H\u0002J\u0010\u0010D\u001a\u00020+2\u0006\u0010\r\u001a\u00020\u0011H\u0002J\u0010\u0010E\u001a\u00020+2\u0006\u0010\r\u001a\u00020\u0011H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010\r\u001a\u00020\u0011H\u0002J\u0010\u0010F\u001a\u00020+2\u0006\u0010\r\u001a\u00020\u0011H\u0002J\u0010\u0010G\u001a\u00020+2\u0006\u0010\r\u001a\u00020\u0011H\u0002J\u0010\u0010H\u001a\u00020\t2\u0006\u0010I\u001a\u00020%H\u0002J\u0010\u0010J\u001a\u00020+2\u0006\u0010>\u001a\u00020\u0015H\u0002J\b\u0010M\u001a\u00020\tH\u0002J\u0018\u0010N\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J\u001c\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010P\u001a\u00020%2\u0006\u0010Q\u001a\u00020%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u00100\u001a\u0004\u0018\u000101X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0014\u0010K\u001a\u00020+8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010L\u00a8\u0006T"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/StylesMenuModule;", "Lorg/brailleblaster/perspectives/mvc/BBSimpleManager$SimpleListener;", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;)V", "lastStyleId", "", "onEvent", "", "event", "Lorg/brailleblaster/perspectives/mvc/SimpleEvent;", "update", "s", "Lorg/brailleblaster/perspectives/mvc/menu/BBStyleSelection;", "getColorName", "Lorg/eclipse/swt/widgets/Shell;", "Lorg/brailleblaster/utd/Style;", "repeatStyle", "updateStyle", "", "Lnu/xom/Node;", "style", "updateAction", "t", "Lorg/brailleblaster/perspectives/mvc/menu/BBActionSelection;", "updateStyleOption", "option", "Lorg/brailleblaster/perspectives/mvc/menu/BBStyleOptionSelection;", "applyStyleOptionAndReformat", "start", "end", "boxBlock", "boxMultiBlocks", "applyStyle", "wrapSelectedPage", "page", "Lnu/xom/Element;", "startNode", "endNode", "wrapSelectedText", "guideWord", "isGuideWord", "", "node", "copyChildrenToElement", "from", "to", "parent0", "Lnu/xom/ParentNode;", "getParent0", "()Lnu/xom/ParentNode;", "setParent0", "(Lnu/xom/ParentNode;)V", "collectParents", "blocks", "Ljava/util/LinkedHashSet;", "reformat", "modifiedNodes", "getBlocks", "isAnyBox", "isColorBoxline", "n", "isColorFullBox", "isBoxline", "isFullBox", "isPoeticStanza", "isDontSplit", "isList", "isListItem", "isPage", "isDoubleLine", "detachTableCopy", "table", "isContainer", "isTableSelected", "()Z", "warnTable", "movePageIndicators", "getBoxSiblings", "a", "b", "RepeatStyleTool", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nStylesMenuModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StylesMenuModule.kt\norg/brailleblaster/perspectives/mvc/modules/misc/StylesMenuModule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,1000:1\n742#2,9:1001\n296#2,2:1012\n37#3,2:1010\n*S KotlinDebug\n*F\n+ 1 StylesMenuModule.kt\norg/brailleblaster/perspectives/mvc/modules/misc/StylesMenuModule\n*L\n138#1:1001,9\n214#1:1012,2\n138#1:1010,2\n*E\n"})
public final class StylesMenuModule
implements BBSimpleManager.SimpleListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Manager m;
    @Nullable
    private String lastStyleId;
    @Nullable
    private ParentNode parent0;
    @NotNull
    private static final Logger log;
    @NotNull
    private static final List<String> ALWAYS_WRAP_STYLES;
    @NotNull
    public static final String TRNOTE_ACTION_STYLE_NAME = "TRNote";
    @NotNull
    public static final String DESCRIPTION_STYLE_NAME = "Description";
    @NotNull
    public static final String TRNOTE_ACTION_STYLE_DISPLAY_NAME = "Transcriber's Note";
    @NotNull
    public static final String COLOR_PROP = "color_box";

    public StylesMenuModule(@NotNull Manager m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        this.m = m;
    }

    @Override
    public void onEvent(@NotNull SimpleEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof BuildMenuEvent) {
            MenuManager.INSTANCE.add(new RepeatStyleTool());
            MenuManager.INSTANCE.add(new BBSeparator(TopMenu.STYLES));
            StyleMenuBuilder smb = new StyleMenuBuilder(WPManager.Companion.getInstance().getShell(), this.m);
            smb.generateStylesMenu(arg_0 -> StylesMenuModule.onEvent$lambda$0(this, arg_0), arg_0 -> StylesMenuModule.onEvent$lambda$1(this, arg_0), arg_0 -> StylesMenuModule.onEvent$lambda$2(this, arg_0), StylesMenuModule::onEvent$lambda$3);
        }
    }

    private final void update(BBStyleSelection s) {
        IStyle iStyle = s.getStyle();
        Intrinsics.checkNotNull((Object)iStyle, (String)"null cannot be cast to non-null type org.brailleblaster.utd.Style");
        List<Node> newNodes = this.updateStyle((Style)iStyle);
        if (!((Collection)newNodes).isEmpty()) {
            if (!Intrinsics.areEqual((Object)((Style)s.getStyle()).getName(), (Object)TRNOTE_ACTION_STYLE_NAME) && !Intrinsics.areEqual((Object)((Style)s.getStyle()).getName(), (Object)DESCRIPTION_STYLE_NAME)) {
                this.reformat(newNodes);
            } else {
                this.updateAction(new BBActionSelection(EmphasisType.TRANS_NOTE, s.getWidget()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Shell getColorName(Style s) {
        log.debug("Color box");
        Shell shell = new Shell(WPManager.display, 134384);
        EasySWT.setSizeAndLocationMiddleScreen((Shell)shell, (int)300, (int)150);
        shell.setLayoutData((Object)new GridData(4, 4, true, true));
        shell.setLayout((Layout)new GridLayout(1, false));
        Label l = new Label((Composite)shell, 0);
        l.setText("Enter Color: ");
        l.setLayoutData((Object)new GridData(4, 4, true, true));
        Combo text = new Combo((Composite)shell, 2832);
        String boxString = BBIni.getPropertyFileManager().getProperty(COLOR_PROP, "");
        String[] boxes = null;
        List array = new ArrayList();
        if (((CharSequence)boxString).length() > 0) {
            void $this$toTypedArray$iv;
            List list;
            Collection $this$dropLastWhile$iv;
            Object object = boxString;
            Regex regex = new Regex(",");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            int $i$f$toTypedArray = 0;
            void thisCollection$iv = $this$toTypedArray$iv;
            for (String box : thisCollection$iv.toArray(new String[0])) {
                if (array.contains(box)) continue;
                array.add(box);
            }
            for (Object e : array) {
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                String i = (String)e;
                text.add(i);
            }
        }
        GridData textData = new GridData(4, 4, true, true);
        textData.widthHint = 100;
        textData.minimumWidth = 100;
        text.setData((Object)textData);
        Group g = new Group((Composite)shell, 0);
        g.setData((Object)new GridData(4, 4, true, true));
        g.setLayout((Layout)new GridLayout(2, true));
        Button ok = new Button((Composite)g, 8);
        ok.setText("OK");
        ok.setLayoutData((Object)new GridData(4, 4, true, true));
        ok.addSelectionListener(new SelectionListener(text, array, s, this, shell){
            final /* synthetic */ Combo $text;
            final /* synthetic */ List<String> $array;
            final /* synthetic */ Style $s;
            final /* synthetic */ StylesMenuModule this$0;
            final /* synthetic */ Shell $shell;
            {
                this.$text = $text;
                this.$array = $array;
                this.$s = $s;
                this.this$0 = $receiver;
                this.$shell = $shell;
            }

            public void widgetSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String string = this.$text.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (((CharSequence)string).length() == 0) {
                    Notify.notify$default(Notify.INSTANCE, "You must enter a color or cancel", Notify.ALERT_SHELL_NAME, false, 4, null);
                } else {
                    String color = this.$text.getText();
                    StringBuilder sb = new StringBuilder();
                    this.$array.iterator().forEachRemaining(arg_0 -> getColorName.2.widgetSelected$lambda$1(arg_0 -> getColorName.2.widgetSelected$lambda$0(sb, arg_0), arg_0));
                    BBIni.getPropertyFileManager().save("color_box", color + "," + sb);
                    this.$s.setColor(color);
                    if (Intrinsics.areEqual((Object)StylesMenuModule.access$getM$p((StylesMenuModule)this.this$0).getSimpleManager().getCurrentSelection().start.getNode(), (Object)StylesMenuModule.access$getM$p((StylesMenuModule)this.this$0).getSimpleManager().getCurrentSelection().end.getNode())) {
                        Node n = this.this$0.boxBlock(StylesMenuModule.access$getM$p((StylesMenuModule)this.this$0).getSimpleManager().getCurrentSelection().start.getNode(), this.$s);
                        StylesMenuModule.access$reformat(this.this$0, CollectionsKt.listOf((Object)n));
                    } else {
                        Node node = this.this$0.boxMultiBlocks(StylesMenuModule.access$getM$p((StylesMenuModule)this.this$0).getSimpleManager().getCurrentSelection().start.getNode(), StylesMenuModule.access$getM$p((StylesMenuModule)this.this$0).getSimpleManager().getCurrentSelection().end.getNode(), this.$s);
                        Intrinsics.checkNotNull((Object)node);
                        Node n = node;
                        StylesMenuModule.access$reformat(this.this$0, CollectionsKt.listOf((Object)n));
                    }
                    this.$shell.close();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            private static final Unit widgetSelected$lambda$0(StringBuilder $sb, String z) {
                Intrinsics.checkNotNullParameter((Object)z, (String)"z");
                if (((CharSequence)z).length() > 0) {
                    $sb.append(z).append(",");
                }
                return Unit.INSTANCE;
            }

            private static final void widgetSelected$lambda$1(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        });
        Button cancel = new Button((Composite)g, 8);
        cancel.setText("Cancel");
        cancel.setLayoutData((Object)new GridData(4, 4, true, true));
        cancel.addSelectionListener(new SelectionListener(shell){
            final /* synthetic */ Shell $shell;
            {
                this.$shell = $shell;
            }

            public void widgetSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$shell.close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$shell.close();
            }
        });
        shell.setDefaultButton(ok);
        shell.pack();
        return shell;
    }

    private final void repeatStyle() {
        Object v0;
        block4: {
            if (this.lastStyleId == null) {
                throw new BBNotifyException("Must apply a style first before it can be repeated");
            }
            Iterable $this$firstOrNull$iv = this.m.getDocument().getSettingsManager().getEngine().getStyleDefinitions().getStyles();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Style style = (Style)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)style.getId(), (Object)this.lastStyleId)) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        Style style = v0;
        if (style == null) {
            throw new RuntimeException("Unable to find lastStyleId " + this.lastStyleId);
        }
        Style styleToApply = style;
        List<Node> modifiedNodes = this.updateStyle(styleToApply);
        if (!((Collection)modifiedNodes).isEmpty()) {
            this.m.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.EMPHASIS, modifiedNodes, true));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final List<Node> updateStyle(Style style) {
        this.m.checkForUpdatedViews();
        XMLSelection currentSelection = this.m.getSimpleManager().getCurrentSelection();
        Node startSelection = currentSelection.start.getNode();
        Node endSelection = currentSelection.end.getNode();
        if (this.isTableSelected()) {
            Element endTableParent;
            if (!Companion.isAlwaysWrapStyle(style)) {
                this.warnTable();
                return new ArrayList();
            }
            Element startTableParent = Manager.getTableParent(startSelection);
            if (startTableParent != null) {
                startSelection = endSelection = (Node)startTableParent;
                this.detachTableCopy((Element)startSelection);
            }
            if (startSelection != endSelection && (endTableParent = Manager.getTableParent(endSelection)) != null) {
                endSelection = (Node)endTableParent;
                this.detachTableCopy((Element)endSelection);
            }
        } else if ((MathModuleUtils.isSpatialMath(startSelection) || MathModuleUtils.isSpatialMath(endSelection)) && !Intrinsics.areEqual((Object)style.getId(), (Object)"miscellaneous/doubleLine")) {
            Notify.notify$default(Notify.INSTANCE, MathModuleUtils.SPATIAL_MATH_WARNING, Notify.ALERT_SHELL_NAME, false, 4, null);
            return new ArrayList();
        }
        this.m.stopFormatting();
        this.lastStyleId = style.getId();
        return this.applyStyle(style, startSelection, endSelection);
    }

    private final void updateAction(BBActionSelection t) {
        if (this.isTableSelected()) {
            this.warnTable();
            return;
        }
        BBSimpleManager bBSimpleManager = this.m.getSimpleManager();
        Intrinsics.checkNotNullExpressionValue((Object)bBSimpleManager, (String)"getSimpleManager(...)");
        EmphasisModule.addEmphasis(bBSimpleManager, t.getAction());
    }

    public final void updateStyleOption(@NotNull BBStyleOptionSelection option) {
        Node endNode;
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        this.m.checkForUpdatedViews();
        XMLSelection currentSelection = this.m.getSimpleManager().getCurrentSelection();
        Node startNode = currentSelection.start.getNode();
        if (Manager.getTableParent(startNode) != null) {
            startNode = (Node)Manager.getTableParent(startNode);
        }
        if (Manager.getTableParent(endNode = currentSelection.end.getNode()) != null) {
            endNode = (Node)Manager.getTableParent(endNode);
        }
        this.applyStyleOptionAndReformat(option, startNode, endNode);
    }

    public final void applyStyleOptionAndReformat(@NotNull BBStyleOptionSelection option, @Nullable Node start, @Nullable Node end) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        LinkedHashSet<Element> blocks = this.getBlocks(start, end);
        UTDManager utdMan = this.m.getDocument().getSettingsManager();
        Iterator iterator = blocks.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Element block = (Element)iterator2.next();
            IStyle iStyle = Objects.requireNonNull(utdMan.getEngine().getStyle((Node)block));
            Intrinsics.checkNotNull((Object)iStyle, (String)"null cannot be cast to non-null type org.brailleblaster.utd.Style");
            utdMan.applyStyleWithOption((Style)iStyle, option.getOption(), option.getValue(), block);
        }
        this.m.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.SIMPLEMANAGER, new ArrayList(blocks), true));
    }

    @NotNull
    public final Node boxBlock(@NotNull Node start, @Nullable Style style) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Element block = BBX.CONTAINER.TABLE.isA(start) || BBX.CONTAINER.LIST.isA(start) || BBX.CONTAINER.BOX.isA(start) ? (Element)start : BBXUtilsKt.findBlock(start);
        Node node = (Node)block;
        Element element = BBX.CONTAINER.BOX.create();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"create(...)");
        XMLHandler.Companion.wrapNodeWithElement(node, element);
        UTDManager uTDManager = this.m.getDocument().getSettingsManager();
        ParentNode parentNode = block.getParent();
        Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
        uTDManager.applyStyle(style, (Element)parentNode);
        ParentNode parentNode2 = block.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)parentNode2, (String)"getParent(...)");
        return (Node)parentNode2;
    }

    @Nullable
    public final Node boxMultiBlocks(@NotNull Node start, @NotNull Node end, @NotNull Style style) {
        List<Node> selectedSiblings;
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Element b1 = this.isContainer(start) ? (Element)start : BBXUtilsKt.findBlock(start);
        Element b2 = this.isContainer(end) ? (Element)end : BBXUtilsKt.findBlock(end);
        Element tableParent = Manager.getTableParent((Node)b1);
        if (tableParent != null) {
            b1 = tableParent;
        }
        if ((tableParent = Manager.getTableParent((Node)b2)) != null) {
            b2 = tableParent;
        }
        List<Node> list = selectedSiblings = Intrinsics.areEqual((Object)style.getName(), (Object)"Box") || Intrinsics.areEqual((Object)style.getName(), (Object)"Color Box") ? this.getBoxSiblings(b1, b2) : XMLSelection.Companion.isValidTreeSelection((Node)b1, (Node)b2);
        if (selectedSiblings == null) {
            this.m.notify("Boxline selections cannot cross sections.\nPlease reapply your selection.");
            return null;
        }
        Element sidebar = BBX.CONTAINER.BOX.create();
        ParentNode parentNode = selectedSiblings.get(0).getParent();
        Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element treeParent = (Element)parentNode;
        treeParent.insertChild((Node)sidebar, treeParent.indexOf(selectedSiblings.get(0)));
        Element lastMovedElement = null;
        for (Node selectedSibling : selectedSiblings) {
            selectedSibling.detach();
            if (BBX.CONTAINER.TABLE.isA(selectedSibling)) {
                Intrinsics.checkNotNull((Object)selectedSibling, (String)"null cannot be cast to non-null type nu.xom.Element");
                if (TableUtils.isTableCopy((Element)((Element)selectedSibling)) && BBX.CONTAINER.TABLE.isA((Node)lastMovedElement)) continue;
            }
            if (selectedSibling instanceof Element) {
                lastMovedElement = (Element)selectedSibling;
            }
            sidebar.appendChild(selectedSibling);
        }
        UTDManager uTDManager = this.m.getDocument().getSettingsManager();
        Intrinsics.checkNotNull((Object)sidebar);
        uTDManager.applyStyle(style, sidebar);
        return (Node)sidebar;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final List<Node> applyStyle(@NotNull Style style, @NotNull Node start, @NotNull Node end) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        List modifiedNodes = new ArrayList();
        if (Companion.isAlwaysWrapStyle(style)) {
            if (this.isAnyBox(style)) {
                this.movePageIndicators(start, end);
                if (Intrinsics.areEqual((Object)start, (Object)end)) {
                    if (this.isBoxline(style) && this.isBoxline(start) || this.isFullBox(style) && this.isFullBox(start) || this.isColorBoxline(style) && this.isColorBoxline(start) || this.isColorFullBox(style) && this.isColorFullBox(start)) {
                        Element container = (Element)start;
                        Element child = BBXUtilsKt.findBlockChildOrNull(container);
                        BoxUtils.unbox((Element)container);
                        if (child == null) return modifiedNodes;
                        modifiedNodes.add(child);
                        return modifiedNodes;
                    } else {
                        String string = style.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Color", (boolean)false, (int)2, null)) {
                            this.getColorName(style).open();
                            return modifiedNodes;
                        } else {
                            modifiedNodes.add(this.boxBlock(start, style));
                        }
                    }
                    return modifiedNodes;
                } else {
                    String string = style.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Color", (boolean)false, (int)2, null)) {
                        this.getColorName(style).open();
                        return modifiedNodes;
                    } else {
                        Node sidebar = this.boxMultiBlocks(start, end, style);
                        if (sidebar == null) {
                            return new ArrayList();
                        }
                        modifiedNodes.add(sidebar);
                    }
                }
                return modifiedNodes;
            } else if (this.isPoeticStanza(style)) {
                Element stanza = BBX.CONTAINER.LIST.create(BBX.ListType.POEM_LINE_GROUP);
                Intrinsics.checkNotNull((Object)stanza);
                Companion.wrapSelectedElements(this.m, stanza, start, end);
                return modifiedNodes;
            } else if (this.isDontSplit(style)) {
                Element dontSplit = BBX.CONTAINER.DONT_SPLIT.create();
                Intrinsics.checkNotNull((Object)dontSplit);
                Companion.wrapSelectedElements(this.m, dontSplit, start, end);
                return modifiedNodes;
            } else if (this.isList(style)) {
                Element list = BBX.CONTAINER.LIST.create(BBX.ListType.NORMAL);
                Intrinsics.checkNotNull((Object)list);
                Companion.wrapSelectedElements(this.m, list, start, end);
                return modifiedNodes;
            } else if (this.isGuideWord(style)) {
                Element guideWord = BBX.SPAN.GUIDEWORD.create();
                Intrinsics.checkNotNull((Object)guideWord);
                this.wrapSelectedText(guideWord, start, end);
                return modifiedNodes;
            } else if (this.isPage(style)) {
                Element page = XMLHandler.Companion.ancestorElementIs(start, StylesMenuModule::applyStyle$lambda$0) ? BBX.SPAN.PAGE_NUM.create() : BBX.BLOCK.PAGE_NUM.create();
                Intrinsics.checkNotNull((Object)page);
                this.wrapSelectedPage(page, start, end);
                return modifiedNodes;
            } else {
                if (!this.isDoubleLine(style)) throw new UnsupportedOperationException("TODO");
                Element doubleLineContainer = BBX.CONTAINER.DOUBLE_SPACE.create();
                Intrinsics.checkNotNull((Object)doubleLineContainer);
                Companion.wrapSelectedElements(this.m, doubleLineContainer, start, end);
            }
            return modifiedNodes;
        } else if (start == end) {
            if (BBX.CONTAINER.isA(start) || BBX.SECTION.isA(start)) {
                XMLSelection currentSelection = this.m.getSimpleManager().getCurrentSelection();
                List<Element> blocks = currentSelection.getSelectedBlocks();
                for (Element block : blocks) {
                    if (BBX.BLOCK.PAGE_NUM.isA((Node)block)) continue;
                    BBXUtils.INSTANCE.stripStyle(block, this.m);
                    this.m.getDocument().getSettingsManager().applyStyle(style, block);
                }
                v2 = modifiedNodes.addAll((Collection)blocks);
                return modifiedNodes;
            } else {
                Element element = BBXUtilsKt.findBlockOrNull(start);
                if (element == null) {
                    throw new NodeException("start not inside block", start, null, 4, null);
                }
                Element block = element;
                BBXUtils.INSTANCE.stripStyle(block, this.m);
                this.m.getDocument().getSettingsManager().applyStyle(style, block);
                v2 = modifiedNodes.add(block);
            }
            return modifiedNodes;
        } else {
            LinkedHashSet<Element> blocks = this.getBlocks(start, end);
            if (this.isListItem(style)) {
                this.collectParents(blocks);
            }
            Iterator iterator = blocks.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Element block = (Element)iterator2.next();
                BBXUtils.INSTANCE.stripStyle(block, this.m);
                this.m.getDocument().getSettingsManager().applyStyle(style, block);
            }
            modifiedNodes.addAll((Collection)blocks);
        }
        return modifiedNodes;
    }

    public final void wrapSelectedPage(@NotNull Element page, @NotNull Node startNode, @NotNull Node endNode) {
        Node[] nodeArray;
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)startNode, (String)"startNode");
        Intrinsics.checkNotNullParameter((Object)endNode, (String)"endNode");
        Element page2 = page;
        ParentNode parentNode = startNode.getParent();
        Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element parent = (Element)parentNode;
        int cellsPerLine = (int)(this.m.getDocument().getEngine().getPageSettings().getDrawableWidth() / this.m.getDocument().getEngine().getBrailleSettings().getCellType().getWidth().doubleValue());
        if (this.m.getDocument().getEngine().getPageSettings().isPrintPageNumberRange()) {
            --cellsPerLine;
        }
        if (startNode instanceof Text && startNode == endNode) {
            XMLNodeCaret xMLNodeCaret = this.m.getSimpleManager().getCurrentSelection().start;
            Intrinsics.checkNotNull((Object)xMLNodeCaret, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.mvc.XMLTextCaret");
            int n = ((XMLTextCaret)xMLNodeCaret).getOffset();
            nodeArray = this.m.getSimpleManager().getCurrentSelection().end;
            Intrinsics.checkNotNull((Object)nodeArray, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.mvc.XMLTextCaret");
            if (n == ((XMLTextCaret)nodeArray).getOffset()) {
                this.m.notify("Invalid text for the Page style.  You must highlight a number. ");
            } else {
                XMLNodeCaret xMLNodeCaret2 = this.m.getSimpleManager().getCurrentSelection().end;
                Intrinsics.checkNotNull((Object)xMLNodeCaret2, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.mvc.XMLTextCaret");
                int n2 = ((XMLTextCaret)xMLNodeCaret2).getOffset();
                nodeArray = this.m.getSimpleManager().getCurrentSelection().start;
                Intrinsics.checkNotNull((Object)nodeArray, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.mvc.XMLTextCaret");
                if (n2 - ((XMLTextCaret)nodeArray).getOffset() < cellsPerLine) {
                    Element element = XMLHandler.Companion.ancestorVisitorElement(endNode, StylesMenuModule::wrapSelectedPage$lambda$0);
                    Intrinsics.checkNotNull((Object)element);
                    Element ancestorElement = element;
                    UTDHelper.stripUTDRecursive((Element)ancestorElement);
                    Text text = (Text)startNode;
                    int[] nArray = new int[2];
                    XMLNodeCaret xMLNodeCaret3 = this.m.getSimpleManager().getCurrentSelection().start;
                    Intrinsics.checkNotNull((Object)xMLNodeCaret3, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.mvc.XMLTextCaret");
                    nArray[0] = ((XMLTextCaret)xMLNodeCaret3).getOffset();
                    XMLNodeCaret xMLNodeCaret4 = this.m.getSimpleManager().getCurrentSelection().end;
                    Intrinsics.checkNotNull((Object)xMLNodeCaret4, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.mvc.XMLTextCaret");
                    nArray[1] = ((XMLTextCaret)xMLNodeCaret4).getOffset();
                    List splitTextNode = CollectionsKt.toMutableList((Collection)XMLHandlerKt.splitNode((Text)text, (int[])nArray));
                    if (BBX.INLINE.isA((Node)((Text)splitTextNode.get(0)).getParent())) {
                        ParentNode parentNode2 = ((Text)splitTextNode.get(0)).getParent();
                        Intrinsics.checkNotNull((Object)parentNode2, (String)"null cannot be cast to non-null type nu.xom.Element");
                        Element inline = (Element)parentNode2;
                        ParentNode parentNode3 = inline.getParent();
                        Intrinsics.checkNotNull((Object)parentNode3, (String)"null cannot be cast to non-null type nu.xom.Element");
                        Element inlineParent = (Element)parentNode3;
                        Element inlineCopy = inline.copy();
                        inlineCopy.removeChildren();
                        inlineCopy.appendChild((Node)((Text)splitTextNode.get(0)).copy());
                        inlineParent.replaceChild((Node)inline, (Node)inlineCopy);
                        int index = inlineParent.indexOf((Node)inlineCopy) + 1;
                        page2.appendChild((Node)((Text)splitTextNode.get(1)).copy());
                        inlineParent.insertChild((Node)page2, index);
                        if (splitTextNode.size() > 2) {
                            inlineCopy = inlineCopy.copy();
                            inlineCopy.removeChildren();
                            inlineCopy.appendChild((Node)((Text)splitTextNode.get(2)).copy());
                            inlineParent.insertChild((Node)inlineCopy, ++index);
                        }
                        parent = inlineParent;
                    } else {
                        page2.appendChild((Node)((Text)splitTextNode.get(1)).copy());
                        parent.replaceChild((Node)splitTextNode.get(1), (Node)page2);
                    }
                    Iterator itr = splitTextNode.iterator();
                    while (itr.hasNext()) {
                        Text next = (Text)itr.next();
                        String string = next.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                        if (!(((CharSequence)string).length() == 0)) continue;
                        next.detach();
                        itr.remove();
                    }
                    if (BBX.BLOCK.isA((Node)parent) && parent.getChildCount() == 1) {
                        XMLHandler.Companion.unwrapElement(page2);
                        BBX.transform(parent, BBX.BLOCK.PAGE_NUM);
                        page2 = parent;
                    }
                } else {
                    this.m.notify("Invalid text for the Page style. The highlighted value is too long.");
                }
            }
        } else {
            this.m.notify("Invalid text for the Page style. Cannot highlight text between elements. Please apply the style only on the desired page number.");
            return;
        }
        page2.addAttribute(new Attribute("page", "bbAdded"));
        nodeArray = new Node[]{parent};
        this.m.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.NO_SENDER, true, nodeArray));
    }

    private final void wrapSelectedText(Element guideWord, Node startNode, Node endNode) {
        if (this.isGuideWord((Node)startNode)) {
            return;
        }
        ParentNode parentNode = startNode.getParent();
        Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element parent = (Element)parentNode;
        Node[] nodeArray = startNode;
        if (nodeArray instanceof Text && Intrinsics.areEqual((Object)startNode, (Object)endNode)) {
            Text text = (Text)startNode;
            int[] nArray = new int[2];
            XMLNodeCaret xMLNodeCaret = this.m.getSimpleManager().getCurrentSelection().start;
            Intrinsics.checkNotNull((Object)xMLNodeCaret, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.mvc.XMLTextCaret");
            nArray[0] = ((XMLTextCaret)xMLNodeCaret).getOffset();
            XMLNodeCaret xMLNodeCaret2 = this.m.getSimpleManager().getCurrentSelection().end;
            Intrinsics.checkNotNull((Object)xMLNodeCaret2, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.mvc.XMLTextCaret");
            nArray[1] = ((XMLTextCaret)xMLNodeCaret2).getOffset();
            List splitTextNode = XMLHandlerKt.splitNode((Text)text, (int[])nArray);
            String string = ((Text)splitTextNode.get(0)).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            if (((CharSequence)string).length() == 0) {
                ((Text)splitTextNode.get(0)).detach();
            }
            guideWord.appendChild((Node)((Text)splitTextNode.get(1)).copy());
            parent.replaceChild((Node)splitTextNode.get(1), (Node)guideWord);
        } else {
            if (nodeArray instanceof Element && ((Element)startNode).getAttribute("utd-style") != null && Intrinsics.areEqual((Object)((Element)startNode).getAttributeValue("utd-style"), (Object)"Guide Word")) {
                return;
            }
            parent = StylesMenuModule.Companion.getCommonParent((Node)startNode, endNode);
            LinkedHashSet<Element> blocks = this.getBlocks((Node)startNode, endNode);
            Iterator iterator = blocks.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Element guide;
                Element element = (Element)iterator2.next();
                Element element2 = guide = BBX.SPAN.GUIDEWORD.create();
                Intrinsics.checkNotNull((Object)element2);
                guide = this.copyChildrenToElement(element, element2);
                element.appendChild((Node)guide);
            }
        }
        nodeArray = new Node[]{parent};
        this.m.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.NO_SENDER, true, nodeArray));
    }

    private final boolean isGuideWord(Node node) {
        Element guideWord;
        Nodes guideWords = node.query("ancestor-or-self::node()[@utd-style='Guide Word']");
        if (guideWords.size() > 0 && (guideWord = (Element)guideWords.get(0)) != null) {
            if (guideWord.getAttribute("guideWords") != null && Intrinsics.areEqual((Object)guideWord.getAttributeValue("guideWords"), (Object)"false")) {
                guideWord.addAttribute(new Attribute("guideWords", "true"));
            } else {
                guideWord.addAttribute(new Attribute("guideWords", "false"));
            }
            Node[] nodeArray = new Node[]{guideWord};
            this.m.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.NO_SENDER, true, nodeArray));
            return true;
        }
        return false;
    }

    private final Element copyChildrenToElement(Element from, Element to) {
        while (from.getChildCount() > 1) {
            to.appendChild(from.removeChild(0).copy());
        }
        return to;
    }

    @Nullable
    public final ParentNode getParent0() {
        return this.parent0;
    }

    public final void setParent0(@Nullable ParentNode parentNode) {
        this.parent0 = parentNode;
    }

    private final void collectParents(LinkedHashSet<Element> blocks) {
        ParentNode parent = null;
        int index = -1;
        boolean first = true;
        Iterator iterator = blocks.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Element block = (Element)iterator2.next();
            if (BBX.CONTAINER.TABLE.isA((Node)block)) {
                Element tableBrlCopy;
                Element element = tableBrlCopy = Manager.getTableBrlCopy((Node)block);
                if (element != null) {
                    element.detach();
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)block.getParent(), (String)"getParent(...)");
            if (first) {
                first = false;
                ParentNode parentNode = this.parent0 = parent;
                Intrinsics.checkNotNull((Object)parentNode);
                index = parentNode.indexOf((Node)block);
                continue;
            }
            if (Intrinsics.areEqual((Object)parent, (Object)this.parent0)) continue;
            block.detach();
            ParentNode parentNode = this.parent0;
            Intrinsics.checkNotNull((Object)parentNode);
            parentNode.insertChild((Node)block, ++index);
            if (parent.getChildCount() != 0) continue;
            parent.detach();
        }
    }

    private final void reformat(List<? extends Node> modifiedNodes) {
        this.m.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.NO_SENDER, modifiedNodes, true));
    }

    @NotNull
    public final LinkedHashSet<Element> getBlocks(@Nullable Node start, @Nullable Node end) {
        List nodes = new ArrayList();
        for (Node curNode : FastXPath.descendantAndFollowing((Node)start)) {
            nodes.add(curNode);
            if (curNode != end) continue;
        }
        if (end instanceof Element) {
            CollectionsKt.addAll((Collection)nodes, (Sequence)FastXPath.descendant((Node)end));
        }
        LinkedHashSet<Element> blocks = new LinkedHashSet<Element>();
        for (Node curNode : nodes) {
            if (BBXUtilsKt.findBlockOrNull(curNode) == null) continue;
            blocks.add(BBXUtilsKt.findBlock(curNode));
        }
        return blocks;
    }

    private final boolean isAnyBox(Style s) {
        return this.isColorBoxline(s) || this.isColorFullBox(s) || this.isBoxline(s) || this.isFullBox(s);
    }

    private final boolean isColorBoxline(Node n) {
        if (BBX.CONTAINER.isA(n)) {
            IStyle style = this.m.getStyle(n);
            return style != null && this.isColorBoxline((Style)style);
        }
        return false;
    }

    private final boolean isColorFullBox(Node n) {
        if (BBX.CONTAINER.isA(n)) {
            IStyle style = this.m.getStyle(n);
            return style != null && this.isColorFullBox((Style)style);
        }
        return false;
    }

    private final boolean isColorBoxline(Style s) {
        return Intrinsics.areEqual((Object)s.getName(), (Object)"Color Box");
    }

    private final boolean isColorFullBox(Style s) {
        return Intrinsics.areEqual((Object)s.getName(), (Object)"Color Full Box");
    }

    private final boolean isBoxline(Node n) {
        if (BBX.CONTAINER.isA(n)) {
            IStyle style = this.m.getStyle(n);
            return style != null && this.isBoxline((Style)style);
        }
        return false;
    }

    private final boolean isFullBox(Node n) {
        if (BBX.CONTAINER.isA(n)) {
            IStyle style = this.m.getStyle(n);
            return style != null && this.isFullBox((Style)style);
        }
        return false;
    }

    private final boolean isBoxline(Style s) {
        return Intrinsics.areEqual((Object)s.getName(), (Object)"Box");
    }

    private final boolean isFullBox(Style s) {
        return Intrinsics.areEqual((Object)s.getName(), (Object)"Full Box");
    }

    private final boolean isPoeticStanza(Style s) {
        return Intrinsics.areEqual((Object)s.getName(), (Object)"Poetic Stanza");
    }

    private final boolean isDontSplit(Style s) {
        return Intrinsics.areEqual((Object)s.getName(), (Object)"Dont Split");
    }

    private final boolean isList(Style s) {
        return Intrinsics.areEqual((Object)s.getName(), (Object)"List Tag");
    }

    private final boolean isListItem(Style s) {
        return Intrinsics.areEqual((Object)"List Item", (Object)s.getBaseStyleName());
    }

    private final boolean isGuideWord(Style s) {
        return Intrinsics.areEqual((Object)s.getName(), (Object)"Guide Word");
    }

    private final boolean isPage(Style s) {
        return Intrinsics.areEqual((Object)s.getName(), (Object)"Page");
    }

    private final boolean isDoubleLine(Style s) {
        return Intrinsics.areEqual((Object)s.getName(), (Object)"Double Spaced");
    }

    private final void detachTableCopy(Element table) {
        Node checkSibling;
        ParentNode parent = table.getParent();
        if (parent != null && parent.indexOf((Node)table) != parent.getChildCount() - 1 && (checkSibling = parent.getChild(parent.indexOf((Node)table) + 1)) instanceof Element && ((Element)checkSibling).getAttribute("tableCopy", "http://brailleblaster.org/ns/utd") != null) {
            ((Element)checkSibling).detach();
        }
    }

    private final boolean isContainer(Node n) {
        return BBX.CONTAINER.isA(n);
    }

    private final boolean isTableSelected() {
        TableSelectionModule tableSelectionModule = this.m.getSimpleManager().getModule(TableSelectionModule.class);
        Intrinsics.checkNotNull((Object)tableSelectionModule);
        return tableSelectionModule.isTableSelected();
    }

    private final void warnTable() {
        TableSelectionModule.Companion.displayInvalidTableMessage(this.m.getWpManager().getShell());
    }

    private final void movePageIndicators(Node start, Node end) {
        Element c2;
        Element element;
        Element b1;
        if (this.isContainer(start)) {
            Intrinsics.checkNotNull((Object)start, (String)"null cannot be cast to non-null type nu.xom.Element");
            v0 = (Element)start;
        } else {
            v0 = b1 = BBXUtilsKt.findBlock(start);
        }
        if (this.isContainer(end)) {
            Intrinsics.checkNotNull((Object)end, (String)"null cannot be cast to non-null type nu.xom.Element");
            element = (Element)end;
        } else {
            element = BBXUtilsKt.findBlock(end);
        }
        Element b2 = element;
        Element tableParent = Manager.getTableParent((Node)b1);
        if (tableParent != null) {
            b1 = tableParent;
        }
        if ((tableParent = Manager.getTableParent((Node)b2)) != null) {
            b2 = tableParent;
        }
        Elements s1 = b1.getChildElements();
        Elements s2 = b2.getChildElements();
        Element c1 = s1.size() > 0 ? s1.get(0) : null;
        int ns2 = s2.size();
        Element element2 = c2 = ns2 > 0 ? s2.get(ns2 - 1) : null;
        if (c1 != null && BBX.SPAN.PAGE_NUM.isA((Node)c1)) {
            BBX.transform(c1, BBX.BLOCK.PAGE_NUM);
            c1.detach();
            b1.getParent().insertChild((Node)c1, b1.getParent().indexOf((Node)b1));
        }
        if (c2 != null && BBX.SPAN.PAGE_NUM.isA((Node)c2)) {
            BBX.transform(c2, BBX.BLOCK.PAGE_NUM);
            c2.detach();
            b2.getParent().insertChild((Node)c2, b2.getParent().indexOf((Node)b2) + 1);
        }
    }

    @NotNull
    public final List<Node> getBoxSiblings(@NotNull Element a, @NotNull Element b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        XMLNodeCaret nc1 = new XMLNodeCaret((Node)a, null, 2, null);
        XMLNodeCaret nc2 = new XMLNodeCaret((Node)b, null, 2, null);
        XMLSelection xmlSelect = new XMLSelection(nc1, nc2);
        List<Element> sibs = xmlSelect.getSelectedBlocks();
        for (int i = 0; i < sibs.size(); ++i) {
            Element tableParent = Manager.getTableParent((Node)sibs.get(i));
            if (tableParent == null) continue;
            sibs.remove(i);
            if (!sibs.contains(tableParent)) {
                sibs.add(i, tableParent);
                continue;
            }
            --i;
        }
        this.collectParents(new LinkedHashSet<Element>((Collection)sibs));
        return new ArrayList(sibs);
    }

    private static final void onEvent$lambda$0(StylesMenuModule this$0, BBStyleSelection s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this$0.update(s);
    }

    private static final void onEvent$lambda$1(StylesMenuModule this$0, BBActionSelection t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this$0.updateAction(t);
    }

    private static final void onEvent$lambda$2(StylesMenuModule this$0, BBStyleOptionSelection option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        this$0.updateStyleOption(option);
    }

    private static final void onEvent$lambda$3(BBSelectionData e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getManager().getSimpleManager().initMenu(WPManager.Companion.getInstance().getShell());
    }

    private static final boolean applyStyle$lambda$0(Element node) {
        return BBX.BLOCK.isA((Node)node);
    }

    private static final boolean wrapSelectedPage$lambda$0(Element node) {
        return BBX.BLOCK.isA((Node)node);
    }

    public static final /* synthetic */ Manager access$getM$p(StylesMenuModule $this) {
        return $this.m;
    }

    public static final /* synthetic */ void access$reformat(StylesMenuModule $this, List modifiedNodes) {
        $this.reformat(modifiedNodes);
    }

    static {
        Logger logger = LoggerFactory.getLogger(StylesMenuModule.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
        Object[] objectArray = new String[]{"Box", "Color Box", "Color Full Box", "Full Box", "Dont Split", "List Tag", "Poetic Stanza", "Guide Word", "Page", "Double Spaced"};
        ALWAYS_WRAP_STYLES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/StylesMenuModule$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "ALWAYS_WRAP_STYLES", "", "", "TRNOTE_ACTION_STYLE_NAME", "DESCRIPTION_STYLE_NAME", "TRNOTE_ACTION_STYLE_DISPLAY_NAME", "COLOR_PROP", "wrapSelectedElements", "", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "container", "Lnu/xom/Element;", "startNode", "Lnu/xom/Node;", "endNode", "handleListLevels", "getCommonParent", "start", "end", "isAlwaysWrapStyle", "", "style", "Lorg/brailleblaster/utd/Style;", "brailleblaster-core"})
    @SourceDebugExtension(value={"SMAP\nStylesMenuModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StylesMenuModule.kt\norg/brailleblaster/perspectives/mvc/modules/misc/StylesMenuModule$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1000:1\n1807#2,3:1001\n*S KotlinDebug\n*F\n+ 1 StylesMenuModule.kt\norg/brailleblaster/perspectives/mvc/modules/misc/StylesMenuModule$Companion\n*L\n991#1:1001,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void wrapSelectedElements(@NotNull Manager m, @NotNull Element container, @NotNull Node startNode, @NotNull Node endNode) {
            Node endNode2;
            Node startNode2;
            block18: {
                block17: {
                    boolean isNestedLineGroup;
                    Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                    Intrinsics.checkNotNullParameter((Object)container, (String)"container");
                    Intrinsics.checkNotNullParameter((Object)startNode, (String)"startNode");
                    Intrinsics.checkNotNullParameter((Object)endNode, (String)"endNode");
                    startNode2 = startNode;
                    endNode2 = endNode;
                    if (startNode2 instanceof Text || MathModuleUtils.isMath(startNode2)) {
                        startNode2 = (Node)BBXUtilsKt.findBlock(startNode2);
                    }
                    if (endNode2 instanceof Text || MathModuleUtils.isMath(endNode2)) {
                        endNode2 = (Node)BBXUtilsKt.findBlock(endNode2);
                    }
                    Nodes ancestorLists = startNode2.query("ancestor::node()[@utd-style='List Tag']");
                    boolean bl = isNestedLineGroup = BBX.ListType.POEM_LINE_GROUP.isA((Node)container) && XMLHandler.Companion.ancestorElementIs(startNode2, Companion::wrapSelectedElements$lambda$0);
                    if (ancestorLists.size() > 0 || BBX.CONTAINER.LIST.isA(startNode2)) break block17;
                    Node node = startNode2;
                    Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
                    if (!UTDManager.Companion.hasUtdStyleTag((Element)node, "List Tag") && !isNestedLineGroup) break block18;
                }
                if (BBIni.getDebugging()) {
                    throw new RuntimeException("Cannot have a list inside a list.");
                }
                MessageBox message = new MessageBox(WPManager.Companion.getInstance().getShell());
                message.setMessage("Cannot have a list inside a list.");
                message.open();
                return;
            }
            Element parent = this.getCommonParent(startNode2, endNode2);
            if (m.getSimpleManager().getCurrentSelection().isSingleNode()) {
                if (BBX.SECTION.isA(startNode2)) {
                    Node startElem = startNode2;
                    while (((Element)startElem).getChildCount() != 0) {
                        Node startChild = ((Element)startElem).getChild(0);
                        startChild.detach();
                        container.appendChild(startChild);
                    }
                    ((Element)startNode2).appendChild((Node)container);
                } else {
                    container.appendChild((Node)((Element)startNode2).copy());
                    if (Intrinsics.areEqual((Object)parent, (Object)startNode2)) {
                        ParentNode parentNode = parent.getParent();
                        Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
                        parent = (Element)parentNode;
                    }
                    parent.replaceChild(startNode2, (Node)container);
                }
            } else if (Intrinsics.areEqual((Object)startNode2, (Object)endNode2)) {
                ParentNode parentNode = parent.getParent();
                Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
                parent = (Element)parentNode;
                int index = parent.indexOf(startNode2);
                container.appendChild(parent.removeChild(startNode2));
                parent.insertChild((Node)container, index);
            } else {
                List<Node> selectedSiblings = XMLSelection.Companion.isValidTreeSelection(startNode2, endNode2);
                if (selectedSiblings == null) {
                    m.notify("Invalid selection. Cannot select part of a node.");
                    return;
                }
                ParentNode parentNode = selectedSiblings.get(0).getParent();
                Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
                Element treeParent = (Element)parentNode;
                treeParent.insertChild((Node)container, treeParent.indexOf(selectedSiblings.get(0)));
                for (Node selectedSibling : selectedSiblings) {
                    selectedSibling.detach();
                    container.appendChild(selectedSibling);
                }
            }
            if (BBX.CONTAINER.LIST.isA((Node)container)) {
                this.handleListLevels(container);
            }
            Node[] nodeArray = new Node[]{parent};
            m.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.NO_SENDER, true, nodeArray));
        }

        private final void handleListLevels(Element container) {
            Element parentPoemList;
            String name = "bb:listLevel";
            Nodes descendantLists = container.query("descendant::node()[@utd-style='List Tag']");
            if (descendantLists.size() > 0) {
                MessageBox message = new MessageBox(WPManager.Companion.getInstance().getShell());
                message.setMessage("Cannot have a list inside a list.");
                message.open();
                return;
            }
            Nodes listItems = container.query("descendant::node()[@*[local-name()='itemLevel']]");
            int maxItemLevel = 0;
            int n = listItems.size();
            for (int i = 0; i < n; ++i) {
                Node node = listItems.get(i);
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
                Element listItem = (Element)node;
                String string = listItem.getAttributeValue("itemLevel", "http://brailleblaster.org/ns/bb");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
                maxItemLevel = Math.max(Integer.parseInt(string), maxItemLevel);
            }
            if (BBX.ListType.POEM_LINE_GROUP.isA((Node)container) && (parentPoemList = XMLHandler.Companion.ancestorVisitorElement((Node)container, Companion::handleListLevels$lambda$0)) != null) {
                Integer n2 = (Integer)BBX.CONTAINER.LIST.ATTRIB_LIST_LEVEL.get(parentPoemList);
                n = maxItemLevel;
                if (n2 == null || n2 != n) {
                    BBX.CONTAINER.LIST.ATTRIB_LIST_LEVEL.set(container, maxItemLevel);
                }
                return;
            }
            container.addAttribute(new Attribute(name, "http://brailleblaster.org/ns/bb", String.valueOf(maxItemLevel)));
        }

        private final Element getCommonParent(Node start, Node end) {
            Node start2 = start;
            Node end2 = end;
            if (start2 instanceof Text) {
                ParentNode parentNode = ((Text)start2).getParent();
                Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
                start2 = (Node)parentNode;
            }
            if (end2 instanceof Text) {
                ParentNode parentNode = ((Text)end2).getParent();
                Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
                end2 = (Node)parentNode;
            }
            Object[] objectArray = new Element[2];
            Intrinsics.checkNotNull((Object)start2, (String)"null cannot be cast to non-null type nu.xom.Element");
            Intrinsics.checkNotNull((Object)end2, (String)"null cannot be cast to non-null type nu.xom.Element");
            return XMLHandler.Companion.findCommonParent(CollectionsKt.listOf((Object[])objectArray));
        }

        public final boolean isAlwaysWrapStyle(@Nullable Style style) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = ALWAYS_WRAP_STYLES;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String curAlwaysUnwrap = (String)element$iv;
                        boolean bl2 = false;
                        String string = curAlwaysUnwrap;
                        Intrinsics.checkNotNull((Object)string);
                        if (!UTDManager.Companion.isStyle(style, string)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private static final boolean wrapSelectedElements$lambda$0(Element node) {
            return BBX.ListType.POEM_LINE_GROUP.isA((Node)node);
        }

        private static final boolean handleListLevels$lambda$0(Element node) {
            return BBX.ListType.POEM.isA((Node)node);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/StylesMenuModule$RepeatStyleTool;", "Lorg/brailleblaster/tools/MenuToolModule;", "<init>", "(Lorg/brailleblaster/perspectives/mvc/modules/misc/StylesMenuModule;)V", "topMenu", "Lorg/brailleblaster/perspectives/mvc/menu/TopMenu;", "getTopMenu", "()Lorg/brailleblaster/perspectives/mvc/menu/TopMenu;", "title", "", "getTitle", "()Ljava/lang/String;", "accelerator", "", "getAccelerator", "()I", "sharedItem", "Lorg/brailleblaster/perspectives/mvc/menu/SharedItem;", "getSharedItem", "()Lorg/brailleblaster/perspectives/mvc/menu/SharedItem;", "onRun", "", "bbData", "Lorg/brailleblaster/perspectives/mvc/menu/BBSelectionData;", "brailleblaster-core"})
    public final class RepeatStyleTool
    implements MenuToolModule {
        @Override
        @NotNull
        public TopMenu getTopMenu() {
            return TopMenu.STYLES;
        }

        @Override
        @NotNull
        public String getTitle() {
            return "Repeat Last Style";
        }

        @Override
        public int getAccelerator() {
            return 262226;
        }

        @Override
        @NotNull
        public SharedItem getSharedItem() {
            return SharedItem.REPEAT_LAST_STYLE;
        }

        @Override
        public void onRun(@NotNull BBSelectionData bbData) {
            Intrinsics.checkNotNullParameter((Object)bbData, (String)"bbData");
            StylesMenuModule.this.repeatStyle();
        }
    }
}

