/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.mvc.modules.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import org.brailleblaster.BBIni;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.views.style.BreadcrumbsToolbar;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.perspectives.mvc.SimpleEvent;
import org.brailleblaster.perspectives.mvc.ViewManager;
import org.brailleblaster.perspectives.mvc.events.BuildMenuEvent;
import org.brailleblaster.perspectives.mvc.menu.BBSelectionData;
import org.brailleblaster.perspectives.mvc.menu.MenuManager;
import org.brailleblaster.perspectives.mvc.menu.SubMenuBuilder;
import org.brailleblaster.perspectives.mvc.menu.TopMenu;
import org.brailleblaster.perspectives.mvc.modules.views.DebugModule;
import org.brailleblaster.tools.MenuTool;
import org.brailleblaster.tools.ToggleViewTool;
import org.brailleblaster.utils.PropertyFileManager;
import org.brailleblaster.utils.swt.CompositeBuilder;
import org.brailleblaster.utils.swt.EasySWT;
import org.brailleblaster.wordprocessor.WPManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\u0018\u0000 +2\u00020\u0001:\u0004()*+B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00172\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u0006\u0010\u0018\u001a\u00020\u000fJ\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J\u0016\u0010\u001f\u001a\u00020\r2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002J\b\u0010 \u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010#R\u0014\u0010&\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010#\u00a8\u0006,"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/ToggleViewsModule;", "Lorg/brailleblaster/perspectives/mvc/BBSimpleManager$SimpleListener;", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;)V", "shell", "Lorg/eclipse/swt/widgets/Shell;", "windowedView", "Lorg/brailleblaster/perspectives/mvc/modules/misc/ToggleViewsModule$Views;", "currentViews", "", "parent", "Lorg/eclipse/swt/widgets/Composite;", "onEvent", "", "event", "Lorg/brailleblaster/perspectives/mvc/SimpleEvent;", "enableWindowedView", "e", "Lorg/brailleblaster/perspectives/mvc/menu/BBSelectionData;", "view", "makeSelectionListener", "Ljava/util/function/Consumer;", "checkViews", "checkView", "widget", "Lorg/eclipse/swt/custom/StyledText;", "setVisible", "", "visible", "findParentComposite", "invalidViewChange", "stylePane", "getStylePane", "()Lorg/eclipse/swt/custom/StyledText;", "printView", "getPrintView", "brailleView", "getBrailleView", "Views", "RearrangeViewsTool", "ChangeViewOrderDialog", "Companion", "brailleblaster-core"})
public final class ToggleViewsModule
implements BBSimpleManager.SimpleListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Manager m;
    @NotNull
    private final Shell shell;
    @Nullable
    private Views windowedView;
    @NotNull
    private List<Views> currentViews;
    @NotNull
    private final Composite parent;
    private static final Logger log = LoggerFactory.getLogger(ToggleViewsModule.class);
    @NotNull
    public static final String ERROR_TITLE = "Error";
    @NotNull
    public static final String ERROR_MESSAGE = "At least one view must be active";
    @NotNull
    public static final String TOGGLE_SUBMENU_TITLE = "Toggle Views";
    @NotNull
    private static final String REARRANGE = "Rearrange Views...";
    @NotNull
    private static final String USER_SETTING_KEY = "views";
    @NotNull
    private static final String USER_SETTING_DELIMITER = ",";
    @NotNull
    public static final String WINDOWIZE_TITLE = "Windowize";
    @NotNull
    private static final List<Views> DEFAULT_ORDER;

    public ToggleViewsModule(@NotNull Manager m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        this.m = m;
        this.shell = this.m.getWpManager().getShell();
        this.currentViews = Companion.loadSettings();
        this.parent = this.findParentComposite(this.currentViews);
        this.checkViews();
    }

    @Override
    public void onEvent(@NotNull SimpleEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof BuildMenuEvent) {
            ToggleViewTool.TogglePrintViewTool tool = new ToggleViewTool.TogglePrintViewTool(this.currentViews.contains((Object)Views.PRINT), this.makeSelectionListener(Views.PRINT));
            SubMenuBuilder subMenuBuilder = new SubMenuBuilder(TopMenu.VIEW, TOGGLE_SUBMENU_TITLE);
            subMenuBuilder.add(tool);
            ToggleViewTool.ToggleBrailleViewTool tool1 = new ToggleViewTool.ToggleBrailleViewTool(this.currentViews.contains((Object)Views.BRAILLE), this.makeSelectionListener(Views.BRAILLE));
            subMenuBuilder.add(tool1);
            ToggleViewTool.ToggleStyleViewTool tool2 = new ToggleViewTool.ToggleStyleViewTool(this.currentViews.contains((Object)Views.STYLE), this.makeSelectionListener(Views.STYLE));
            subMenuBuilder.add(tool2);
            ToggleViewTool.ToggleBreadCrumbsToolbarTool tool3 = new ToggleViewTool.ToggleBreadCrumbsToolbarTool(BreadcrumbsToolbar.Companion.getEnabled(), ToggleViewsModule::onEvent$lambda$0);
            subMenuBuilder.add(tool3);
            RearrangeViewsTool tool4 = new RearrangeViewsTool();
            SubMenuBuilder addSeparator = subMenuBuilder.addSeparator();
            addSeparator.add(tool4);
            MenuManager.INSTANCE.add(addSeparator.build());
            this.windowedView = ViewManager.Companion.getWindowedView();
            if (DebugModule.enabled) {
                MenuManager.INSTANCE.add(new SubMenuBuilder(TopMenu.WINDOW, WINDOWIZE_TITLE).addRadioItem("Print", 0, this.windowedView == Views.PRINT, (Function1<? super BBSelectionData, Unit>)((Function1)arg_0 -> ToggleViewsModule.onEvent$lambda$1(this, arg_0))).addRadioItem("Braille", 0, this.windowedView == Views.BRAILLE, (Function1<? super BBSelectionData, Unit>)((Function1)arg_0 -> ToggleViewsModule.onEvent$lambda$2(this, arg_0))).addRadioItem("Style", 0, this.windowedView == Views.STYLE, (Function1<? super BBSelectionData, Unit>)((Function1)arg_0 -> ToggleViewsModule.onEvent$lambda$3(this, arg_0))).build());
            }
        }
    }

    private final void enableWindowedView(BBSelectionData e, Views view) {
        log.info("enable");
        Widget widget = e.getWidget();
        Intrinsics.checkNotNull((Object)widget, (String)"null cannot be cast to non-null type org.eclipse.swt.widgets.MenuItem");
        MenuItem menu = (MenuItem)widget;
        if (this.windowedView == view) {
            ViewManager.Companion.setWindowedView(null);
            menu.setSelection(false);
            this.windowedView = null;
        } else {
            ViewManager.Companion.setWindowedView(view);
            this.windowedView = view;
        }
        this.m.getViewManager().reparent();
    }

    private final Consumer<BBSelectionData> makeSelectionListener(Views view) {
        return arg_0 -> ToggleViewsModule.makeSelectionListener$lambda$0(this, view, arg_0);
    }

    public final void checkViews() {
        this.checkView(Views.STYLE, this.getStylePane());
        this.checkView(Views.PRINT, this.getPrintView());
        this.checkView(Views.BRAILLE, this.getBrailleView());
        StyledText styledText = this.getStylePane();
        StyledText styledText2 = this.getPrintView();
        StyledText styledText3 = this.getBrailleView();
        ViewManager viewManager = this.m.getViewManager();
        Intrinsics.checkNotNullExpressionValue((Object)viewManager, (String)"getViewManager(...)");
        Companion.setViewOrder(styledText, styledText2, styledText3, viewManager);
        this.parent.layout(true);
    }

    private final void checkView(Views view, StyledText widget) {
        widget.setVisible(this.currentViews.contains((Object)view));
    }

    private final boolean setVisible(Views view, boolean visible) {
        this.m.getViewManager().saveScreenProperties();
        if (visible && !this.currentViews.contains((Object)view)) {
            this.currentViews.add(view);
        } else if (!visible) {
            if (this.currentViews.size() == 1) {
                this.invalidViewChange();
                return false;
            }
            this.currentViews.remove((Object)view);
        }
        this.checkViews();
        Companion.saveSettings(this.currentViews);
        this.m.getViewManager().reparent();
        StyledText styledText = this.getStylePane();
        StyledText styledText2 = this.getPrintView();
        StyledText styledText3 = this.getBrailleView();
        ViewManager viewManager = this.m.getViewManager();
        Intrinsics.checkNotNullExpressionValue((Object)viewManager, (String)"getViewManager(...)");
        Companion.setViewOrder(styledText, styledText2, styledText3, viewManager);
        return true;
    }

    private final Composite findParentComposite(List<Views> currentViews) {
        ToggleViewsModule.Companion.checkList(currentViews);
        StyledText widget = switch (WhenMappings.$EnumSwitchMapping$0[currentViews.get(0).ordinal()]) {
            case 1 -> this.getBrailleView();
            case 2 -> this.getPrintView();
            case 3 -> this.getStylePane();
            default -> throw new NoWhenBranchMatchedException();
        };
        Composite composite = widget.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)composite, (String)"getParent(...)");
        return composite;
    }

    private final void invalidViewChange() {
        EasySWT.makeEasyOkDialog((String)ERROR_TITLE, (String)ERROR_MESSAGE, (Shell)this.shell);
    }

    private final StyledText getStylePane() {
        return this.m.getStylePane().getWidget();
    }

    private final StyledText getPrintView() {
        StyledText styledText = this.m.getTextView();
        Intrinsics.checkNotNullExpressionValue((Object)styledText, (String)"getTextView(...)");
        return styledText;
    }

    private final StyledText getBrailleView() {
        StyledText styledText = this.m.getBrailleView();
        Intrinsics.checkNotNullExpressionValue((Object)styledText, (String)"getBrailleView(...)");
        return styledText;
    }

    private static final void onEvent$lambda$0(BBSelectionData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BreadcrumbsToolbar.Companion.setEnabled(!BreadcrumbsToolbar.Companion.getEnabled());
        WPManager.Companion.getInstance().buildToolBar();
    }

    private static final Unit onEvent$lambda$1(ToggleViewsModule this$0, BBSelectionData e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this$0.enableWindowedView(e, Views.PRINT);
        return Unit.INSTANCE;
    }

    private static final Unit onEvent$lambda$2(ToggleViewsModule this$0, BBSelectionData e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this$0.enableWindowedView(e, Views.BRAILLE);
        return Unit.INSTANCE;
    }

    private static final Unit onEvent$lambda$3(ToggleViewsModule this$0, BBSelectionData e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this$0.enableWindowedView(e, Views.STYLE);
        return Unit.INSTANCE;
    }

    private static final void makeSelectionListener$lambda$0(ToggleViewsModule this$0, Views $view, BBSelectionData e) {
        boolean selection;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ToolItem toolBarItem = e.getToolBarItem();
        MenuItem menuItem = e.getMenuItem();
        boolean toolBarSource = e.getWidget() instanceof ToolItem;
        if (toolBarSource) {
            ToolItem toolItem = toolBarItem;
            Intrinsics.checkNotNull((Object)toolItem);
            v1 = toolItem.getSelection();
        } else {
            MenuItem menuItem2 = menuItem;
            Intrinsics.checkNotNull((Object)menuItem2);
            v1 = selection = menuItem2.getSelection();
        }
        if (!this$0.setVisible($view, selection)) {
            if (toolBarSource) {
                ToolItem toolItem = toolBarItem;
                Intrinsics.checkNotNull((Object)toolItem);
                toolItem.setSelection(!toolBarItem.getSelection());
            } else {
                MenuItem menuItem3 = menuItem;
                Intrinsics.checkNotNull((Object)menuItem3);
                menuItem3.setSelection(!menuItem.getSelection());
            }
        } else if (toolBarSource) {
            MenuItem menuItem4 = menuItem;
            Intrinsics.checkNotNull((Object)menuItem4);
            ToolItem toolItem = toolBarItem;
            Intrinsics.checkNotNull((Object)toolItem);
            menuItem4.setSelection(toolItem.getSelection());
        } else {
            ToolItem toolItem = toolBarItem;
            boolean bl = toolItem != null ? !toolItem.isDisposed() : false;
            if (bl) {
                MenuItem menuItem5 = menuItem;
                Intrinsics.checkNotNull((Object)menuItem5);
                toolBarItem.setSelection(menuItem5.getSelection());
            }
        }
        this$0.m.getViewManager().setTabList();
        this$0.m.getViewManager().reparent();
    }

    @JvmStatic
    @NotNull
    public static final List<Views> loadSettings() {
        return Companion.loadSettings();
    }

    static {
        Views[] viewsArray = new Views[]{Views.STYLE, Views.PRINT, Views.BRAILLE};
        DEFAULT_ORDER = CollectionsKt.listOf((Object[])viewsArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001b\u0010\b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/ToggleViewsModule$ChangeViewOrderDialog;", "", "<init>", "(Lorg/brailleblaster/perspectives/mvc/modules/misc/ToggleViewsModule;)V", "fillList", "", "list", "Lorg/eclipse/swt/widgets/List;", "saveNewList", "items", "", "", "([Ljava/lang/String;)V", "moveUp", "moveDown", "brailleblaster-core"})
    @SourceDebugExtension(value={"SMAP\nToggleViewsModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToggleViewsModule.kt\norg/brailleblaster/perspectives/mvc/modules/misc/ToggleViewsModule$ChangeViewOrderDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,363:1\n1#2:364\n*E\n"})
    private final class ChangeViewOrderDialog {
        public ChangeViewOrderDialog() {
            CompositeBuilder compositeBuilder;
            Shell dialog = new Shell(ToggleViewsModule.this.shell, 2144);
            dialog.setText("Rearrange Views");
            dialog.setLayout((Layout)new GridLayout(1, false));
            Composite container = EasySWT.makeComposite((Composite)((Composite)dialog), (int)2);
            org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(container, 2052);
            EasySWT.buildGridData().setHint(Integer.valueOf(200), Integer.valueOf(-1)).applyTo((Control)list);
            this.fillList(list);
            String moveUpButton = "Move Up";
            String moveDownButton = "Move Down";
            CompositeBuilder $this$_init__u24lambda_u240 = compositeBuilder = EasySWT.buildComposite((Composite)container);
            boolean bl = false;
            $this$_init__u24lambda_u240.setColumns(Integer.valueOf(1));
            $this$_init__u24lambda_u240.addButton(moveUpButton, 1, arg_0 -> ChangeViewOrderDialog.lambda$0$0(this, list, arg_0));
            $this$_init__u24lambda_u240.addButton(moveDownButton, 1, arg_0 -> ChangeViewOrderDialog.lambda$0$1(this, list, arg_0));
            compositeBuilder.build();
            String okButton = "Ok";
            String cancelButton = "Cancel";
            EasySWT.buildGridData().setColumns(2).applyTo((Control)EasySWT.buildComposite((Composite)container).addButton(okButton, 1, arg_0 -> ChangeViewOrderDialog._init_$lambda$1(this, list, dialog, arg_0)).addButton(cancelButton, 1, arg_0 -> ChangeViewOrderDialog._init_$lambda$2(dialog, arg_0)).build());
            dialog.pack();
            dialog.open();
        }

        private final void fillList(org.eclipse.swt.widgets.List list) {
            list.removeAll();
            ToggleViewsModule.this.currentViews.forEach(arg_0 -> ChangeViewOrderDialog.fillList$lambda$0(list, arg_0));
        }

        private final void saveNewList(String[] items) {
            ToggleViewsModule.this.currentViews = new ArrayList();
            int n = items.length;
            for (int i = 0; i < n; ++i) {
                String string;
                String item;
                String string2 = item = items[i];
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                Intrinsics.checkNotNullExpressionValue((Object)string2.toLowerCase(locale), (String)"toLowerCase(...)");
                string2 = "STYLE";
                Locale locale2 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
                String string3 = string2.toLowerCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                if (Intrinsics.areEqual((Object)string, (Object)string3)) {
                    ToggleViewsModule.this.currentViews.add(Views.STYLE);
                    continue;
                }
                string2 = "PRINT";
                Locale locale3 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"getDefault(...)");
                String string4 = string2.toLowerCase(locale3);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                if (Intrinsics.areEqual((Object)string, (Object)string4)) {
                    ToggleViewsModule.this.currentViews.add(Views.PRINT);
                    continue;
                }
                string2 = "BRAILLE";
                Locale locale4 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale4, (String)"getDefault(...)");
                String string5 = string2.toLowerCase(locale4);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                if (!Intrinsics.areEqual((Object)string, (Object)string5)) continue;
                ToggleViewsModule.this.currentViews.add(Views.BRAILLE);
            }
            Companion.saveSettings(ToggleViewsModule.this.currentViews);
            StyledText styledText = ToggleViewsModule.this.getStylePane();
            StyledText styledText2 = ToggleViewsModule.this.getPrintView();
            StyledText styledText3 = ToggleViewsModule.this.getBrailleView();
            ViewManager viewManager = ToggleViewsModule.this.m.getViewManager();
            Intrinsics.checkNotNullExpressionValue((Object)viewManager, (String)"getViewManager(...)");
            Companion.setViewOrder(styledText, styledText2, styledText3, viewManager);
            ToggleViewsModule.this.m.getViewManager().setTabList();
        }

        private final void moveUp(org.eclipse.swt.widgets.List list) {
            int selection = list.getSelectionIndex();
            if (selection > 0 && selection < ToggleViewsModule.this.currentViews.size()) {
                Views view = (Views)((Object)ToggleViewsModule.this.currentViews.get(selection));
                ToggleViewsModule.this.currentViews.remove(selection);
                ToggleViewsModule.this.currentViews.add(selection - 1, view);
                this.fillList(list);
                list.setSelection(selection - 1);
            }
        }

        private final void moveDown(org.eclipse.swt.widgets.List list) {
            int selection = list.getSelectionIndex();
            if (selection != ToggleViewsModule.this.currentViews.size() - 1 && selection < ToggleViewsModule.this.currentViews.size() && selection != -1) {
                Views view = (Views)((Object)ToggleViewsModule.this.currentViews.get(selection));
                ToggleViewsModule.this.currentViews.remove(selection);
                ToggleViewsModule.this.currentViews.add(selection + 1, view);
                this.fillList(list);
                list.setSelection(selection + 1);
            }
        }

        private static final void lambda$0$0(ChangeViewOrderDialog this$0, org.eclipse.swt.widgets.List $list, SelectionEvent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.moveUp($list);
        }

        private static final void lambda$0$1(ChangeViewOrderDialog this$0, org.eclipse.swt.widgets.List $list, SelectionEvent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.moveDown($list);
        }

        private static final void _init_$lambda$1(ChangeViewOrderDialog this$0, org.eclipse.swt.widgets.List $list, Shell $dialog, SelectionEvent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String[] stringArray = $list.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getItems(...)");
            this$0.saveNewList(stringArray);
            $dialog.close();
        }

        private static final void _init_$lambda$2(Shell $dialog, SelectionEvent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $dialog.close();
        }

        /*
         * WARNING - void declaration
         */
        private static final void fillList$lambda$0(org.eclipse.swt.widgets.List $list, Views v) {
            String string;
            Intrinsics.checkNotNullParameter((Object)((Object)v), (String)"v");
            org.eclipse.swt.widgets.List list = $list;
            String string2 = v.name();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            string2 = string3;
            if (((CharSequence)string2).length() > 0) {
                void it;
                char c = string2.charAt(0);
                StringBuilder stringBuilder = new StringBuilder();
                org.eclipse.swt.widgets.List list2 = list;
                boolean bl = false;
                CharSequence charSequence = CharsKt.titlecase((char)it);
                list = list2;
                StringBuilder stringBuilder2 = stringBuilder.append((Object)charSequence);
                String string4 = string2;
                int n = 1;
                String string5 = string4.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                string = stringBuilder2.append(string5).toString();
            } else {
                string = string2;
            }
            list.add(string);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u001bH\u0007J\u0014\u0010\u001c\u001a\u00020\u00132\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0016\u0010\u001e\u001a\u00020\u00132\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/ToggleViewsModule$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "ERROR_TITLE", "", "ERROR_MESSAGE", "TOGGLE_SUBMENU_TITLE", "REARRANGE", "USER_SETTING_KEY", "USER_SETTING_DELIMITER", "WINDOWIZE_TITLE", "DEFAULT_ORDER", "", "Lorg/brailleblaster/perspectives/mvc/modules/misc/ToggleViewsModule$Views;", "setViewOrder", "", "style", "Lorg/eclipse/swt/custom/StyledText;", "print", "braille", "viewManager", "Lorg/brailleblaster/perspectives/mvc/ViewManager;", "loadSettings", "", "saveSettings", "newViews", "checkList", "views", "brailleblaster-core"})
    @SourceDebugExtension(value={"SMAP\nToggleViewsModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToggleViewsModule.kt\norg/brailleblaster/perspectives/mvc/modules/misc/ToggleViewsModule$Companion\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,363:1\n106#2:364\n78#2,22:365\n742#3,9:387\n37#4,2:396\n1#5:398\n*S KotlinDebug\n*F\n+ 1 ToggleViewsModule.kt\norg/brailleblaster/perspectives/mvc/modules/misc/ToggleViewsModule$Companion\n*L\n335#1:364\n335#1:365,22\n339#1:387,9\n340#1:396,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void setViewOrder(@NotNull StyledText style, @NotNull StyledText print, @NotNull StyledText braille, @NotNull ViewManager viewManager) {
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            Intrinsics.checkNotNullParameter((Object)print, (String)"print");
            Intrinsics.checkNotNullParameter((Object)braille, (String)"braille");
            Intrinsics.checkNotNullParameter((Object)viewManager, (String)"viewManager");
            List<Views> viewOrder = this.loadSettings();
            this.checkList(viewOrder);
            ViewManager.Companion.removeWindowedView(viewOrder);
            Composite parent = switch (WhenMappings.$EnumSwitchMapping$0[viewOrder.get(0).ordinal()]) {
                case 1 -> {
                    style.moveAbove(null);
                    yield style.getParent();
                }
                case 2 -> {
                    print.moveAbove(null);
                    yield print.getParent();
                }
                case 3 -> {
                    braille.moveAbove(null);
                    yield braille.getParent();
                }
                default -> throw new NoWhenBranchMatchedException();
            };
            if (viewOrder.size() > 1) {
                switch (WhenMappings.$EnumSwitchMapping$0[viewOrder.get(viewOrder.size() - 1).ordinal()]) {
                    case 1: {
                        style.moveBelow(null);
                        break;
                    }
                    case 2: {
                        print.moveBelow(null);
                        break;
                    }
                    case 3: {
                        braille.moveBelow(null);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            viewManager.setViewSizes();
            parent.layout(true);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<Views> loadSettings() {
            void $this$toTypedArray$iv;
            List list;
            Collection $this$dropLastWhile$iv;
            int startIndex$iv$iv;
            Object $this$trim$iv$iv;
            String propValue;
            block12: {
                block11: {
                    propValue = BBIni.getPropertyFileManager().getProperty(ToggleViewsModule.USER_SETTING_KEY);
                    if (propValue == null) break block11;
                    String $this$trim$iv = propValue;
                    boolean $i$f$trim = false;
                    $this$trim$iv$iv = $this$trim$iv;
                    boolean $i$f$trim2 = false;
                    startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    if (!(((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() == 0)) break block12;
                }
                return CollectionsKt.toMutableList((Collection)DEFAULT_ORDER);
            }
            List returnList = new ArrayList();
            $this$trim$iv$iv = propValue;
            Regex $i$f$trim2 = new Regex(ToggleViewsModule.USER_SETTING_DELIMITER);
            startIndex$iv$iv = 0;
            $this$trim$iv$iv = $i$f$trim2.split((CharSequence)$this$trim$iv$iv, startIndex$iv$iv);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            for (String value : thisCollection$iv.toArray(new String[0])) {
                for (Views view : Views.getEntries()) {
                    if (!Intrinsics.areEqual((Object)view.name(), (Object)value)) continue;
                    returnList.add(view);
                }
            }
            return returnList;
        }

        public final void saveSettings(@NotNull List<? extends Views> newViews) {
            Intrinsics.checkNotNullParameter(newViews, (String)"newViews");
            this.checkList(newViews);
            StringBuilder sb = new StringBuilder();
            int n = ((Collection)newViews).size();
            for (int i = 0; i < n; ++i) {
                sb.append((Object)newViews.get(i));
                if (i == newViews.size() - 1) continue;
                sb.append(ToggleViewsModule.USER_SETTING_DELIMITER);
            }
            PropertyFileManager propertyFileManager = BBIni.getPropertyFileManager();
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            propertyFileManager.save(ToggleViewsModule.USER_SETTING_KEY, string);
        }

        private final void checkList(List<? extends Views> views) {
            if (!(!((Collection)views).isEmpty())) {
                boolean bl = false;
                String string = "There must be at least one view active";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Views.values().length];
                try {
                    nArray[Views.STYLE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Views.PRINT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Views.BRAILLE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/ToggleViewsModule$RearrangeViewsTool;", "Lorg/brailleblaster/tools/MenuTool;", "<init>", "(Lorg/brailleblaster/perspectives/mvc/modules/misc/ToggleViewsModule;)V", "topMenu", "Lorg/brailleblaster/perspectives/mvc/menu/TopMenu;", "getTopMenu", "()Lorg/brailleblaster/perspectives/mvc/menu/TopMenu;", "title", "", "getTitle", "()Ljava/lang/String;", "onRun", "", "bbData", "Lorg/brailleblaster/perspectives/mvc/menu/BBSelectionData;", "brailleblaster-core"})
    public final class RearrangeViewsTool
    implements MenuTool {
        @NotNull
        private final TopMenu topMenu = TopMenu.VIEW;
        @NotNull
        private final String title;

        public RearrangeViewsTool() {
            this.title = ToggleViewsModule.REARRANGE;
        }

        @Override
        @NotNull
        public TopMenu getTopMenu() {
            return this.topMenu;
        }

        @Override
        @NotNull
        public String getTitle() {
            return this.title;
        }

        @Override
        public void onRun(@NotNull BBSelectionData bbData) {
            Intrinsics.checkNotNullParameter((Object)bbData, (String)"bbData");
            new ChangeViewOrderDialog();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/ToggleViewsModule$Views;", "", "<init>", "(Ljava/lang/String;I)V", "PRINT", "BRAILLE", "STYLE", "brailleblaster-core"})
    public static final class Views
    extends Enum<Views> {
        public static final /* enum */ Views PRINT = new Views();
        public static final /* enum */ Views BRAILLE = new Views();
        public static final /* enum */ Views STYLE = new Views();
        private static final /* synthetic */ Views[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Views[] values() {
            return (Views[])$VALUES.clone();
        }

        public static Views valueOf(String value) {
            return Enum.valueOf(Views.class, value);
        }

        @NotNull
        public static EnumEntries<Views> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = viewsArray = new Views[]{Views.PRINT, Views.BRAILLE, Views.STYLE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Views.values().length];
            try {
                nArray[Views.BRAILLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Views.PRINT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Views.STYLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

