/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.mvc.modules.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.brailleblaster.BBIni;
import org.brailleblaster.Main;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.document.DocumentSnapshot;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.document.BrailleDocument;
import org.brailleblaster.perspectives.braille.eventQueue.EventFrame;
import org.brailleblaster.perspectives.braille.eventQueue.QueueManager;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.perspectives.mvc.SimpleEvent;
import org.brailleblaster.perspectives.mvc.events.BuildMenuEvent;
import org.brailleblaster.perspectives.mvc.events.ModifyEvent;
import org.brailleblaster.perspectives.mvc.events.ModularEvent;
import org.brailleblaster.perspectives.mvc.menu.BBSelectionData;
import org.brailleblaster.perspectives.mvc.menu.MenuManager;
import org.brailleblaster.perspectives.mvc.modules.misc.RedoTool;
import org.brailleblaster.perspectives.mvc.modules.misc.UndoTool;
import org.brailleblaster.utd.ActionMap;
import org.brailleblaster.utd.StyleMap;
import org.brailleblaster.utd.config.DocumentUTDConfig;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.util.Notify;
import org.brailleblaster.util.Utils;
import org.eclipse.swt.widgets.Display;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 *2\u00020\u0001:\u0002)*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0010\u0010\u0019\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0018J\b\u0010\u001b\u001a\u0004\u0018\u00010\u0018J\u0006\u0010\u001c\u001a\u00020\u0018J\u0018\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010 \u001a\u00020\u000f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0006\u0010!\u001a\u00020\u000fJ \u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u001f2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0002J\u0006\u0010(\u001a\u00020\u000fR\u0012\u0010\u0006\u001a\u00060\u0007R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/UndoRedoModule;", "Lorg/brailleblaster/perspectives/mvc/BBSimpleManager$SimpleListener;", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;)V", "undoRun", "Lorg/brailleblaster/perspectives/mvc/modules/misc/UndoRedoModule$AddToUndoQueueRunnable;", "takeSnapshotLock", "Ljava/util/concurrent/CountDownLatch;", "queueManager", "Lorg/brailleblaster/perspectives/braille/eventQueue/QueueManager;", "lastDoc", "Lorg/brailleblaster/document/DocumentSnapshot;", "onEvent", "", "event", "Lorg/brailleblaster/perspectives/mvc/SimpleEvent;", "redo", "bbData", "Lorg/brailleblaster/perspectives/mvc/menu/BBSelectionData;", "undo", "addUndoEvent", "frame", "Lorg/brailleblaster/perspectives/braille/eventQueue/EventFrame;", "addRedoEvent", "peekUndoEvent", "peekRedoEvent", "popUndoEvent", "copyDocumentNoBraille", "doc", "Lnu/xom/Document;", "copyDocument", "waitForUndoThread", "getParent", "Lnu/xom/Element;", "documentSnapshot", "indexes", "", "", "closeUndoThread", "AddToUndoQueueRunnable", "Companion", "brailleblaster-core"})
public final class UndoRedoModule
implements BBSimpleManager.SimpleListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AddToUndoQueueRunnable undoRun;
    @Nullable
    private CountDownLatch takeSnapshotLock;
    @NotNull
    private final QueueManager queueManager;
    @Nullable
    private DocumentSnapshot lastDoc;
    private static final Logger log = LoggerFactory.getLogger(UndoRedoModule.class);

    public UndoRedoModule(@NotNull Manager m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        this.queueManager = new QueueManager();
        this.undoRun = new AddToUndoQueueRunnable();
        Thread newThread = new Thread(this.undoRun);
        newThread.setName("undo-" + m.instanceId);
        newThread.setDaemon(true);
        newThread.start();
    }

    @Override
    public void onEvent(@NotNull SimpleEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof BuildMenuEvent) {
            MenuManager.INSTANCE.add(new UndoTool(this));
            MenuManager.INSTANCE.add(new RedoTool(this));
        } else if (event instanceof ModifyEvent) {
            if (ModifyEvent.Companion.canUndo()) {
                Document copyDoc = null;
                try {
                    copyDoc = event.getManager().getManager().getLastCopiedDoc();
                    if (copyDoc == null) {
                        return;
                    }
                }
                catch (NullPointerException e) {
                    log.error("Potential reformatter thread race, see Issue #5259", (Throwable)e);
                    return;
                }
                this.undoRun.addToQueue((ModifyEvent)event, copyDoc);
            } else {
                ModifyEvent.Companion.resetUndoable();
            }
        }
    }

    public final void redo(@NotNull BBSelectionData bbData) {
        Intrinsics.checkNotNullParameter((Object)bbData, (String)"bbData");
        bbData.getManager().stopFormatting();
        this.waitForUndoThread();
        this.queueManager.redo(bbData.getManager());
    }

    public final void undo(@NotNull BBSelectionData bbData) {
        Intrinsics.checkNotNullParameter((Object)bbData, (String)"bbData");
        bbData.getManager().stopFormatting();
        this.waitForUndoThread();
        this.queueManager.undo(bbData.getManager());
    }

    public final void addUndoEvent(@Nullable EventFrame frame) {
        EventFrame eventFrame = frame;
        Intrinsics.checkNotNull((Object)eventFrame);
        this.queueManager.addUndoEvent(eventFrame);
    }

    public final void addRedoEvent(@Nullable EventFrame frame) {
        EventFrame eventFrame = frame;
        Intrinsics.checkNotNull((Object)eventFrame);
        this.queueManager.addRedoEvent(eventFrame);
    }

    @Nullable
    public final EventFrame peekUndoEvent() {
        return this.queueManager.peekUndoEvent();
    }

    @Nullable
    public final EventFrame peekRedoEvent() {
        return this.queueManager.peekRedoEvent();
    }

    @NotNull
    public final EventFrame popUndoEvent() {
        return this.queueManager.popUndoEvent();
    }

    private final void copyDocumentNoBraille(Document doc, Manager m) {
        BrailleDocument brailleDocument = m.getDocument();
        Element element = doc.getRootElement();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getRootElement(...)");
        brailleDocument.removeAllBraille(element);
        this.lastDoc = new DocumentSnapshot(doc);
    }

    public final void copyDocument(@Nullable Document doc) {
        Document document = doc;
        Intrinsics.checkNotNull((Object)document);
        this.lastDoc = new DocumentSnapshot(document);
    }

    public final void waitForUndoThread() {
        if (this.takeSnapshotLock != null) {
            try {
                CountDownLatch countDownLatch = this.takeSnapshotLock;
                Intrinsics.checkNotNull((Object)countDownLatch);
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private final Element getParent(Document documentSnapshot, List<Integer> indexes) {
        Element element;
        if (!((Collection)indexes).isEmpty()) {
            Node node = documentSnapshot.getChild(((Number)indexes.get(0)).intValue());
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            element = (Element)node;
        } else {
            element = null;
        }
        Element e = element;
        int n = indexes.size();
        for (int i = 1; i < n; ++i) {
            int n2 = ((Number)indexes.get(i)).intValue();
            Element element2 = e;
            Intrinsics.checkNotNull((Object)element2);
            if (n2 >= element2.getChildCount()) {
                throw new IndexOutOfBoundsException("Element has no child at index " + indexes.get(i));
            }
            Node node = e.getChild(((Number)indexes.get(i)).intValue());
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            e = (Element)node;
        }
        return e;
    }

    public final void closeUndoThread() {
        this.undoRun.close();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0001/B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u0019H\u0016J\u0006\u0010\n\u001a\u00020\u0019J(\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\"\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0002J\u001c\u0010&\u001a\u00020\u000b2\b\u0010'\u001a\u0004\u0018\u00010(2\b\u0010)\u001a\u0004\u0018\u00010(H\u0002J\u0018\u0010*\u001a\b\u0012\u0004\u0012\u00020\"0+2\b\u0010)\u001a\u0004\u0018\u00010(H\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020(H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR(\u0010\u0010\u001a\u0010\u0012\f\u0012\n0\u0012R\u00060\u0000R\u00020\u00130\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u00060"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/UndoRedoModule$AddToUndoQueueRunnable;", "Ljava/lang/Runnable;", "<init>", "(Lorg/brailleblaster/perspectives/mvc/modules/misc/UndoRedoModule;)V", "waitForWork", "Ljava/util/concurrent/CountDownLatch;", "getWaitForWork", "()Ljava/util/concurrent/CountDownLatch;", "setWaitForWork", "(Ljava/util/concurrent/CountDownLatch;)V", "close", "", "getClose", "()Z", "setClose", "(Z)V", "queue", "Ljava/util/LinkedList;", "Lorg/brailleblaster/perspectives/mvc/modules/misc/UndoRedoModule$AddToUndoQueueRunnable$UndoState;", "Lorg/brailleblaster/perspectives/mvc/modules/misc/UndoRedoModule;", "getQueue", "()Ljava/util/LinkedList;", "setQueue", "(Ljava/util/LinkedList;)V", "addToQueue", "", "ev", "Lorg/brailleblaster/perspectives/mvc/events/ModifyEvent;", "doc", "Lnu/xom/Document;", "run", "addToUndoQueue", "event", "sectionIndex", "", "textOffset", "createEventFrame", "Lorg/brailleblaster/perspectives/braille/eventQueue/EventFrame;", "isDescendedFrom", "child", "Lnu/xom/Node;", "parent", "makeIndexes", "Ljava/util/ArrayList;", "getSection", "Lnu/xom/Element;", "n", "UndoState", "brailleblaster-core"})
    private final class AddToUndoQueueRunnable
    implements Runnable {
        @NotNull
        private CountDownLatch waitForWork = new CountDownLatch(1);
        private volatile boolean close = false;
        @NotNull
        private LinkedList<UndoState> queue = new LinkedList();

        @NotNull
        public final CountDownLatch getWaitForWork() {
            return this.waitForWork;
        }

        public final void setWaitForWork(@NotNull CountDownLatch countDownLatch) {
            Intrinsics.checkNotNullParameter((Object)countDownLatch, (String)"<set-?>");
            this.waitForWork = countDownLatch;
        }

        public final boolean getClose() {
            return this.close;
        }

        public final void setClose(boolean bl) {
            this.close = bl;
        }

        @NotNull
        public final LinkedList<UndoState> getQueue() {
            return this.queue;
        }

        public final void setQueue(@NotNull LinkedList<UndoState> linkedList) {
            Intrinsics.checkNotNullParameter(linkedList, (String)"<set-?>");
            this.queue = linkedList;
        }

        public final void addToQueue(@NotNull ModifyEvent ev, @NotNull Document doc) {
            Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
            Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
            int sectionIndex = ev.isQueueEvent() ? ev.sectionIndex : ev.getManager().getManager().getViewInitializer().getStartIndex();
            int textOffset = ev.isQueueEvent() ? ev.textOffset : ev.getManager().getManager().getText().getView().getCaretOffset();
            this.queue.add(new UndoState(ev, doc, sectionIndex, textOffset));
            this.waitForWork.countDown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block8: while (true) {
                try {
                    boolean doneWaiting = false;
                    while (!doneWaiting) {
                        doneWaiting = this.waitForWork.await(10L, TimeUnit.SECONDS);
                        if (!this.close) continue;
                        return;
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                this.waitForWork = new CountDownLatch(1);
                UndoRedoModule.this.takeSnapshotLock = new CountDownLatch(1);
                try {
                    if (this.close) {
                        return;
                    }
                    while (true) {
                        if (this.queue.isEmpty()) continue block8;
                        UndoState curState = this.queue.pop();
                        this.addToUndoQueue(curState.getEv(), curState.getSectionIndex(), curState.getTextOffset(), curState.getDoc());
                    }
                }
                catch (Exception e) {
                    if (BBIni.getDebugging()) {
                        Main.handleFatalException(e);
                        continue;
                    }
                    Display.getDefault().asyncExec(() -> AddToUndoQueueRunnable.run$lambda$0(e));
                    continue;
                }
                finally {
                    CountDownLatch countDownLatch = UndoRedoModule.this.takeSnapshotLock;
                    Intrinsics.checkNotNull((Object)countDownLatch);
                    countDownLatch.countDown();
                    continue;
                }
                break;
            }
        }

        public final void close() {
            this.close = true;
        }

        private final void addToUndoQueue(ModifyEvent event, int sectionIndex, int textOffset, Document doc) {
            boolean isUndoEvent;
            EventFrame newEventFrame = this.createEventFrame(event, sectionIndex, textOffset);
            boolean bl = isUndoEvent = event.getSender() == Sender.UNDO_QUEUE;
            if (newEventFrame != null) {
                if (isUndoEvent) {
                    UndoRedoModule.this.addRedoEvent(newEventFrame);
                } else {
                    UndoRedoModule.this.addUndoEvent(newEventFrame);
                }
                if (event.getManager().getManager().isEmptyDocument()) {
                    UndoRedoModule.this.copyDocumentNoBraille(doc, event.getManager().getManager());
                } else {
                    UndoRedoModule.this.copyDocument(doc);
                }
            }
        }

        private final EventFrame createEventFrame(ModifyEvent ev, int sectionIndex, int textOffset) {
            int i;
            int n;
            if (ev.changedNodes.isEmpty()) {
                log.error("Could not add event to undo");
                return null;
            }
            long startTime = System.currentTimeMillis();
            EventFrame event = new EventFrame();
            ArrayList<Element> sections = new ArrayList<Element>();
            ArrayList<ArrayList<Integer>> indexes = new ArrayList<ArrayList<Integer>>();
            block0: for (Node n2 : ev.changedNodes) {
                Element parent;
                if (n2.getDocument() == null || sections.contains(parent = this.getSection(n2))) continue;
                n = ((Collection)sections).size();
                for (i = 0; i < n; ++i) {
                    if (this.isDescendedFrom((Node)parent, (Node)sections.get(i))) continue block0;
                    if (!this.isDescendedFrom((Node)sections.get(i), (Node)parent)) continue;
                    sections.remove(i);
                }
                sections.add(parent);
                indexes.add(this.makeIndexes((Node)parent));
            }
            DocumentSnapshot documentSnapshot = UndoRedoModule.this.lastDoc;
            Intrinsics.checkNotNull((Object)documentSnapshot);
            Document documentSnapshot2 = documentSnapshot.getSnapshot();
            Element actionMap2 = DocumentUTDConfig.NIMAS.getConfigElement(documentSnapshot2, ActionMap.class);
            Element styleMap2 = DocumentUTDConfig.NIMAS.getConfigElement(documentSnapshot2, StyleMap.class);
            n = ((Collection)sections).size();
            for (i = 0; i < n; ++i) {
                Object e = indexes.get(i);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                Element element = UndoRedoModule.this.getParent(documentSnapshot2, (List)e);
                Intrinsics.checkNotNull((Object)element);
                Object e2 = indexes.get(i);
                Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
                event.addEvent(new ModularEvent(element, actionMap2, styleMap2, (List)e2, sectionIndex, textOffset));
            }
            log.trace("Took document snapshot in " + Utils.runtimeToString(startTime));
            return event;
        }

        private final boolean isDescendedFrom(Node child, Node parent) {
            for (Node child2 = child; child2 != null; child2 = (Node)child2.getParent()) {
                if (child2 != parent) continue;
                return true;
            }
            return false;
        }

        private final ArrayList<Integer> makeIndexes(Node parent) {
            Node parent2 = parent;
            ArrayList<Integer> list = new ArrayList<Integer>();
            Node node = parent2;
            Intrinsics.checkNotNull((Object)node);
            ParentNode p = node.getParent();
            do {
                ParentNode parentNode = p;
                Intrinsics.checkNotNull((Object)parentNode);
                list.add(0, parentNode.indexOf(parent2));
                parent2 = (Node)p;
            } while ((p = p.getParent()) != null);
            return list;
        }

        private final Element getSection(Node n) {
            if (n.getDocument() == null) {
                throw new RuntimeException("node not attached to document " + n.toXML());
            }
            if (n instanceof Document || n.getDocument().getRootElement() == n) {
                return ((ParentNode)n).getDocument().getRootElement();
            }
            if (n instanceof Element && BBX.SECTION.isA(n)) {
                return (Element)n;
            }
            Node section = XMLHandler.Companion.ancestorVisitor(n, AddToUndoQueueRunnable::getSection$lambda$0);
            if (section == null) {
                section = (Node)n.getDocument().getRootElement();
            }
            return (Element)section;
        }

        private static final void run$lambda$0(Exception $e) {
            Notify.INSTANCE.showException($e);
        }

        private static final boolean getSection$lambda$0(Node parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            if (BBX.SECTION.isA(parent)) {
                ParentNode sectionParent = parent.getParent();
                int n = sectionParent.getChildCount();
                for (int i = 0; i < n; ++i) {
                    if (!BBX.CONTAINER.isA(sectionParent.getChild(i)) && !BBX.BLOCK.isA(sectionParent.getChild(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\b\u0082\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0014\"\u0004\b\u0018\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/UndoRedoModule$AddToUndoQueueRunnable$UndoState;", "", "ev", "Lorg/brailleblaster/perspectives/mvc/events/ModifyEvent;", "doc", "Lnu/xom/Document;", "sectionIndex", "", "textOffset", "<init>", "(Lorg/brailleblaster/perspectives/mvc/modules/misc/UndoRedoModule$AddToUndoQueueRunnable;Lorg/brailleblaster/perspectives/mvc/events/ModifyEvent;Lnu/xom/Document;II)V", "getEv", "()Lorg/brailleblaster/perspectives/mvc/events/ModifyEvent;", "setEv", "(Lorg/brailleblaster/perspectives/mvc/events/ModifyEvent;)V", "getDoc", "()Lnu/xom/Document;", "setDoc", "(Lnu/xom/Document;)V", "getSectionIndex", "()I", "setSectionIndex", "(I)V", "getTextOffset", "setTextOffset", "brailleblaster-core"})
        private final class UndoState {
            @NotNull
            private ModifyEvent ev;
            @NotNull
            private Document doc;
            private int sectionIndex;
            private int textOffset;

            public UndoState(@NotNull ModifyEvent ev, Document doc, int sectionIndex, int textOffset) {
                Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
                Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
                this.ev = ev;
                this.doc = doc;
                this.sectionIndex = sectionIndex;
                this.textOffset = textOffset;
            }

            @NotNull
            public final ModifyEvent getEv() {
                return this.ev;
            }

            public final void setEv(@NotNull ModifyEvent modifyEvent) {
                Intrinsics.checkNotNullParameter((Object)modifyEvent, (String)"<set-?>");
                this.ev = modifyEvent;
            }

            @NotNull
            public final Document getDoc() {
                return this.doc;
            }

            public final void setDoc(@NotNull Document document) {
                Intrinsics.checkNotNullParameter((Object)document, (String)"<set-?>");
                this.doc = document;
            }

            public final int getSectionIndex() {
                return this.sectionIndex;
            }

            public final void setSectionIndex(int n) {
                this.sectionIndex = n;
            }

            public final int getTextOffset() {
                return this.textOffset;
            }

            public final void setTextOffset(int n) {
                this.textOffset = n;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/UndoRedoModule$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

