/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.mvc.modules.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.BBXUtilsKt;
import org.brailleblaster.exceptions.BBNotifyException;
import org.brailleblaster.frontmatter.VolumeUtils;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.WhiteSpaceElement;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.perspectives.mvc.SimpleEvent;
import org.brailleblaster.perspectives.mvc.events.BuildMenuEvent;
import org.brailleblaster.perspectives.mvc.events.ModifyEvent;
import org.brailleblaster.perspectives.mvc.menu.BBSelectionData;
import org.brailleblaster.perspectives.mvc.menu.MenuManager;
import org.brailleblaster.perspectives.mvc.menu.SubMenuBuilder;
import org.brailleblaster.perspectives.mvc.menu.TopMenu;
import org.brailleblaster.perspectives.mvc.modules.views.DebugModule;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.util.Notify;
import org.brailleblaster.util.WorkingDialog;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/VolumeInsertModule;", "Lorg/brailleblaster/perspectives/mvc/BBSimpleManager$SimpleListener;", "<init>", "()V", "onEvent", "", "event", "Lorg/brailleblaster/perspectives/mvc/SimpleEvent;", "Companion", "brailleblaster-core"})
public final class VolumeInsertModule
implements BBSimpleManager.SimpleListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final LocaleHandler localeHandler = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null);
    @JvmField
    @NotNull
    public static final TopMenu MENU_VOLUME_MANAGER_TOP = TopMenu.DEBUG;
    @NotNull
    public static final String MENU_VOLUME_MANAGER_NAME = "Volume Manager";
    @NotNull
    public static final String MENU_INSERT_VOLUME = "Insert";
    @NotNull
    private static final List<Element> pageNumbers = new ArrayList();

    @Override
    public void onEvent(@NotNull SimpleEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof BuildMenuEvent && DebugModule.enabled) {
            SubMenuBuilder volumeManagerMenu = new SubMenuBuilder(MENU_VOLUME_MANAGER_TOP, MENU_VOLUME_MANAGER_NAME);
            SubMenuBuilder subMenuBuilder = new SubMenuBuilder(volumeManagerMenu, MENU_INSERT_VOLUME);
            String string = BBX.VolumeType.VOLUME.volumeMenuName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"volumeMenuName");
            SubMenuBuilder subMenuBuilder2 = SubMenuBuilder.addItem$default(subMenuBuilder, string, 0, 0, null, VolumeInsertModule::onEvent$lambda$0, 12, null);
            String string2 = BBX.VolumeType.VOLUME_PRELIMINARY.volumeMenuName;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"volumeMenuName");
            SubMenuBuilder subMenuBuilder3 = SubMenuBuilder.addItem$default(subMenuBuilder2, string2, 0, 0, null, VolumeInsertModule::onEvent$lambda$1, 12, null);
            String string3 = BBX.VolumeType.VOLUME_SUPPLEMENTAL.volumeMenuName;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"volumeMenuName");
            volumeManagerMenu.addSubMenu(SubMenuBuilder.addItem$default(subMenuBuilder3, string3, 0, 0, null, VolumeInsertModule::onEvent$lambda$2, 12, null).build());
            MenuManager.INSTANCE.add(volumeManagerMenu.build());
        }
    }

    private static final void onEvent$lambda$0(BBSelectionData e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VolumeInsertModule.Companion.insertVolume(BBX.VolumeType.VOLUME, e.getManager());
    }

    private static final void onEvent$lambda$1(BBSelectionData e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VolumeInsertModule.Companion.insertVolume(BBX.VolumeType.VOLUME_PRELIMINARY, e.getManager());
    }

    private static final void onEvent$lambda$2(BBSelectionData e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VolumeInsertModule.Companion.insertVolume(BBX.VolumeType.VOLUME_SUPPLEMENTAL, e.getManager());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u0019J\u001a\u0010\u001a\u001a\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/VolumeInsertModule$Companion;", "", "<init>", "()V", "localeHandler", "Lorg/brailleblaster/utils/localization/LocaleHandler;", "MENU_VOLUME_MANAGER_TOP", "Lorg/brailleblaster/perspectives/mvc/menu/TopMenu;", "MENU_VOLUME_MANAGER_NAME", "", "MENU_INSERT_VOLUME", "pageNumbers", "", "Lnu/xom/Element;", "getPageNumbers", "()Ljava/util/List;", "insertVolume", "", "volumeType", "Lorg/brailleblaster/bbx/BBX$VolumeType;", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "insertVolumeBeforeElement", "type", "caret", "Lnu/xom/Node;", "insertLastVolume", "doc", "Lnu/xom/Document;", "brailleblaster-core"})
    @SourceDebugExtension(value={"SMAP\nVolumeInsertModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VolumeInsertModule.kt\norg/brailleblaster/perspectives/mvc/modules/misc/VolumeInsertModule$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n812#2,12:200\n296#2,2:212\n1#3:214\n*S KotlinDebug\n*F\n+ 1 VolumeInsertModule.kt\norg/brailleblaster/perspectives/mvc/modules/misc/VolumeInsertModule$Companion\n*L\n164#1:200,12\n164#1:212,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Element> getPageNumbers() {
            return pageNumbers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void insertVolume(BBX.VolumeType volumeType, Manager m) {
            if (!m.isEmptyDocument()) {
                TextMapElement firstTme = m.getSectionList().get((int)0).list.getFirstUsable();
                Object object = CollectionsKt.last((List)m.getSectionList().get((int)m.getLastSection()).list);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"last(...)");
                TextMapElement lastTme = (TextMapElement)object;
                Node node = firstTme.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
                ParentNode firstTmeParent = (ParentNode)BBXUtilsKt.findBlock(node);
                TextMapElement currentTme = null;
                TextMapElement textMapElement = m.getMapList().getCurrent();
                Intrinsics.checkNotNullExpressionValue((Object)textMapElement, (String)"getCurrent(...)");
                currentTme = textMapElement;
                if (lastTme.getEnd(m.getMapList()) > currentTme.getStart(m.getMapList())) {
                    if (currentTme instanceof WhiteSpaceElement) {
                        TextMapElement textMapElement2 = m.getMapList().getNext(true);
                        Intrinsics.checkNotNullExpressionValue((Object)textMapElement2, (String)"getNext(...)");
                        currentTme = textMapElement2;
                    }
                    Node node2 = currentTme.getNode();
                    Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"getNode(...)");
                    if (!Intrinsics.areEqual((Object)firstTmeParent, (Object)BBXUtilsKt.findBlock(node2))) {
                        AutoCloseable autoCloseable = new WorkingDialog("Inserting new volume");
                        Throwable throwable = null;
                        try {
                            WorkingDialog dialog = (WorkingDialog)autoCloseable;
                            boolean bl = false;
                            m.stopFormatting();
                            Node node3 = currentTme.getNode();
                            Intrinsics.checkNotNullExpressionValue((Object)node3, (String)"getNode(...)");
                            Element insertedVolume = Companion.insertVolumeBeforeElement(volumeType, node3);
                            List volumes = new ArrayList(VolumeUtils.getVolumeElementsFatal(m.getDoc()));
                            if (volumes.size() == 1) {
                                Element lastVolume = Companion.insertLastVolume(volumeType, m.getDoc());
                                volumes.add(lastVolume);
                            }
                            VolumeUtils.updateEndOfVolume(m.getDoc());
                            if (volumes.size() != 2 && Intrinsics.areEqual((Object)insertedVolume, volumes.get(volumes.size() - 2))) {
                                List<VolumeUtils.VolumeData> volumeData = VolumeUtils.INSTANCE.getVolumeNames(volumes);
                                VolumeUtils.VolumeData lastData = (VolumeUtils.VolumeData)CollectionsKt.last(volumeData);
                                VolumeUtils.VolumeData prevData = volumeData.get(volumeData.size() - 2);
                                if (lastData.type == BBX.VolumeType.VOLUME_PRELIMINARY && (prevData.type == BBX.VolumeType.VOLUME || prevData.type == BBX.VolumeType.VOLUME_SUPPLEMENTAL) || lastData.type == BBX.VolumeType.VOLUME && prevData.type == BBX.VolumeType.VOLUME_SUPPLEMENTAL) {
                                    BBX.CONTAINER.VOLUME.ATTRIB_TYPE.set(lastData.element, prevData.type);
                                }
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                        }
                        ArrayList toUpdate = new ArrayList(VolumeUtils.getVolumeElementsFatal(m.getDoc()));
                        toUpdate.addAll(this.getPageNumbers());
                        m.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.NO_SENDER, toUpdate, true));
                    } else {
                        Notify.showMessage("Volumes must be added at the end of the volume, not the beginning.", new Object[0]);
                    }
                } else {
                    Notify.showMessage("Cannot add volume at end of file.", new Object[0]);
                }
            } else {
                m.notify(localeHandler.get("emptyDocMenuWarning"));
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Element insertVolumeBeforeElement(@Nullable BBX.VolumeType type, @NotNull Node caret) {
            Object v2;
            Element stopTag;
            block5: {
                void $this$firstOrNull$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
                Element element = XMLHandler.Companion.nodeToElementOrParentOrDocRoot(caret);
                Intrinsics.checkNotNull((Object)element);
                stopTag = element;
                if (XMLHandler.Companion.ancestorVisitorElement((Node)stopTag, Companion::insertVolumeBeforeElement$lambda$0) != null) {
                    throw new BBNotifyException("Cannot insert volume inside another volume division");
                }
                Element element2 = XMLHandler.Companion.ancestorVisitorElement((Node)stopTag, Companion::insertVolumeBeforeElement$lambda$1);
                Intrinsics.checkNotNull((Object)element2);
                stopTag = element2;
                Iterable iterable = FastXPath.INSTANCE.preceding((Node)stopTag);
                boolean $i$f$filterIsInstance = false;
                Iterator iterator = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof Element)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Element node = (Element)element$iv;
                    boolean bl = false;
                    if (!BBX.BLOCK.isA((Node)node)) continue;
                    v2 = element$iv;
                    break block5;
                }
                v2 = null;
            }
            Element previous = v2;
            if (previous != null && BBXUtilsKt.isPageNum((Node)previous)) {
                this.getPageNumbers().add(previous);
                stopTag = previous;
            }
            if (previous != null && XMLHandler.Companion.ancestorElementIs((Node)previous, Companion::insertVolumeBeforeElement$lambda$3)) {
                Element element = XMLHandler.Companion.ancestorVisitorElement((Node)previous, Companion::insertVolumeBeforeElement$lambda$4);
                Intrinsics.checkNotNull((Object)element);
                stopTag = element;
            }
            Element newVolumeElement = VolumeUtils.newVolumeElement(type);
            ParentNode parentNode = stopTag.getParent();
            Intrinsics.checkNotNull((Object)parentNode);
            ParentNode stopTagParent = parentNode;
            stopTagParent.insertChild((Node)newVolumeElement, stopTagParent.indexOf((Node)stopTag));
            return newVolumeElement;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Element insertLastVolume(@Nullable BBX.VolumeType type, @Nullable Document doc) {
            Element root = null;
            Document document = doc;
            Intrinsics.checkNotNull((Object)document);
            Element element = BBX.getRoot(document);
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getRoot(...)");
            root = element;
            Companion $this$insertLastVolume_u24lambda_u240 = this;
            boolean bl = false;
            Object curElem = null;
            while (true) {
                void it;
                Node node;
                Node node2 = node = root.getChild(root.getChildCount() - 1);
                BBX.SectionElement sectionElement = BBX.SECTION;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                curElem = it;
                if (!sectionElement.isA(node)) break;
                root = curElem;
            }
            Element newVolumeElement = VolumeUtils.newVolumeElement(type);
            root.appendChild((Node)newVolumeElement);
            return newVolumeElement;
        }

        private static final boolean insertVolumeBeforeElement$lambda$0(Element node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return BBX.CONTAINER.VOLUME.isA((Node)node);
        }

        private static final boolean insertVolumeBeforeElement$lambda$1(Element curAncestor) {
            Intrinsics.checkNotNullParameter((Object)curAncestor, (String)"curAncestor");
            return BBX.BLOCK.isA((Node)curAncestor) || BBX.CONTAINER.isA((Node)curAncestor);
        }

        private static final boolean insertVolumeBeforeElement$lambda$3(Element node) {
            return BBX.CONTAINER.TABLETN.isA((Node)node);
        }

        private static final boolean insertVolumeBeforeElement$lambda$4(Element node) {
            return BBX.CONTAINER.TABLETN.isA((Node)node);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

