/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.mvc.modules.views;

import com.google.common.base.Suppliers;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.maps.MapList;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.braille.views.wp.TextView;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.perspectives.mvc.SimpleEvent;
import org.brailleblaster.perspectives.mvc.XMLNodeCaret;
import org.brailleblaster.perspectives.mvc.XMLTextCaret;
import org.brailleblaster.perspectives.mvc.events.ModifyEvent;
import org.brailleblaster.perspectives.mvc.events.XMLCaretEvent;
import org.brailleblaster.perspectives.mvc.modules.views.AbstractModule;
import org.brailleblaster.utd.exceptions.NodeException;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.eclipse.swt.custom.StyledText;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J2\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00130\u0010H\u0002J2\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00130\u0010H\u0002J \u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/views/TextViewModule;", "Lorg/brailleblaster/perspectives/mvc/modules/views/AbstractModule;", "Lorg/brailleblaster/perspectives/mvc/BBSimpleManager$SimpleListener;", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;)V", "onEvent", "", "event", "Lorg/brailleblaster/perspectives/mvc/SimpleEvent;", "getTMEFirst", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "node", "Lnu/xom/Node;", "tableParent", "Ljava/util/function/Supplier;", "Lnu/xom/Element;", "descendants", "", "getTMELast", "getTMEPreFilter", "inputNode", "getTMEOfTextNode", "text", "Lnu/xom/Text;", "getTMEOfElement", "element", "currentElementOnScreen", "", "view", "Lorg/eclipse/swt/custom/StyledText;", "pos", "", "Companion", "brailleblaster-core"})
public final class TextViewModule
extends AbstractModule
implements BBSimpleManager.SimpleListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Manager manager;
    private static final Logger log = LoggerFactory.getLogger(TextViewModule.class);

    public TextViewModule(@NotNull Manager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.manager = manager;
        this.sender = Sender.TEXT;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onEvent(@NotNull SimpleEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof ModifyEvent) {
            this.manager.getText().resetSelectionObject();
            return;
        }
        if (!(event instanceof XMLCaretEvent)) return;
        if (!((XMLCaretEvent)event).isSingleNode()) {
            TextView tv = event.getManager().getManager().getText();
            int actualStart = tv.getCurrentStart();
            int actualEnd = tv.getCurrentEnd();
            log.trace("Actually selecting {}-{}", (Object)actualStart, (Object)actualEnd);
            this.manager.getTextView().setSelection(actualStart, actualEnd);
            this.manager.getText().setListenerLock(false);
            return;
        }
        if (((XMLCaretEvent)event).start instanceof XMLTextCaret) {
            XMLNodeCaret caret = ((XMLCaretEvent)event).start;
            TextMapElement tme = this.getTMEOfTextNode(((XMLTextCaret)caret).getNode());
            this.manager.checkView(tme);
            if (!tme.isFullyVisible()) {
                boolean atEnd = tme.getStart(this.manager.getMapList()) > 0;
                int section = this.manager.getSection(tme);
                if (atEnd && this.manager.getSectionList().size() > section + 1) {
                    this.manager.buffer(section + 1);
                } else if (section > 0) {
                    this.manager.buffer(section - 1);
                }
            }
            this.manager.getMapList().setCurrent(this.manager.getMapList().indexOf(tme));
            if (event.getSender() == Sender.TEXT) return;
            this.manager.getText().setPositionFromStart(0);
            this.manager.getText().cursorOffset = 0;
            log.debug("positionFromStart " + this.manager.getText().getPositionFromStart() + " cursorOfset" + this.manager.getText().cursorOffset + " viewOffset " + this.manager.getTextView().getCaretOffset());
            this.manager.getText().updateCursor(((XMLTextCaret)caret).getOffset());
            StyledText styledText = this.manager.getTextView();
            Intrinsics.checkNotNullExpressionValue((Object)styledText, (String)"getTextView(...)");
            if (this.currentElementOnScreen(styledText, this.manager.getTextView().getCaretOffset())) return;
            this.manager.getTextView().setTopIndex(this.manager.getTextView().getLineAtOffset(this.manager.getTextView().getCaretOffset()));
            return;
        }
        Node node = ((XMLCaretEvent)event).start.getNode();
        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element node2 = (Element)node;
        Supplier<Element> tableParent = () -> TextViewModule.onEvent$lambda$0(node2);
        Supplier<List<Node>> descendants = () -> TextViewModule.onEvent$lambda$1(node2);
        TextMapElement tmeStart = this.getTMEFirst((Node)node2, tableParent, descendants);
        this.manager.checkView(tmeStart);
        int tmeStartIndex = this.manager.getMapList().indexOf(tmeStart);
        TextMapElement tmeEnd = this.getTMELast((Node)node2, tableParent, descendants);
        int tmeEndIndex = this.manager.getMapList().indexOf(tmeEnd);
        Object e = this.manager.getMapList().get(tmeStartIndex);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        tmeStart = (TextMapElement)e;
        Object e2 = this.manager.getMapList().get(tmeEndIndex);
        Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
        tmeEnd = (TextMapElement)e2;
        this.manager.getText().setListenerLock(true);
        Object[] objectArray = new Object[]{tmeStartIndex, tmeStart, tmeEndIndex, tmeEnd};
        log.trace("tmeStart {} {} tmeEnd {} {}", objectArray);
        objectArray = new Object[]{tmeStart.getNode(), tmeStart.getStart(this.manager.getMapList()), tmeStart.getEnd(this.manager.getMapList()), tmeEnd.getNode(), tmeEnd.getStart(this.manager.getMapList()), tmeEnd.getEnd(this.manager.getMapList())};
        log.trace("Set selection from tme node {} start {} end {} to tme node {} start {} end {}", objectArray);
        int actualStart = tmeStart.getStart(this.manager.getMapList());
        int actualEnd = tmeEnd.getEnd(this.manager.getMapList());
        log.trace("Actually selecting {}-{}", (Object)actualStart, (Object)actualEnd);
        if (event.getSender() == Sender.BREADCRUMBS || event.getSender() == Sender.IMAGE_DESCRIBER) {
            if (actualStart == -1) {
                actualStart = 0;
            }
            if (actualEnd == -1) {
                actualEnd = this.manager.getTextView().getCharCount() - actualStart;
            }
            this.manager.getText().setCurrentSelection(actualStart, actualEnd);
        } else {
            this.manager.getTextView().setCaretOffset(actualStart);
            StyledText styledText = this.manager.getTextView();
            Intrinsics.checkNotNullExpressionValue((Object)styledText, (String)"getTextView(...)");
            if (!this.currentElementOnScreen(styledText, this.manager.getTextView().getCaretOffset())) {
                this.manager.getTextView().setTopIndex(this.manager.getTextView().getLineAtOffset(this.manager.getTextView().getCaretOffset()));
            }
        }
        this.manager.getText().setListenerLock(false);
    }

    private final TextMapElement getTMEFirst(Node node, Supplier<Element> tableParent, Supplier<List<Node>> descendants) {
        TextMapElement preFilter = this.getTMEPreFilter(node, tableParent);
        if (preFilter != null) {
            return preFilter;
        }
        for (Node curDescendant : descendants.get()) {
            if (XMLHandler.Companion.ancestorElementIs(curDescendant, TextViewModule::getTMEFirst$lambda$0)) continue;
            int currentSection = this.manager.getSection(this.manager.getMapList().getClosest(this.manager.getTextView().getCaretOffset(), true));
            if (currentSection < 0) {
                currentSection = 0;
            }
            int n = ((Collection)this.manager.getSectionList()).size();
            for (int i = 0; i < n; ++i) {
                MapList list = this.manager.isEmptyDocument() ? this.manager.getMapList() : this.manager.getSectionList().get((int)i).list;
                int n2 = ((Collection)list).size();
                for (int j = 0; j < n2; ++j) {
                    Object e = list.get(j);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                    TextMapElement curTME = (TextMapElement)e;
                    if (curTME.getNode() != curDescendant) continue;
                    if (currentSection != i) {
                        this.manager.resetSection(i);
                    }
                    return curTME;
                }
            }
        }
        throw new NodeException("No usable TME found", node, null, 4, null);
    }

    private final TextMapElement getTMELast(Node node, Supplier<Element> tableParent, Supplier<List<Node>> descendants) {
        TextMapElement preFilter = this.getTMEPreFilter(node, tableParent);
        if (preFilter != null) {
            return preFilter;
        }
        List<Node> list = descendants.get();
        Intrinsics.checkNotNullExpressionValue(list, (String)"get(...)");
        for (Node curDescendant : CollectionsKt.reversed((Iterable)list)) {
            if (XMLHandler.Companion.ancestorElementIs(curDescendant, TextViewModule::getTMELast$lambda$0)) continue;
            int currentSection = this.manager.getSection(this.manager.getMapList().getClosest(this.manager.getTextView().getCaretOffset(), true));
            if (currentSection < 0) {
                currentSection = 0;
            }
            int n = ((Collection)this.manager.getSectionList()).size();
            for (int i = 0; i < n; ++i) {
                MapList list2 = this.manager.isEmptyDocument() ? this.manager.getMapList() : this.manager.getSectionList().get((int)i).list;
                int n2 = ((Collection)list2).size();
                for (int j = 0; j < n2; ++j) {
                    Object e = list2.get(j);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                    TextMapElement curTME = (TextMapElement)e;
                    if (curTME.getNode() != curDescendant) continue;
                    if (currentSection != i) {
                        this.manager.resetSection(i);
                    }
                    return curTME;
                }
            }
        }
        throw new NodeException("No usable TME found", node, null, 4, null);
    }

    private final TextMapElement getTMEPreFilter(Node inputNode, Supplier<Element> tableParent) {
        Node node = inputNode;
        if (node instanceof Text) {
            return this.getTMEOfTextNode((Text)node);
        }
        if (BBX.CONTAINER.TABLE.isA(node)) {
            Element element = tableParent.get();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"get(...)");
            node = (Node)element;
            Iterator iterator = this.manager.getMapList().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                TextMapElement curTME = (TextMapElement)iterator2.next();
                if (curTME.getNodeParent() != node) continue;
                return curTME;
            }
        } else if (node instanceof Element && !Intrinsics.areEqual((Object)((Element)node).getNamespaceURI(), (Object)"http://brailleblaster.org/ns/bb")) {
            return this.getTMEOfElement((Element)node);
        }
        return null;
    }

    private final TextMapElement getTMEOfTextNode(Text text) {
        TextMapElement tme = this.manager.getMapList().findNode((Node)text);
        if (tme == null) {
            Pair<Integer, Integer> pair = this.manager.getViewInitializer().findSection((Node)text);
            if (pair == null) {
                throw new NodeException("Node is not in maplist", (Node)text, null, 4, null);
            }
            Pair<Integer, Integer> result = pair;
            if (!this.manager.getViewInitializer().getSectionList().get(((Number)result.getFirst()).intValue()).isVisible() && this.manager.needsMapListUpdate()) {
                this.manager.waitForFormatting(true);
                Pair<Integer, Integer> pair2 = this.manager.getViewInitializer().findSection((Node)text);
                if (pair2 == null) {
                    throw new NodeException("Node is not in maplist", (Node)text, null, 4, null);
                }
                result = pair2;
            }
            tme = (TextMapElement)this.manager.getViewInitializer().getSectionList().get((int)((Number)result.getFirst()).intValue()).list.get(((Number)result.getSecond()).intValue());
        }
        return tme;
    }

    private final TextMapElement getTMEOfElement(Element element) {
        return this.manager.getMapList().findNode((Node)element);
    }

    private final boolean currentElementOnScreen(StyledText view, int pos) {
        int topIndex;
        int viewHeight = view.getClientArea().height;
        int lineHeight = view.getLineHeight();
        int totalLines = viewHeight / lineHeight;
        int currentLine = view.getLineAtOffset(pos);
        return currentLine >= (topIndex = view.getTopIndex()) && currentLine <= topIndex + totalLines - 1;
    }

    private static final Element onEvent$lambda$0$0(Element $node) {
        return Manager.getTableParent((Node)$node);
    }

    private static final List onEvent$lambda$1$0(Element $node) {
        return SequencesKt.toList((Sequence)FastXPath.descendantOrSelf((Node)((Node)$node)));
    }

    private static final Element onEvent$lambda$0(Element $node) {
        return (Element)Suppliers.memoize(() -> TextViewModule.onEvent$lambda$0$0($node)).get();
    }

    private static final List onEvent$lambda$1(Element $node) {
        return (List)Suppliers.memoize(() -> TextViewModule.onEvent$lambda$1$0($node)).get();
    }

    private static final boolean getTMEFirst$lambda$0(Element curAncestor) {
        Intrinsics.checkNotNullParameter((Object)curAncestor, (String)"curAncestor");
        return Intrinsics.areEqual((Object)curAncestor.getNamespaceURI(), (Object)"http://brailleblaster.org/ns/utd");
    }

    private static final boolean getTMELast$lambda$0(Element curAncestor) {
        Intrinsics.checkNotNullParameter((Object)curAncestor, (String)"curAncestor");
        return Intrinsics.areEqual((Object)curAncestor.getNamespaceURI(), (Object)"http://brailleblaster.org/ns/utd");
    }

    @JvmStatic
    @NotNull
    public static final TextMapElement[] getAllTextMapElementsInSelectedRange(@NotNull Manager m) {
        return Companion.getAllTextMapElementsInSelectedRange(m);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/views/TextViewModule$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getAllTextMapElementsInSelectedRange", "", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "(Lorg/brailleblaster/perspectives/braille/Manager;)[Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "setCursorAfterInsert", "", "numberCharsAdded", "", "sender", "Lorg/brailleblaster/perspectives/braille/messages/Sender;", "brailleblaster-core"})
    @SourceDebugExtension(value={"SMAP\nTextViewModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextViewModule.kt\norg/brailleblaster/perspectives/mvc/modules/views/TextViewModule$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,320:1\n37#2,2:321\n*S KotlinDebug\n*F\n+ 1 TextViewModule.kt\norg/brailleblaster/perspectives/mvc/modules/views/TextViewModule$Companion\n*L\n293#1:321,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TextMapElement[] getAllTextMapElementsInSelectedRange(@NotNull Manager m) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            Set<TextMapElement> allElements = m.getAllTextMapElementsInRange(m.getTextView().getSelection().x, m.getTextView().getSelection().y);
            Intrinsics.checkNotNull(allElements);
            Collection $this$toTypedArray$iv = allElements;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new TextMapElement[0]);
        }

        public final void setCursorAfterInsert(@NotNull Manager m, int numberCharsAdded, @NotNull Sender sender) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            Intrinsics.checkNotNullParameter((Object)((Object)sender), (String)"sender");
            int cursorPos = m.getTextView().getCaretOffset();
            TextMapElement mapElement = m.getMapList().getClosest(cursorPos + numberCharsAdded, true);
            if (mapElement.getNode() instanceof Text) {
                BBSimpleManager bBSimpleManager = m.getSimpleManager();
                Node node = mapElement.getNode();
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Text");
                bBSimpleManager.dispatchEvent(new XMLCaretEvent(sender, new XMLTextCaret((Text)node, cursorPos + numberCharsAdded, null, 4, null), null, 4, null));
            } else {
                BBSimpleManager bBSimpleManager = m.getSimpleManager();
                Node node = mapElement.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
                bBSimpleManager.dispatchEvent(new XMLCaretEvent(sender, new XMLNodeCaret(node, XMLNodeCaret.CursorPosition.AFTER), null, 4, null));
            }
            m.getText().setCurrentElement(cursorPos + numberCharsAdded);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

