/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.search;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Node;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.search.Click;
import org.brailleblaster.search.DOMControl;
import org.brailleblaster.search.SearchUtils;
import org.brailleblaster.search.ViewControl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/brailleblaster/search/Find;", "", "<init>", "()V", "clickCount", "", "getClickCount", "()I", "setClickCount", "(I)V", "find", "", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "click", "Lorg/brailleblaster/search/Click;", "domCon", "Lorg/brailleblaster/search/DOMControl;", "viewCon", "Lorg/brailleblaster/search/ViewControl;", "brailleblaster-core"})
public final class Find {
    private int clickCount;

    public final int getClickCount() {
        return this.clickCount;
    }

    public final void setClickCount(int n) {
        this.clickCount = n;
    }

    public final boolean find(@NotNull Manager m, @NotNull Click click) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Intrinsics.checkNotNullParameter((Object)click, (String)"click");
        DOMControl domCon = new DOMControl(click);
        ViewControl viewCon = new ViewControl(m, click);
        return this.find(m, click, domCon, viewCon);
    }

    public final boolean find(@NotNull Manager m, @NotNull Click click, @NotNull DOMControl domCon, @NotNull ViewControl viewCon) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Intrinsics.checkNotNullParameter((Object)click, (String)"click");
        Intrinsics.checkNotNullParameter((Object)domCon, (String)"domCon");
        Intrinsics.checkNotNullParameter((Object)viewCon, (String)"viewCon");
        int n = this.clickCount;
        this.clickCount = n + 1;
        if (!SearchUtils.INSTANCE.hasFindCriteria(click)) {
            return false;
        }
        if (!click.getSettings().findHasText()) {
            Node correctNode = null;
            if (domCon.getPossiblesCorrectAttributes().isEmpty()) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)domCon.getPossiblesCorrectAttributes().get(0), (Object)click.getInitialView().mapElement.getNode()) || click.getInitialView().cursorOffset <= click.getInitialView().mapElement.getStart(m.getMapList())) {
                correctNode = domCon.getPossiblesCorrectAttributes().get(0);
            } else if (domCon.getPossiblesCorrectAttributes().size() > 1) {
                correctNode = domCon.getPossiblesCorrectAttributes().get(1);
            }
            if (correctNode != null) {
                String string = correctNode.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                if (((CharSequence)string).length() > 0) {
                    viewCon.findNodeAndHighlight(correctNode);
                    return true;
                }
            }
            return false;
        }
        int totalSections = m.getSectionList().size();
        for (int i = click.getInitialView().section; i < totalSections; ++i) {
            List<Node> array = i == click.getInitialView().section ? viewCon.getNodeFromCurrent() : viewCon.getNodeFromBeginning(i);
            String s1 = domCon.searchNoView(array);
            String s2 = domCon.searchNoViewNoSpaces(array);
            if (!SearchUtils.matchPhrase(s1, click, false).hasNext() && !SearchUtils.matchPhrase(s2, click, false).hasNext() || !viewCon.findInSection(i, domCon.getPossiblesCorrectAttributes())) continue;
            return true;
        }
        return false;
    }
}

