/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.maps.MapList;
import org.brailleblaster.perspectives.braille.views.wp.TextView;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.perspectives.mvc.SimpleEvent;
import org.brailleblaster.perspectives.mvc.events.BuildMenuEvent;
import org.brailleblaster.perspectives.mvc.menu.BBSelectionData;
import org.brailleblaster.perspectives.mvc.menu.EnableListener;
import org.brailleblaster.perspectives.mvc.menu.MenuManager;
import org.brailleblaster.perspectives.mvc.menu.SharedItem;
import org.brailleblaster.perspectives.mvc.menu.TopMenu;
import org.brailleblaster.perspectives.mvc.modules.misc.TableSelectionModule;
import org.brailleblaster.search.Click;
import org.brailleblaster.search.Find;
import org.brailleblaster.search.Replace;
import org.brailleblaster.search.SavedSearches;
import org.brailleblaster.search.SearchConstants;
import org.brailleblaster.search.SearchController;
import org.brailleblaster.search.SearchCriteria;
import org.brailleblaster.search.SearchNotices;
import org.brailleblaster.search.SearchUtils;
import org.brailleblaster.search.ViewState;
import org.brailleblaster.tools.MenuTool;
import org.brailleblaster.tools.RepeatSearchTool;
import org.brailleblaster.utd.Style;
import org.brailleblaster.utd.properties.EmphasisType;
import org.brailleblaster.util.Notify;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.brailleblaster.utils.swt.EasySWT;
import org.brailleblaster.wordprocessor.WPManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u0000 E2\u00020\u00012\u00020\u0002:\u0001EB\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0006\u0010\"\u001a\u00020\u001cJ\b\u0010#\u001a\u00020\u001cH\u0002J\b\u0010$\u001a\u00020\u001cH\u0002J\b\u0010%\u001a\u00020\u001cH\u0002J\u0018\u0010&\u001a\u00020\u001c2\u0006\u0010\u0003\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010*\u001a\u00020\u001c2\u0006\u0010\u0003\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010+\u001a\u00020\u001c2\u0006\u0010\u0003\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J \u0010,\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020)H\u0002J \u00100\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)2\u0006\u00101\u001a\u0002022\u0006\u0010/\u001a\u00020)H\u0002J \u00103\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)2\u0006\u00104\u001a\u00020.2\u0006\u0010/\u001a\u00020)H\u0002J\u0010\u00105\u001a\u00020.2\u0006\u00104\u001a\u00020.H\u0002J\u0010\u00106\u001a\u00020)2\u0006\u00104\u001a\u00020.H\u0002J\u0010\u00107\u001a\u00020.2\u0006\u00104\u001a\u00020.H\u0002J\u0010\u00108\u001a\u00020)2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u00109\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020'H\u0002J\b\u0010:\u001a\u00020\u001cH\u0002J\b\u0010;\u001a\u00020\u001cH\u0002J\u0010\u0010<\u001a\u00020.2\u0006\u0010=\u001a\u00020.H\u0002J\u0010\u0010>\u001a\u00020.2\u0006\u0010=\u001a\u00020.H\u0002J\b\u0010B\u001a\u00020\u001cH\u0002J\u0006\u0010C\u001a\u00020\u001cJ\b\u0010D\u001a\u00020\u001cH\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0013\u0010?\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b@\u0010A\u00a8\u0006F"}, d2={"Lorg/brailleblaster/search/SearchDialog;", "Lorg/eclipse/swt/widgets/Dialog;", "Lorg/brailleblaster/perspectives/mvc/BBSimpleManager$SimpleListener;", "parent", "Lorg/eclipse/swt/widgets/Shell;", "style", "", "<init>", "(Lorg/eclipse/swt/widgets/Shell;I)V", "click", "Lorg/brailleblaster/search/Click;", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "findCombo", "Lorg/eclipse/swt/widgets/Combo;", "replaceCombo", "findList", "Lorg/eclipse/swt/widgets/List;", "replaceList", "sc", "Lorg/brailleblaster/search/SearchCriteria;", "location", "Lorg/eclipse/swt/graphics/Point$WithMonitor;", "findObj", "Lorg/brailleblaster/search/Find;", "replaceObj", "Lorg/brailleblaster/search/Replace;", "onEvent", "", "event", "Lorg/brailleblaster/perspectives/mvc/SimpleEvent;", "rightManager", "getRightManager", "()Lorg/brailleblaster/perspectives/braille/Manager;", "open", "createContents", "saveLocation", "createBetterUI", "addStylesDropdown", "Lorg/eclipse/swt/widgets/Group;", "isFind", "", "addEmphasisDropdown", "addContainersDropdown", "addToContainersList", "cfs", "", "isNegated", "addToStyleList", "sf", "Lorg/brailleblaster/search/SearchCriteria$StyleFormatting;", "addToEmphasisList", "s", "getNegated", "isNot", "getNonNegated", "isValidClick", "makeList", "replace", "replaceAll", "addBlackBox", "string", "removeBlackBox", "shell", "getShell", "()Lorg/eclipse/swt/widgets/Shell;", "search", "repeatLastSearch", "loadSearchesIntoCombos", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nSearchDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchDialog.kt\norg/brailleblaster/search/SearchDialog\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,825:1\n37#2,2:826\n812#3,12:828\n106#4:840\n78#4,22:841\n*S KotlinDebug\n*F\n+ 1 SearchDialog.kt\norg/brailleblaster/search/SearchDialog\n*L\n398#1:826,2\n441#1:828,12\n569#1:840\n569#1:841,22\n*E\n"})
public final class SearchDialog
extends Dialog
implements BBSimpleManager.SimpleListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Click click;
    @Nullable
    private Manager m;
    @Nullable
    private Combo findCombo;
    @Nullable
    private Combo replaceCombo;
    @Nullable
    private org.eclipse.swt.widgets.List findList;
    @Nullable
    private org.eclipse.swt.widgets.List replaceList;
    @NotNull
    private SearchCriteria sc = new SearchCriteria();
    @NotNull
    private final Point.WithMonitor location = new Point.WithMonitor(0, 0, Display.getCurrent().getPrimaryMonitor());
    @Nullable
    private Find findObj;
    @Nullable
    private Replace replaceObj;
    @Nullable
    private static Shell shell;
    @NotNull
    private static final String NB_SPACE = "\u00a0";
    @NotNull
    private static final String BLACK_BOX = "\u25a0";

    public SearchDialog(@Nullable Shell parent, int style) {
        super(parent, style);
        this.setText("SWT Dialog");
    }

    @Override
    public void onEvent(@NotNull SimpleEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof BuildMenuEvent) {
            MenuTool searchTool2 = new MenuTool(this){
                final /* synthetic */ SearchDialog this$0;
                {
                    this.this$0 = $receiver;
                }

                public TopMenu getTopMenu() {
                    return TopMenu.EDIT;
                }

                public String getTitle() {
                    return SearchConstants.SEARCH;
                }

                public int getAccelerator() {
                    return SWT.MOD1 + 70;
                }

                public SharedItem getSharedItem() {
                    return SharedItem.SEARCH;
                }

                public EnableListener getEnableListener() {
                    return null;
                }

                public void onRun(BBSelectionData bbData) {
                    Intrinsics.checkNotNullParameter((Object)bbData, (String)"bbData");
                    SearchDialog.access$setM$p(this.this$0, bbData.getManager());
                    this.this$0.open();
                }
            };
            MenuManager.INSTANCE.add(searchTool2);
            MenuManager.INSTANCE.add(RepeatSearchTool.INSTANCE);
        }
    }

    private final Manager getRightManager() {
        return WPManager.Companion.getInstance().getController();
    }

    public final void open() {
        this.createContents();
        Shell shell = SearchDialog.shell;
        Intrinsics.checkNotNull((Object)shell);
        shell.open();
        Shell shell2 = SearchDialog.shell;
        Intrinsics.checkNotNull((Object)shell2);
        shell2.layout();
        Shell shell3 = SearchDialog.shell;
        Intrinsics.checkNotNull((Object)shell3);
        EasySWT.INSTANCE.setLargeDialogSize(shell3);
    }

    private final void createContents() {
        SearchCriteria searchCriteria;
        if (SavedSearches.lastSettings == null) {
            searchCriteria = new SearchCriteria();
        } else {
            SearchCriteria searchCriteria2 = SavedSearches.lastSettings;
            searchCriteria = searchCriteria2;
            Intrinsics.checkNotNull((Object)searchCriteria2);
        }
        this.sc = searchCriteria;
        this.findObj = new Find();
        this.replaceObj = new Replace();
        this.createBetterUI();
    }

    private final void saveLocation() {
        if (shell != null) {
            Shell shell = SearchDialog.shell;
            Intrinsics.checkNotNull((Object)shell);
            if (!shell.isDisposed()) {
                Shell shell2 = SearchDialog.shell;
                Intrinsics.checkNotNull((Object)shell2);
                this.location.x = shell2.getLocation().x;
                Shell shell3 = SearchDialog.shell;
                Intrinsics.checkNotNull((Object)shell3);
                this.location.y = shell3.getLocation().y;
            }
        }
    }

    private final void createBetterUI() {
        if (shell != null) {
            Shell shell = SearchDialog.shell;
            Intrinsics.checkNotNull((Object)shell);
            if (!shell.isDisposed()) {
                this.saveLocation();
                Shell shell2 = SearchDialog.shell;
                Intrinsics.checkNotNull((Object)shell2);
                shell2.close();
            }
        }
        Shell shell = SearchDialog.shell = EasySWT.INSTANCE.makeDialogFloating(this.getParent());
        Intrinsics.checkNotNull((Object)shell);
        shell.setLocation((Point)this.location);
        Shell shell3 = SearchDialog.shell;
        Intrinsics.checkNotNull((Object)shell3);
        shell3.setText(SearchConstants.FIND_REPLACE_SHELL);
        Shell shell4 = SearchDialog.shell;
        Intrinsics.checkNotNull((Object)shell4);
        shell4.setLayout((Layout)new GridLayout(1, false));
        Shell shell5 = SearchDialog.shell;
        Intrinsics.checkNotNull((Object)shell5);
        shell5.setLayoutData((Object)new GridData(4, 4, true, true));
        Group findGroup = EasySWT.makeGroup((Composite)((Composite)SearchDialog.shell), (int)0, (int)2, (boolean)false);
        findGroup.setText(SearchConstants.FIND);
        Combo combo = this.findCombo = new Combo((Composite)findGroup, 4);
        Intrinsics.checkNotNull((Object)combo);
        combo.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Button findFormattingBtn = EasySWT.makePushButton((Composite)((Composite)findGroup), (String)SearchConstants.FORMATTING, (int)1, SearchDialog::createBetterUI$lambda$0);
        findFormattingBtn.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.findList = this.makeList(findGroup);
        Group findFormattingGroup = EasySWT.makeGroup((Composite)((Composite)SearchDialog.shell), (int)0, (int)1, (boolean)false);
        findFormattingGroup.setVisible(false);
        findFormattingGroup.setText(SearchConstants.FIND + " " + SearchConstants.FORMATTING);
        GridData findFormattingData = new GridData(4, 0x1000000, true, true);
        findFormattingData.exclude = true;
        findFormattingGroup.setLayoutData((Object)findFormattingData);
        this.addStylesDropdown(findFormattingGroup, true);
        this.addEmphasisDropdown(findFormattingGroup, true);
        this.addContainersDropdown(findFormattingGroup, true);
        findFormattingBtn.addSelectionListener((SelectionListener)new SelectionAdapter(findFormattingGroup, findFormattingData, findFormattingBtn){
            final /* synthetic */ Group $findFormattingGroup;
            final /* synthetic */ GridData $findFormattingData;
            final /* synthetic */ Button $findFormattingBtn;
            {
                this.$findFormattingGroup = $findFormattingGroup;
                this.$findFormattingData = $findFormattingData;
                this.$findFormattingBtn = $findFormattingBtn;
            }

            public void widgetSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$findFormattingGroup.setVisible(!this.$findFormattingGroup.getVisible());
                boolean bl = this.$findFormattingData.exclude = !this.$findFormattingData.exclude;
                if (!this.$findFormattingGroup.getVisible()) {
                    this.$findFormattingBtn.setText(SearchConstants.FORMATTING);
                } else {
                    this.$findFormattingBtn.setText(SearchConstants.CLOSE + " " + SearchConstants.FORMATTING);
                }
                Shell shell = SearchDialog.access$getShell$cp();
                Intrinsics.checkNotNull((Object)shell);
                shell.layout();
                Shell shell2 = SearchDialog.access$getShell$cp();
                Intrinsics.checkNotNull((Object)shell2);
                shell2.pack();
            }
        });
        Group replaceGroup = EasySWT.makeGroup((Composite)((Composite)SearchDialog.shell), (int)0, (int)2, (boolean)false);
        replaceGroup.setText(SearchConstants.REPLACE_WITH);
        Combo combo2 = this.replaceCombo = new Combo((Composite)replaceGroup, 4);
        Intrinsics.checkNotNull((Object)combo2);
        combo2.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Button replaceFormattingBtn = EasySWT.makePushButton((Composite)((Composite)replaceGroup), (String)SearchConstants.FORMATTING, (int)1, SearchDialog::createBetterUI$lambda$1);
        replaceFormattingBtn.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.replaceList = this.makeList(replaceGroup);
        Group replaceFormattingGroup = EasySWT.makeGroup((Composite)((Composite)SearchDialog.shell), (int)0, (int)1, (boolean)false);
        replaceFormattingGroup.setVisible(false);
        replaceFormattingGroup.setText(SearchConstants.REPLACE + " " + SearchConstants.FORMATTING);
        GridData replaceFormattingData = new GridData(4, 0x1000000, true, true, 1, 1);
        replaceFormattingData.exclude = true;
        replaceFormattingGroup.setLayoutData((Object)replaceFormattingData);
        this.addStylesDropdown(replaceFormattingGroup, false);
        this.addEmphasisDropdown(replaceFormattingGroup, false);
        replaceFormattingBtn.addSelectionListener((SelectionListener)new SelectionAdapter(replaceFormattingGroup, replaceFormattingData, replaceFormattingBtn){
            final /* synthetic */ Group $replaceFormattingGroup;
            final /* synthetic */ GridData $replaceFormattingData;
            final /* synthetic */ Button $replaceFormattingBtn;
            {
                this.$replaceFormattingGroup = $replaceFormattingGroup;
                this.$replaceFormattingData = $replaceFormattingData;
                this.$replaceFormattingBtn = $replaceFormattingBtn;
            }

            public void widgetSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$replaceFormattingGroup.setVisible(!this.$replaceFormattingGroup.getVisible());
                boolean bl = this.$replaceFormattingData.exclude = !this.$replaceFormattingData.exclude;
                if (!this.$replaceFormattingGroup.getVisible()) {
                    this.$replaceFormattingBtn.setText(SearchConstants.FORMATTING);
                } else {
                    this.$replaceFormattingBtn.setText(SearchConstants.CLOSE + " " + SearchConstants.FORMATTING);
                }
                Shell shell = SearchDialog.access$getShell$cp();
                Intrinsics.checkNotNull((Object)shell);
                shell.layout();
                Shell shell2 = SearchDialog.access$getShell$cp();
                Intrinsics.checkNotNull((Object)shell2);
                shell2.pack();
            }
        });
        Group directionGroup = EasySWT.makeGroup((Composite)((Composite)SearchDialog.shell), (int)0, (int)2, (boolean)true);
        GridData directionsData = new GridData(4, 0x1000000, true, true, 1, 2);
        directionsData.exclude = true;
        directionGroup.setLayoutData((Object)directionsData);
        directionGroup.setText("Direction: ");
        directionGroup.setVisible(false);
        Button fwdButton = EasySWT.makeRadioButton((Composite)((Composite)directionGroup), (String)SearchConstants.FORWARD, (int)1, SearchDialog::createBetterUI$lambda$2);
        fwdButton.setSelection(this.sc.isSearchForward());
        EasySWT.addSelectionListener((Button)fwdButton, arg_0 -> SearchDialog.createBetterUI$lambda$3(fwdButton, this, arg_0));
        Button revButton = EasySWT.makeRadioButton((Composite)((Composite)directionGroup), (String)SearchConstants.BACKWARD, (int)1, SearchDialog::createBetterUI$lambda$4);
        revButton.setSelection(!this.sc.isSearchForward());
        EasySWT.addSelectionListener((Button)revButton, arg_0 -> SearchDialog.createBetterUI$lambda$5(revButton, this, arg_0));
        Group matchGroup = EasySWT.makeGroup((Composite)((Composite)SearchDialog.shell), (int)0, (int)2, (boolean)true);
        Button matchCase = EasySWT.makeCheckBox((Composite)((Composite)matchGroup), (String)SearchConstants.MATCH_CASE, SearchDialog::createBetterUI$lambda$6);
        matchCase.setSelection(this.sc.isFindCaseSensitive());
        matchCase.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ SearchDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void widgetSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SearchDialog.access$getSc$p(this.this$0).setFindCaseSensitive(!SearchDialog.access$getSc$p(this.this$0).isFindCaseSensitive());
            }
        });
        Button matchWord = EasySWT.makeCheckBox((Composite)((Composite)matchGroup), (String)SearchConstants.WHOLE_WORD, SearchDialog::createBetterUI$lambda$7);
        matchWord.setSelection(this.sc.isWholeWord());
        matchWord.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ SearchDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void widgetSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SearchDialog.access$getSc$p(this.this$0).setWholeWord(!SearchDialog.access$getSc$p(this.this$0).isWholeWord());
            }
        });
        Group searchGroup = EasySWT.makeGroup((Composite)((Composite)SearchDialog.shell), (int)0, (int)3, (boolean)false);
        Button findButton = EasySWT.makePushButton((Composite)((Composite)searchGroup), (String)SearchConstants.FIND, (int)1, SearchDialog::createBetterUI$lambda$8);
        Shell shell6 = SearchDialog.shell;
        Intrinsics.checkNotNull((Object)shell6);
        shell6.setDefaultButton(findButton);
        findButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ SearchDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void widgetSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SearchDialog.access$search(this.this$0);
            }
        });
        Button replaceButton = EasySWT.makePushButton((Composite)((Composite)searchGroup), (String)SearchConstants.REPLACE, (int)1, SearchDialog::createBetterUI$lambda$9);
        replaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ SearchDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void widgetSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SearchDialog.access$replace(this.this$0);
            }
        });
        Button replaceAllButton = EasySWT.makePushButton((Composite)((Composite)searchGroup), (String)SearchConstants.REPLACE_ALL, (int)1, SearchDialog::createBetterUI$lambda$10);
        replaceAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ SearchDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void widgetSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SearchDialog.access$replaceAll(this.this$0);
            }
        });
        Group closeGroup = EasySWT.makeGroup((Composite)((Composite)SearchDialog.shell), (int)0, (int)2, (boolean)false);
        Button resetButton = EasySWT.makePushButton((Composite)((Composite)closeGroup), (String)SearchConstants.RESET, (int)1, SearchDialog::createBetterUI$lambda$11);
        resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ SearchDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void widgetSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SearchDialog.access$getSc$p(this.this$0).reset();
                Find find = SearchDialog.access$getFindObj$p(this.this$0);
                Intrinsics.checkNotNull((Object)find);
                find.setClickCount(0);
                Replace replace = SearchDialog.access$getReplaceObj$p(this.this$0);
                Intrinsics.checkNotNull((Object)replace);
                replace.setReplaceClickCount(0);
                Combo combo = SearchDialog.access$getFindCombo$p(this.this$0);
                Intrinsics.checkNotNull((Object)combo);
                combo.setText("");
                Combo combo2 = SearchDialog.access$getReplaceCombo$p(this.this$0);
                Intrinsics.checkNotNull((Object)combo2);
                combo2.setText("");
                org.eclipse.swt.widgets.List list = SearchDialog.access$getFindList$p(this.this$0);
                Intrinsics.checkNotNull((Object)list);
                list.removeAll();
                org.eclipse.swt.widgets.List list2 = SearchDialog.access$getFindList$p(this.this$0);
                Intrinsics.checkNotNull((Object)list2);
                list2.add("");
                org.eclipse.swt.widgets.List list3 = SearchDialog.access$getReplaceList$p(this.this$0);
                Intrinsics.checkNotNull((Object)list3);
                list3.removeAll();
                org.eclipse.swt.widgets.List list4 = SearchDialog.access$getReplaceList$p(this.this$0);
                Intrinsics.checkNotNull((Object)list4);
                list4.add("");
                Shell shell = SearchDialog.access$getShell$cp();
                Intrinsics.checkNotNull((Object)shell);
                shell.layout();
                Shell shell2 = SearchDialog.access$getShell$cp();
                Intrinsics.checkNotNull((Object)shell2);
                shell2.pack();
            }
        });
        Button closeButton = EasySWT.makePushButton((Composite)((Composite)closeGroup), (String)SearchConstants.CLOSE, (int)1, SearchDialog::createBetterUI$lambda$12);
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ SearchDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void widgetSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SearchDialog.access$saveLocation(this.this$0);
                Shell shell = SearchDialog.access$getShell$cp();
                Intrinsics.checkNotNull((Object)shell);
                shell.close();
            }
        });
        Shell shell7 = SearchDialog.shell;
        Intrinsics.checkNotNull((Object)shell7);
        shell7.layout();
        Shell shell8 = SearchDialog.shell;
        Intrinsics.checkNotNull((Object)shell8);
        shell8.pack();
        this.loadSearchesIntoCombos();
    }

    private final void addStylesDropdown(Group parent, boolean isFind) {
        Group addStyleGroup = EasySWT.makeGroup((Composite)((Composite)parent), (int)0, (int)3, (boolean)false);
        addStyleGroup.setText(SearchConstants.STYLES);
        Button notCheckbox = EasySWT.makeCheckBox((Composite)((Composite)addStyleGroup), (String)"Not", SearchDialog::addStylesDropdown$lambda$0);
        if (!isFind) {
            notCheckbox.setText("");
            notCheckbox.setSelection(false);
            notCheckbox.setEnabled(false);
            notCheckbox.setVisible(false);
        }
        ComboViewer styleComboViewer = new ComboViewer((Composite)addStyleGroup, 12);
        styleComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        styleComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object elm) {
                Intrinsics.checkNotNullParameter((Object)elm, (String)"elm");
                LocaleHandler localeHandler = LocaleHandler.Companion.getBanaStyles$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null);
                String string = ((Style)elm).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                return localeHandler.get(string);
            }
        });
        List styleDefs2 = WPManager.Companion.getInstance().getController().getDocument().getEngine().getStyleDefinitions().getStyles();
        ArrayList<Style> styles = new ArrayList<Style>();
        for (Style s : styleDefs2) {
            String string = s.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"internal", (boolean)false, (int)2, null)) continue;
            String string2 = s.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
            if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"options", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)s.getName(), (Object)"Page")) continue;
            String string3 = s.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            if (SearchUtils.isContainerStyle(string3) || Intrinsics.areEqual((Object)s.getName(), (Object)"Poetic Stanza")) continue;
            styles.add(s);
        }
        Comparator<Object> byDisplay = Comparator.comparing(arg_0 -> SearchDialog.addStylesDropdown$lambda$2(SearchDialog::addStylesDropdown$lambda$1, arg_0));
        List list = styles;
        Intrinsics.checkNotNull(byDisplay);
        CollectionsKt.sortWith((List)list, byDisplay);
        Collection $this$toTypedArray$iv = styles;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Style[] styleArray = thisCollection$iv.toArray(new Style[0]);
        styleComboViewer.add((Object[])Arrays.copyOf(styleArray, styleArray.length));
        EasySWT.makePushButton((Composite)((Composite)addStyleGroup), (String)SearchConstants.ADD, (int)1, arg_0 -> SearchDialog.addStylesDropdown$lambda$3(styleComboViewer, notCheckbox, this, isFind, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void addEmphasisDropdown(Group parent, boolean isFind) {
        void $this$filterIsInstanceTo$iv$iv;
        Group addEmphasisGroup = EasySWT.makeGroup((Composite)((Composite)parent), (int)0, (int)3, (boolean)false);
        addEmphasisGroup.setText(SearchConstants.TEXT_ATTRIBUTES);
        Button notCheckbox = isFind ? EasySWT.makeCheckBox((Composite)((Composite)addEmphasisGroup), (String)"Not", SearchDialog::addEmphasisDropdown$lambda$0) : EasySWT.makeCheckBox((Composite)((Composite)addEmphasisGroup), (String)"Remove", SearchDialog::addEmphasisDropdown$lambda$1);
        Combo emphasisCombo = (Combo)EasySWT.makeComboDropdown((Composite)((Composite)addEmphasisGroup)).get();
        Iterable $this$filterIsInstance$iv = this.sc.getAvailableEmphasis();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof SearchCriteria.EmphasisFormatting)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List emphasis = (List)destination$iv$iv;
        for (SearchCriteria.SearchFormatting entry : emphasis) {
            emphasisCombo.add(entry.toString());
        }
        EasySWT.makePushButton((Composite)((Composite)addEmphasisGroup), (String)SearchConstants.ADD, (int)1, arg_0 -> SearchDialog.addEmphasisDropdown$lambda$2(emphasisCombo, this, isFind, notCheckbox, arg_0));
    }

    private final void addContainersDropdown(Group parent, boolean isFind) {
        Group addContainersGroup = EasySWT.makeGroup((Composite)((Composite)parent), (int)0, (int)3, (boolean)false);
        addContainersGroup.setText("Containers");
        Button notCheckbox = isFind ? EasySWT.makeCheckBox((Composite)((Composite)addContainersGroup), (String)"Not", SearchDialog::addContainersDropdown$lambda$0) : EasySWT.makeCheckBox((Composite)((Composite)addContainersGroup), (String)"Remove", SearchDialog::addContainersDropdown$lambda$1);
        Combo containersCombo = (Combo)EasySWT.makeComboDropdown((Composite)((Composite)addContainersGroup)).get();
        List styleDefs2 = WPManager.Companion.getInstance().getController().getDocument().getEngine().getStyleDefinitions().getStyles();
        for (Style s : styleDefs2) {
            String string = s.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!SearchUtils.isContainerStyle(string)) continue;
            containersCombo.add(s.getName());
        }
        EasySWT.makePushButton((Composite)((Composite)addContainersGroup), (String)SearchConstants.ADD, (int)1, arg_0 -> SearchDialog.addContainersDropdown$lambda$2(containersCombo, this, isFind, notCheckbox, arg_0));
    }

    private final void addToContainersList(boolean isFind, String cfs, boolean isNegated) {
        SearchCriteria.ContainerFormatting cf = new SearchCriteria.ContainerFormatting(isNegated, cfs);
        SearchCriteria.ContainerFormatting ncf = new SearchCriteria.ContainerFormatting(!isNegated, cfs);
        if (isFind) {
            if (!this.sc.containerFormattingContains(cf, this.sc.findContainerFormatting) && !this.sc.containerFormattingContains(ncf, this.sc.findContainerFormatting)) {
                this.sc.findContainerFormatting.add(cf);
                try {
                    org.eclipse.swt.widgets.List list = this.findList;
                    Intrinsics.checkNotNull((Object)list);
                    list.remove("");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                org.eclipse.swt.widgets.List list = this.findList;
                Intrinsics.checkNotNull((Object)list);
                list.add((isNegated ? "Not " : "") + cfs);
            }
        } else if (!this.sc.containerFormattingContains(cf, this.sc.replaceContainerFormatting) && !this.sc.containerFormattingContains(ncf, this.sc.replaceContainerFormatting)) {
            this.sc.replaceContainerFormatting.add(cf);
            try {
                org.eclipse.swt.widgets.List list = this.replaceList;
                Intrinsics.checkNotNull((Object)list);
                list.remove("");
            }
            catch (Exception exception) {
                // empty catch block
            }
            org.eclipse.swt.widgets.List list = this.replaceList;
            Intrinsics.checkNotNull((Object)list);
            list.add((isNegated ? "Remove " : "") + cfs);
        }
    }

    private final void addToStyleList(boolean isFind, SearchCriteria.StyleFormatting sf, boolean isNegated) {
        String sfs = sf.style;
        String sfd = sf.display;
        String lc = LocaleHandler.Companion.getBanaStyles$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get(sfs);
        SearchCriteria.StyleFormatting formatting = this.sc.getStyleFormatting(isNegated, sfs, sfd);
        SearchCriteria.StyleFormatting negatedFormatting = this.sc.getStyleFormatting(!isNegated, sfs, sfd);
        if (isFind) {
            if (!this.sc.styleFormattingContains(formatting, this.sc.findStyleFormatting) && !this.sc.styleFormattingContains(negatedFormatting, this.sc.findStyleFormatting)) {
                this.sc.findStyleFormatting.add(formatting);
                try {
                    org.eclipse.swt.widgets.List list = this.findList;
                    Intrinsics.checkNotNull((Object)list);
                    list.remove("");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                org.eclipse.swt.widgets.List list = this.findList;
                Intrinsics.checkNotNull((Object)list);
                list.add((isNegated ? "Not " : "") + lc);
            }
        } else if (this.sc.replaceStyleFormatting == null) {
            this.sc.replaceStyleFormatting = formatting;
            try {
                org.eclipse.swt.widgets.List list = this.replaceList;
                Intrinsics.checkNotNull((Object)list);
                list.remove("");
            }
            catch (Exception exception) {
                // empty catch block
            }
            org.eclipse.swt.widgets.List list = this.replaceList;
            Intrinsics.checkNotNull((Object)list);
            list.add((isNegated ? "Remove " : "") + lc);
        }
    }

    private final void addToEmphasisList(boolean isFind, String s, boolean isNegated) {
        CharSequence $this$trim$iv$iv2;
        String s2 = s;
        if (isNegated) {
            String $this$trim$iv = this.getNonNegated(s2);
            boolean $i$f$trim = false;
            $this$trim$iv$iv2 = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv2.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv2.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            s2 = ((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        }
        EmphasisType emphasisType = EmphasisType.Companion.getEmphasisType(s2);
        if (emphasisType == null) {
            $this$trim$iv$iv2 = "Required value was null.";
            throw new IllegalArgumentException($this$trim$iv$iv2.toString());
        }
        EmphasisType emphasisType2 = emphasisType;
        SearchCriteria.EmphasisFormatting formatting = this.sc.getEmphasisFormatting(isNegated, emphasisType2);
        if (isFind) {
            if (!this.sc.emphasisFormattingContains(formatting, this.sc.findEmphasisFormatting)) {
                this.sc.findEmphasisFormatting.add(formatting);
                try {
                    org.eclipse.swt.widgets.List list = this.findList;
                    Intrinsics.checkNotNull((Object)list);
                    list.remove("");
                }
                catch (Exception $this$trim$iv$iv2) {
                    // empty catch block
                }
                org.eclipse.swt.widgets.List list = this.findList;
                Intrinsics.checkNotNull((Object)list);
                list.add(formatting.toString());
            }
        } else if (!this.sc.emphasisFormattingContains(formatting, this.sc.replaceEmphasisFormatting)) {
            this.sc.replaceEmphasisFormatting.add(formatting);
            try {
                org.eclipse.swt.widgets.List list = this.replaceList;
                Intrinsics.checkNotNull((Object)list);
                list.remove("");
            }
            catch (Exception $this$trim$iv$iv2) {
                // empty catch block
            }
            Object fs = this.getNonNegated(formatting.toString());
            if (isNegated) {
                fs = "Remove " + (String)fs;
            }
            org.eclipse.swt.widgets.List list = this.replaceList;
            Intrinsics.checkNotNull((Object)list);
            list.add((String)fs);
        }
    }

    private final String getNegated(String s) {
        if (this.isNot(s)) {
            return s;
        }
        return "Not " + s;
    }

    private final boolean isNot(String s) {
        int index = StringsKt.indexOf$default((CharSequence)s, (String)"Not", (int)0, (boolean)false, (int)6, null);
        return index >= 0;
    }

    private final String getNonNegated(String s) {
        if (!this.isNot(s)) {
            return s;
        }
        String string = s.substring(4);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    private final boolean isValidClick(Click click) {
        return click.getSettings().findHasAttributes() || click.getSettings().findHasText();
    }

    private final org.eclipse.swt.widgets.List makeList(Group parent) {
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List((Composite)parent, 2060);
        GridData gdF = new GridData(4, 16384, true, true, 1, 1);
        list.setLayoutData((Object)gdF);
        list.add("");
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void replace() {
        String replaceName;
        CharSequence charSequence;
        Combo combo = this.findCombo;
        Intrinsics.checkNotNull((Object)combo);
        String string = combo.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (((CharSequence)string).length() == 0) {
            Combo combo2 = this.replaceCombo;
            Intrinsics.checkNotNull((Object)combo2);
            String string2 = combo2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            if (((CharSequence)string2).length() > 0) {
                new SearchNotices().invalidMessage(this.getParent(), "Cannot perform replace with empty find criteria!");
                return;
            }
        }
        Manager manager = this.m = this.getRightManager();
        Intrinsics.checkNotNull((Object)manager);
        manager.waitForFormatting(true);
        Manager manager2 = this.m;
        Intrinsics.checkNotNull((Object)manager2);
        int index = manager2.getText().getView().getCaretOffset();
        Manager manager3 = this.m;
        Intrinsics.checkNotNull((Object)manager3);
        TextMapElement tme = manager3.getMapList().getClosest(index, true);
        Manager manager4 = this.m;
        Intrinsics.checkNotNull((Object)manager4);
        int section = manager4.getSection(tme);
        Combo combo3 = this.replaceCombo;
        Intrinsics.checkNotNull((Object)combo3);
        String string3 = combo3.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        CharSequence charSequence2 = this.removeBlackBox(string3);
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = "";
        } else {
            charSequence = charSequence2;
        }
        this.sc.replaceString = replaceName = (String)charSequence;
        Combo combo4 = this.findCombo;
        Intrinsics.checkNotNull((Object)combo4);
        String string4 = combo4.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
        this.sc.findString = this.removeBlackBox(string4);
        Intrinsics.checkNotNull((Object)tme);
        ViewState state = new ViewState(index, section, tme);
        Click click = this.click = new Click(this.sc, state, true);
        Intrinsics.checkNotNull((Object)click);
        if (!this.isValidClick(click)) {
            return;
        }
        Replace replace = this.replaceObj;
        Intrinsics.checkNotNull((Object)replace);
        Manager manager5 = this.m;
        Intrinsics.checkNotNull((Object)manager5);
        Click click2 = this.click;
        Intrinsics.checkNotNull((Object)click2);
        boolean replaced = replace.replace(manager5, click2);
        if (!replaced) {
            Manager manager6 = this.m;
            Intrinsics.checkNotNull((Object)manager6);
            if (SearchUtils.inTable(manager6)) {
                Manager manager7 = this.m;
                Intrinsics.checkNotNull((Object)manager7);
                TableSelectionModule.Companion.displayInvalidTableMessage(manager7.getWpManager().getShell());
                return;
            }
        }
        if (!replaced && index == 0 && section == 0) {
            new SearchNotices().wordNotFoundMessage(this.getParent(), this.findCombo);
            return;
        }
        if (!replaced) {
            SearchNotices searchNotices = new SearchNotices();
            Shell shell = this.getParent();
            Manager manager8 = this.m;
            Intrinsics.checkNotNull((Object)manager8);
            searchNotices.endOfDoc(shell, "beginning", manager8);
            return;
        }
        Shell shell = SearchDialog.shell;
        Intrinsics.checkNotNull((Object)shell);
        shell.setFocus();
    }

    private final void replaceAll() {
        String string;
        Manager manager = this.m = this.getRightManager();
        Intrinsics.checkNotNull((Object)manager);
        manager.waitForFormatting(true);
        Combo combo = this.findCombo;
        Intrinsics.checkNotNull((Object)combo);
        String string2 = combo.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        if (((CharSequence)string2).length() == 0) {
            Combo combo2 = this.replaceCombo;
            Intrinsics.checkNotNull((Object)combo2);
            String string3 = combo2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
            if (((CharSequence)string3).length() > 0) {
                new SearchNotices().invalidMessage(this.getParent(), "Cannot perform replace with empty find criteria!");
                return;
            }
        }
        Combo combo3 = this.replaceCombo;
        Intrinsics.checkNotNull((Object)combo3);
        String string4 = combo3.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
        if (((CharSequence)this.removeBlackBox(string4)).length() > 0) {
            Combo combo4 = this.replaceCombo;
            Intrinsics.checkNotNull((Object)combo4);
            String string5 = combo4.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getText(...)");
            string = this.removeBlackBox(string5);
        } else if (!this.sc.replaceHasAttributes()) {
            string = "";
        } else {
            Combo combo5 = this.findCombo;
            Intrinsics.checkNotNull((Object)combo5);
            String string6 = combo5.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getText(...)");
            string = this.removeBlackBox(string6);
        }
        String replaceName = string;
        Manager manager2 = this.m;
        Intrinsics.checkNotNull((Object)manager2);
        int index = manager2.getText().getView().getCaretOffset();
        Manager manager3 = this.m;
        Intrinsics.checkNotNull((Object)manager3);
        TextMapElement tme = manager3.getMapList().getClosest(index, true);
        Manager manager4 = this.m;
        Intrinsics.checkNotNull((Object)manager4);
        int section = manager4.getSection(tme);
        Intrinsics.checkNotNull((Object)tme);
        ViewState before = new ViewState(index, section, tme);
        this.sc.replaceString = replaceName;
        Combo combo6 = this.findCombo;
        Intrinsics.checkNotNull((Object)combo6);
        String string7 = combo6.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getText(...)");
        this.sc.findString = this.removeBlackBox(string7);
        Click click = this.click = new Click(this.sc, before, true);
        Intrinsics.checkNotNull((Object)click);
        if (!this.isValidClick(click)) {
            return;
        }
        Manager manager5 = this.m;
        Intrinsics.checkNotNull((Object)manager5);
        Click click2 = this.click;
        Intrinsics.checkNotNull((Object)click2);
        SearchController sr = new SearchController(manager5, click2);
        int numberReplaceAlls = sr.replaceAll();
        if (numberReplaceAlls == -1 && sr.getTableDoubles() < 1) {
            new SearchNotices().wordNotFoundMessage(this.getParent(), this.findCombo);
        }
        if (numberReplaceAlls > 0 || sr.getTableDoubles() > 0) {
            new SearchNotices().replaceAllMessage(this.getParent(), numberReplaceAlls, sr.getTableDoubles(), this.findCombo);
        }
    }

    private final String addBlackBox(String string) {
        String string2;
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)NB_SPACE, (boolean)false, (int)2, null)) {
            CharSequence charSequence = string;
            Regex regex = new Regex(NB_SPACE);
            String string3 = BLACK_BOX;
            string2 = regex.replace(charSequence, string3);
        } else {
            string2 = string;
        }
        return string2;
    }

    private final String removeBlackBox(String string) {
        String string2;
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)BLACK_BOX, (boolean)false, (int)2, null)) {
            CharSequence charSequence = string;
            Regex regex = new Regex(BLACK_BOX);
            String string3 = NB_SPACE;
            string2 = regex.replace(charSequence, string3);
        } else {
            string2 = string;
        }
        return string2;
    }

    @Nullable
    public final Shell getShell() {
        return shell;
    }

    private final void search() {
        Manager manager = this.m = this.getRightManager();
        Intrinsics.checkNotNull((Object)manager);
        manager.waitForFormatting(true);
        Manager manager2 = this.m;
        Intrinsics.checkNotNull((Object)manager2);
        int index = manager2.getText().getView().getCaretOffset();
        Manager manager3 = this.m;
        Intrinsics.checkNotNull((Object)manager3);
        TextMapElement tme = manager3.getMapList().getClosest(index, true);
        Manager manager4 = this.m;
        Intrinsics.checkNotNull((Object)manager4);
        int section = manager4.getSection(tme);
        Intrinsics.checkNotNull((Object)tme);
        ViewState before = new ViewState(index, section, tme);
        Manager manager5 = this.m;
        Intrinsics.checkNotNull((Object)manager5);
        if (manager5.getText().getCurrentElement() == null) {
            Manager manager6 = this.m;
            Intrinsics.checkNotNull((Object)manager6);
            TextView textView = manager6.getText();
            Manager manager7 = this.m;
            Intrinsics.checkNotNull((Object)manager7);
            textView.setCurrentElement(tme.getStart(manager7.getMapList()));
        }
        Combo combo = this.findCombo;
        Intrinsics.checkNotNull((Object)combo);
        String string = combo.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.sc.findString = this.removeBlackBox(string);
        this.sc.replaceString = null;
        Click click = this.click = new Click(this.sc, before, false);
        Intrinsics.checkNotNull((Object)click);
        if (!this.isValidClick(click)) {
            return;
        }
        Find find = this.findObj;
        Intrinsics.checkNotNull((Object)find);
        Manager manager8 = this.m;
        Intrinsics.checkNotNull((Object)manager8);
        Click click2 = this.click;
        Intrinsics.checkNotNull((Object)click2);
        boolean found = find.find(manager8, click2);
        if (!found && index == 0 && section == 0) {
            new SearchNotices().wordNotFoundMessage(this.getParent(), this.findCombo);
        } else if (!found) {
            SearchNotices searchNotices = new SearchNotices();
            Shell shell = this.getParent();
            Manager manager9 = this.m;
            Intrinsics.checkNotNull((Object)manager9);
            searchNotices.endOfDoc(shell, "beginning", manager9);
        } else {
            Shell shell = SearchDialog.shell;
            Intrinsics.checkNotNull((Object)shell);
            shell.setFocus();
        }
    }

    public final void repeatLastSearch() {
        if (this.m == null) {
            return;
        }
        Manager manager = this.m;
        Intrinsics.checkNotNull((Object)manager);
        manager.waitForFormatting(true);
        this.click = SavedSearches.getLastMemory();
        if (this.click == null) {
            Notify.notify$default(Notify.INSTANCE, SearchConstants.NO_SEARCHES_IN_MEMORY, Notify.ALERT_SHELL_NAME, false, 4, null);
            return;
        }
        Click click = this.click;
        Intrinsics.checkNotNull((Object)click);
        ViewState viewState = click.getInitialView();
        Manager manager2 = this.m;
        Intrinsics.checkNotNull((Object)manager2);
        viewState.cursorOffset = manager2.getTextView().getCaretOffset();
        Click click2 = this.click;
        Intrinsics.checkNotNull((Object)click2);
        ViewState viewState2 = click2.getInitialView();
        Manager manager3 = this.m;
        Intrinsics.checkNotNull((Object)manager3);
        MapList mapList = manager3.getMapList();
        Click click3 = this.click;
        Intrinsics.checkNotNull((Object)click3);
        TextMapElement textMapElement = mapList.getClosest(click3.getInitialView().cursorOffset, true);
        Intrinsics.checkNotNullExpressionValue((Object)textMapElement, (String)"getClosest(...)");
        viewState2.mapElement = textMapElement;
        Click click4 = this.click;
        Intrinsics.checkNotNull((Object)click4);
        ViewState viewState3 = click4.getInitialView();
        Manager manager4 = this.m;
        Intrinsics.checkNotNull((Object)manager4);
        Click click5 = this.click;
        Intrinsics.checkNotNull((Object)click5);
        viewState3.section = manager4.getSection(click5.getInitialView().mapElement);
        Manager manager5 = this.m;
        Intrinsics.checkNotNull((Object)manager5);
        if (manager5.getText().getCurrentElement() == null) {
            Manager manager6 = this.m;
            Intrinsics.checkNotNull((Object)manager6);
            TextView textView = manager6.getText();
            Click click6 = this.click;
            Intrinsics.checkNotNull((Object)click6);
            TextMapElement textMapElement2 = click6.getInitialView().mapElement;
            Manager manager7 = this.m;
            Intrinsics.checkNotNull((Object)manager7);
            textView.setCurrentElement(textMapElement2.getStart(manager7.getMapList()));
        }
        Click click7 = this.click;
        Intrinsics.checkNotNull((Object)click7);
        if (click7.isReplace()) {
            this.replace();
        } else {
            this.search();
        }
    }

    private final void loadSearchesIntoCombos() {
        int i;
        Combo combo = this.findCombo;
        Intrinsics.checkNotNull((Object)combo);
        combo.removeAll();
        int n = SavedSearches.findSize();
        for (i = 0; i < n; ++i) {
            Combo combo2 = this.findCombo;
            Intrinsics.checkNotNull((Object)combo2);
            String string = SavedSearches.findSavedSearches.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
            combo2.add(this.addBlackBox(string), 0);
        }
        if (!((Collection)SavedSearches.findSavedSearches).isEmpty()) {
            Combo combo3 = this.findCombo;
            Intrinsics.checkNotNull((Object)combo3);
            String string = SavedSearches.findSavedSearches.get(SavedSearches.findSavedSearches.size() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
            combo3.setText(this.addBlackBox(string));
        }
        Combo combo4 = this.replaceCombo;
        Intrinsics.checkNotNull((Object)combo4);
        combo4.removeAll();
        n = SavedSearches.replaceSize();
        for (i = 0; i < n; ++i) {
            Combo combo5 = this.replaceCombo;
            Intrinsics.checkNotNull((Object)combo5);
            String string = SavedSearches.replaceSavedSearches.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
            combo5.add(this.addBlackBox(string), 0);
        }
        if (!((Collection)SavedSearches.replaceSavedSearches).isEmpty()) {
            Combo combo6 = this.replaceCombo;
            Intrinsics.checkNotNull((Object)combo6);
            String string = SavedSearches.replaceSavedSearches.get(SavedSearches.replaceSavedSearches.size() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
            combo6.setText(this.addBlackBox(string));
        }
    }

    private static final void createBetterUI$lambda$0(SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void createBetterUI$lambda$1(SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void createBetterUI$lambda$2(SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void createBetterUI$lambda$3(Button $fwdButton, SearchDialog this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($fwdButton.getSelection()) {
            this$0.sc.setSearchForward(true);
        }
    }

    private static final void createBetterUI$lambda$4(SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void createBetterUI$lambda$5(Button $revButton, SearchDialog this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($revButton.getSelection()) {
            this$0.sc.setSearchForward(false);
        }
    }

    private static final void createBetterUI$lambda$6(SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void createBetterUI$lambda$7(SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void createBetterUI$lambda$8(SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void createBetterUI$lambda$9(SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void createBetterUI$lambda$10(SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void createBetterUI$lambda$11(SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void createBetterUI$lambda$12(SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void addStylesDropdown$lambda$0(SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final String addStylesDropdown$lambda$1(Style o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        LocaleHandler localeHandler = LocaleHandler.Companion.getBanaStyles$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null);
        String string = o.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return localeHandler.get(string);
    }

    private static final String addStylesDropdown$lambda$2(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final void addStylesDropdown$lambda$3(ComboViewer $styleComboViewer, Button $notCheckbox, SearchDialog this$0, boolean $isFind, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($styleComboViewer.getCombo().getSelectionIndex() > -1) {
            Object object = $styleComboViewer.getElementAt($styleComboViewer.getCombo().getSelectionIndex());
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.brailleblaster.utd.Style");
            String string = ((Style)object).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String name = string;
            LocaleHandler localeHandler = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null);
            Object object2 = $styleComboViewer.getElementAt($styleComboViewer.getCombo().getSelectionIndex());
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.brailleblaster.utd.Style");
            String string2 = ((Style)object2).getBaseStyleName();
            if (string2 == null) {
                String string3 = "Required value was null.";
                throw new IllegalArgumentException(string3.toString());
            }
            String display = localeHandler.get(string2);
            SearchCriteria.StyleFormatting sf = new SearchCriteria.StyleFormatting($notCheckbox.getSelection(), name, display);
            this$0.addToStyleList($isFind, sf, $notCheckbox.getSelection());
            Shell shell = SearchDialog.shell;
            Intrinsics.checkNotNull((Object)shell);
            shell.redraw();
            Shell shell2 = SearchDialog.shell;
            Intrinsics.checkNotNull((Object)shell2);
            shell2.layout();
            Shell shell3 = SearchDialog.shell;
            Intrinsics.checkNotNull((Object)shell3);
            shell3.pack();
        }
    }

    private static final void addEmphasisDropdown$lambda$0(SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void addEmphasisDropdown$lambda$1(SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void addEmphasisDropdown$lambda$2(Combo $emphasisCombo, SearchDialog this$0, boolean $isFind, Button $notCheckbox, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($emphasisCombo.getSelectionIndex() > -1) {
            String ef = $emphasisCombo.getItem($emphasisCombo.getSelectionIndex());
            Intrinsics.checkNotNull((Object)ef);
            this$0.addToEmphasisList($isFind, ef, $notCheckbox.getSelection());
            Shell shell = SearchDialog.shell;
            Intrinsics.checkNotNull((Object)shell);
            shell.redraw();
            Shell shell2 = SearchDialog.shell;
            Intrinsics.checkNotNull((Object)shell2);
            shell2.layout();
            Shell shell3 = SearchDialog.shell;
            Intrinsics.checkNotNull((Object)shell3);
            shell3.pack();
        }
    }

    private static final void addContainersDropdown$lambda$0(SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void addContainersDropdown$lambda$1(SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void addContainersDropdown$lambda$2(Combo $containersCombo, SearchDialog this$0, boolean $isFind, Button $notCheckbox, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($containersCombo.getSelectionIndex() > -1) {
            String cf = $containersCombo.getItem($containersCombo.getSelectionIndex());
            Intrinsics.checkNotNull((Object)cf);
            this$0.addToContainersList($isFind, cf, $notCheckbox.getSelection());
            Shell shell = SearchDialog.shell;
            Intrinsics.checkNotNull((Object)shell);
            shell.redraw();
            Shell shell2 = SearchDialog.shell;
            Intrinsics.checkNotNull((Object)shell2);
            shell2.layout();
            Shell shell3 = SearchDialog.shell;
            Intrinsics.checkNotNull((Object)shell3);
            shell3.pack();
        }
    }

    public static final /* synthetic */ void access$setM$p(SearchDialog $this, Manager manager) {
        $this.m = manager;
    }

    public static final /* synthetic */ Shell access$getShell$cp() {
        return shell;
    }

    public static final /* synthetic */ SearchCriteria access$getSc$p(SearchDialog $this) {
        return $this.sc;
    }

    public static final /* synthetic */ void access$search(SearchDialog $this) {
        $this.search();
    }

    public static final /* synthetic */ void access$replace(SearchDialog $this) {
        $this.replace();
    }

    public static final /* synthetic */ void access$replaceAll(SearchDialog $this) {
        $this.replaceAll();
    }

    public static final /* synthetic */ Find access$getFindObj$p(SearchDialog $this) {
        return $this.findObj;
    }

    public static final /* synthetic */ Replace access$getReplaceObj$p(SearchDialog $this) {
        return $this.replaceObj;
    }

    public static final /* synthetic */ Combo access$getFindCombo$p(SearchDialog $this) {
        return $this.findCombo;
    }

    public static final /* synthetic */ Combo access$getReplaceCombo$p(SearchDialog $this) {
        return $this.replaceCombo;
    }

    public static final /* synthetic */ org.eclipse.swt.widgets.List access$getFindList$p(SearchDialog $this) {
        return $this.findList;
    }

    public static final /* synthetic */ org.eclipse.swt.widgets.List access$getReplaceList$p(SearchDialog $this) {
        return $this.replaceList;
    }

    public static final /* synthetic */ void access$saveLocation(SearchDialog $this) {
        $this.saveLocation();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/brailleblaster/search/SearchDialog$Companion;", "", "<init>", "()V", "shell", "Lorg/eclipse/swt/widgets/Shell;", "NB_SPACE", "", "BLACK_BOX", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

