/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.BBXUtils;
import org.brailleblaster.bbx.BBXUtilsKt;
import org.brailleblaster.math.mathml.MathMLElement;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.AbstractMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.SectionElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TableTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.maps.MapList;
import org.brailleblaster.search.Click;
import org.brailleblaster.search.SavedSearches;
import org.brailleblaster.search.SearchController;
import org.brailleblaster.search.SearchUtils;
import org.brailleblaster.search.ViewControl$highlightMultipleElements$;
import org.brailleblaster.search.ViewState;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.utils.UTDHelper;
import org.brailleblaster.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rJ.\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bJ\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\u001dH\u0002J\u001a\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\r2\u0006\u0010\"\u001a\u00020\rH\u0002J\u001e\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\u00172\u000e\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u001dJ\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\r0\u001d2\u0006\u0010$\u001a\u00020\u0017J)\u0010*\u001a\u00020\r2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u00020\u0017\u00a2\u0006\u0002\u00100R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020\r0\u001d8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u00061"}, d2={"Lorg/brailleblaster/search/ViewControl;", "", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "click", "Lorg/brailleblaster/search/Click;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;Lorg/brailleblaster/search/Click;)V", "getM", "()Lorg/brailleblaster/perspectives/braille/Manager;", "getClick", "()Lorg/brailleblaster/search/Click;", "checkToReplaceCurrent", "Lnu/xom/Node;", "currentViewState", "Lorg/brailleblaster/search/ViewState;", "getCurrentViewState", "()Lorg/brailleblaster/search/ViewState;", "findNodeAndHighlight", "", "node", "highlightMultipleElements", "start", "", "end", "mapIndex", "list", "Lorg/brailleblaster/perspectives/braille/mapping/maps/MapList;", "removeBraille", "", "siblings", "parentChildRelationship", "", "child", "block", "findInSection", "section", "possiblesCorrectAttributes", "getNodeFromBeginning", "nodeFromCurrent", "getNodeFromCurrent", "()Ljava/util/List;", "acrossNodeReplace", "array", "", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "x", "y", "([Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;II)Lnu/xom/Node;", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nViewControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewControl.kt\norg/brailleblaster/search/ViewControl\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,357:1\n37#2,2:358\n479#3:360\n832#4:361\n862#4,2:362\n*S KotlinDebug\n*F\n+ 1 ViewControl.kt\norg/brailleblaster/search/ViewControl\n*L\n63#1:358,2\n142#1:360\n187#1:361\n187#1:362,2\n*E\n"})
public final class ViewControl {
    @NotNull
    private final Manager m;
    @NotNull
    private final Click click;

    public ViewControl(@NotNull Manager m, @NotNull Click click) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Intrinsics.checkNotNullParameter((Object)click, (String)"click");
        this.m = m;
        this.click = click;
    }

    @NotNull
    public final Manager getM() {
        return this.m;
    }

    @NotNull
    public final Click getClick() {
        return this.click;
    }

    @Nullable
    public final Node checkToReplaceCurrent() {
        String string = this.m.getTextView().getSelectionText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSelectionText(...)");
        if (((CharSequence)string).length() == 0) {
            return null;
        }
        Node current = this.m.getMapList().getClosest(this.m.getTextView().getCaretOffset(), true).getNode();
        int x = this.m.getTextView().getSelectionRange().x;
        int y = this.m.getTextView().getSelectionRange().y + x;
        Node node = current;
        Intrinsics.checkNotNull((Object)node);
        if (SearchUtils.checkUneditable(node)) {
            return null;
        }
        Set<TextMapElement> allElements = this.m.getAllTextMapElementsInRange(x, y);
        Intrinsics.checkNotNull(allElements);
        Collection $this$toTypedArray$iv = allElements;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        TextMapElement[] array = thisCollection$iv.toArray(new TextMapElement[0]);
        if (allElements.isEmpty()) {
            return null;
        }
        if (allElements.size() == 1) {
            TextMapElement textMapElement = array[0];
            Intrinsics.checkNotNull((Object)textMapElement);
            current = textMapElement.getNode();
        } else if (allElements.size() == 2) {
            TextMapElement textMapElement = array[1];
            Intrinsics.checkNotNull((Object)textMapElement);
            if (x == textMapElement.getEnd(this.m.getMapList())) {
                TextMapElement textMapElement2 = array[0];
                Intrinsics.checkNotNull((Object)textMapElement2);
                current = textMapElement2.getNode();
            } else {
                TextMapElement textMapElement3 = array[0];
                Intrinsics.checkNotNull((Object)textMapElement3);
                if (y == textMapElement3.getStart(this.m.getMapList())) {
                    TextMapElement textMapElement4 = array[1];
                    Intrinsics.checkNotNull((Object)textMapElement4);
                    current = textMapElement4.getNode();
                } else {
                    TextMapElement textMapElement5 = array[1];
                    Intrinsics.checkNotNull((Object)textMapElement5);
                    if (x == textMapElement5.getStart(this.m.getMapList())) {
                        TextMapElement textMapElement6 = array[1];
                        Intrinsics.checkNotNull((Object)textMapElement6);
                        current = textMapElement6.getNode();
                    }
                }
            }
        }
        Node node2 = current;
        Intrinsics.checkNotNull((Object)node2);
        if (SearchUtils.checkCorrectAttributes(node2, this.click)) {
            String string2 = this.m.getTextView().getSelectionText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSelectionText(...)");
            if (SearchUtils.matchPhrase(string2, this.click, false).hasNext()) {
                if (SavedSearches.getLastMemory() != null) {
                    Click click = SavedSearches.getLastMemory();
                    Intrinsics.checkNotNull((Object)click);
                    if (click.getReplaced() != null) {
                        Click click2 = SavedSearches.getLastMemory();
                        Intrinsics.checkNotNull((Object)click2);
                        ViewState viewState = click2.getReplaced();
                        Intrinsics.checkNotNull((Object)viewState);
                        if (Intrinsics.areEqual((Object)current, (Object)viewState.mapElement.getNode())) {
                            Click click3 = SavedSearches.getLastMemory();
                            Intrinsics.checkNotNull((Object)click3);
                            ViewState viewState2 = click3.getReplaced();
                            Intrinsics.checkNotNull((Object)viewState2);
                            if (x != viewState2.cursorOffset) {
                                return current;
                            }
                        } else {
                            return current;
                        }
                    }
                }
                return current;
            }
        }
        return null;
    }

    @NotNull
    public final ViewState getCurrentViewState() {
        int index = this.m.getTextView().getCaretOffset();
        TextMapElement mapElement = this.m.getMapList().getClosest(index, true);
        int section = this.m.getSection(mapElement.getNode());
        Intrinsics.checkNotNull((Object)mapElement);
        return new ViewState(index, section, mapElement);
    }

    public final void findNodeAndHighlight(@NotNull Node node) {
        int startSection;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        int n = this.m.getSectionList().size();
        for (int i = startSection = this.click.getInitialView().section; i < n; ++i) {
            SectionElement section = this.m.getSectionList().get(i);
            MapList list = section.list;
            int listSize = list.size();
            for (int j = 0; j < listSize; ++j) {
                Object e = list.get(j);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                TextMapElement mapElement = (TextMapElement)e;
                if (mapElement.getNode() == null || !Intrinsics.areEqual((Object)mapElement.getNode(), (Object)node)) continue;
                if (!section.isVisible()) {
                    this.m.useResetSectionMethod(i);
                    this.m.getMapList().setCurrent(0);
                    this.m.waitForFormatting(true);
                }
                if ((this.click.getSettings().findHasStyle() || this.click.getSettings().findHasContainer()) && !this.click.getSettings().findHasEmphasis()) {
                    this.highlightMultipleElements(node, mapElement.getStart(this.m.getMapList()), mapElement.getEnd(this.m.getMapList()), j, list);
                } else {
                    this.m.getTextView().setTopIndex(this.m.getTextView().getLineAtOffset(mapElement.getStart(this.m.getMapList())));
                    this.m.getText().highlight(mapElement.getStart(this.m.getMapList()), mapElement.getEnd(this.m.getMapList()));
                }
                return;
            }
        }
    }

    public final void highlightMultipleElements(@NotNull Node node, int start, int end, int mapIndex, @NotNull MapList list) {
        Node block;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        int curEnd = end;
        for (block = node; block != null && !BBX.BLOCK.isA(block); block = (Node)block.getParent()) {
        }
        if (block == null) {
            SearchController.Companion.logIt("Node unattached to document");
            return;
        }
        Sequence $this$filterIsInstance$iv = FastXPath.following((Node)node);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)highlightMultipleElements$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        List<Node> siblings = SequencesKt.toList((Sequence)sequence);
        siblings = this.removeBraille((List<? extends Node>)siblings);
        if (!((Collection)siblings).isEmpty()) {
            boolean unexaminedChildren = true;
            int siblingsExamined = 0;
            Node previous = node;
            while (unexaminedChildren && siblingsExamined < siblings.size()) {
                Node child = siblings.get(siblingsExamined);
                if (this.parentChildRelationship(child, block)) {
                    ++siblingsExamined;
                } else {
                    unexaminedChildren = false;
                    if (!Intrinsics.areEqual((Object)previous, (Object)node)) {
                        int n = list.size();
                        for (int j = mapIndex; j < n; ++j) {
                            Object e = list.get(j);
                            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                            TextMapElement mapElement = (TextMapElement)e;
                            if (mapElement.getNode() == null || !Intrinsics.areEqual((Object)mapElement.getNode(), (Object)previous)) continue;
                            curEnd = mapElement.getEnd(this.m.getMapList());
                        }
                    }
                }
                previous = child;
            }
            if (unexaminedChildren) {
                SearchController.log.debug("Last child of parent included in sibling text condensation");
                if (!Intrinsics.areEqual((Object)previous, (Object)node)) {
                    int n = list.size();
                    for (int j = mapIndex; j < n; ++j) {
                        Object e = list.get(j);
                        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                        TextMapElement mapElement = (TextMapElement)e;
                        if (!Intrinsics.areEqual((Object)mapElement.getNode(), (Object)previous)) continue;
                        curEnd = mapElement.getEnd(this.m.getMapList());
                    }
                }
            }
        }
        this.m.getTextView().setTopIndex(this.m.getTextView().getLineAtOffset(start));
        this.m.getText().highlight(start, curEnd);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Node> removeBraille(List<? extends Node> siblings) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = siblings;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Node it = (Node)element$iv$iv;
            boolean bl = false;
            if (XMLHandler.Companion.ancestorElementIs(it, ViewControl::removeBraille$lambda$0$0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean parentChildRelationship(Node child, Node block) {
        for (Node node = child; node != null; node = (Node)node.getParent()) {
            if (!Intrinsics.areEqual((Object)block, (Object)node)) continue;
            return true;
        }
        return false;
    }

    public final boolean findInSection(int section, @NotNull List<? extends Node> possiblesCorrectAttributes) {
        Intrinsics.checkNotNullParameter(possiblesCorrectAttributes, (String)"possiblesCorrectAttributes");
        int buffer = 0;
        String view = null;
        if (section == this.click.getInitialView().section) {
            String string = this.m.getTextView().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = string;
            int n = this.m.getTextView().getCaretOffset();
            int n2 = this.m.getTextView().getCharCount();
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            view = string3;
            buffer = this.m.getTextView().getCaretOffset();
        } else {
            SearchController.Companion.logIt(" resetting to " + section);
            this.m.useResetSectionMethod(section);
            this.m.waitForFormatting(true);
            this.m.getMapList().setCurrent(0);
            String string = this.m.getTextView().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            view = string;
        }
        SearchUtils.MatchObject match = SearchUtils.matchPhrase(view, this.click, false);
        while (match.hasNext()) {
            SearchUtils.StartEndPair pair = match.getNext();
            SearchController.Companion.logIt(" looking at match pair " + this.m.getTextView().getText(pair.start + buffer, pair.end + buffer) + " at " + pair.start + buffer + ", " + pair.end + buffer);
            Set<TextMapElement> list = this.m.getMapList().getElementInSelectedRange(pair.start + buffer, pair.end + buffer);
            boolean current = true;
            for (TextMapElement mapElement : list) {
                if (possiblesCorrectAttributes.contains(mapElement.getNode()) || mapElement instanceof TableTextMapElement || mapElement instanceof MathMLElement) continue;
                current = false;
                break;
            }
            if (!current) continue;
            this.m.getTextView().setTopIndex(this.m.getTextView().getLineAtOffset(pair.start + buffer));
            SearchController.Companion.logIt("highlighting match pair " + this.m.getTextView().getText(pair.start + buffer, pair.end + buffer));
            this.m.getText().highlight(pair.start + buffer, pair.end + buffer);
            return true;
        }
        return false;
    }

    @NotNull
    public final List<Node> getNodeFromBeginning(int section) {
        List array = new ArrayList();
        SectionElement sectionElement = this.m.getSectionList().get(section);
        MapList maplist = sectionElement.list;
        Iterator iterator = maplist.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            TextMapElement textMapElement = (TextMapElement)iterator2.next();
            if (textMapElement.getNode() == null) continue;
            Node node = textMapElement.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
            array.add(node);
        }
        return array;
    }

    @NotNull
    public final List<Node> getNodeFromCurrent() {
        int currentIndex;
        List array = new ArrayList();
        MapList maplist = this.m.getMapList();
        int n = maplist.size();
        for (int i = currentIndex = this.m.getMapList().getNodeIndex(this.m.getMapList().getClosest(this.m.getTextView().getCaretOffset(), true)); i < n; ++i) {
            if (((TextMapElement)maplist.get(i)).getNode() == null) continue;
            Node node = ((TextMapElement)maplist.get(i)).getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
            array.add(node);
        }
        return array;
    }

    @NotNull
    public final Node acrossNodeReplace(@NotNull TextMapElement[] array, int x, int y) {
        String string22;
        Object textMapElement;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        StringBuilder sBefore = new StringBuilder();
        StringBuilder sTheNode = new StringBuilder();
        StringBuilder sAfter = new StringBuilder();
        boolean pastX = false;
        boolean pastY = false;
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            textMapElement = array[i];
            int start = ((AbstractMapElement)textMapElement).getStart(this.m.getMapList());
            int end2 = ((AbstractMapElement)textMapElement).getEnd(this.m.getMapList());
            if (end2 < 1) {
                SearchController.log.debug("Text node is one character.");
                continue;
            }
            string22 = this.m.getTextView().getText(start, end2 - 1);
            if (!pastY) {
                if (end2 >= y) {
                    sTheNode.append(string22, 0, y - start);
                    Intrinsics.checkNotNull((Object)string22);
                    String string = string22.substring(y - start);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    sAfter.append(string);
                    pastY = true;
                    continue;
                }
                if (pastX) continue;
                if (end2 >= x) {
                    sBefore.append(string22, 0, x - start);
                    Intrinsics.checkNotNull((Object)string22);
                    String string = string22.substring(x - start);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    sTheNode.append(string);
                    pastX = true;
                    continue;
                }
                sBefore.append(string22);
                continue;
            }
            if (pastX) continue;
            if (end2 >= x) {
                sBefore.append(string22, 0, end2 - x);
                Intrinsics.checkNotNull((Object)string22);
                String string = string22.substring(end2 - x);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                sTheNode.append(string);
                pastX = true;
                continue;
            }
            sBefore.append(string22);
        }
        String string = sBefore.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        CharSequence charSequence = string;
        textMapElement = new Regex("\r");
        CharSequence start = "";
        charSequence = textMapElement.replace(charSequence, start);
        textMapElement = new Regex("\n");
        start = "";
        Text before = new Text(textMapElement.replace(charSequence, start));
        String string3 = sTheNode.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        textMapElement = string3;
        start = new Regex("\r");
        String end2 = "";
        textMapElement = start.replace((CharSequence)textMapElement, end2);
        start = new Regex("\n");
        end2 = "";
        Text theNode = new Text(start.replace((CharSequence)textMapElement, end2));
        String string4 = sAfter.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        start = string4;
        end2 = new Regex("\r");
        string22 = "";
        start = end2.replace(start, string22);
        end2 = new Regex("\n");
        string22 = "";
        Text after = new Text(end2.replace(start, string22));
        List blocks = new ArrayList();
        int string22 = array.length;
        for (int end2 = 0; end2 < string22; ++end2) {
            TextMapElement textMapElement2 = array[end2];
            Node node = textMapElement2.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
            Element block = BBXUtilsKt.findBlock(node);
            if (blocks.contains(block)) continue;
            blocks.add(block);
        }
        Element parent = (Element)blocks.get(0);
        Node node = array[0].getNode();
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
        int index = BBXUtils.INSTANCE.getIndexInBlock(node);
        String string5 = before.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getValue(...)");
        if (((CharSequence)string5).length() > 0) {
            Utils.insertChildCountSafe((ParentNode)parent, (Node)before, index++);
        }
        Utils.insertChildCountSafe((ParentNode)parent, (Node)theNode, index++);
        String string6 = after.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getValue(...)");
        if (((CharSequence)string6).length() > 0) {
            Utils.insertChildCountSafe((ParentNode)parent, (Node)after, index);
        }
        for (TextMapElement tme : array) {
            tme.getNode().detach();
        }
        UTDHelper.stripUTDRecursive((Element)parent);
        if (blocks.size() > 1) {
            for (Element block : blocks) {
                UTDHelper.stripUTDRecursive((Element)block);
                int n2 = block.getChildCount();
                int n3 = 0;
                while (n3 < n2) {
                    int it = n3++;
                    boolean bl = false;
                    Node n4 = block.getChild(0);
                    n4.detach();
                    parent.appendChild(n4);
                }
            }
        }
        return (Node)theNode;
    }

    private static final boolean removeBraille$lambda$0$0(Element obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return SearchUtils.isBraille((Node)obj);
    }
}

