/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.settings;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.brailleblaster.BBIni;
import org.brailleblaster.exceptions.BBRuntimeException;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.settings.MathTranslationSettings;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.utd.BrailleSettings;
import org.brailleblaster.util.ConstantsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0005H\u0007J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0005H\u0007J\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0012\u0010!\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006#"}, d2={"Lorg/brailleblaster/settings/TableExceptions;", "", "<init>", "()V", "EXCEPTIONS_TABLE_EXTENSION", "", "UNIVERSAL_EXCEPTION_FILE_HEADING", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "mainTranslationStandardFile", "Ljava/io/File;", "MATH_TRANSLATION_STANDARD_FILE", "TEST_EXCEPTION_FILE", "KEEP_TEST_DATA", "", "MATH_EXCEPTION_TABLES", "generateExceptionsTables", "", "engine", "Lorg/brailleblaster/settings/UTDManager$BBUTDTranslationEngine;", "forTesting", "brailleStandard", "getTranslationExceptionFile", "settings", "Lorg/brailleblaster/utd/BrailleSettings;", "getMathTranslationExceptionFile", "testExceptionFile", "getTestExceptionFile", "()Ljava/io/File;", "getCurrentStandardName", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "getCurrentExceptionFile", "getCurrentExceptionTable", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nTableExceptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableExceptions.kt\norg/brailleblaster/settings/TableExceptions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n1#2:192\n*E\n"})
public final class TableExceptions {
    @NotNull
    public static final TableExceptions INSTANCE = new TableExceptions();
    @NotNull
    public static final String EXCEPTIONS_TABLE_EXTENSION = "-bb-exceptions.ctb";
    @JvmField
    @NotNull
    public static String UNIVERSAL_EXCEPTION_FILE_HEADING = "# Translation exception table " + ConstantsKt.getLINE_BREAK() + "# for users of brailleblaster " + ConstantsKt.getLINE_BREAK() + "sign \\xf000 4-46-126 transcriber start indicator" + ConstantsKt.getLINE_BREAK() + "sign \\xf001 4-46-354 transcriber end indicator";
    private static final Logger log = LoggerFactory.getLogger(TableExceptions.class);
    @Nullable
    private static File mainTranslationStandardFile;
    @Nullable
    private static File MATH_TRANSLATION_STANDARD_FILE;
    @Nullable
    private static File TEST_EXCEPTION_FILE;
    @JvmField
    public static boolean KEEP_TEST_DATA;
    @JvmField
    public static boolean MATH_EXCEPTION_TABLES;

    private TableExceptions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void generateExceptionsTables(@NotNull UTDManager.BBUTDTranslationEngine engine, boolean forTesting, @NotNull String brailleStandard) {
        File mathExceptionsTableFile;
        Object object;
        Object oldTable2;
        Intrinsics.checkNotNullParameter((Object)((Object)engine), (String)"engine");
        Intrinsics.checkNotNullParameter((Object)brailleStandard, (String)"brailleStandard");
        File exceptionsTableFile = null;
        if (forTesting) {
            try {
                File file = exceptionsTableFile = INSTANCE.getTestExceptionFile();
                Intrinsics.checkNotNull((Object)file);
                if (!file.exists()) {
                    log.debug("Making exceptions table {}", (Object)exceptionsTableFile);
                    exceptionsTableFile.getParentFile().mkdirs();
                }
                try {
                    Closeable closeable = new PrintWriter(exceptionsTableFile);
                    Throwable throwable = null;
                    try {
                        PrintWriter writer = (PrintWriter)closeable;
                        boolean bl = false;
                        writer.println(UNIVERSAL_EXCEPTION_FILE_HEADING);
                        writer = Unit.INSTANCE;
                    }
                    catch (Throwable bl) {
                        throwable = bl;
                        throw bl;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (Exception e) {
                    throw new BBRuntimeException("Can't create file " + exceptionsTableFile, (Throwable)e, new Object[0]);
                }
                String translationTable = engine.getBrailleSettings().getMainTranslationTable();
                log.info("Table before " + translationTable);
                int lastTableStart = StringsKt.lastIndexOf$default((CharSequence)translationTable, (char)',', (int)0, (boolean)false, (int)6, null);
                String string = translationTable.substring(lastTableStart + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String oldTable2 = string;
                if (!StringsKt.contains$default((CharSequence)oldTable2, (CharSequence)"/", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)oldTable2, (CharSequence)"\\", (boolean)false, (int)2, null)) {
                    throw new RuntimeException("Not removing exceptions table? " + oldTable2 + " for " + translationTable);
                }
                engine.getBrailleSettings().setMainTranslationTable(StringsKt.take((String)translationTable, (int)lastTableStart) + "," + exceptionsTableFile.getAbsolutePath());
                log.info("Reset exceptions table to " + engine.getBrailleSettings().getMainTranslationTable());
                TEST_EXCEPTION_FILE = exceptionsTableFile;
                mainTranslationStandardFile = exceptionsTableFile;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to rebuild exceptions table", e);
            }
        }
        BrailleSettings brailleSettings = engine.getBrailleSettings();
        File file = exceptionsTableFile = TableExceptions.getTranslationExceptionFile(brailleSettings, brailleStandard);
        Intrinsics.checkNotNull((Object)file);
        if (!file.exists()) {
            log.debug("Making exceptions table {}", (Object)exceptionsTableFile);
            exceptionsTableFile.getParentFile().mkdirs();
            try {
                Closeable lastTableStart = new PrintWriter(exceptionsTableFile);
                oldTable2 = null;
                try {
                    PrintWriter writer = (PrintWriter)lastTableStart;
                    boolean bl = false;
                    writer.println(UNIVERSAL_EXCEPTION_FILE_HEADING);
                    object = Unit.INSTANCE;
                }
                catch (Throwable bl) {
                    oldTable2 = bl;
                    throw bl;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)lastTableStart, (Throwable)oldTable2);
                }
            }
            catch (Exception e) {
                throw new BBRuntimeException("Can't create file " + exceptionsTableFile, (Throwable)e, new Object[0]);
            }
        }
        log.debug("BB Exceptions Table {}", (Object)exceptionsTableFile.getAbsolutePath());
        brailleSettings.setMainTranslationTable(brailleSettings.getMainTranslationTable() + "," + exceptionsTableFile);
        mainTranslationStandardFile = exceptionsTableFile;
        File file2 = mathExceptionsTableFile = INSTANCE.getMathTranslationExceptionFile(brailleSettings, brailleStandard);
        Intrinsics.checkNotNull((Object)file2);
        if (!file2.exists()) {
            log.debug("Making exceptions table {}", (Object)mathExceptionsTableFile);
            mathExceptionsTableFile.getParentFile().mkdirs();
            try {
                oldTable2 = new PrintWriter(mathExceptionsTableFile);
                object = null;
                try {
                    PrintWriter writer = (PrintWriter)oldTable2;
                    boolean bl = false;
                    writer.println(UNIVERSAL_EXCEPTION_FILE_HEADING);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)oldTable2, (Throwable)object);
                }
            }
            catch (Exception e) {
                throw new BBRuntimeException("Can't create file " + mathExceptionsTableFile, (Throwable)e, new Object[0]);
            }
        }
        brailleSettings.setMathExpressionTable(brailleSettings.getMathExpressionTable() + "," + mathExceptionsTableFile);
        MATH_TRANSLATION_STANDARD_FILE = mathExceptionsTableFile;
    }

    @JvmStatic
    @Nullable
    public static final File getTranslationExceptionFile(@NotNull BrailleSettings settings, @NotNull String brailleStandard) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)brailleStandard, (String)"brailleStandard");
        if (TEST_EXCEPTION_FILE != null && KEEP_TEST_DATA) {
            return TEST_EXCEPTION_FILE;
        }
        String exceptionsTableName = brailleStandard + EXCEPTIONS_TABLE_EXTENSION;
        String[] stringArray = new String[]{"liblouis", "tables", exceptionsTableName};
        return BBIni.INSTANCE.getUserProgramDataFile(stringArray);
    }

    private final File getMathTranslationExceptionFile(BrailleSettings settings, String brailleStandard) {
        if (TEST_EXCEPTION_FILE != null && KEEP_TEST_DATA) {
            return TEST_EXCEPTION_FILE;
        }
        String math = MathTranslationSettings.INSTANCE.getMathTable(settings);
        String exceptionsTableName = math + EXCEPTIONS_TABLE_EXTENSION;
        String[] stringArray = new String[]{"liblouis", "tables", exceptionsTableName};
        return BBIni.INSTANCE.getUserProgramDataFile(stringArray);
    }

    private final File getTestExceptionFile() {
        File file = null;
        try {
            file = File.createTempFile("bbTest", "utd-bb-exceptions.ctb");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    @JvmStatic
    @NotNull
    public static final String getCurrentStandardName(@NotNull Manager m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        return MathModuleUtils.isMath(m.getMapList().getCurrent().getNode()) && MATH_EXCEPTION_TABLES ? MathTranslationSettings.INSTANCE.getMathTable(m.getDocument().getSettingsManager().getEngine().getBrailleSettings()) : m.getDocument().getSettingsManager().getBrailleStandard();
    }

    @JvmStatic
    @Nullable
    public static final File getCurrentExceptionFile(@NotNull Manager m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        return MathModuleUtils.isMath(m.getMapList().getCurrent().getNode()) && MATH_EXCEPTION_TABLES ? MATH_TRANSLATION_STANDARD_FILE : mainTranslationStandardFile;
    }

    @JvmStatic
    @NotNull
    public static final String getCurrentExceptionTable(@NotNull Manager m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        return MathModuleUtils.isMath(m.getMapList().getCurrent().getNode()) && MATH_EXCEPTION_TABLES ? m.getDocument().getSettingsManager().getEngine().getBrailleSettings().getMathExpressionTable() : m.getDocument().getSettingsManager().getEngine().getBrailleSettings().getMainTranslationTable();
    }
}

