/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.settings;

import ch.qos.logback.classic.Level;
import com.google.common.base.CaseFormat;
import java.io.File;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.BBIni;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.BBXUtils;
import org.brailleblaster.bbx.fixers.NodeTreeSplitter;
import org.brailleblaster.bbx.utd.BBXDynamicOptionStyleMap;
import org.brailleblaster.bbx.utd.BBXStyleMap;
import org.brailleblaster.libembosser.spi.BrlCell;
import org.brailleblaster.logging.LogUtils;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.settings.PredominantQuoteSetting;
import org.brailleblaster.settings.TableExceptions;
import org.brailleblaster.utd.ActionMap;
import org.brailleblaster.utd.ActionMultiMap;
import org.brailleblaster.utd.IActionMap;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.IStyleMap;
import org.brailleblaster.utd.OverrideMap;
import org.brailleblaster.utd.PageSettings;
import org.brailleblaster.utd.Style;
import org.brailleblaster.utd.StyleMap;
import org.brailleblaster.utd.StyleMultiMap;
import org.brailleblaster.utd.UTDTranslationEngine;
import org.brailleblaster.utd.actions.IAction;
import org.brailleblaster.utd.config.DocumentUTDConfig;
import org.brailleblaster.utd.config.StyleDefinitions;
import org.brailleblaster.utd.config.UTDConfig;
import org.brailleblaster.utd.exceptions.NodeException;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mwhapples.jlouis.Louis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 h2\u00020\u0001:\u0002ghB\u0013\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u00107\u001a\u00020\u0007H\u0002J\u0016\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u000bJ,\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010=\u001a\u00020>2\b\u0010?\u001a\u0004\u0018\u00010@2\b\u00104\u001a\u0004\u0018\u00010>H\u0002J\u0006\u0010A\u001a\u000209J\u0006\u0010B\u001a\u000209J\u0018\u0010C\u001a\u0002092\b\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010F\u001a\u00020GJ$\u0010C\u001a\u0002092\b\u0010D\u001a\u0004\u0018\u00010E2\b\u0010F\u001a\u0004\u0018\u00010G2\b\u0010:\u001a\u0004\u0018\u00010;J\u000e\u0010H\u001a\u00020G2\u0006\u0010F\u001a\u00020GJ\u0018\u0010I\u001a\u0002092\b\u0010J\u001a\u0004\u0018\u00010\u00172\u0006\u0010F\u001a\u00020GJ0\u0010I\u001a\u0002092\b\u0010J\u001a\u0004\u0018\u00010\u00172\b\u0010F\u001a\u0004\u0018\u00010G2\b\u0010:\u001a\u0004\u0018\u00010;2\b\b\u0002\u0010K\u001a\u00020LH\u0007J\u0012\u0010M\u001a\u0004\u0018\u00010N2\u0006\u0010F\u001a\u00020NH\u0002J\u0012\u0010O\u001a\u0004\u0018\u00010N2\u0006\u0010F\u001a\u00020NH\u0002J\u0018\u0010P\u001a\u00020G2\u0006\u0010Q\u001a\u00020G2\u0006\u0010R\u001a\u00020GH\u0002J\u000e\u0010S\u001a\u00020G2\u0006\u0010F\u001a\u00020GJ&\u0010T\u001a\u00020\u00172\u0006\u0010U\u001a\u00020\u00172\u0006\u0010V\u001a\u00020W2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010F\u001a\u00020GJ\u0016\u0010X\u001a\u00020\u000b2\u0006\u0010Y\u001a\u00020\u000b2\u0006\u0010Z\u001a\u00020NJ\u0016\u0010[\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010\\\u001a\u00020\u000bJ\u0016\u0010]\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010^\u001a\u00020\u0010J\u000e\u0010_\u001a\u0002092\u0006\u0010\\\u001a\u00020\u000bJ\u0018\u0010d\u001a\u00020L2\b\u0010Z\u001a\u0004\u0018\u00010N2\u0006\u0010Y\u001a\u00020\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001c\u0010%\u001a\u0004\u0018\u00010&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001c\u0010+\u001a\u0004\u0018\u00010,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001c\u00101\u001a\u0004\u0018\u00010,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010.\"\u0004\b3\u00100R\u001c\u00104\u001a\u0004\u0018\u00010,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010.\"\u0004\b6\u00100R\u0011\u0010`\u001a\u00020a8F\u00a2\u0006\u0006\u001a\u0004\bb\u0010cR\u0013\u0010e\u001a\u0004\u0018\u00010a8F\u00a2\u0006\u0006\u001a\u0004\bf\u0010c\u00a8\u0006i"}, d2={"Lorg/brailleblaster/settings/UTDManager;", "", "styleDefs", "Lorg/brailleblaster/utd/config/StyleDefinitions;", "<init>", "(Lorg/brailleblaster/utd/config/StyleDefinitions;)V", "engine", "Lorg/brailleblaster/settings/UTDManager$BBUTDTranslationEngine;", "getEngine", "()Lorg/brailleblaster/settings/UTDManager$BBUTDTranslationEngine;", "value", "", "brailleStandard", "getBrailleStandard", "()Ljava/lang/String;", "predominantQuoteSetting", "Lorg/brailleblaster/settings/PredominantQuoteSetting;", "getPredominantQuoteSetting", "()Lorg/brailleblaster/settings/PredominantQuoteSetting;", "setPredominantQuoteSetting", "(Lorg/brailleblaster/settings/PredominantQuoteSetting;)V", "origStyleDefs", "", "Lorg/brailleblaster/utd/Style;", "bookTypeStyleMap", "Lorg/brailleblaster/utd/IStyleMap;", "overrideStyleMap", "getOverrideStyleMap", "()Lorg/brailleblaster/utd/IStyleMap;", "setOverrideStyleMap", "(Lorg/brailleblaster/utd/IStyleMap;)V", "bbxStyleMap", "Lorg/brailleblaster/bbx/utd/BBXStyleMap;", "getBbxStyleMap", "()Lorg/brailleblaster/bbx/utd/BBXStyleMap;", "setBbxStyleMap", "(Lorg/brailleblaster/bbx/utd/BBXStyleMap;)V", "bbxOptionStyleMap", "Lorg/brailleblaster/bbx/utd/BBXDynamicOptionStyleMap;", "getBbxOptionStyleMap", "()Lorg/brailleblaster/bbx/utd/BBXDynamicOptionStyleMap;", "setBbxOptionStyleMap", "(Lorg/brailleblaster/bbx/utd/BBXDynamicOptionStyleMap;)V", "bookTypeActionMap", "Lorg/brailleblaster/utd/IActionMap;", "getBookTypeActionMap", "()Lorg/brailleblaster/utd/IActionMap;", "setBookTypeActionMap", "(Lorg/brailleblaster/utd/IActionMap;)V", "overrideActionMap", "getOverrideActionMap", "setOverrideActionMap", "mathMap", "getMathMap", "setMathMap", "newEngine", "loadEngineFromDoc", "", "doc", "Lnu/xom/Document;", "bookType", "actionMap", "Lorg/brailleblaster/utd/ActionMap;", "styleMap", "Lorg/brailleblaster/utd/StyleMap;", "reloadMapsFromDoc", "testSetup", "applyAction", "action", "Lorg/brailleblaster/utd/actions/IAction;", "element", "Lnu/xom/Element;", "removeOverrideAction", "applyStyle", "style", "stripStyle", "", "getPreviousBBXSiblingNode", "Lnu/xom/Node;", "getNextBBXSiblingNode", "mergeContainers", "containerOne", "containerTwo", "removeOverrideStyle", "applyStyleWithOption", "curStyle", "styleOption", "Lorg/brailleblaster/utd/Style$StyleOption;", "getBaseStyle", "styleName", "node", "updateBrailleStandard", "std", "updatePredominantQuote", "pq", "applyBrailleStandard", "userShortcutDefinitionsFile", "Ljava/io/File;", "getUserShortcutDefinitionsFile", "()Ljava/io/File;", "hasStyle", "exceptionsTableFile", "getExceptionsTableFile", "BBUTDTranslationEngine", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nUTDManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UTDManager.kt\norg/brailleblaster/settings/UTDManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,730:1\n1807#2,3:731\n*S KotlinDebug\n*F\n+ 1 UTDManager.kt\norg/brailleblaster/settings/UTDManager\n*L\n221#1:731,3\n*E\n"})
public final class UTDManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BBUTDTranslationEngine engine;
    @NotNull
    private String brailleStandard;
    @NotNull
    private PredominantQuoteSetting predominantQuoteSetting;
    @NotNull
    private final List<Style> origStyleDefs;
    @Nullable
    private IStyleMap bookTypeStyleMap;
    @Nullable
    private IStyleMap overrideStyleMap;
    @Nullable
    private BBXStyleMap bbxStyleMap;
    @Nullable
    private BBXDynamicOptionStyleMap bbxOptionStyleMap;
    @Nullable
    private IActionMap bookTypeActionMap;
    @Nullable
    private IActionMap overrideActionMap;
    @Nullable
    private IActionMap mathMap;
    @JvmField
    @NotNull
    public static Consumer<UTDTranslationEngine> benchmarkCallback = UTDManager::benchmarkCallback$lambda$0;
    private static final Logger log = LoggerFactory.getLogger(UTDManager.class);
    @NotNull
    public static final String UTD_FOLDER = "utd";
    @NotNull
    public static final String STYLE_DEFS_NAME = "styleDefs.xml";
    @NotNull
    private static final String SHORTCUT_DEFS_NAME = "shortcutDefs.xml";
    @NotNull
    public static final String BRAILLE_SETTINGS_NAME = ".brailleSettings.xml";
    @NotNull
    private static final String PAGE_SETTINGS_NAME = "pageSettings.xml";
    @NotNull
    public static final String USER_SETTINGS_BRAILLE_STANDARD = "brailleStandard";
    @NotNull
    public static final String USER_SETTINGS_PREDOMINANT_QUOTE = "predominantQuote";
    @NotNull
    public static final String USER_SETTINGS_FORMAT_STANDARD = "formatStandard";
    @NotNull
    public static final String DOCUMENT_STYLE_NAME_PREFIX = "bbs-";
    private static long totalMilliLoad;

    @JvmOverloads
    public UTDManager(@NotNull StyleDefinitions styleDefs2) {
        Intrinsics.checkNotNullParameter((Object)styleDefs2, (String)"styleDefs");
        this.brailleStandard = BBIni.getPropertyFileManager().getProperty(USER_SETTINGS_BRAILLE_STANDARD, "UEB");
        PredominantQuoteSetting predominantQuoteSetting = PredominantQuoteSetting.Companion.findValue(BBIni.getPropertyFileManager().getProperty(USER_SETTINGS_PREDOMINANT_QUOTE, ""));
        if (predominantQuoteSetting == null) {
            predominantQuoteSetting = PredominantQuoteSetting.Companion.getDEFAULT_SETTING();
        }
        this.predominantQuoteSetting = predominantQuoteSetting;
        this.engine = this.newEngine();
        Louis translator = this.engine.getBrailleTranslator();
        log.debug("Initting engine");
        if (translator.getDataPath() == null) {
            String[] stringArray = new String[]{"mwhapples", "jlouis", "tables"};
            String programTablesPath = ((Object)BBIni.getProgramDataPath().resolve(Paths.get("org", stringArray))).toString();
            translator.setDataPath(BBIni.getUserProgramDataPath() + "," + programTablesPath);
        }
        log.debug("Liblouis data path: " + translator.getDataPath());
        this.origStyleDefs = CollectionsKt.toList((Iterable)styleDefs2.getStyles());
        this.engine.setStyleDefinitions(styleDefs2);
        Level level = LogUtils.getLogLevel$default(null, 1, null);
        if (Intrinsics.areEqual((Object)level, (Object)Level.ERROR)) {
            translator.setLogLevel(40000);
        } else if (Intrinsics.areEqual((Object)level, (Object)Level.WARN)) {
            translator.setLogLevel(30000);
        } else if (Intrinsics.areEqual((Object)level, (Object)Level.INFO)) {
            translator.setLogLevel(20000);
        } else if (Intrinsics.areEqual((Object)level, (Object)Level.DEBUG)) {
            translator.setLogLevel(10000);
        } else {
            translator.setLogLevel(Integer.MIN_VALUE);
        }
    }

    public /* synthetic */ UTDManager(StyleDefinitions styleDefinitions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            styleDefinitions = Companion.loadStyleDefinitions(Companion.getPreferredFormatStandard());
        }
        this(styleDefinitions);
    }

    @NotNull
    public final BBUTDTranslationEngine getEngine() {
        return this.engine;
    }

    @NotNull
    public final String getBrailleStandard() {
        return this.brailleStandard;
    }

    @NotNull
    public final PredominantQuoteSetting getPredominantQuoteSetting() {
        return this.predominantQuoteSetting;
    }

    public final void setPredominantQuoteSetting(@NotNull PredominantQuoteSetting predominantQuoteSetting) {
        Intrinsics.checkNotNullParameter((Object)((Object)predominantQuoteSetting), (String)"<set-?>");
        this.predominantQuoteSetting = predominantQuoteSetting;
    }

    @Nullable
    public final IStyleMap getOverrideStyleMap() {
        return this.overrideStyleMap;
    }

    public final void setOverrideStyleMap(@Nullable IStyleMap iStyleMap) {
        this.overrideStyleMap = iStyleMap;
    }

    @Nullable
    public final BBXStyleMap getBbxStyleMap() {
        return this.bbxStyleMap;
    }

    public final void setBbxStyleMap(@Nullable BBXStyleMap bBXStyleMap) {
        this.bbxStyleMap = bBXStyleMap;
    }

    @Nullable
    public final BBXDynamicOptionStyleMap getBbxOptionStyleMap() {
        return this.bbxOptionStyleMap;
    }

    public final void setBbxOptionStyleMap(@Nullable BBXDynamicOptionStyleMap bBXDynamicOptionStyleMap) {
        this.bbxOptionStyleMap = bBXDynamicOptionStyleMap;
    }

    @Nullable
    public final IActionMap getBookTypeActionMap() {
        return this.bookTypeActionMap;
    }

    public final void setBookTypeActionMap(@Nullable IActionMap iActionMap) {
        this.bookTypeActionMap = iActionMap;
    }

    @Nullable
    public final IActionMap getOverrideActionMap() {
        return this.overrideActionMap;
    }

    public final void setOverrideActionMap(@Nullable IActionMap iActionMap) {
        this.overrideActionMap = iActionMap;
    }

    @Nullable
    public final IActionMap getMathMap() {
        return this.mathMap;
    }

    public final void setMathMap(@Nullable IActionMap iActionMap) {
        this.mathMap = iActionMap;
    }

    private final BBUTDTranslationEngine newEngine() {
        return new BBUTDTranslationEngine();
    }

    public final void loadEngineFromDoc(@NotNull Document doc, @NotNull String bookType) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)bookType, (String)"bookType");
        String[] stringArray = new String[]{UTD_FOLDER, bookType + ".actionMap.xml"};
        ActionMap actionMap2 = UTDConfig.loadActions((File)BBIni.loadAutoProgramDataFile(stringArray));
        Intrinsics.checkNotNull((Object)actionMap2);
        ActionMap actionMap3 = actionMap2;
        log.debug("Loaded {} entries", (Object)actionMap3.size());
        String[] stringArray2 = new String[]{UTD_FOLDER, bookType + ".styleMap.xml"};
        StyleMap styleMap2 = UTDConfig.loadStyle((File)BBIni.loadAutoProgramDataFile(stringArray2), (StyleDefinitions)this.engine.getStyleDefinitions());
        String[] stringArray3 = new String[]{UTD_FOLDER, "mathml.actionMap.xml"};
        ActionMap mathMap = UTDConfig.loadActions((File)BBIni.loadAutoProgramDataFile(stringArray3));
        this.loadEngineFromDoc(doc, actionMap3, styleMap2, mathMap);
    }

    private final void loadEngineFromDoc(Document doc, ActionMap actionMap2, StyleMap styleMap2, ActionMap mathMap) {
        PredominantQuoteSetting predominantQuoteSetting;
        String string;
        PageSettings pageSettings;
        log.debug("Loading engine");
        this.bookTypeActionMap = (IActionMap)actionMap2;
        this.bookTypeStyleMap = (IStyleMap)styleMap2;
        this.mathMap = (IActionMap)mathMap;
        this.bbxStyleMap = new BBXStyleMap(this.engine.getStyleDefinitions());
        this.bbxOptionStyleMap = new BBXDynamicOptionStyleMap(this.engine.getStyleDefinitions(), () -> UTDManager.loadEngineFromDoc$lambda$0(this));
        PageSettings docPageSettings = DocumentUTDConfig.NIMAS.loadPageSettings(doc);
        if (docPageSettings == null) {
            String[] stringArray = new String[]{UTD_FOLDER, PAGE_SETTINGS_NAME};
            File settingsFile = BBIni.loadAutoProgramDataFile(stringArray);
            log.debug("Document doesn't have pageSettings, loading defaults at {}", (Object)settingsFile.getAbsolutePath());
            pageSettings = UTDConfig.loadPageSettings((File)settingsFile);
        } else {
            log.debug("Loading document specific pageSettings");
            pageSettings = docPageSettings;
        }
        PageSettings pageSettings2 = pageSettings;
        this.engine.setPageSettings(pageSettings2);
        String string2 = DocumentUTDConfig.NIMAS.getSetting(doc, USER_SETTINGS_BRAILLE_STANDARD);
        if (string2 == null) {
            string2 = this.brailleStandard = this.brailleStandard;
        }
        if ((string = DocumentUTDConfig.NIMAS.getSetting(doc, USER_SETTINGS_PREDOMINANT_QUOTE)) == null) {
            string = "";
        }
        if ((predominantQuoteSetting = PredominantQuoteSetting.Companion.findValue(string)) == null) {
            predominantQuoteSetting = this.predominantQuoteSetting;
        }
        this.predominantQuoteSetting = predominantQuoteSetting;
        this.applyBrailleStandard(this.brailleStandard);
        log.debug("Loaded {} entries", (Object)actionMap2.size());
        this.overrideActionMap = OverrideMap.INSTANCE.generateOverrideActionMap(actionMap2);
        this.overrideStyleMap = OverrideMap.INSTANCE.generateOverrideStyleMap(this.engine.getStyleDefinitions());
        this.reloadMapsFromDoc();
        benchmarkCallback.accept(this.engine);
    }

    public final void reloadMapsFromDoc() {
        long startTime = System.currentTimeMillis();
        StyleDefinitions styleDefs2 = this.engine.getStyleDefinitions();
        styleDefs2.clear();
        styleDefs2.addStyles((Iterable)this.origStyleDefs);
        ActionMultiMap newActionMap = new ActionMultiMap();
        Object[] objectArray = new IActionMap[]{this.overrideActionMap, this.bookTypeActionMap, this.mathMap};
        newActionMap.setMaps(CollectionsKt.mutableListOf((Object[])objectArray));
        this.engine.setActionMap((IActionMap)newActionMap);
        Style style = this.engine.getStyleDefinitions().getDefaultStyle();
        if (style == null) {
            style = new Style();
        }
        StyleMultiMap newStyleMap = new StyleMultiMap((IStyle)style);
        IStyleMap[] iStyleMapArray = new IStyleMap[]{this.bbxOptionStyleMap, this.overrideStyleMap, this.bbxStyleMap, this.bookTypeStyleMap};
        newStyleMap.setMaps(CollectionsKt.mutableListOf((Object[])iStyleMapArray));
        this.engine.setStyleMap((IStyleMap)newStyleMap);
        BBXDynamicOptionStyleMap bBXDynamicOptionStyleMap = this.bbxOptionStyleMap;
        Intrinsics.checkNotNull((Object)((Object)bBXDynamicOptionStyleMap));
        for (Style curDocStyleDef : bBXDynamicOptionStyleMap.getGeneratedStyles()) {
            styleDefs2.addStyle(curDocStyleDef);
        }
        totalMilliLoad += System.currentTimeMillis() - startTime;
    }

    public final void testSetup() {
        TableExceptions.generateExceptionsTables(this.engine, true, this.brailleStandard);
    }

    public final void applyAction(@Nullable IAction action, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element.getDocument() == null) {
            throw new NodeException("Element must be attached to document", (Node)element, null, 4, null);
        }
        this.applyAction(action, element, element.getDocument());
    }

    public final void applyAction(@Nullable IAction action, @Nullable Element element, @Nullable Document doc) {
        boolean bl;
        String actionName;
        block9: {
            if (action == null) {
                throw new NullPointerException("action");
            }
            if (element == null) {
                throw new NullPointerException("element");
            }
            if (doc == null) {
                throw new NullPointerException("doc");
            }
            if (!(element.getDocument() == null || element.getDocument() == doc)) {
                boolean $i$a$-require-UTDManager$applyAction$22 = false;
                String $i$a$-require-UTDManager$applyAction$22 = "Element is attached to different document than given";
                throw new IllegalArgumentException($i$a$-require-UTDManager$applyAction$22.toString());
            }
            actionName = action.getClass().getSimpleName();
            IActionMap iActionMap = this.overrideActionMap;
            Intrinsics.checkNotNull((Object)iActionMap);
            Iterable $this$any$iv = iActionMap.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IAction it = (IAction)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getClass().getSimpleName(), (Object)actionName)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (!bl) {
            throw new RuntimeException("Unhandlable action (does it take fields?) " + action);
        }
        BBX._ATTRIB_OVERRIDE_ACTION.set(element, actionName);
        log.debug("Applied override action {} to {}", (Object)action, (Object)XMLHandler.Companion.toXMLStartTag(element));
        IAction lookedUpAction = (IAction)this.engine.getActionMap().findValueOrDefault((Node)element);
        if (!Intrinsics.areEqual((Object)lookedUpAction, (Object)action)) {
            throw new NodeException("Expected element action to be " + action + ", got " + lookedUpAction, (Node)element, null, 4, null);
        }
    }

    @NotNull
    public final Element removeOverrideAction(@NotNull Element element) {
        block1: {
            Attribute attrib;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (element.getDocument() == null) {
                throw new NodeException("Element must be attached to document", (Node)element, null, 4, null);
            }
            Attribute attribute = attrib = BBX._ATTRIB_OVERRIDE_ACTION.getAttribute(element);
            if (attribute == null) break block1;
            attribute.detach();
        }
        return element;
    }

    public final void applyStyle(@Nullable Style style, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element.getDocument() == null) {
            throw new NodeException("Element must be attached to document", (Node)element, null, 4, null);
        }
        UTDManager.applyStyle$default(this, style, element, element.getDocument(), false, 8, null);
    }

    @JvmOverloads
    public final void applyStyle(@Nullable Style style, @Nullable Element element, @Nullable Document doc, boolean stripStyle) {
        if (style == null) {
            throw new NullPointerException("style");
        }
        if (element == null) {
            throw new NullPointerException("element");
        }
        if (doc == null) {
            throw new NullPointerException("doc");
        }
        if (!(element.getDocument() == null || element.getDocument() == doc)) {
            boolean $i$a$-require-UTDManager$applyStyle$22 = false;
            String $i$a$-require-UTDManager$applyStyle$22 = "Element is attached to different document than given";
            throw new IllegalArgumentException($i$a$-require-UTDManager$applyStyle$22.toString());
        }
        if (stripStyle) {
            BBXUtils.INSTANCE.stripStyle(element, this);
        }
        String string = style.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        BBXUtils.ListStyleData itemStyleData = BBXUtils.INSTANCE.parseListStyle(string);
        if (itemStyleData != null) {
            BBX.BLOCK.assertIsA((Node)element);
            if (itemStyleData.getListType() == null) {
                BBX.BLOCK.MARGIN.set(element);
                BBX.BLOCK.MARGIN.ATTRIB_MARGIN_TYPE.set(element, itemStyleData.getMarginType());
                BBX.BLOCK.MARGIN.ATTRIB_INDENT.set(element, itemStyleData.getIndentLevel());
                BBX.BLOCK.MARGIN.ATTRIB_RUNOVER.set(element, itemStyleData.getRunoverLevel());
            } else {
                Element ancestorPoem;
                Element parentList = XMLHandler.Companion.ancestorVisitorElement((Node)element, UTDManager::applyStyle$lambda$1);
                Node previousSiblingNode = this.getPreviousBBXSiblingNode((Node)element);
                Node nextSiblingNode = this.getNextBBXSiblingNode((Node)element);
                Element wrapperList = null;
                if (parentList != null) {
                    if (UTDManager.Companion.isCompatibleList(parentList, itemStyleData)) {
                        wrapperList = parentList;
                    } else {
                        boolean isPreviousSiblingList;
                        Node previousSiblingList = XMLHandler.Companion.previousSiblingNode((Node)parentList);
                        Node nextSiblingList = XMLHandler.Companion.nextSiblingNode((Node)parentList);
                        boolean isNextSiblingList = nextSiblingList instanceof Element && BBX.PreFormatterMarker.LIST_SPLIT.has(nextSiblingList);
                        boolean bl = isPreviousSiblingList = previousSiblingList instanceof Element && BBX.PreFormatterMarker.LIST_SPLIT.has(previousSiblingList);
                        if (isPreviousSiblingList || isNextSiblingList) {
                            if (element.getParent().getChildCount() == 1) {
                                element.getParent().detach();
                            }
                            element.detach();
                            Node node = isPreviousSiblingList ? previousSiblingList : nextSiblingList;
                            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
                            wrapperList = (Element)node;
                            wrapperList.appendChild((Node)element);
                        } else {
                            log.debug("UTDMgr splitting list");
                            Element element2 = BBX.CONTAINER.LIST.create(itemStyleData.getListType());
                            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"create(...)");
                            wrapperList = element2;
                            BBX.PreFormatterMarker.ATTRIB_PRE_FORMATTER_MARKER.set(wrapperList, BBX.PreFormatterMarker.LIST_SPLIT);
                            NodeTreeSplitter.split(parentList, (Node)element);
                            element.getParent().replaceChild((Node)element, (Node)wrapperList);
                            wrapperList.appendChild((Node)element);
                            BBX.CONTAINER.LIST.ATTRIB_LIST_LEVEL.set(wrapperList, itemStyleData.getRunoverLevel());
                        }
                    }
                } else if (previousSiblingNode != null && BBX.CONTAINER.LIST.isA(previousSiblingNode) && BBX.CONTAINER.LIST.ATTRIB_LIST_TYPE.get((Element)previousSiblingNode) == itemStyleData.getListType() && UTDManager.Companion.isCompatibleList((Element)previousSiblingNode, itemStyleData)) {
                    element.detach();
                    wrapperList = (Element)previousSiblingNode;
                    wrapperList.appendChild((Node)element);
                    if (nextSiblingNode != null && BBX.CONTAINER.LIST.isA(nextSiblingNode) && BBX.CONTAINER.LIST.ATTRIB_LIST_TYPE.get((Element)nextSiblingNode) == itemStyleData.getListType() && UTDManager.Companion.isCompatibleList((Element)nextSiblingNode, itemStyleData)) {
                        wrapperList = this.mergeContainers(wrapperList, (Element)nextSiblingNode);
                    }
                } else if (nextSiblingNode != null && BBX.CONTAINER.LIST.isA(nextSiblingNode) && BBX.CONTAINER.LIST.ATTRIB_LIST_TYPE.get((Element)nextSiblingNode) == itemStyleData.getListType() && UTDManager.Companion.isCompatibleList((Element)nextSiblingNode, itemStyleData)) {
                    element.detach();
                    wrapperList = (Element)nextSiblingNode;
                    wrapperList.insertChild((Node)element, 0);
                } else {
                    Element element3 = BBX.CONTAINER.LIST.create(itemStyleData.getListType());
                    Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"create(...)");
                    wrapperList = element3;
                    element.getParent().replaceChild((Node)element, (Node)wrapperList);
                    wrapperList.appendChild((Node)element);
                    BBX.CONTAINER.LIST.ATTRIB_LIST_LEVEL.set(wrapperList, itemStyleData.getRunoverLevel());
                }
                if (BBX.CONTAINER.LIST.ATTRIB_LIST_TYPE.get(wrapperList) == BBX.ListType.POEM_LINE_GROUP && (ancestorPoem = XMLHandler.Companion.ancestorVisitorElement((Node)wrapperList, UTDManager::applyStyle$lambda$2)) != null) {
                    wrapperList = ancestorPoem;
                }
                log.debug("WrapperList XML: \n" + wrapperList.toXML() + "\nWlist: " + BBX.CONTAINER.LIST.ATTRIB_LIST_LEVEL.get(wrapperList) + " runover: " + itemStyleData.getRunoverLevel());
                if (((Number)BBX.CONTAINER.LIST.ATTRIB_LIST_LEVEL.get(wrapperList)).intValue() < itemStyleData.getRunoverLevel()) {
                    BBX.CONTAINER.LIST.ATTRIB_LIST_LEVEL.set(wrapperList, itemStyleData.getRunoverLevel());
                }
                BBX.transform(element, BBX.BLOCK.LIST_ITEM);
                BBX.BLOCK.LIST_ITEM.ATTRIB_ITEM_LEVEL.set(element, itemStyleData.getIndentLevel());
            }
        } else {
            IStyleMap iStyleMap = this.overrideStyleMap;
            Intrinsics.checkNotNull((Object)iStyleMap);
            if (iStyleMap.values().contains(style)) {
                BBX._ATTRIB_OVERRIDE_STYLE.set(element, style.getName());
                if (BBX.BLOCK.isA((Node)element)) {
                    BBXUtils.INSTANCE.stripStyleExceptOverrideStyle(element);
                    BBX.transform(element, BBX.BLOCK.STYLE);
                }
                if (XMLHandler.Companion.ancestorElementIs((Node)element, UTDManager::applyStyle$lambda$3)) {
                    BBXUtils.INSTANCE.stripStyleExceptOverrideStyle(element);
                    BBXUtils.INSTANCE.checkListStyle(XMLHandler.Companion.ancestorVisitorElement((Node)element, UTDManager::applyStyle$lambda$4), element, this);
                }
            } else {
                throw new RuntimeException("Unhandled style " + style.getName());
            }
        }
        if (element.getDocument() == null) {
            throw new NodeException("Element missing from document? " + XMLHandler.Companion.toXMLSimple((Node)element), (Node)doc, null, 4, null);
        }
        IStyle lookedUpStyle = (IStyle)this.engine.getStyleMap().findValueOrDefault((Node)element);
        if (!Intrinsics.areEqual((Object)lookedUpStyle, (Object)style)) {
            BBXDynamicOptionStyleMap bBXDynamicOptionStyleMap = this.bbxOptionStyleMap;
            Intrinsics.checkNotNull((Object)((Object)bBXDynamicOptionStyleMap));
            if (bBXDynamicOptionStyleMap.getStyleOptions(element).isEmpty()) {
                throw new NodeException("Expected element style to be " + style.getName() + ", got " + lookedUpStyle.getName() + " . Detail: expected " + style + ", got " + lookedUpStyle, (Node)element, null, 4, null);
            }
        }
    }

    public static /* synthetic */ void applyStyle$default(UTDManager uTDManager, Style style, Element element, Document document, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        uTDManager.applyStyle(style, element, document, bl);
    }

    private final Node getPreviousBBXSiblingNode(Node element) {
        Node sibling = element;
        boolean isBBX = false;
        while (!isBBX) {
            if (XMLHandler.Companion.previousSiblingNode(sibling) == null) {
                return null;
            }
            if (!(sibling instanceof Element) || StringsKt.equals((String)((Element)sibling).getNamespacePrefix(), (String)UTD_FOLDER, (boolean)true)) continue;
            isBBX = true;
        }
        return sibling;
    }

    private final Node getNextBBXSiblingNode(Node element) {
        Node sibling = element;
        boolean isBBX = false;
        while (!isBBX) {
            if (XMLHandler.Companion.nextSiblingNode(sibling) == null) {
                return null;
            }
            if (!(sibling instanceof Element) || StringsKt.equals((String)((Element)sibling).getNamespacePrefix(), (String)UTD_FOLDER, (boolean)true)) continue;
            isBBX = true;
        }
        return sibling;
    }

    private final Element mergeContainers(Element containerOne, Element containerTwo) {
        while (containerOne.getChildCount() > 0) {
            containerTwo.insertChild(containerOne.removeChild(containerOne.getChildCount() - 1), 0);
        }
        containerOne.detach();
        return containerTwo;
    }

    @NotNull
    public final Element removeOverrideStyle(@NotNull Element element) {
        block1: {
            Attribute attrib;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (element.getDocument() == null) {
                throw new NodeException("Element must be attached to document " + element.toXML(), (Node)element, null, 4, null);
            }
            Attribute attribute = attrib = BBX._ATTRIB_OVERRIDE_STYLE.getAttribute(element);
            if (attribute == null) break block1;
            attribute.detach();
        }
        return element;
    }

    @NotNull
    public final Style applyStyleWithOption(@NotNull Style curStyle, @NotNull Style.StyleOption styleOption, @NotNull Object value, @NotNull Element element) {
        Style style;
        Intrinsics.checkNotNullParameter((Object)curStyle, (String)"curStyle");
        Intrinsics.checkNotNullParameter((Object)styleOption, (String)"styleOption");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        switch (WhenMappings.$EnumSwitchMapping$0[styleOption.ordinal()]) {
            case 1: {
                element.addAttribute(new Attribute("guideWords", Boolean.toString((Boolean)value)));
                style = curStyle;
                break;
            }
            case 2: {
                String string = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, styleOption.name());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"to(...)");
                String attribName = string;
                element.addAttribute(new Attribute(attribName, value.toString()));
                style = curStyle;
                break;
            }
            case 3: 
            case 4: {
                style = curStyle;
                break;
            }
            default: {
                Style baseStyle = Companion.getBaseStyle(curStyle);
                log.debug("Got base style {} frorm {}", (Object)baseStyle.getName(), (Object)curStyle.getName());
                IStyle iStyle = this.engine.getStyle((Node)element);
                Intrinsics.checkNotNull((Object)iStyle, (String)"null cannot be cast to non-null type org.brailleblaster.utd.Style");
                if (!Intrinsics.areEqual((Object)Companion.getBaseStyle((Style)iStyle), (Object)baseStyle)) {
                    this.applyStyle(baseStyle, element, element.getDocument(), false);
                }
                BBXDynamicOptionStyleMap.Companion.setStyleOptionAttrib(element, styleOption, value);
                Style newStyle = (Style)this.engine.getStyle((Node)element);
                if (newStyle == baseStyle) {
                    throw new NodeException("Style option " + styleOption + " with value " + value + " has no affect on style " + baseStyle.getName() + ". Full: " + newStyle, (Node)element, null, 4, null);
                }
                Style style2 = newStyle;
                style = style2;
                Intrinsics.checkNotNull((Object)style2);
            }
        }
        return style;
    }

    @NotNull
    public final String getBaseStyle(@NotNull String styleName, @NotNull Node node) {
        String string;
        Intrinsics.checkNotNullParameter((Object)styleName, (String)"styleName");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (StringsKt.startsWith$default((String)styleName, (String)DOCUMENT_STYLE_NAME_PREFIX, (boolean)false, (int)2, null)) {
            IStyle iStyle = this.engine.getStyle(node);
            Intrinsics.checkNotNull((Object)iStyle, (String)"null cannot be cast to non-null type org.brailleblaster.utd.Style");
            String string2 = Companion.getBaseStyle((Style)iStyle).getName();
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            string = styleName;
        }
        return string;
    }

    public final void updateBrailleStandard(@NotNull Document doc, @NotNull String std) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)std, (String)"std");
        log.debug("Changing braille standard from {} to {}", (Object)this.brailleStandard, (Object)std);
        DocumentUTDConfig.NIMAS.setSetting(doc, USER_SETTINGS_BRAILLE_STANDARD, std);
        this.brailleStandard = std;
        this.applyBrailleStandard(std);
    }

    public final void updatePredominantQuote(@NotNull Document doc, @NotNull PredominantQuoteSetting pq) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)((Object)pq), (String)"pq");
        DocumentUTDConfig.NIMAS.setSetting(doc, USER_SETTINGS_PREDOMINANT_QUOTE, pq.name());
        this.predominantQuoteSetting = pq;
        this.applyBrailleStandard(this.brailleStandard);
    }

    public final void applyBrailleStandard(@NotNull String std) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)std, (String)"std");
        String[] stringArray2 = new String[]{UTD_FOLDER, std + BRAILLE_SETTINGS_NAME};
        File file = BBIni.INSTANCE.loadAutoProgramDataFileOrNull(stringArray2);
        if (file == null && (file = BBIni.INSTANCE.loadAutoProgramDataFileOrNull(stringArray = new String[]{UTD_FOLDER, "legacy", std + BRAILLE_SETTINGS_NAME})) == null) {
            throw new RuntimeException("Braille standard file not found.");
        }
        this.engine.setBrailleSettings(UTDConfig.loadBrailleSettings((File)file));
        Path path = BBIni.getProgramDataPath();
        stringArray2 = new String[1];
        String string = this.predominantQuoteSetting.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        stringArray2[0] = this.brailleStandard + "-quotes-" + string + ".cti";
        File quotesTable = path.resolve(Paths.get("quotesTables", stringArray2)).toFile();
        if (quotesTable.exists()) {
            this.engine.getBrailleSettings().setMainTranslationTable(quotesTable.getAbsolutePath() + "," + this.engine.getBrailleSettings().getMainTranslationTable());
        }
        TableExceptions.generateExceptionsTables(this.engine, false, this.brailleStandard);
    }

    @NotNull
    public final File getUserShortcutDefinitionsFile() {
        String[] stringArray = new String[]{SHORTCUT_DEFS_NAME};
        File file = BBIni.getUserProgramDataPath().resolve(Paths.get(UTD_FOLDER, stringArray)).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    public final boolean hasStyle(@Nullable Node node, @NotNull String styleName) {
        Intrinsics.checkNotNullParameter((Object)styleName, (String)"styleName");
        Node node2 = node;
        Intrinsics.checkNotNull((Object)node2);
        IStyle curStyle = this.engine.getStyle(node2);
        return curStyle != null && Companion.isStyle((Style)curStyle, styleName);
    }

    @Nullable
    public final File getExceptionsTableFile() {
        return TableExceptions.getTranslationExceptionFile(this.engine.getBrailleSettings(), this.brailleStandard);
    }

    @JvmOverloads
    public UTDManager() {
        this(null, 1, null);
    }

    @JvmOverloads
    public final void applyStyle(@Nullable Style style, @Nullable Element element, @Nullable Document doc) {
        UTDManager.applyStyle$default(this, style, element, doc, false, 8, null);
    }

    private static final IStyleMap loadEngineFromDoc$lambda$0(UTDManager this$0) {
        return this$0.engine.getStyleMap();
    }

    private static final boolean applyStyle$lambda$1(Element node) {
        return BBX.CONTAINER.LIST.isA((Node)node);
    }

    private static final boolean applyStyle$lambda$2(Element e) {
        return BBX.CONTAINER.LIST.ATTRIB_LIST_TYPE.getOptional(e).orElse(null) == BBX.ListType.POEM;
    }

    private static final boolean applyStyle$lambda$3(Element node) {
        return BBX.CONTAINER.LIST.isA((Node)node);
    }

    private static final boolean applyStyle$lambda$4(Element node) {
        return BBX.CONTAINER.LIST.isA((Node)node);
    }

    private static final void benchmarkCallback$lambda$0(UTDTranslationEngine uTDTranslationEngine) {
    }

    @JvmStatic
    @NotNull
    public static final Style getBaseStyle(@NotNull Style style) {
        return Companion.getBaseStyle(style);
    }

    @NotNull
    public static final File getUserPageSettingsFile() {
        return Companion.getUserPageSettingsFile();
    }

    @NotNull
    public static final String getPreferredFormatStandard() {
        return Companion.getPreferredFormatStandard();
    }

    @JvmStatic
    public static final boolean isStyle(@Nullable Style style, @NotNull String styleName) {
        return Companion.isStyle(style, styleName);
    }

    @JvmStatic
    public static final boolean hasUtdStyleTag(@NotNull Element element, @NotNull String style) {
        return Companion.hasUtdStyleTag(element, style);
    }

    @JvmStatic
    @NotNull
    public static final String getNextPageNum(@Nullable Element element) {
        return Companion.getNextPageNum(element);
    }

    @JvmStatic
    @NotNull
    public static final StyleDefinitions loadStyleDefinitions(@Nullable String formatStandard) {
        return Companion.loadStyleDefinitions(formatStandard);
    }

    @JvmStatic
    public static final int getCellsPerLine(@NotNull Manager m) {
        return Companion.getCellsPerLine(m);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\tH\u0016J\u0006\u0010\u000e\u001a\u00020\u000fR\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/brailleblaster/settings/UTDManager$BBUTDTranslationEngine;", "Lorg/brailleblaster/utd/UTDTranslationEngine;", "<init>", "()V", "expectedTranslate", "", "translate", "Lnu/xom/Nodes;", "doc", "Lnu/xom/Node;", "translateDocument", "Lnu/xom/Document;", "format", "nodes", "fail", "", "brailleblaster-core"})
    public static final class BBUTDTranslationEngine
    extends UTDTranslationEngine {
        @JvmField
        public boolean expectedTranslate;

        @NotNull
        public Nodes translate(@NotNull Node doc) {
            Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
            if (!this.expectedTranslate) {
                this.fail();
            }
            return super.translate(doc);
        }

        @NotNull
        public Document translateDocument(@NotNull Document doc) {
            Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
            if (!this.expectedTranslate) {
                this.fail();
            }
            return super.translateDocument(doc);
        }

        @NotNull
        public Document format(@NotNull Node nodes) {
            Document document;
            Intrinsics.checkNotNullParameter((Object)nodes, (String)"nodes");
            Document origDoc = nodes.getDocument();
            try {
                document = super.format(nodes);
            }
            catch (Exception e) {
                Node failNode = nodes.getDocument() != null ? nodes : (Node)origDoc;
                throw new NodeException("Failed to format " + (nodes.getDocument() != null ? "(orig node)" : "(orig doc)"), failNode, (Throwable)e);
            }
            return document;
        }

        public final void fail() {
            throw new UnsupportedOperationException("Unexpected call to translate, should most likely use ModifyEvent");
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0007J\u001a\u00100\u001a\u00020\u001b2\b\u0010\"\u001a\u0004\u0018\u00010!2\u0006\u00101\u001a\u00020\u000bH\u0007J\u0018\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u000bH\u0007J\u0016\u00104\u001a\u00020\u001b2\u0006\u00103\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u000bJ\u0012\u00105\u001a\u00020\u000b2\b\u00103\u001a\u0004\u0018\u00010\u001dH\u0007J\u0012\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u00010\u000bH\u0007J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0007R\u001a\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010#\u001a\u00020$8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b%\u0010\u0003\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010'R\u0011\u0010*\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010'R\u001a\u0010,\u001a\u00020\u000b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b-\u0010\u0003\u001a\u0004\b.\u0010/\u00a8\u0006="}, d2={"Lorg/brailleblaster/settings/UTDManager$Companion;", "", "<init>", "()V", "benchmarkCallback", "Ljava/util/function/Consumer;", "Lorg/brailleblaster/utd/UTDTranslationEngine;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "UTD_FOLDER", "", "STYLE_DEFS_NAME", "SHORTCUT_DEFS_NAME", "BRAILLE_SETTINGS_NAME", "PAGE_SETTINGS_NAME", "USER_SETTINGS_BRAILLE_STANDARD", "USER_SETTINGS_PREDOMINANT_QUOTE", "USER_SETTINGS_FORMAT_STANDARD", "DOCUMENT_STYLE_NAME_PREFIX", "totalMilliLoad", "", "getTotalMilliLoad", "()J", "setTotalMilliLoad", "(J)V", "isCompatibleList", "", "list", "Lnu/xom/Element;", "itemStyleData", "Lorg/brailleblaster/bbx/BBXUtils$ListStyleData;", "getBaseStyle", "Lorg/brailleblaster/utd/Style;", "style", "userPageSettingsFile", "Ljava/io/File;", "getUserPageSettingsFile$annotations", "getUserPageSettingsFile", "()Ljava/io/File;", "userBrailleSettingsFile", "getUserBrailleSettingsFile", "userStyleDefinitionsFile", "getUserStyleDefinitionsFile", "preferredFormatStandard", "getPreferredFormatStandard$annotations", "getPreferredFormatStandard", "()Ljava/lang/String;", "isStyle", "styleName", "hasUtdStyleTag", "element", "hasUtdActionTag", "getNextPageNum", "loadStyleDefinitions", "Lorg/brailleblaster/utd/config/StyleDefinitions;", "formatStandard", "getCellsPerLine", "", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "brailleblaster-core"})
    @SourceDebugExtension(value={"SMAP\nUTDManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UTDManager.kt\norg/brailleblaster/settings/UTDManager$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,730:1\n184#2,2:731\n*S KotlinDebug\n*F\n+ 1 UTDManager.kt\norg/brailleblaster/settings/UTDManager$Companion\n*L\n654#1:731,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final long getTotalMilliLoad() {
            return totalMilliLoad;
        }

        public final void setTotalMilliLoad(long l) {
            totalMilliLoad = l;
        }

        private final boolean isCompatibleList(Element list, BBXUtils.ListStyleData itemStyleData) {
            Element element;
            if (BBX.ListType.POEM_LINE_GROUP.isA((Node)list) && !BBX.CONTAINER.LIST.ATTRIB_LIST_LEVEL.has((Node)list)) {
                ParentNode parentNode = list.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
                element = XMLHandler.Companion.ancestorVisitorElement((Node)parentNode, Companion::isCompatibleList$lambda$0);
            } else {
                element = list;
            }
            Element actualList = element;
            return ((Number)BBX.CONTAINER.LIST.ATTRIB_LIST_LEVEL.get(actualList)).intValue() <= itemStyleData.getRunoverLevel() && BBX.CONTAINER.LIST.ATTRIB_LIST_TYPE.getOptional(actualList).orElse(null) == itemStyleData.getListType();
        }

        @JvmStatic
        @NotNull
        public final Style getBaseStyle(@NotNull Style style) {
            Style style2;
            Object v1;
            block2: {
                Intrinsics.checkNotNullParameter((Object)style, (String)"style");
                Sequence $this$firstOrNull$iv = SequencesKt.generateSequence((Object)style, Companion::getBaseStyle$lambda$0);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Style it = (Style)element$iv;
                    boolean bl = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (!(!StringsKt.startsWith$default((String)string, (String)UTDManager.DOCUMENT_STYLE_NAME_PREFIX, (boolean)false, (int)2, null))) continue;
                    v1 = element$iv;
                    break block2;
                }
                v1 = null;
            }
            if ((style2 = (Style)v1) == null) {
                style2 = style;
            }
            return style2;
        }

        @NotNull
        public final File getUserPageSettingsFile() {
            String[] stringArray = new String[]{UTDManager.PAGE_SETTINGS_NAME};
            File file = BBIni.getUserProgramDataPath().resolve(Paths.get(UTDManager.UTD_FOLDER, stringArray)).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            return file;
        }

        @JvmStatic
        public static /* synthetic */ void getUserPageSettingsFile$annotations() {
        }

        @NotNull
        public final File getUserBrailleSettingsFile() {
            String[] stringArray = new String[]{UTDManager.BRAILLE_SETTINGS_NAME};
            File file = BBIni.getUserProgramDataPath().resolve(Paths.get(UTDManager.UTD_FOLDER, stringArray)).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            return file;
        }

        @NotNull
        public final File getUserStyleDefinitionsFile() {
            String[] stringArray = new String[]{UTDManager.STYLE_DEFS_NAME};
            File file = BBIni.getUserProgramDataPath().resolve(Paths.get(UTDManager.UTD_FOLDER, stringArray)).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            return file;
        }

        @NotNull
        public final String getPreferredFormatStandard() {
            return BBIni.getPropertyFileManager().getProperty(UTDManager.USER_SETTINGS_FORMAT_STANDARD, "BANA");
        }

        @JvmStatic
        public static /* synthetic */ void getPreferredFormatStandard$annotations() {
        }

        @JvmStatic
        public final boolean isStyle(@Nullable Style style, @NotNull String styleName) {
            Intrinsics.checkNotNullParameter((Object)styleName, (String)"styleName");
            for (Style curStyle = style; curStyle != null; curStyle = curStyle.getBaseStyle()) {
                if (!Intrinsics.areEqual((Object)curStyle.getName(), (Object)styleName)) continue;
                return true;
            }
            return false;
        }

        @JvmStatic
        public final boolean hasUtdStyleTag(@NotNull Element element, @NotNull String style) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            return element.getAttributeValue("utd-style") != null && Intrinsics.areEqual((Object)element.getAttributeValue("utd-style"), (Object)style) || element.getAttributeValue("overrideStyle") != null && Intrinsics.areEqual((Object)element.getAttributeValue("overrideStyle"), (Object)style);
        }

        public final boolean hasUtdActionTag(@NotNull Element element, @NotNull String style) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            return element.getAttributeValue("utd-action") != null && Intrinsics.areEqual((Object)element.getAttributeValue("utd-action"), (Object)style) || element.getAttributeValue("overrideAction") != null && Intrinsics.areEqual((Object)element.getAttributeValue("overrideAction"), (Object)style);
        }

        @JvmStatic
        @NotNull
        public final String getNextPageNum(@Nullable Element element) {
            String string;
            Node pagenum = XMLHandler.Companion.followingWithSelfVisitor((Node)element, Companion::getNextPageNum$lambda$0);
            if (pagenum != null) {
                String string2 = pagenum.getValue();
                Intrinsics.checkNotNull((Object)string2);
                string = string2;
            } else {
                string = "Page Not Found";
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public final StyleDefinitions loadStyleDefinitions(@Nullable String formatStandard) {
            String[] stringArray = new String[2];
            stringArray[0] = UTDManager.UTD_FOLDER;
            String string = "%s.%s";
            Object[] objectArray = new Object[]{formatStandard, UTDManager.STYLE_DEFS_NAME};
            Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(...)");
            return UTDConfig.loadStyleDefinitions((File)BBIni.loadAutoProgramDataFile(stringArray));
        }

        @JvmStatic
        public final int getCellsPerLine(@NotNull Manager m) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            PageSettings pageSettings = m.getDocument().getEngine().getPageSettings();
            BrlCell brailleCell = m.getDocument().getEngine().getBrailleSettings().getCellType();
            double middle = pageSettings.getDrawableWidth();
            return brailleCell.getCellsForWidth(new BigDecimal(String.valueOf(middle)));
        }

        private static final boolean isCompatibleList$lambda$0(Element node) {
            return BBX.CONTAINER.LIST.isA((Node)node);
        }

        private static final Style getBaseStyle$lambda$0(Style it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getBaseStyle();
        }

        private static final boolean getNextPageNum$lambda$0(Node n) {
            Intrinsics.checkNotNullParameter((Object)n, (String)"n");
            return n instanceof Text && ((Text)n).getParent() != null && BBX.BLOCK.PAGE_NUM.isA((Node)((Text)n).getParent());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Style.StyleOption.values().length];
            try {
                nArray[Style.StyleOption.GUIDE_WORDS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Style.StyleOption.PAGE_SIDE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Style.StyleOption.LINES_BEFORE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Style.StyleOption.LINES_AFTER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

