/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.settings.ui;

import ch.qos.logback.classic.Level;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.logging.LogUtils;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.brailleblaster.utils.swt.EasySWT;
import org.brailleblaster.wordprocessor.WPManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/brailleblaster/settings/ui/AdvancedSettingsDialog;", "", "<init>", "()V", "dialog", "Lorg/eclipse/swt/widgets/Shell;", "logDebug", "Lorg/eclipse/swt/widgets/Button;", "logInfo", "logWarn", "logError", "onSave", "", "Companion", "brailleblaster-core"})
public final class AdvancedSettingsDialog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Shell dialog = new Shell(WPManager.Companion.getInstance().getShell(), 67680);
    @NotNull
    private final Button logDebug;
    @NotNull
    private final Button logInfo;
    @NotNull
    private final Button logWarn;
    @NotNull
    private final Button logError;
    @NotNull
    private static final LocaleHandler localeHandler = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null);

    public AdvancedSettingsDialog() {
        this.dialog.setLayout((Layout)new GridLayout(1, true));
        this.dialog.setText(localeHandler.get("settingsTitle"));
        Group logLevelGroup = new Group((Composite)this.dialog, 4);
        logLevelGroup.setText("Log Level");
        logLevelGroup.setLayout((Layout)new RowLayout(256));
        Button logAll = new Button((Composite)logLevelGroup, 16);
        logAll.setText("All");
        this.logDebug = new Button((Composite)logLevelGroup, 16);
        this.logDebug.setText("Debug");
        this.logInfo = new Button((Composite)logLevelGroup, 16);
        this.logInfo.setText("Info");
        this.logWarn = new Button((Composite)logLevelGroup, 16);
        this.logWarn.setText("Warn");
        this.logError = new Button((Composite)logLevelGroup, 16);
        this.logError.setText("Error (Recommended)");
        Composite submitGroup = new Composite((Composite)this.dialog, 0);
        RowLayout submitGroupLayout = new RowLayout();
        submitGroupLayout.center = true;
        submitGroup.setLayout((Layout)submitGroupLayout);
        Button saveButton = new Button(submitGroup, 8);
        saveButton.setText(localeHandler.get("&Save"));
        Button cancelButton = new Button(submitGroup, 8);
        cancelButton.setText(localeHandler.get("&Cancel"));
        saveButton.addSelectionListener(EasySWT.INSTANCE.makeSelectedListener(arg_0 -> AdvancedSettingsDialog._init_$lambda$0(this, arg_0)));
        cancelButton.addSelectionListener(EasySWT.INSTANCE.makeSelectedListener(arg_0 -> AdvancedSettingsDialog._init_$lambda$1(this, arg_0)));
        Level level = LogUtils.getLogLevel$default(null, 1, null);
        if (Intrinsics.areEqual((Object)level, (Object)Level.ERROR)) {
            this.logError.setSelection(true);
        } else if (Intrinsics.areEqual((Object)level, (Object)Level.WARN)) {
            this.logWarn.setSelection(true);
        } else if (Intrinsics.areEqual((Object)level, (Object)Level.INFO)) {
            this.logInfo.setSelection(true);
        } else if (Intrinsics.areEqual((Object)level, (Object)Level.DEBUG)) {
            this.logDebug.setSelection(true);
        } else {
            logAll.setSelection(true);
        }
        EasySWT.INSTANCE.setLargeDialogSize(this.dialog);
        this.dialog.open();
    }

    private final void onSave() {
        if (this.logError.getSelection()) {
            LogUtils.setLogLevel$default(Level.ERROR, null, 2, null);
        } else if (this.logWarn.getSelection()) {
            LogUtils.setLogLevel$default(Level.WARN, null, 2, null);
        } else if (this.logInfo.getSelection()) {
            LogUtils.setLogLevel$default(Level.INFO, null, 2, null);
        } else if (this.logDebug.getSelection()) {
            LogUtils.setLogLevel$default(Level.DEBUG, null, 2, null);
        } else {
            LogUtils.setLogLevel$default(Level.ALL, null, 2, null);
        }
        LogUtils.updateLogSettings();
        this.dialog.close();
    }

    private static final void _init_$lambda$0(AdvancedSettingsDialog this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.onSave();
    }

    private static final void _init_$lambda$1(AdvancedSettingsDialog this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.dialog.close();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/brailleblaster/settings/ui/AdvancedSettingsDialog$Companion;", "", "<init>", "()V", "localeHandler", "Lorg/brailleblaster/utils/localization/LocaleHandler;", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

