/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.settings.ui;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nu.xom.Document;
import org.brailleblaster.BBIni;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.document.BrailleDocument;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.settings.ui.EmbosserSettingsTab;
import org.brailleblaster.settings.ui.FormatSettingsTab;
import org.brailleblaster.settings.ui.PageNumbersTab;
import org.brailleblaster.settings.ui.PagePropertiesTab;
import org.brailleblaster.settings.ui.SettingsUITab;
import org.brailleblaster.settings.ui.StatusBarSettingsTab;
import org.brailleblaster.settings.ui.TranslationSettingsTab;
import org.brailleblaster.utd.UTDTranslationEngine;
import org.brailleblaster.utd.config.DocumentUTDConfig;
import org.brailleblaster.utd.config.UTDConfig;
import org.brailleblaster.util.Notify;
import org.brailleblaster.util.WorkingDialog;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.brailleblaster.utils.swt.EasySWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nB%\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0004\b\t\u0010\u000bJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0006\u0010\u001d\u001a\u00020\u001aR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/brailleblaster/settings/ui/BrailleSettingsDialog;", "", "parent", "Lorg/eclipse/swt/widgets/Shell;", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "tabToOpen", "Ljava/lang/Class;", "Lorg/brailleblaster/settings/ui/SettingsUITab;", "<init>", "(Lorg/eclipse/swt/widgets/Shell;Lorg/brailleblaster/perspectives/braille/Manager;Ljava/lang/Class;)V", "(Lorg/brailleblaster/perspectives/braille/Manager;Ljava/lang/Class;)V", "engine", "Lorg/brailleblaster/utd/UTDTranslationEngine;", "shell", "getShell", "()Lorg/eclipse/swt/widgets/Shell;", "pageProperties", "pageNumTab", "embosserTab", "translationTab", "Lorg/brailleblaster/settings/ui/TranslationSettingsTab;", "formatTab", "Lorg/brailleblaster/settings/ui/FormatSettingsTab;", "statusBarSettingsTab", "saveConfig", "", "saveAsDefault", "", "close", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nBrailleSettingsDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrailleSettingsDialog.kt\norg/brailleblaster/settings/ui/BrailleSettingsDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1#2:211\n*E\n"})
public final class BrailleSettingsDialog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final UTDTranslationEngine engine;
    @Nullable
    private final Manager m;
    @Nullable
    private final Shell shell;
    @Nullable
    private final SettingsUITab pageProperties;
    @Nullable
    private final SettingsUITab pageNumTab;
    @Nullable
    private SettingsUITab embosserTab;
    @Nullable
    private final TranslationSettingsTab translationTab;
    @Nullable
    private final FormatSettingsTab formatTab;
    @Nullable
    private final SettingsUITab statusBarSettingsTab;
    @NotNull
    private static final LocaleHandler localeHandler = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null);
    @NotNull
    public static final String SWTBOT_OK_BUTTON = "translationSettingsTab.ok";
    @NotNull
    public static final String SWTBOT_OK_DEFAULT_BUTTON = "translationSettingsTab.okDefault";

    public BrailleSettingsDialog(@Nullable Shell parent, @Nullable Manager m, @NotNull Class<? extends SettingsUITab> tabToOpen) {
        Intrinsics.checkNotNullParameter(tabToOpen, (String)"tabToOpen");
        if (m == null) {
            Notify.showMessage("Must open document first", new Object[0]);
            this.engine = null;
            this.shell = null;
            this.m = null;
            this.translationTab = null;
            this.pageNumTab = null;
            this.pageProperties = null;
            this.embosserTab = null;
            this.formatTab = null;
            this.statusBarSettingsTab = null;
        } else {
            m.waitForFormatting(true);
            this.engine = m.getDocument().getEngine();
            this.m = m;
            this.shell = parent != null ? EasySWT.INSTANCE.makeDialog(parent) : EasySWT.INSTANCE.makeDialog(m.getWpManager().getShell());
            this.shell.setText(localeHandler.get("settings"));
            this.shell.setLayout((Layout)new GridLayout(1, true));
            TabFolder folder = new TabFolder((Composite)this.shell, 0);
            EasySWT.INSTANCE.setGridData((Control)folder);
            Intrinsics.checkNotNull((Object)folder.getLayoutData(), (String)"null cannot be cast to non-null type org.eclipse.swt.layout.GridData");
            ((GridData)folder.getLayoutData()).grabExcessVerticalSpace = true;
            this.pageProperties = PagePropertiesTab.Companion.create(folder, this.engine, this.shell);
            BrailleDocument brailleDocument = m.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)brailleDocument, (String)"getDocument(...)");
            this.translationTab = new TranslationSettingsTab(folder, brailleDocument);
            this.pageNumTab = new PageNumbersTab(folder, this.engine.getPageSettings());
            BrailleDocument brailleDocument2 = m.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)brailleDocument2, (String)"getDocument(...)");
            this.formatTab = new FormatSettingsTab(folder, brailleDocument2);
            this.embosserTab = new EmbosserSettingsTab(folder);
            this.statusBarSettingsTab = new StatusBarSettingsTab(folder);
            Composite buttonPanel = new Composite((Composite)this.shell, 0);
            EasySWT.INSTANCE.setGridData((Control)buttonPanel);
            buttonPanel.setLayout((Layout)new RowLayout(256));
            Button okButton = new Button(buttonPanel, 8);
            okButton.setText(localeHandler.get(localeHandler.get("buttonOk")));
            EasySWT.INSTANCE.addSwtBotKey((Control)okButton, SWTBOT_OK_BUTTON);
            Button okDefaultButton = new Button(buttonPanel, 8);
            okDefaultButton.setText("Make Default");
            EasySWT.INSTANCE.addSwtBotKey((Control)okDefaultButton, SWTBOT_OK_DEFAULT_BUTTON);
            Button cancelButton = new Button(buttonPanel, 8);
            cancelButton.setText("Cancel");
            this.shell.addTraverseListener(arg_0 -> BrailleSettingsDialog._init_$lambda$0(this, arg_0));
            this.shell.addListener(21, arg_0 -> BrailleSettingsDialog._init_$lambda$1(this, arg_0));
            okButton.addSelectionListener(EasySWT.INSTANCE.makeSelectedListener(arg_0 -> BrailleSettingsDialog._init_$lambda$2(this, arg_0)));
            okDefaultButton.addSelectionListener(EasySWT.INSTANCE.makeSelectedListener(arg_0 -> BrailleSettingsDialog._init_$lambda$3(this, arg_0)));
            cancelButton.addSelectionListener(EasySWT.INSTANCE.makeSelectedListener(arg_0 -> BrailleSettingsDialog._init_$lambda$4(this, arg_0)));
            Class<? extends SettingsUITab> clazz = tabToOpen;
            if (Intrinsics.areEqual(clazz, PagePropertiesTab.class)) {
                folder.setSelection(0);
            } else if (Intrinsics.areEqual(clazz, TranslationSettingsTab.class)) {
                folder.setSelection(1);
            } else if (Intrinsics.areEqual(clazz, PageNumbersTab.class)) {
                folder.setSelection(2);
            } else if (Intrinsics.areEqual(clazz, FormatSettingsTab.class)) {
                folder.setSelection(3);
            } else if (Intrinsics.areEqual(clazz, EmbosserSettingsTab.class)) {
                folder.setSelection(4);
            } else if (Intrinsics.areEqual(clazz, StatusBarSettingsTab.class)) {
                folder.setSelection(5);
            }
            EasySWT.INSTANCE.setLargeDialogSize(this.shell);
            this.shell.open();
        }
    }

    @Nullable
    public final Shell getShell() {
        return this.shell;
    }

    public BrailleSettingsDialog(@Nullable Manager m, @NotNull Class<? extends SettingsUITab> tabToOpen) {
        Intrinsics.checkNotNullParameter(tabToOpen, (String)"tabToOpen");
        this(null, m, tabToOpen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveConfig(boolean saveAsDefault) {
        String string;
        String errorStr = null;
        SettingsUITab settingsUITab = this.pageProperties;
        Intrinsics.checkNotNull((Object)settingsUITab);
        String it = string = settingsUITab.validate();
        boolean bl = false;
        errorStr = it;
        if (string != null) {
            String string2 = errorStr;
            Intrinsics.checkNotNull((Object)string2);
            Notify.notify$default(Notify.INSTANCE, localeHandler.get(string2), Notify.EXCEPTION_SHELL_NAME, false, 4, null);
        } else {
            TranslationSettingsTab translationSettingsTab = this.translationTab;
            Intrinsics.checkNotNull((Object)translationSettingsTab);
            it = string = translationSettingsTab.validate();
            boolean bl2 = false;
            errorStr = it;
            if (string != null) {
                String string3 = errorStr;
                Intrinsics.checkNotNull((Object)string3);
                Notify.notify$default(Notify.INSTANCE, localeHandler.get(string3), Notify.EXCEPTION_SHELL_NAME, false, 4, null);
            } else {
                SettingsUITab settingsUITab2 = this.pageNumTab;
                Intrinsics.checkNotNull((Object)settingsUITab2);
                it = string = settingsUITab2.validate();
                boolean bl3 = false;
                errorStr = it;
                if (string != null) {
                    String string4 = errorStr;
                    Intrinsics.checkNotNull((Object)string4);
                    Notify.notify$default(Notify.INSTANCE, localeHandler.get(string4), Notify.EXCEPTION_SHELL_NAME, false, 4, null);
                } else {
                    boolean updated = false;
                    UTDTranslationEngine uTDTranslationEngine = this.engine;
                    Intrinsics.checkNotNull((Object)uTDTranslationEngine);
                    if (this.pageProperties.updateEngine(uTDTranslationEngine)) {
                        Manager manager = this.m;
                        Intrinsics.checkNotNull((Object)manager);
                        Document document = manager.getDoc();
                        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"<get-doc>(...)");
                        DocumentUTDConfig.NIMAS.savePageSettings(document, this.engine.getPageSettings());
                        if (saveAsDefault) {
                            UTDConfig.INSTANCE.savePageSettings(UTDManager.Companion.getUserPageSettingsFile(), this.engine.getPageSettings());
                        }
                        updated = true;
                    }
                    if (this.translationTab.updateEngine(this.engine)) {
                        Manager manager = this.m;
                        Intrinsics.checkNotNull((Object)manager);
                        UTDManager uTDManager = manager.getDocument().getSettingsManager();
                        Document document = this.m.getDoc();
                        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"<get-doc>(...)");
                        uTDManager.updateBrailleStandard(document, this.translationTab.getSelectedName());
                        if (saveAsDefault) {
                            BBIni.getPropertyFileManager().save("brailleStandard", this.translationTab.getSelectedName());
                        }
                        updated = true;
                    }
                    FormatSettingsTab formatSettingsTab = this.formatTab;
                    Intrinsics.checkNotNull((Object)formatSettingsTab);
                    if (formatSettingsTab.updateEngine(this.engine)) {
                        Manager manager = this.m;
                        Intrinsics.checkNotNull((Object)manager);
                        UTDManager uTDManager = manager.getDocument().getSettingsManager();
                        Document document = this.m.getDoc();
                        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"<get-doc>(...)");
                        uTDManager.updatePredominantQuote(document, this.formatTab.getPredominantQuote());
                        if (saveAsDefault) {
                            BBIni.getPropertyFileManager().save("predominantQuote", this.formatTab.getPredominantQuote().name());
                        }
                        updated = true;
                    }
                    boolean tryAgain = false;
                    try {
                        if (this.pageNumTab.updateEngine(this.engine)) {
                            Manager manager = this.m;
                            Intrinsics.checkNotNull((Object)manager);
                            Document document = manager.getDoc();
                            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"<get-doc>(...)");
                            DocumentUTDConfig.NIMAS.savePageSettings(document, this.engine.getPageSettings());
                            if (saveAsDefault) {
                                UTDConfig.INSTANCE.savePageSettings(UTDManager.Companion.getUserPageSettingsFile(), this.engine.getPageSettings());
                            }
                            updated = true;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        MessageBox messageBox = new MessageBox(this.shell, 40);
                        messageBox.setText("Warning");
                        messageBox.setMessage("Braille and Print page numbers cannot be on the same location");
                        messageBox.open();
                        tryAgain = true;
                    }
                    SettingsUITab settingsUITab3 = this.embosserTab;
                    Intrinsics.checkNotNull((Object)settingsUITab3);
                    if (settingsUITab3.updateEngine(this.engine)) {
                        updated = true;
                    }
                    if (updated) {
                        AutoCloseable autoCloseable = new WorkingDialog("Refreshing view due to settings changes");
                        Throwable throwable = null;
                        try {
                            WorkingDialog it2 = (WorkingDialog)autoCloseable;
                            boolean bl4 = false;
                            Manager manager = this.m;
                            Intrinsics.checkNotNull((Object)manager);
                            manager.refresh();
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                        }
                    }
                    if (!tryAgain) {
                        this.close();
                    }
                }
            }
        }
    }

    public final void close() {
        Shell shell = this.shell;
        Intrinsics.checkNotNull((Object)shell);
        shell.dispose();
    }

    private static final void _init_$lambda$0(BrailleSettingsDialog this$0, TraverseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.keyCode == 27) {
            this$0.shell.close();
        }
    }

    private static final void _init_$lambda$1(BrailleSettingsDialog this$0, Event it) {
        this$0.close();
    }

    private static final void _init_$lambda$2(BrailleSettingsDialog this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.saveConfig(false);
    }

    private static final void _init_$lambda$3(BrailleSettingsDialog this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.saveConfig(true);
    }

    private static final void _init_$lambda$4(BrailleSettingsDialog this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.close();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/brailleblaster/settings/ui/BrailleSettingsDialog$Companion;", "", "<init>", "()V", "localeHandler", "Lorg/brailleblaster/utils/localization/LocaleHandler;", "SWTBOT_OK_BUTTON", "", "SWTBOT_OK_DEFAULT_BUTTON", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

