/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.settings.ui;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import org.brailleblaster.settings.ui.SettingsUITab;
import org.brailleblaster.utd.PageSettings;
import org.brailleblaster.utd.UTDTranslationEngine;
import org.brailleblaster.utd.properties.PageNumberPosition;
import org.brailleblaster.util.FormUIUtils;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.brailleblaster.utils.swt.AccessibilityUtils;
import org.brailleblaster.utils.swt.EasySWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"Lorg/brailleblaster/settings/ui/PageNumbersTab;", "Lorg/brailleblaster/settings/ui/SettingsUITab;", "folder", "Lorg/eclipse/swt/widgets/TabFolder;", "pageSettingsDefault", "Lorg/brailleblaster/utd/PageSettings;", "<init>", "(Lorg/eclipse/swt/widgets/TabFolder;Lorg/brailleblaster/utd/PageSettings;)V", "evenBrailleNumCombo", "Lorg/eclipse/swt/widgets/Combo;", "evenPrintNumCombo", "continueSymbolsCombo", "continuePagesCombo", "guideWordsCombo", "oddBrailleNumCombo", "oddPrintNumCombo", "continuationIndicatorCombo", "shell", "Lorg/eclipse/swt/widgets/Shell;", "getShell", "()Lorg/eclipse/swt/widgets/Shell;", "setShell", "(Lorg/eclipse/swt/widgets/Shell;)V", "validate", "", "updateEngine", "", "engine", "Lorg/brailleblaster/utd/UTDTranslationEngine;", "Companion", "brailleblaster-core"})
public final class PageNumbersTab
implements SettingsUITab {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Combo evenBrailleNumCombo;
    @NotNull
    private final Combo evenPrintNumCombo;
    @NotNull
    private final Combo continueSymbolsCombo;
    @NotNull
    private final Combo continuePagesCombo;
    @NotNull
    private final Combo guideWordsCombo;
    @NotNull
    private final Combo oddBrailleNumCombo;
    @NotNull
    private final Combo oddPrintNumCombo;
    @NotNull
    private final Combo continuationIndicatorCombo;
    @NotNull
    private Shell shell;
    @NotNull
    private static final LocaleHandler localeHandler = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null);

    public PageNumbersTab(@NotNull TabFolder folder, @NotNull PageSettings pageSettingsDefault) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        Intrinsics.checkNotNullParameter((Object)pageSettingsDefault, (String)"pageSettingsDefault");
        Shell shell = folder.getShell();
        Intrinsics.checkNotNullExpressionValue((Object)shell, (String)"getShell(...)");
        this.shell = shell;
        TabItem item = new TabItem(folder, 0);
        item.setText(localeHandler.get("pageNumbers"));
        Composite parent = new Composite((Composite)folder, 0);
        parent.setLayout((Layout)new GridLayout(1, true));
        item.setControl((Control)parent);
        Group brailleGroup = new Group(parent, 0);
        brailleGroup.setLayout((Layout)new GridLayout(2, true));
        brailleGroup.setText(localeHandler.get("braille"));
        EasySWT.INSTANCE.setGridDataGroup(brailleGroup);
        Label evenBraille = EasySWT.INSTANCE.addLabel((Composite)brailleGroup, "Even Braille Page Number");
        evenBraille.setToolTipText("Sets location of even braille page number.");
        this.evenBrailleNumCombo = PageNumbersTab.Companion.makeNumberPositionCombo((Composite)brailleGroup, pageSettingsDefault.getEvenBraillePageNumberAt());
        AccessibilityUtils.appendName((Control)((Control)this.evenBrailleNumCombo), (String)"Sets location of even braille page number.");
        Label oddBraille = EasySWT.INSTANCE.addLabel((Composite)brailleGroup, "Odd Braille Page Number");
        oddBraille.setToolTipText("Sets location of odd braille page number.");
        this.oddBrailleNumCombo = PageNumbersTab.Companion.makeNumberPositionCombo((Composite)brailleGroup, pageSettingsDefault.getOddBraillePageNumberAt());
        AccessibilityUtils.appendName((Control)((Control)this.oddBrailleNumCombo), (String)"Sets location of odd braille page number.");
        Group printGroup = new Group(parent, 0);
        printGroup.setLayout((Layout)new GridLayout(2, true));
        printGroup.setText(localeHandler.get("print"));
        EasySWT.INSTANCE.setGridDataGroup(printGroup);
        Label evenPrint = EasySWT.INSTANCE.addLabel((Composite)printGroup, "Even Print Page Number");
        evenPrint.setToolTipText("Sets location of print page number when the braille page number is even.");
        this.evenPrintNumCombo = PageNumbersTab.Companion.makeNumberPositionCombo((Composite)printGroup, pageSettingsDefault.getEvenPrintPageNumberAt());
        AccessibilityUtils.appendName((Control)((Control)this.evenPrintNumCombo), (String)"Sets location of print page number when the braille page number is even.");
        Label oddPrint = EasySWT.INSTANCE.addLabel((Composite)printGroup, "Odd Print Page Number");
        oddPrint.setToolTipText("Sets location of print page number when the braille page number is odd.");
        this.oddPrintNumCombo = PageNumbersTab.Companion.makeNumberPositionCombo((Composite)printGroup, pageSettingsDefault.getOddPrintPageNumberAt());
        AccessibilityUtils.appendName((Control)((Control)this.oddPrintNumCombo), (String)"Sets location of print page number when the braille page number is odd.");
        Label contSymbols = EasySWT.INSTANCE.addLabel((Composite)printGroup, "Lettered Continuation Pages");
        contSymbols.setToolTipText("Sets whether a letter appears to the left of a print page number on runovers.");
        this.continueSymbolsCombo = PageNumbersTab.Companion.makeYesNoCombo((Composite)printGroup, pageSettingsDefault.isPrintPageNumberRange());
        AccessibilityUtils.appendName((Control)((Control)this.continueSymbolsCombo), (String)"Sets whether a letter appears to the left of a print page number on runovers.");
        Label contIndicator = EasySWT.INSTANCE.addLabel((Composite)printGroup, "Continuation Indicator For Print Pages");
        contIndicator.setToolTipText("Uses Grade 1 symbol indicator between continuation letter and alphabetic page number.");
        this.continuationIndicatorCombo = PageNumbersTab.Companion.makeYesNoCombo((Composite)printGroup, pageSettingsDefault.isPrintPageLetterIndicator());
        AccessibilityUtils.appendName((Control)((Control)this.continuationIndicatorCombo), (String)"Use Grade 1 symbol indicator between continuation letter and alphabetic page number.");
        Group cpGroup = new Group(parent, 0);
        cpGroup.setLayout((Layout)new GridLayout(2, true));
        cpGroup.setText(localeHandler.get("continue"));
        EasySWT.INSTANCE.setGridDataGroup(cpGroup);
        Label contPages = EasySWT.INSTANCE.addLabel((Composite)cpGroup, "Continue Braille Pages Across Volumes");
        contPages.setToolTipText("Sets whether braille page numbering resets at start of new volume.");
        this.continuePagesCombo = PageNumbersTab.Companion.makeYesNoCombo((Composite)cpGroup, pageSettingsDefault.isContinuePages());
        EasySWT.INSTANCE.setGridData((Control)this.continuePagesCombo);
        AccessibilityUtils.appendName((Control)((Control)this.continuePagesCombo), (String)"Sets whether braille page numbering resets at start of new volume.");
        Group guideWordsGrp = new Group(parent, 0);
        guideWordsGrp.setLayout((Layout)new GridLayout(2, true));
        guideWordsGrp.setText("Guide Words");
        EasySWT.INSTANCE.setGridDataGroup(guideWordsGrp);
        Label guideWords = EasySWT.INSTANCE.addLabel((Composite)guideWordsGrp, "Guide Words");
        guideWords.setToolTipText("Turns automatic Guide Words on/off for entire document.");
        this.guideWordsCombo = PageNumbersTab.Companion.makeYesNoCombo((Composite)guideWordsGrp, pageSettingsDefault.isGuideWords());
        EasySWT.INSTANCE.setGridData((Control)this.guideWordsCombo);
        AccessibilityUtils.appendName((Control)((Control)this.guideWordsCombo), (String)"Turns automatic Guide Words on/off for entire document.");
    }

    @NotNull
    public final Shell getShell() {
        return this.shell;
    }

    public final void setShell(@NotNull Shell shell) {
        Intrinsics.checkNotNullParameter((Object)shell, (String)"<set-?>");
        this.shell = shell;
    }

    @Override
    @Nullable
    public String validate() {
        return null;
    }

    @Override
    public boolean updateEngine(@NotNull UTDTranslationEngine engine) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        PageSettings pageSettings = engine.getPageSettings();
        List pageNumberLocations = new ArrayList();
        String string = this.evenPrintNumCombo.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        pageNumberLocations.add(PageNumberPosition.valueOf((String)string));
        String string2 = this.oddPrintNumCombo.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        pageNumberLocations.add(PageNumberPosition.valueOf((String)string2));
        String string3 = this.evenBrailleNumCombo.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        pageNumberLocations.add(PageNumberPosition.valueOf((String)string3));
        String string4 = this.oddBrailleNumCombo.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
        pageNumberLocations.add(PageNumberPosition.valueOf((String)string4));
        return FormUIUtils.INSTANCE.updateObject((KMutableProperty0)new MutablePropertyReference0Impl(pageSettings){

            public Object get() {
                return ((PageSettings)this.receiver).getPageNumberLocations();
            }

            public void set(Object value) {
                ((PageSettings)this.receiver).setPageNumberLocations((List)value);
            }
        }, pageNumberLocations) || FormUIUtils.INSTANCE.updateObject((KMutableProperty0)new MutablePropertyReference0Impl(pageSettings){

            public Object get() {
                return ((PageSettings)this.receiver).isPrintPageNumberRange();
            }

            public void set(Object value) {
                ((PageSettings)this.receiver).setPrintPageNumberRange(((Boolean)value).booleanValue());
            }
        }, Intrinsics.areEqual((Object)this.continueSymbolsCombo.getText(), (Object)"Yes")) || FormUIUtils.INSTANCE.updateObject((KMutableProperty0)new MutablePropertyReference0Impl(pageSettings){

            public Object get() {
                return ((PageSettings)this.receiver).isContinuePages();
            }

            public void set(Object value) {
                ((PageSettings)this.receiver).setContinuePages(((Boolean)value).booleanValue());
            }
        }, Intrinsics.areEqual((Object)this.continuePagesCombo.getText(), (Object)"Yes")) || FormUIUtils.INSTANCE.updateObject((KMutableProperty0)new MutablePropertyReference0Impl(pageSettings){

            public Object get() {
                return ((PageSettings)this.receiver).isPrintPageLetterIndicator();
            }

            public void set(Object value) {
                ((PageSettings)this.receiver).setPrintPageLetterIndicator(((Boolean)value).booleanValue());
            }
        }, Intrinsics.areEqual((Object)this.continuationIndicatorCombo.getText(), (Object)"Yes")) || FormUIUtils.INSTANCE.updateObject((KMutableProperty0)new MutablePropertyReference0Impl(pageSettings){

            public Object get() {
                return ((PageSettings)this.receiver).isGuideWords();
            }

            public void set(Object value) {
                ((PageSettings)this.receiver).setGuideWords(((Boolean)value).booleanValue());
            }
        }, Intrinsics.areEqual((Object)this.guideWordsCombo.getText(), (Object)"Yes"));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/brailleblaster/settings/ui/PageNumbersTab$Companion;", "", "<init>", "()V", "localeHandler", "Lorg/brailleblaster/utils/localization/LocaleHandler;", "makeNumberPositionCombo", "Lorg/eclipse/swt/widgets/Combo;", "parent", "Lorg/eclipse/swt/widgets/Composite;", "defaultValue", "Lorg/brailleblaster/utd/properties/PageNumberPosition;", "makeYesNoCombo", "", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        private final Combo makeNumberPositionCombo(Composite parent, PageNumberPosition defaultValue) {
            Combo combo = new Combo(parent, 8);
            for (PageNumberPosition curLoc : PageNumberPosition.getEntries()) {
                combo.add(curLoc.name());
            }
            combo.setText(defaultValue.name());
            EasySWT.INSTANCE.setGridData((Control)combo);
            return combo;
        }

        private final Combo makeYesNoCombo(Composite parent, boolean defaultValue) {
            Combo combo = new Combo(parent, 8);
            combo.add("Yes");
            combo.add("No");
            if (defaultValue) {
                combo.setText("Yes");
            } else {
                combo.setText("No");
            }
            EasySWT.INSTANCE.setGridData((Control)combo);
            return combo;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

