/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.settings.ui;

import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.brailleblaster.BBIni;
import org.brailleblaster.document.BBDocument;
import org.brailleblaster.libembosser.spi.BrlCell;
import org.brailleblaster.settings.ui.SettingsUITab;
import org.brailleblaster.utd.BrailleSettings;
import org.brailleblaster.utd.UTDTranslationEngine;
import org.brailleblaster.utd.config.UTDConfig;
import org.brailleblaster.utd.properties.BrailleTableType;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.brailleblaster.utils.swt.EasySWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B\u001b\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\nH\u0002J\n\u0010\u001e\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006$"}, d2={"Lorg/brailleblaster/settings/ui/TranslationSettingsTab;", "Lorg/brailleblaster/settings/ui/SettingsUITab;", "folder", "Lorg/eclipse/swt/widgets/TabFolder;", "bbdoc", "Lorg/brailleblaster/document/BBDocument;", "<init>", "(Lorg/eclipse/swt/widgets/TabFolder;Lorg/brailleblaster/document/BBDocument;)V", "config", "", "", "Ljava/io/File;", "standardCombo", "Lorg/eclipse/swt/widgets/Combo;", "brailleCellRadios", "", "Lorg/eclipse/swt/widgets/Button;", "mainTableText", "Lorg/eclipse/swt/widgets/Text;", "compTableText", "unconTableText", "mathTextTableText", "mathExprTableText", "value", "selectedName", "getSelectedName", "()Ljava/lang/String;", "updateUI", "", "standardName", "validate", "updateEngine", "", "engine", "Lorg/brailleblaster/utd/UTDTranslationEngine;", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nTranslationSettingsTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TranslationSettingsTab.kt\norg/brailleblaster/settings/ui/TranslationSettingsTab\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,188:1\n507#2,7:189\n*S KotlinDebug\n*F\n+ 1 TranslationSettingsTab.kt\norg/brailleblaster/settings/ui/TranslationSettingsTab\n*L\n117#1:189,7\n*E\n"})
public final class TranslationSettingsTab
implements SettingsUITab {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BBDocument bbdoc;
    @NotNull
    private final Map<String, File> config;
    @NotNull
    private final Combo standardCombo;
    @NotNull
    private final Map<String, Button> brailleCellRadios;
    @NotNull
    private final Text mainTableText;
    @NotNull
    private final Text compTableText;
    @NotNull
    private final Text unconTableText;
    @NotNull
    private final Text mathTextTableText;
    @NotNull
    private final Text mathExprTableText;
    private String selectedName;
    @NotNull
    private static final LocaleHandler localeHandler = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null);
    private static final Logger log = LoggerFactory.getLogger(TranslationSettingsTab.class);
    @NotNull
    private static final String FILE_SUFFIX = ".brailleSettings.xml";
    @NotNull
    public static final String SWTBOT_STANDARD_COMBO = "translationSettingsTab.standard";
    @NotNull
    public static final String UEB_PLUS_NEMETH = "UEB-PLUS-NEMETH";
    @NotNull
    public static final String UEB = "UEB";

    public TranslationSettingsTab(@Nullable TabFolder folder, @NotNull BBDocument bbdoc) {
        Intrinsics.checkNotNullParameter((Object)bbdoc, (String)"bbdoc");
        this.bbdoc = bbdoc;
        this.brailleCellRadios = new HashMap();
        TabItem tab = new TabItem(folder, 0);
        tab.setText(localeHandler.get("translationSettings"));
        Composite parent = new Composite((Composite)folder, 0);
        parent.setLayout((Layout)new GridLayout(1, true));
        tab.setControl((Control)parent);
        Group standardsGroup = new Group(parent, 0);
        standardsGroup.setLayout((Layout)new GridLayout(2, true));
        standardsGroup.setText("Standards");
        EasySWT.INSTANCE.setGridData((Control)standardsGroup);
        EasySWT.INSTANCE.addLabel((Composite)standardsGroup, "Braille Standard");
        this.standardCombo = new Combo((Composite)standardsGroup, 8);
        EasySWT.INSTANCE.setGridData((Control)this.standardCombo);
        EasySWT.INSTANCE.addSwtBotKey((Control)this.standardCombo, SWTBOT_STANDARD_COMBO);
        Group settingsGroup = new Group(parent, 0);
        settingsGroup.setLayout((Layout)new GridLayout(2, false));
        settingsGroup.setText("Selected Standard Settings");
        EasySWT.INSTANCE.setGridData((Control)settingsGroup);
        EasySWT.INSTANCE.addLabel((Composite)settingsGroup, "Cell type");
        Composite cellTypeContainer = new Composite((Composite)settingsGroup, 0);
        cellTypeContainer.setLayout((Layout)new RowLayout());
        for (BrlCell curType : EntriesMappings.entries$0) {
            Button typeButton = new Button(cellTypeContainer, 16);
            typeButton.setEnabled(false);
            typeButton.setText(curType.name());
            this.brailleCellRadios.put(curType.name(), typeButton);
        }
        EasySWT.INSTANCE.addLabel((Composite)settingsGroup, "Main Translation Table");
        this.mainTableText = new Text((Composite)settingsGroup, 2048);
        this.mainTableText.setEnabled(false);
        EasySWT.INSTANCE.setGridData((Control)this.mainTableText);
        EasySWT.INSTANCE.addLabel((Composite)settingsGroup, "Computer Braille Table");
        this.compTableText = new Text((Composite)settingsGroup, 2048);
        this.compTableText.setEnabled(false);
        EasySWT.INSTANCE.setGridData((Control)this.compTableText);
        EasySWT.INSTANCE.addLabel((Composite)settingsGroup, "Uncontracted Table");
        this.unconTableText = new Text((Composite)settingsGroup, 2048);
        this.unconTableText.setEnabled(false);
        EasySWT.INSTANCE.setGridData((Control)this.unconTableText);
        EasySWT.INSTANCE.addLabel((Composite)settingsGroup, "Math Text Table");
        this.mathTextTableText = new Text((Composite)settingsGroup, 2048);
        this.mathTextTableText.setEnabled(false);
        EasySWT.INSTANCE.setGridData((Control)this.mathTextTableText);
        EasySWT.INSTANCE.addLabel((Composite)settingsGroup, "Math Expression Table");
        this.mathExprTableText = new Text((Composite)settingsGroup, 2048);
        this.mathExprTableText.setEnabled(false);
        EasySWT.INSTANCE.setGridData((Control)this.mathExprTableText);
        this.standardCombo.addSelectionListener(EasySWT.INSTANCE.makeSelectedListener(arg_0 -> TranslationSettingsTab._init_$lambda$0(this, arg_0)));
        this.config = TranslationSettingsTab.Companion.loadAllStandardFiles();
        for (String curKey : this.config.keySet()) {
            this.standardCombo.add(curKey);
        }
        String stdBaseName = this.bbdoc.getSettingsManager().getBrailleStandard();
        Map<String, File> $this$filterValues$iv = this.config;
        boolean $i$f$filterValues = false;
        LinkedHashMap<String, File> result$iv = new LinkedHashMap<String, File>();
        for (Map.Entry<String, File> entry$iv : $this$filterValues$iv.entrySet()) {
            File it = entry$iv.getValue();
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!Intrinsics.areEqual((Object)StringsKt.removeSuffix((String)string, (CharSequence)FILE_SUFFIX), (Object)stdBaseName)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        String currentStd = (String)CollectionsKt.first((Iterable)((Map)result$iv).keySet());
        this.standardCombo.select(this.standardCombo.indexOf(currentStd));
        this.updateUI(currentStd);
    }

    @NotNull
    public final String getSelectedName() {
        String string = this.selectedName;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"selectedName");
        return null;
    }

    private final void updateUI(String standardName) {
        try {
            File file = this.config.get(standardName);
            Intrinsics.checkNotNull((Object)file);
            File selectedConfig = file;
            BrailleSettings selectedSettings = UTDConfig.loadBrailleSettings((File)selectedConfig);
            String string = selectedConfig.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            this.selectedName = StringsKt.removeSuffix((String)string, (CharSequence)FILE_SUFFIX);
            this.mainTableText.setText(BrailleTableType.LITERARY.getTableName(selectedSettings));
            this.compTableText.setText(BrailleTableType.COMPUTER_BRAILLE.getTableName(selectedSettings));
            this.unconTableText.setText(BrailleTableType.UNCONTRACTED.getTableName(selectedSettings));
            this.mathTextTableText.setText(BrailleTableType.MATH_TEXT.getTableName(selectedSettings));
            this.mathExprTableText.setText(BrailleTableType.MATH.getTableName(selectedSettings));
            Button button = this.brailleCellRadios.get(selectedSettings.getCellType().name());
            Intrinsics.checkNotNull((Object)button);
            button.setSelection(true);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed when loading standard " + standardName, ex);
        }
    }

    @Override
    @Nullable
    public String validate() {
        return null;
    }

    @Override
    public boolean updateEngine(@NotNull UTDTranslationEngine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        return !Intrinsics.areEqual((Object)this.bbdoc.getSettingsManager().getBrailleStandard(), (Object)this.getSelectedName());
    }

    private static final void _init_$lambda$0(TranslationSettingsTab this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = this$0.standardCombo.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this$0.updateUI(string);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/brailleblaster/settings/ui/TranslationSettingsTab$Companion;", "", "<init>", "()V", "localeHandler", "Lorg/brailleblaster/utils/localization/LocaleHandler;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "FILE_SUFFIX", "", "SWTBOT_STANDARD_COMBO", "UEB_PLUS_NEMETH", "UEB", "loadAllStandardFiles", "", "Ljava/io/File;", "brailleblaster-core"})
    @SourceDebugExtension(value={"SMAP\nTranslationSettingsTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TranslationSettingsTab.kt\norg/brailleblaster/settings/ui/TranslationSettingsTab$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,188:1\n11705#2:189\n12052#2,3:190\n11705#2:193\n12052#2,3:194\n11705#2:197\n12052#2,3:198\n37#3,2:201\n*S KotlinDebug\n*F\n+ 1 TranslationSettingsTab.kt\norg/brailleblaster/settings/ui/TranslationSettingsTab$Companion\n*L\n171#1:189\n171#1:190,3\n174#1:193\n174#1:194,3\n178#1:197\n178#1:198,3\n184#1:201,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final Map<String, File> loadAllStandardFiles() {
            List list;
            List list2;
            List list3;
            Object object;
            int n;
            File[] destination$iv$iv;
            FilenameFilter fileFilter = Companion::loadAllStandardFiles$lambda$0;
            File[] fileArray = BBIni.getProgramDataPath().resolve("utd").toFile().listFiles(fileFilter);
            if (fileArray != null) {
                void $this$mapTo$iv$iv;
                File[] $this$map$iv = fileArray;
                boolean $i$f$map = false;
                File[] fileArray2 = $this$map$iv;
                destination$iv$iv = (File[])new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var13_24 = item$iv$iv = $this$mapTo$iv$iv[i];
                    object = destination$iv$iv;
                    boolean bl = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    object.add(TuplesKt.to((Object)StringsKt.removeSuffix((String)string, (CharSequence)TranslationSettingsTab.FILE_SUFFIX), (Object)it));
                }
                list3 = (List)destination$iv$iv;
            } else {
                list3 = CollectionsKt.emptyList();
            }
            List defaultFiles = list3;
            File[] fileArray3 = BBIni.getUserProgramDataPath().resolve("utd").toFile().listFiles(fileFilter);
            if (fileArray3 != null) {
                void $this$mapTo$iv$iv;
                File[] $this$map$iv = fileArray3;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n2 = ((void)$this$mapTo$iv$iv).length;
                for (n = 0; n < n2; ++n) {
                    void it;
                    void item$iv$iv;
                    void bl = item$iv$iv = $this$mapTo$iv$iv[n];
                    object = destination$iv$iv2;
                    boolean bl2 = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    object.add(TuplesKt.to((Object)StringsKt.removeSuffix((String)string, (CharSequence)TranslationSettingsTab.FILE_SUFFIX), (Object)it));
                }
                list2 = (List)destination$iv$iv2;
            } else {
                list2 = CollectionsKt.emptyList();
            }
            List userFiles = list2;
            String[] $this$map$iv = new String[]{"legacy"};
            File[] fileArray4 = BBIni.getProgramDataPath().resolve(Paths.get("utd", $this$map$iv)).toFile().listFiles(fileFilter);
            if (fileArray4 != null) {
                void $this$mapTo$iv$iv;
                File[] $this$map$iv2 = fileArray4;
                boolean $i$f$map = false;
                File[] destination$iv$iv2 = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList($this$map$iv2.length);
                boolean $i$f$mapTo = false;
                int n3 = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n3; ++i) {
                    void it;
                    void item$iv$iv;
                    void bl2 = item$iv$iv = $this$mapTo$iv$iv[i];
                    object = destination$iv$iv3;
                    boolean bl = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    object.add(TuplesKt.to((Object)(StringsKt.removeSuffix((String)string, (CharSequence)TranslationSettingsTab.FILE_SUFFIX) + " (Legacy)"), (Object)it));
                }
                list = (List)destination$iv$iv3;
            } else {
                list = CollectionsKt.emptyList();
            }
            List legacyFiles = list;
            List filesToInsert = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)defaultFiles, (Iterable)userFiles), (Iterable)legacyFiles);
            Collection $this$toTypedArray$iv = filesToInsert;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
            LinkedHashMap results = MapsKt.linkedMapOf((Pair[])Arrays.copyOf(pairArray, pairArray.length));
            return results;
        }

        private static final boolean loadAllStandardFiles$lambda$0(File dir, String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return StringsKt.endsWith$default((String)name, (String)TranslationSettingsTab.FILE_SUFFIX, (boolean)false, (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<BrlCell> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])BrlCell.values()));
        }
    }
}

