/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.tools;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.WhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.interfaces.Uneditable;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.braille.stylers.WhitespaceTransformer;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.perspectives.mvc.events.ModifyEvent;
import org.brailleblaster.perspectives.mvc.menu.BBSelectionData;
import org.brailleblaster.perspectives.mvc.menu.TopMenu;
import org.brailleblaster.tools.MenuToolModule;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lorg/brailleblaster/tools/BlankPrintPageIndicatorTool;", "Lorg/brailleblaster/tools/MenuToolModule;", "<init>", "()V", "localeHandler", "Lorg/brailleblaster/utils/localization/LocaleHandler;", "topMenu", "Lorg/brailleblaster/perspectives/mvc/menu/TopMenu;", "getTopMenu", "()Lorg/brailleblaster/perspectives/mvc/menu/TopMenu;", "title", "", "getTitle", "()Ljava/lang/String;", "onRun", "", "bbData", "Lorg/brailleblaster/perspectives/mvc/menu/BBSelectionData;", "brailleblaster-core"})
public final class BlankPrintPageIndicatorTool
implements MenuToolModule {
    @NotNull
    public static final BlankPrintPageIndicatorTool INSTANCE = new BlankPrintPageIndicatorTool();
    @NotNull
    private static final LocaleHandler localeHandler = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null);
    @NotNull
    private static final TopMenu topMenu = TopMenu.INSERT;
    @NotNull
    private static final String title = "Blank Print Page Indicator";

    private BlankPrintPageIndicatorTool() {
    }

    @Override
    @NotNull
    public TopMenu getTopMenu() {
        return topMenu;
    }

    @Override
    @NotNull
    public String getTitle() {
        return title;
    }

    @Override
    public void onRun(@NotNull BBSelectionData bbData) {
        Intrinsics.checkNotNullParameter((Object)bbData, (String)"bbData");
        if (!bbData.getManager().isEmptyDocument() && !bbData.getManager().documentIsOnlyNewlines()) {
            Element parent = BBX.BLOCK.PAGE_NUM.create();
            parent.appendChild(" ");
            parent.addAttribute(new Attribute("page", "bbAdded"));
            TextMapElement textMapElement = bbData.getManager().getMapList().getCurrent();
            Intrinsics.checkNotNullExpressionValue((Object)textMapElement, (String)"getCurrent(...)");
            TextMapElement currentElement = textMapElement;
            if (currentElement instanceof Uneditable) {
                ((Uneditable)((Object)currentElement)).blockEdit(bbData.getManager());
            } else if (currentElement instanceof WhiteSpaceElement) {
                WhitespaceTransformer transformer = new WhitespaceTransformer(bbData.getManager());
                WhiteSpaceElement whiteSpaceElement = (WhiteSpaceElement)currentElement;
                Intrinsics.checkNotNull((Object)parent);
                transformer.transformWhiteSpace(whiteSpaceElement, (Node)parent);
            } else {
                TextMapElement textMapElement2 = bbData.getManager().getText().getCurrentElement();
                Intrinsics.checkNotNull((Object)textMapElement2);
                Node currNode = textMapElement2.getNode();
                ParentNode currParent = currNode.getParent();
                if (currNode instanceof Text) {
                    currNode = (Node)currParent;
                    currParent = currParent.getParent();
                }
                int index = currParent.indexOf(currNode);
                currParent.insertChild((Node)parent, index + 1);
                BBSimpleManager bBSimpleManager = bbData.getManager().getSimpleManager();
                Node[] nodeArray = new Node[1];
                ParentNode parentNode = currParent;
                Intrinsics.checkNotNull((Object)parentNode);
                nodeArray[0] = parentNode;
                bBSimpleManager.dispatchEvent(new ModifyEvent(Sender.NO_SENDER, true, nodeArray));
            }
        } else {
            bbData.getManager().notify(localeHandler.get("emptyDocMenuWarning"));
        }
    }
}

