/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.perspectives.mvc.XMLNodeCaret;
import org.brailleblaster.perspectives.mvc.events.ModifyEvent;
import org.brailleblaster.perspectives.mvc.events.XMLCaretEvent;
import org.brailleblaster.perspectives.mvc.menu.BBSelectionData;
import org.brailleblaster.perspectives.mvc.menu.SharedItem;
import org.brailleblaster.perspectives.mvc.menu.TopMenu;
import org.brailleblaster.tools.InsertBookmarkToolKt;
import org.brailleblaster.tools.MenuToolModule;
import org.brailleblaster.utils.swt.EasySWT;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J\u0018\u0010 \u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\fH\u0002J\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0$2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/brailleblaster/tools/InsertBookmarkTool;", "Lorg/eclipse/swt/widgets/Dialog;", "Lorg/brailleblaster/tools/MenuToolModule;", "parent", "Lorg/brailleblaster/perspectives/braille/Manager;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;)V", "topMenu", "Lorg/brailleblaster/perspectives/mvc/menu/TopMenu;", "getTopMenu", "()Lorg/brailleblaster/perspectives/mvc/menu/TopMenu;", "title", "", "getTitle", "()Ljava/lang/String;", "accelerator", "", "getAccelerator", "()I", "sharedItem", "Lorg/brailleblaster/perspectives/mvc/menu/SharedItem;", "getSharedItem", "()Lorg/brailleblaster/perspectives/mvc/menu/SharedItem;", "bookmarksNodeList", "", "Lnu/xom/Element;", "onRun", "", "bbData", "Lorg/brailleblaster/perspectives/mvc/menu/BBSelectionData;", "removeBookmark", "bookmarkIndex", "addBookmark", "newLinkID", "moveToNode", "getBookmarksXPath", "", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nInsertBookmarkTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsertBookmarkTool.kt\norg/brailleblaster/tools/InsertBookmarkTool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,196:1\n1915#2,2:197\n1586#2:199\n1661#2,3:200\n1586#2:203\n1661#2,3:204\n1915#2,2:207\n1915#2,2:209\n1915#2,2:211\n*S KotlinDebug\n*F\n+ 1 InsertBookmarkTool.kt\norg/brailleblaster/tools/InsertBookmarkTool\n*L\n53#1:197,2\n180#1:199\n180#1:200,3\n185#1:203\n185#1:204,3\n82#1:207,2\n98#1:209,2\n111#1:211,2\n*E\n"})
public final class InsertBookmarkTool
extends Dialog
implements MenuToolModule {
    @NotNull
    private final TopMenu topMenu;
    @NotNull
    private final String title;
    private final int accelerator;
    @NotNull
    private final SharedItem sharedItem;
    @NotNull
    private List<Element> bookmarksNodeList;

    public InsertBookmarkTool(@NotNull Manager parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(parent.getWpManager().getShell(), 0);
        this.topMenu = TopMenu.NAVIGATE;
        this.title = InsertBookmarkToolKt.access$getLocaleHandler$p().get("BookmarksMenu");
        this.accelerator = SWT.MOD1 | SWT.MOD2 | 0x4B;
        this.sharedItem = SharedItem.INSERT_BOOKMARK;
        this.bookmarksNodeList = new ArrayList();
    }

    @Override
    @NotNull
    public TopMenu getTopMenu() {
        return this.topMenu;
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.title;
    }

    @Override
    public int getAccelerator() {
        return this.accelerator;
    }

    @Override
    @NotNull
    public SharedItem getSharedItem() {
        return this.sharedItem;
    }

    @Override
    public void onRun(@NotNull BBSelectionData bbData) {
        Intrinsics.checkNotNullParameter((Object)bbData, (String)"bbData");
        Shell shell = new Shell(this.getParent().getDisplay());
        shell.setText("Bookmarks");
        shell.setLayout((Layout)new GridLayout(2, false));
        Group textBoxGroup = EasySWT.makeGroup((Composite)((Composite)shell), (int)0, (int)1, (boolean)true);
        Group buttonsGroup = EasySWT.makeGroup((Composite)((Composite)shell), (int)0, (int)1, (boolean)true);
        GridData gd = new GridData();
        gd.widthHint = 180;
        gd.heightHint = 90;
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        Text entryBox = EasySWT.makeText((Composite)((Composite)textBoxGroup), (int)180, (int)1);
        entryBox.setMessage("Enter a unique bookmark name");
        org.eclipse.swt.widgets.List bookmarksList = new org.eclipse.swt.widgets.List((Composite)textBoxGroup, 2564);
        Iterable $this$forEach$iv = this.getBookmarksXPath(bbData);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            bookmarksList.add(it);
        }
        bookmarksList.addListener(8, arg_0 -> InsertBookmarkTool.onRun$lambda$1(bookmarksList, this, bbData, arg_0));
        bookmarksList.setLayoutData((Object)gd);
        bookmarksList.setFocus();
        EasySWT.INSTANCE.addEnterListener((Control)bookmarksList, arg_0 -> InsertBookmarkTool.onRun$lambda$2(bookmarksList, this, bbData, arg_0));
        EasySWT.INSTANCE.addEnterListener((Control)entryBox, arg_0 -> InsertBookmarkTool.onRun$lambda$3(entryBox, bookmarksList, this, bbData, shell, arg_0));
        Button bookmarkAtCursor = new Button((Composite)buttonsGroup, 8);
        bookmarkAtCursor.setText("Add Bookmark at Cursor");
        bookmarkAtCursor.addListener(13, arg_0 -> InsertBookmarkTool.onRun$lambda$4(entryBox, bookmarksList, this, bbData, shell, arg_0));
        EasySWT.makePushButton((Composite)((Composite)buttonsGroup), (String)"Remove Selected Bookmark", (int)1, arg_0 -> InsertBookmarkTool.onRun$lambda$5(this, bbData, bookmarksList, arg_0));
        EasySWT.makePushButton((Composite)((Composite)buttonsGroup), (String)"Go To Selected Bookmark", (int)1, arg_0 -> InsertBookmarkTool.onRun$lambda$6(bookmarksList, this, bbData, arg_0));
        EasySWT.makePushButton((Composite)((Composite)buttonsGroup), (String)"Clear Selection", (int)1, arg_0 -> InsertBookmarkTool.onRun$lambda$7(bookmarksList, arg_0));
        EasySWT.INSTANCE.addEscapeCloseListener(shell);
        shell.pack();
        shell.open();
    }

    private final void removeBookmark(BBSelectionData bbData, int bookmarkIndex) {
        if (!(0 <= bookmarkIndex ? bookmarkIndex < ((Collection)this.bookmarksNodeList).size() : false)) {
            return;
        }
        Element el = this.bookmarksNodeList.get(bookmarkIndex);
        el.removeAttribute(el.getAttribute("linkID", "http://brailleblaster.org/ns/bb"));
        BBSimpleManager bBSimpleManager = bbData.getManager().getSimpleManager();
        Node[] nodeArray = new Node[1];
        Intrinsics.checkNotNullExpressionValue((Object)el.getParent(), (String)"getParent(...)");
        bBSimpleManager.dispatchEvent(new ModifyEvent(Sender.TEXT, false, nodeArray));
    }

    private final void addBookmark(BBSelectionData bbData, String newLinkID) {
        Element block = bbData.getManager().getMapList().getCurrent().getBlock();
        if (block != null) {
            try {
                block.addAttribute(BBX.BLOCK.LINKID.newAttribute(newLinkID));
                BBSimpleManager bBSimpleManager = bbData.getManager().getSimpleManager();
                Node[] nodeArray = new Node[1];
                Intrinsics.checkNotNullExpressionValue((Object)block.getParent(), (String)"getParent(...)");
                bBSimpleManager.dispatchEvent(new ModifyEvent(Sender.TEXT, false, nodeArray));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private final void moveToNode(BBSelectionData bbData, int bookmarkIndex) {
        boolean bl = 0 <= bookmarkIndex ? bookmarkIndex < ((Collection)this.bookmarksNodeList).size() : false;
        if (bl) {
            Element node = this.bookmarksNodeList.get(bookmarkIndex);
            bbData.getManager().getSimpleManager().dispatchEvent(new XMLCaretEvent(Sender.GO_TO_PAGE, new XMLNodeCaret((Node)node, null, 2, null), null, 4, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getBookmarksXPath(BBSelectionData bbData) {
        List elementStrings = CollectionsKt.emptyList();
        try {
            void $this$mapTo$iv$iv;
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            String xpath = "//*[@*[local-name() = 'linkID']]";
            Nodes nodes = bbData.getManager().getSimpleManager().getDoc().query(xpath);
            Intrinsics.checkNotNullExpressionValue((Object)nodes, (String)"query(...)");
            List results = CollectionsKt.toList((Iterable)((Iterable)nodes));
            this.bookmarksNodeList.clear();
            Iterable iterable = results;
            Object object = this;
            boolean $i$f$map22 = false;
            void var8_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                Node node = (Node)item$iv$iv2;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type nu.xom.Element");
                collection.add((Element)it);
            }
            ((InsertBookmarkTool)object).bookmarksNodeList = TypeIntrinsics.asMutableList((Object)((List)destination$iv$iv));
            Iterable $this$map$iv2 = results;
            boolean $i$f$map = false;
            Iterable $i$f$map22 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Object item$iv$iv2;
                item$iv$iv2 = (Node)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type nu.xom.Element");
                Element el = (Element)it;
                object.add(el.getAttributeValue("linkID", "http://brailleblaster.org/ns/bb").toString());
            }
            elementStrings = (List)destination$iv$iv2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return elementStrings;
    }

    private static final void onRun$lambda$1(org.eclipse.swt.widgets.List $bookmarksList, InsertBookmarkTool this$0, BBSelectionData $bbData, Event it) {
        if ($bookmarksList.getSelectionIndex() != -1) {
            this$0.moveToNode($bbData, $bookmarksList.getSelectionIndex());
        }
    }

    private static final void onRun$lambda$2(org.eclipse.swt.widgets.List $bookmarksList, InsertBookmarkTool this$0, BBSelectionData $bbData, KeyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($bookmarksList.getSelectionIndex() != -1) {
            this$0.moveToNode($bbData, $bookmarksList.getSelectionIndex());
            $bookmarksList.deselectAll();
        }
    }

    private static final void onRun$lambda$3(Text $entryBox, org.eclipse.swt.widgets.List $bookmarksList, InsertBookmarkTool this$0, BBSelectionData $bbData, Shell $shell, KeyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = $entryBox.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (!(((CharSequence)string).length() == 0)) {
            String[] stringArray = $bookmarksList.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getItems(...)");
            if (!ArraysKt.contains((Object[])stringArray, (Object)$entryBox.getText())) {
                String string2 = $entryBox.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                this$0.addBookmark($bbData, string2);
                $bbData.getManager().refresh();
                $bookmarksList.deselectAll();
                $bookmarksList.removeAll();
                Iterable $this$forEach$iv = this$0.getBookmarksXPath($bbData);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it2 = (String)element$iv;
                    boolean bl = false;
                    $bookmarksList.add(it2);
                }
                $shell.forceFocus();
            }
        }
    }

    private static final void onRun$lambda$4(Text $entryBox, org.eclipse.swt.widgets.List $bookmarksList, InsertBookmarkTool this$0, BBSelectionData $bbData, Shell $shell, Event it) {
        String string = $entryBox.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (!(((CharSequence)string).length() == 0)) {
            String[] stringArray = $bookmarksList.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getItems(...)");
            if (!ArraysKt.contains((Object[])stringArray, (Object)$entryBox.getText())) {
                String string2 = $entryBox.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                this$0.addBookmark($bbData, string2);
                $bbData.getManager().refresh();
                $bookmarksList.deselectAll();
                $bookmarksList.removeAll();
                Iterable $this$forEach$iv = this$0.getBookmarksXPath($bbData);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it2 = (String)element$iv;
                    boolean bl = false;
                    $bookmarksList.add(it2);
                }
                $shell.forceFocus();
            }
        }
    }

    private static final void onRun$lambda$5(InsertBookmarkTool this$0, BBSelectionData $bbData, org.eclipse.swt.widgets.List $bookmarksList, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.removeBookmark($bbData, $bookmarksList.getSelectionIndex());
        $bookmarksList.deselectAll();
        $bookmarksList.removeAll();
        Iterable $this$forEach$iv = this$0.getBookmarksXPath($bbData);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl = false;
            $bookmarksList.add(it2);
        }
    }

    private static final void onRun$lambda$6(org.eclipse.swt.widgets.List $bookmarksList, InsertBookmarkTool this$0, BBSelectionData $bbData, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($bookmarksList.getSelectionIndex() != -1) {
            this$0.moveToNode($bbData, $bookmarksList.getSelectionIndex());
            $bookmarksList.deselectAll();
        }
    }

    private static final void onRun$lambda$7(org.eclipse.swt.widgets.List $bookmarksList, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $bookmarksList.deselectAll();
    }
}

