/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.usage;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.usage.FilteredUsageLogger;
import org.brailleblaster.usage.UsageLogger;
import org.brailleblaster.usage.UsageRecord;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0002\u001a\u00020\u0003*\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a&\u0010\u0007\u001a\u00020\b*\u00020\u00032\u0006\u0010\t\u001a\u00020\u00012\b\b\u0002\u0010\n\u001a\u00020\u00012\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a&\u0010\r\u001a\u00020\b*\u00020\u00032\u0006\u0010\t\u001a\u00020\u00012\b\b\u0002\u0010\n\u001a\u00020\u00012\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a$\u0010\u000e\u001a\u00020\b*\u00020\u00032\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a(\u0010\u0011\u001a\u00020\b*\u00020\u00032\u0006\u0010\t\u001a\u00020\u00012\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\b\b\u0002\u0010\u000b\u001a\u00020\f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"BB_TOOL", "", "filterLogger", "Lorg/brailleblaster/usage/UsageLogger;", "predicate", "Ljava/util/function/Predicate;", "Lorg/brailleblaster/usage/UsageRecord;", "logStart", "", "tool", "message", "time", "Ljava/time/Instant;", "logEnd", "logDurationSeconds", "duration", "Ljava/time/Duration;", "logException", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "brailleblaster-core"})
public final class UsageLoggerKt {
    @NotNull
    public static final String BB_TOOL = "BrailleBlaster";

    @NotNull
    public static final UsageLogger filterLogger(@NotNull UsageLogger $this$filterLogger, @NotNull Predicate<UsageRecord> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$filterLogger, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        return new FilteredUsageLogger($this$filterLogger, predicate);
    }

    public static final void logStart(@NotNull UsageLogger $this$logStart, @NotNull String tool, @NotNull String message, @NotNull Instant time) {
        Intrinsics.checkNotNullParameter((Object)$this$logStart, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        $this$logStart.log(new UsageRecord(tool, "start", message, time));
    }

    public static /* synthetic */ void logStart$default(UsageLogger usageLogger, String string, String string2, Instant instant, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            instant = instant2;
        }
        UsageLoggerKt.logStart(usageLogger, string, string2, instant);
    }

    public static final void logEnd(@NotNull UsageLogger $this$logEnd, @NotNull String tool, @NotNull String message, @NotNull Instant time) {
        Intrinsics.checkNotNullParameter((Object)$this$logEnd, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        $this$logEnd.log(new UsageRecord(tool, "end", message, time));
    }

    public static /* synthetic */ void logEnd$default(UsageLogger usageLogger, String string, String string2, Instant instant, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            instant = instant2;
        }
        UsageLoggerKt.logEnd(usageLogger, string, string2, instant);
    }

    public static final void logDurationSeconds(@NotNull UsageLogger $this$logDurationSeconds, @NotNull String tool, @NotNull Duration duration, @NotNull Instant time) {
        Intrinsics.checkNotNullParameter((Object)$this$logDurationSeconds, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        $this$logDurationSeconds.log(new UsageRecord(tool, "duration-seconds", String.valueOf(duration.toSeconds()), time));
    }

    public static /* synthetic */ void logDurationSeconds$default(UsageLogger usageLogger, String string, Duration duration, Instant instant, int n, Object object) {
        if ((n & 4) != 0) {
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            instant = instant2;
        }
        UsageLoggerKt.logDurationSeconds(usageLogger, string, duration, instant);
    }

    public static final void logException(@NotNull UsageLogger $this$logException, @NotNull String tool, @NotNull Exception e, @NotNull Instant time) {
        Intrinsics.checkNotNullParameter((Object)$this$logException, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        StringBuilder sb = new StringBuilder(e.getClass().getCanonicalName());
        Throwable cause = e.getCause();
        Set<Throwable> set = Collections.newSetFromMap(new IdentityHashMap());
        Intrinsics.checkNotNullExpressionValue(set, (String)"newSetFromMap(...)");
        Set<Throwable> dejaVu = set;
        while (cause != null) {
            Throwable throwable;
            sb.append('\n');
            if (dejaVu.contains(cause)) {
                sb.append("Cycle detected");
                throwable = null;
            } else {
                sb.append("Caused by: " + cause.getClass().getCanonicalName());
                dejaVu.add(cause);
                throwable = cause.getCause();
            }
            cause = throwable;
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        $this$logException.log(new UsageRecord(tool, "exception", string, time));
    }

    public static /* synthetic */ void logException$default(UsageLogger usageLogger, String string, Exception exception, Instant instant, int n, Object object) {
        if ((n & 4) != 0) {
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            instant = instant2;
        }
        UsageLoggerKt.logException(usageLogger, string, exception, instant);
    }
}

