/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.util;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.Text;
import org.brailleblaster.archiver2.BBXArchiver;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.utd.UTDTranslationEngine;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B/\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004H\u0002J\u001a\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\b\u0010\"\u001a\u0004\u0018\u00010\u0004H\u0002J \u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0004H\u0002J*\u0010)\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u00042\b\u0010(\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-H\u0002J\u0018\u0010.\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-2\u0006\u0010$\u001a\u00020\u0004H\u0002J\u0010\u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u0004H\u0002J\b\u00101\u001a\u00020\u0004H\u0002J\b\u00102\u001a\u00020\u0004H\u0002J\u0018\u00103\u001a\u00020 2\u0006\u00104\u001a\u00020\u00112\u0006\u00105\u001a\u00020\tH\u0002J\b\u00106\u001a\u00020 H\u0002J\b\u00107\u001a\u00020 H\u0002J\u0010\u00108\u001a\u00020 2\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u00020\u00182\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010<\u001a\u00020 2\u0006\u0010'\u001a\u00020\u0004H\u0002R\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006="}, d2={"Lorg/brailleblaster/util/BookSplitter;", "", "volList", "Ljava/util/ArrayList;", "Lnu/xom/Element;", "Lkotlin/collections/ArrayList;", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "destPath", "Ljava/nio/file/Path;", "<init>", "(Ljava/util/ArrayList;Lorg/brailleblaster/perspectives/braille/Manager;Ljava/nio/file/Path;)V", "getManager", "()Lorg/brailleblaster/perspectives/braille/Manager;", "setManager", "(Lorg/brailleblaster/perspectives/braille/Manager;)V", "doc", "Lnu/xom/Document;", "getDoc", "()Lnu/xom/Document;", "setDoc", "(Lnu/xom/Document;)V", "manifest", "originalFileName", "", "copy", "", "getCopy", "()Z", "setCopy", "(Z)V", "split", "", "copyFirst", "end", "copyRest", "start", "copyDocumentFromStart", "copyTo", "e", "stopElement", "copyDocumentFromPosition", "startElement", "canCopy", "n", "Lnu/xom/Node;", "isStartElement", "copyElement", "original", "copyRootElement", "copyHead", "saveDoc", "d", "newDocPath", "outputManifest", "setFileName", "setFile", "index", "", "getName", "removeBraille", "brailleblaster-core"})
public final class BookSplitter {
    @NotNull
    private ArrayList<Element> volList;
    @NotNull
    private Manager manager;
    @NotNull
    private final Path destPath;
    @NotNull
    private Document doc;
    @NotNull
    private Document manifest;
    @NotNull
    private String originalFileName;
    private boolean copy;

    public BookSplitter(@NotNull ArrayList<Element> volList, @NotNull Manager manager, @NotNull Path destPath) {
        Intrinsics.checkNotNullParameter(volList, (String)"volList");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)destPath, (String)"destPath");
        this.volList = volList;
        this.manager = manager;
        this.destPath = destPath;
        Document document = this.manager.getDoc();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"<get-doc>(...)");
        this.doc = document;
        this.manifest = new Document(new Element("Files"));
        this.originalFileName = PathsKt.getNameWithoutExtension((Path)this.manager.getArchiver().getPath());
        this.copy = true;
    }

    @NotNull
    public final Manager getManager() {
        return this.manager;
    }

    public final void setManager(@NotNull Manager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"<set-?>");
        this.manager = manager;
    }

    @NotNull
    public final Document getDoc() {
        return this.doc;
    }

    public final void setDoc(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"<set-?>");
        this.doc = document;
    }

    public final boolean getCopy() {
        return this.copy;
    }

    public final void setCopy(boolean bl) {
        this.copy = bl;
    }

    public final void split() {
        Element element = this.doc.getRootElement();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getRootElement(...)");
        this.removeBraille(element);
        int n = ((Collection)this.volList).size();
        for (int i = 0; i < n; ++i) {
            this.setFile(i);
            Element root = null;
            int n2 = i;
            if (n2 == 0) {
                Element element2 = this.volList.get(1);
                Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"get(...)");
                root = this.copyFirst(element2);
            } else if (n2 == this.volList.size() - 1) {
                Element element3 = this.volList.get(i);
                Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"get(...)");
                root = this.copyRest(element3, null);
                root.insertChild((Node)this.copyHead(), 0);
            } else {
                Element element4 = this.volList.get(i);
                Intrinsics.checkNotNullExpressionValue((Object)element4, (String)"get(...)");
                root = this.copyRest(element4, this.volList.get(i + 1));
                root.insertChild((Node)this.copyHead(), 0);
            }
            Document splitDoc = new Document(root);
            Path path = this.destPath.resolve(this.getName(i));
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            this.saveDoc(splitDoc, path);
        }
        this.setFileName();
        this.outputManifest();
        this.manager.refresh();
    }

    private final Element copyFirst(Element end) {
        Element copy2 = this.copyRootElement();
        Element element = this.doc.getRootElement();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getRootElement(...)");
        return this.copyDocumentFromStart(copy2, element, end);
    }

    private final Element copyRest(Element start, Element end) {
        Element copy2 = this.copyRootElement();
        Element element = this.doc.getRootElement();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getRootElement(...)");
        return this.copyDocumentFromPosition(copy2, element, start, end);
    }

    private final Element copyDocumentFromStart(Element copyTo, Element e, Element stopElement) {
        if (Intrinsics.areEqual((Object)e, (Object)stopElement)) {
            this.copy = false;
        }
        int n = e.getChildCount();
        for (int i = 0; i < n; ++i) {
            Text copy2;
            Element child;
            Node node = e.getChild(i);
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getChild(...)");
            if (this.canCopy(node) && e.getChild(i) instanceof Element) {
                Node node2 = e.getChild(i);
                Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type nu.xom.Element");
                child = (Element)node2;
                if (Intrinsics.areEqual((Object)child, (Object)stopElement)) {
                    this.copy = false;
                }
                if (!this.canCopy((Node)child)) continue;
                copy2 = this.copyElement(child);
                copyTo.appendChild((Node)copy2);
                this.copyDocumentFromStart((Element)copy2, child, stopElement);
                continue;
            }
            Node node3 = e.getChild(i);
            Intrinsics.checkNotNullExpressionValue((Object)node3, (String)"getChild(...)");
            if (!this.canCopy(node3) || !(e.getChild(i) instanceof Text)) continue;
            Node node4 = e.getChild(i);
            Intrinsics.checkNotNull((Object)node4, (String)"null cannot be cast to non-null type nu.xom.Text");
            child = (Text)node4;
            copy2 = child.copy();
            copyTo.appendChild((Node)copy2);
        }
        return copyTo;
    }

    private final Element copyDocumentFromPosition(Element copyTo, Element e, Element startElement, Element stopElement) {
        if (Intrinsics.areEqual((Object)e, (Object)stopElement)) {
            this.copy = false;
        } else if (Intrinsics.areEqual((Object)e, (Object)startElement)) {
            this.copy = true;
        }
        int n = e.getChildCount();
        for (int i = 0; i < n; ++i) {
            Text copy2;
            Element child;
            Node node = e.getChild(i);
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getChild(...)");
            if (this.isStartElement(node, startElement)) {
                this.copy = true;
            }
            Node node2 = e.getChild(i);
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"getChild(...)");
            if (this.canCopy(node2) && e.getChild(i) instanceof Element) {
                Node node3 = e.getChild(i);
                Intrinsics.checkNotNull((Object)node3, (String)"null cannot be cast to non-null type nu.xom.Element");
                child = (Element)node3;
                if (Intrinsics.areEqual((Object)child, (Object)stopElement)) {
                    this.copy = false;
                }
                if (!this.canCopy((Node)child)) continue;
                copy2 = this.copyElement(child);
                copyTo.appendChild((Node)copy2);
                this.copyDocumentFromPosition((Element)copy2, child, startElement, stopElement);
                continue;
            }
            Node node4 = e.getChild(i);
            Intrinsics.checkNotNullExpressionValue((Object)node4, (String)"getChild(...)");
            if (!this.canCopy(node4) || !(e.getChild(i) instanceof Text)) continue;
            Node node5 = e.getChild(i);
            Intrinsics.checkNotNull((Object)node5, (String)"null cannot be cast to non-null type nu.xom.Text");
            child = (Text)node5;
            copy2 = child.copy();
            copyTo.appendChild((Node)copy2);
        }
        return copyTo;
    }

    private final boolean canCopy(Node n) {
        if (this.copy) {
            return true;
        }
        return n instanceof Element && Intrinsics.areEqual((Object)((Element)n).getLocalName(), (Object)"SECTION");
    }

    private final boolean isStartElement(Node n, Element start) {
        if (n instanceof Element) {
            return Intrinsics.areEqual((Object)n, (Object)start);
        }
        return false;
    }

    private final Element copyElement(Element original) {
        Element copy2 = BBX.newElement(original.getLocalName());
        int count = original.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            Attribute atr = original.getAttribute(i);
            copy2.addAttribute(atr.copy());
        }
        Intrinsics.checkNotNull((Object)copy2);
        return copy2;
    }

    private final Element copyRootElement() {
        Element root = this.doc.getRootElement();
        Element e = BBX.newElement(this.doc.getRootElement().getLocalName());
        int count = root.getNamespaceDeclarationCount();
        for (int i = 0; i < count; ++i) {
            e.addNamespaceDeclaration(root.getNamespacePrefix(i), root.getNamespaceURI(root.getNamespacePrefix(i)));
        }
        Intrinsics.checkNotNull((Object)e);
        return e;
    }

    private final Element copyHead() {
        Element head = BBX.getHead(this.doc);
        Element element = head.copy();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"copy(...)");
        return element;
    }

    private final void saveDoc(Document d, Path newDocPath) {
        BBXArchiver arch = new BBXArchiver(newDocPath, d, null);
        arch.saveAs(newDocPath, d, new UTDTranslationEngine(), SetsKt.emptySet());
    }

    private final void outputManifest() {
        new XMLHandler().save(this.manifest, new File(((Object)this.destPath.resolve(this.originalFileName + "_manifest.mnf").toAbsolutePath()).toString()));
    }

    private final void setFileName() {
        Element fileName = new Element("fileName");
        fileName.appendChild((Node)new Text(this.originalFileName));
        this.manifest.getRootElement().appendChild((Node)fileName);
    }

    private final void setFile(int index) {
        Element file = new Element("file");
        Text t = new Text(this.getName(index));
        file.appendChild((Node)t);
        this.manifest.getRootElement().appendChild((Node)file);
    }

    private final String getName(int index) {
        return this.originalFileName + "_part_" + (index + 1) + ".bbx";
    }

    private final void removeBraille(Element e) {
        Elements els = e.getChildElements();
        int n = els.size();
        for (int i = 0; i < n; ++i) {
            if (Intrinsics.areEqual((Object)els.get(i).getLocalName(), (Object)"brl")) {
                e.removeChild((Node)els.get(i));
                continue;
            }
            Element element = els.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"get(...)");
            this.removeBraille(element);
        }
    }
}

