/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.util;

import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.BBIni;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/brailleblaster/util/ImageHelper;", "", "<init>", "()V", "imagesPath", "Ljava/nio/file/Path;", "getImagesPath", "()Ljava/nio/file/Path;", "MISSING_IMAGE_FILENAME", "", "createScaledImage", "Lorg/eclipse/swt/graphics/Image;", "fileName", "scale", "", "fallback", "brailleblaster-core"})
public final class ImageHelper {
    @NotNull
    public static final ImageHelper INSTANCE = new ImageHelper();
    @NotNull
    private static final Path imagesPath;
    @NotNull
    public static final String MISSING_IMAGE_FILENAME = "missing.png";

    private ImageHelper() {
    }

    @NotNull
    public final Path getImagesPath() {
        return imagesPath;
    }

    @NotNull
    public final Image createScaledImage(@NotNull String fileName, float scale, @Nullable String fallback) {
        Image image;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (fallback == null) {
            Image img = new Image((Device)Display.getCurrent(), ((Object)imagesPath.resolve(fileName)).toString());
            int width = img.getImageData().width;
            int height = img.getImageData().height;
            Image returnImage = new Image((Device)Display.getCurrent(), img.getImageData().scaledTo((int)((float)width * scale), (int)((float)height * scale)));
            img.dispose();
            image = returnImage;
        } else {
            Image image2;
            try {
                image2 = this.createScaledImage(fileName, scale, null);
            }
            catch (SWTException sWTException) {
                image2 = this.createScaledImage(fallback, scale, null);
            }
            image = image2;
        }
        return image;
    }

    public static /* synthetic */ Image createScaledImage$default(ImageHelper imageHelper, String string, float f, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        if ((n & 4) != 0) {
            string2 = MISSING_IMAGE_FILENAME;
        }
        return imageHelper.createScaledImage(string, f, string2);
    }

    static {
        Path path = BBIni.getProgramDataPath().resolve("images");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        imagesPath = path;
    }
}

