/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import org.brailleblaster.BBIni;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.braille.toolbar.CustomToolBarBuilder;
import org.brailleblaster.perspectives.braille.views.wp.TextView;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.perspectives.mvc.SimpleEvent;
import org.brailleblaster.perspectives.mvc.XMLNodeCaret;
import org.brailleblaster.perspectives.mvc.XMLTextCaret;
import org.brailleblaster.perspectives.mvc.events.BuildMenuEvent;
import org.brailleblaster.perspectives.mvc.events.BuildToolBarEvent;
import org.brailleblaster.perspectives.mvc.events.ModifyEvent;
import org.brailleblaster.perspectives.mvc.menu.BBSelectionData;
import org.brailleblaster.perspectives.mvc.menu.MenuManager;
import org.brailleblaster.perspectives.mvc.menu.TopMenu;
import org.brailleblaster.tools.MenuToolModule;
import org.brailleblaster.utd.ITranslationEngine;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.internal.xml.XMLHandlerKt;
import org.brailleblaster.utd.utils.TextTranslator;
import org.brailleblaster.utd.utils.UTDHelper;
import org.brailleblaster.util.Utils;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.brailleblaster.utils.swt.AccessibilityUtils;
import org.brailleblaster.wordprocessor.WPManager;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 _2\u00020\u0001:\u0001_B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020.H\u0016J\u0006\u0010/\u001a\u00020)J\u0016\u00100\u001a\u00020)2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000202J\u000e\u00104\u001a\u00020)2\u0006\u0010\u0014\u001a\u00020\u0015J\b\u00105\u001a\u00020)H\u0002J\u0018\u00106\u001a\u00020)2\u0006\u00107\u001a\u0002022\u0006\u00103\u001a\u000202H\u0002J\u0018\u00108\u001a\u00020%2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:H\u0002J\u0018\u0010<\u001a\u00020\n2\u0006\u0010=\u001a\u00020\n2\u0006\u0010>\u001a\u00020\nH\u0002J\u0012\u0010?\u001a\u0004\u0018\u00010\u00172\u0006\u00101\u001a\u00020%H\u0002J\u0010\u0010@\u001a\u00020)2\u0006\u0010A\u001a\u00020BH\u0002J\b\u0010C\u001a\u00020)H\u0002J\b\u0010D\u001a\u00020)H\u0002J\u0012\u0010E\u001a\u0004\u0018\u00010\u00172\u0006\u0010F\u001a\u00020\u0017H\u0002J\u0010\u0010L\u001a\u00020)2\u0006\u0010M\u001a\u00020BH\u0002J\u0014\u0010N\u001a\u0004\u0018\u00010\u00172\b\u00101\u001a\u0004\u0018\u00010\u0017H\u0002J\u0014\u0010O\u001a\u0004\u0018\u00010\u00172\b\u00101\u001a\u0004\u0018\u00010\u0017H\u0002J\u001a\u0010P\u001a\u00020\u00052\b\u0010M\u001a\u0004\u0018\u00010B2\u0006\u0010Q\u001a\u00020%H\u0002J\u001a\u0010R\u001a\u00020\u00052\b\u0010M\u001a\u0004\u0018\u00010B2\u0006\u0010Q\u001a\u00020%H\u0002J\u0012\u0010S\u001a\u00020\u00052\b\u0010M\u001a\u0004\u0018\u00010BH\u0002J\u0012\u0010T\u001a\u00020\u00052\b\u0010M\u001a\u0004\u0018\u00010BH\u0002J\u0012\u0010U\u001a\u00020\u00172\b\u0010V\u001a\u0004\u0018\u00010\u0017H\u0002J\u001a\u0010W\u001a\u00020\u00172\b\u0010X\u001a\u0004\u0018\u00010\u00172\u0006\u0010Y\u001a\u00020\u0017H\u0002J\u0010\u0010Z\u001a\u00020\u00052\u0006\u0010F\u001a\u00020\u0017H\u0002J \u0010[\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\\2\u0006\u0010X\u001a\u00020]2\u0006\u0010Y\u001a\u00020]H\u0002J\b\u0010^\u001a\u00020)H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001c\u0010G\u001a\u0004\u0018\u00010BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010K\u00a8\u0006`"}, d2={"Lorg/brailleblaster/util/ProseBuilder;", "Lorg/brailleblaster/tools/MenuToolModule;", "<init>", "()V", "toolbarEnabled", "", "toolbarEnabledChanged", "toolbarPlaced", "listenerAdded", "lineNumberInt", "", "incrementInt", "wrapButton", "Lorg/brailleblaster/perspectives/braille/toolbar/CustomToolBarBuilder$CustomButton;", "textView", "Lorg/brailleblaster/perspectives/braille/views/wp/TextView;", "getTextView", "()Lorg/brailleblaster/perspectives/braille/views/wp/TextView;", "setTextView", "(Lorg/brailleblaster/perspectives/braille/views/wp/TextView;)V", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "startNode", "Lnu/xom/Node;", "keyListener", "Lorg/eclipse/swt/custom/VerifyKeyListener;", "getKeyListener", "()Lorg/eclipse/swt/custom/VerifyKeyListener;", "setKeyListener", "(Lorg/eclipse/swt/custom/VerifyKeyListener;)V", "shell", "Lorg/eclipse/swt/widgets/Shell;", "topMenu", "Lorg/brailleblaster/perspectives/mvc/menu/TopMenu;", "getTopMenu", "()Lorg/brailleblaster/perspectives/mvc/menu/TopMenu;", "title", "", "getTitle", "()Ljava/lang/String;", "onRun", "", "bbData", "Lorg/brailleblaster/perspectives/mvc/menu/BBSelectionData;", "onEvent", "event", "Lorg/brailleblaster/perspectives/mvc/SimpleEvent;", "addToolbar", "addKeyListener", "lineNumber", "Lorg/brailleblaster/perspectives/braille/toolbar/CustomToolBarBuilder$CustomText;", "increment", "enableToolbar", "close", "insertLineNumber", "text", "checkLineNumber", "lineNumberText", "Lorg/eclipse/swt/widgets/Text;", "incrementText", "incrementLineNumber", "curr", "inc", "addLineElement", "checkForSpace", "span", "Lnu/xom/Element;", "wrapSelectedElements", "editLineNumber", "findNearestLineNumber", "node", "activeLineNum", "getActiveLineNum", "()Lnu/xom/Element;", "setActiveLineNum", "(Lnu/xom/Element;)V", "openEditWindow", "lineNum", "retrieveFollowingLineNumber", "retrievePrecedingLineNumber", "editPoemLineNumber", "newNum", "editProseLineNumber", "isProseLineNumber", "isPoemLineNumber", "getBlockParent", "child", "getCommonParent", "start", "end", "unwrapProseParent", "getIntersection", "", "Lnu/xom/Nodes;", "lineNumberTooLong", "Companion", "brailleblaster-core"})
public final class ProseBuilder
implements MenuToolModule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean toolbarEnabled = BBIni.getPropertyFileManager().getPropertyAsBoolean("proseBuilder.enabled", false);
    private boolean toolbarEnabledChanged;
    private boolean toolbarPlaced;
    private boolean listenerAdded;
    private int lineNumberInt = 1;
    private int incrementInt = 1;
    @Nullable
    private CustomToolBarBuilder.CustomButton wrapButton;
    @Nullable
    private TextView textView;
    @Nullable
    private Manager manager;
    @Nullable
    private Node startNode;
    @Nullable
    private VerifyKeyListener keyListener;
    @Nullable
    private Shell shell;
    @NotNull
    private final TopMenu topMenu = TopMenu.TOOLS;
    @NotNull
    private final String title;
    @Nullable
    private Element activeLineNum;
    @NotNull
    private static final LocaleHandler localeHandler = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null);
    @NotNull
    private static final String SETTING_ENABLED = "proseBuilder.enabled";

    public ProseBuilder() {
        this.title = "Line Number Tools";
    }

    @Nullable
    public final TextView getTextView() {
        return this.textView;
    }

    public final void setTextView(@Nullable TextView textView) {
        this.textView = textView;
    }

    @Nullable
    public final VerifyKeyListener getKeyListener() {
        return this.keyListener;
    }

    public final void setKeyListener(@Nullable VerifyKeyListener verifyKeyListener) {
        this.keyListener = verifyKeyListener;
    }

    @Override
    @NotNull
    public TopMenu getTopMenu() {
        return this.topMenu;
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.title;
    }

    @Override
    public void onRun(@NotNull BBSelectionData bbData) {
        Intrinsics.checkNotNullParameter((Object)bbData, (String)"bbData");
        this.enableToolbar(bbData.getManager());
    }

    @Override
    public void onEvent(@NotNull SimpleEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof BuildMenuEvent) {
            MenuManager.INSTANCE.add(this);
        }
        if (event instanceof BuildToolBarEvent && this.toolbarEnabled) {
            this.manager = event.getManager().getManager();
            this.textView = event.getManager().getManager().getText();
            this.addToolbar();
            this.toolbarPlaced = true;
        }
    }

    public final void addToolbar() {
        CustomToolBarBuilder builder2 = new CustomToolBarBuilder(this){
            final /* synthetic */ ProseBuilder this$0;
            {
                this.this$0 = $receiver;
            }

            public Composite build(Composite parent) {
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                Composite composite = super.build(parent);
                Intrinsics.checkNotNull((Object)composite);
                Composite result = composite;
                if (ProseBuilder.access$getToolbarEnabledChanged$p(this.this$0)) {
                    CustomToolBarBuilder.CustomButton customButton = ProseBuilder.access$getWrapButton$p(this.this$0);
                    Intrinsics.checkNotNull((Object)customButton);
                    customButton.getWidget().setFocus();
                    ProseBuilder.access$setToolbarEnabledChanged$p(this.this$0, false);
                }
                return result;
            }
        };
        this.wrapButton = CustomToolBarBuilder.addButton$default(builder2, "Wrap Prose (CTRL + F2)", 0, arg_0 -> ProseBuilder.addToolbar$lambda$0(this, arg_0), null, 8, null);
        CustomToolBarBuilder.addLabel$default(builder2, "Line Number:", 0, null, 4, null);
        CustomToolBarBuilder.CustomText lineNumber = CustomToolBarBuilder.addText$default(builder2, 50, String.valueOf(this.lineNumberInt), null, null, 12, null);
        CustomToolBarBuilder.addLabel$default(builder2, "Increment by:", 0, null, 4, null);
        CustomToolBarBuilder.CustomText increment = CustomToolBarBuilder.addText$default(builder2, 50, String.valueOf(this.incrementInt), null, null, 12, null);
        CustomToolBarBuilder.addButton$default(builder2, "Insert (F2)", 0, arg_0 -> ProseBuilder.addToolbar$lambda$1(this, lineNumber, increment, arg_0), null, 8, null);
        CustomToolBarBuilder.addButton$default(builder2, "Edit Line Number (CTRL + SHIFT + F2)", 0, arg_0 -> ProseBuilder.addToolbar$lambda$2(this, arg_0), null, 8, null);
        Consumer<SelectionEvent> consumer = arg_0 -> ProseBuilder.addToolbar$lambda$3(this, arg_0);
        new CustomToolBarBuilder.CustomButton(builder2, consumer){

            public Control doBuild(Composite parent) {
                Control control = super.doBuild(parent);
                AccessibilityUtils.setName((Control)control, (String)"Close Line Number Tools");
                return control;
            }
        };
        if (this.keyListener != null && this.listenerAdded && this.toolbarPlaced) {
            TextView textView = this.textView;
            Intrinsics.checkNotNull((Object)textView);
            if (!textView.getView().isDisposed()) {
                TextView textView2 = this.textView;
                Intrinsics.checkNotNull((Object)textView2);
                textView2.getView().removeVerifyKeyListener(this.keyListener);
            }
        }
        TextView textView = this.textView;
        Intrinsics.checkNotNull((Object)textView);
        if (!textView.getView().isDisposed()) {
            this.addKeyListener(lineNumber, increment);
        }
        WPManager.Companion.getInstance().getCurrentPerspective().addToToolBar(builder2, this.keyListener);
        this.listenerAdded = true;
    }

    public final void addKeyListener(@NotNull CustomToolBarBuilder.CustomText lineNumber, @NotNull CustomToolBarBuilder.CustomText increment) {
        Intrinsics.checkNotNullParameter((Object)lineNumber, (String)"lineNumber");
        Intrinsics.checkNotNullParameter((Object)increment, (String)"increment");
        this.keyListener = arg_0 -> ProseBuilder.addKeyListener$lambda$0(this, lineNumber, increment, arg_0);
        TextView textView = this.textView;
        Intrinsics.checkNotNull((Object)textView);
        textView.getView().forceFocus();
        TextView textView2 = this.textView;
        Intrinsics.checkNotNull((Object)textView2);
        textView2.getView().addVerifyKeyListener(this.keyListener);
    }

    public final void enableToolbar(@NotNull Manager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.manager = manager;
        this.textView = manager.getText();
        this.toolbarEnabled = !this.toolbarEnabled;
        this.toolbarEnabledChanged = true;
        this.toolbarPlaced = !this.toolbarPlaced;
        BBIni.getPropertyFileManager().saveAsBoolean(SETTING_ENABLED, this.toolbarEnabled);
        WPManager.Companion.getInstance().buildToolBar();
    }

    private final void close() {
        this.toolbarEnabled = false;
        this.toolbarPlaced = false;
        BBIni.getPropertyFileManager().saveAsBoolean(SETTING_ENABLED, this.toolbarEnabled);
        WPManager.Companion.getInstance().buildToolBar();
    }

    private final void insertLineNumber(CustomToolBarBuilder.CustomText text, CustomToolBarBuilder.CustomText increment) {
        Text lineNumberText = text.getWidget();
        Text incrementText = increment.getWidget();
        String string = incrementText.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (Integer.parseInt(string) < 1) {
            MessageBox message = new MessageBox(WPManager.Companion.getInstance().getShell());
            message.setMessage("Increments must be 1 or higher.");
            message.open();
            return;
        }
        String string2 = lineNumberText.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        Node node = this.addLineElement(string2);
        Element element = node instanceof Element ? (Element)node : null;
        if (element == null) {
            return;
        }
        Element pastedSpan = element;
        try {
            this.checkForSpace(pastedSpan);
        }
        catch (Exception exception) {
            Manager manager = this.manager;
            Intrinsics.checkNotNull((Object)manager);
            Shell parentShell = manager.getWpManager().getShell();
            Shell errorShell = new Shell(parentShell);
            errorShell.setSize(250, 70);
            errorShell.setText("Warning!");
            errorShell.setLayout((Layout)new RowLayout());
            new Label((Composite)errorShell, 0).setText("Invalid location for a line number.");
            Button buttonOK = new Button((Composite)errorShell, 8);
            buttonOK.setText("OK");
            buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(errorShell){
                final /* synthetic */ Shell $errorShell;
                {
                    this.$errorShell = $errorShell;
                }

                public void widgetSelected(SelectionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.$errorShell.close();
                }
            });
            errorShell.pack();
            errorShell.open();
            return;
        }
        lineNumberText.setText(this.checkLineNumber(lineNumberText, incrementText));
        Manager manager = this.manager;
        Intrinsics.checkNotNull((Object)manager);
        Node[] nodeArray = new Node[]{pastedSpan};
        manager.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.NO_SENDER, true, nodeArray));
    }

    private final String checkLineNumber(Text lineNumberText, Text incrementText) {
        String string;
        try {
            int nextInt;
            String string2 = lineNumberText.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            int n = Integer.parseInt(string2);
            String string3 = incrementText.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
            this.lineNumberInt = nextInt = this.incrementLineNumber(n, Integer.parseInt(string3));
            String string4 = incrementText.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
            this.incrementInt = Integer.parseInt(string4);
            string = String.valueOf(nextInt);
        }
        catch (NumberFormatException numberFormatException) {
            String string5 = lineNumberText.getText();
            Intrinsics.checkNotNull((Object)string5);
            string = string5;
        }
        return string;
    }

    private final int incrementLineNumber(int curr, int inc) {
        return curr + inc;
    }

    private final Node addLineElement(String lineNumber) {
        Manager manager = this.manager;
        Intrinsics.checkNotNull((Object)manager);
        Node currentNode = manager.getSimpleManager().getCurrentSelection().start.getNode();
        ParentNode p = currentNode.getParent();
        int index = p.indexOf(currentNode);
        if (lineNumber.length() > 10) {
            this.lineNumberTooLong();
            return null;
        }
        if (currentNode instanceof nu.xom.Text) {
            boolean instance2;
            Manager manager2 = this.manager;
            Intrinsics.checkNotNull((Object)manager2);
            XMLNodeCaret xMLNodeCaret = manager2.getSimpleManager().getCurrentSelection().start;
            Intrinsics.checkNotNull((Object)xMLNodeCaret, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.mvc.XMLTextCaret");
            int startOffset = ((XMLTextCaret)xMLNodeCaret).getOffset();
            boolean instance1 = index < p.getChildCount() - 2 && (BBX.SPAN.PROSE_LINE_NUMBER.isA(p.getChild(index + 2)) || BBX.SPAN.POEM_LINE_NUMBER.isA(p.getChild(index + 2))) && startOffset == 0;
            boolean bl = instance2 = index > 1 && (BBX.SPAN.PROSE_LINE_NUMBER.isA(p.getChild(index - 1)) || BBX.SPAN.POEM_LINE_NUMBER.isA(p.getChild(index - 1))) && startOffset == 0;
            if (instance1 || instance2) {
                MessageBox message = new MessageBox(WPManager.Companion.getInstance().getShell());
                message.setMessage(localeHandler.get("invalidPositionMessage"));
                message.open();
                return null;
            }
        }
        Element lineSpan = BBX.SPAN.PROSE_LINE_NUMBER.create();
        Nodes poemParents = currentNode.query("ancestor::node()[@utd-style='Poetic Stanza' or @utd-style='Poetry Line']");
        if (poemParents.size() > 0) {
            lineSpan = BBX.SPAN.POEM_LINE_NUMBER.create();
            lineSpan.addAttribute(new Attribute("type", "poem"));
            lineSpan.appendChild(lineNumber);
        } else {
            lineSpan.addAttribute(new Attribute("type", "prose"));
            lineSpan.addAttribute(new Attribute("class", "linenum"));
            lineSpan.addAttribute(new Attribute("printLineNum", lineNumber));
            Manager manager3 = this.manager;
            Intrinsics.checkNotNull((Object)manager3);
            String lineNum = TextTranslator.translateText$default((String)lineNumber, (ITranslationEngine)((ITranslationEngine)manager3.getDocument().getEngine()), (short)0, null, (int)12, null);
            lineSpan.addAttribute(new Attribute("linenum", lineNum));
        }
        try {
            if (currentNode instanceof nu.xom.Text) {
                String string = ((nu.xom.Text)currentNode).toXML();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toXML(...)");
                if (((CharSequence)string).length() == 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (((nu.xom.Text)currentNode).toXML().length() == 1) {
                    if (index == p.getChildCount() - 1) {
                        p.appendChild((Node)lineSpan);
                    } else {
                        p.insertChild((Node)lineSpan, index + 1);
                    }
                } else {
                    nu.xom.Text text = (nu.xom.Text)currentNode;
                    int[] message = new int[1];
                    Manager manager4 = this.manager;
                    Intrinsics.checkNotNull((Object)manager4);
                    XMLNodeCaret xMLNodeCaret = manager4.getSimpleManager().getCurrentSelection().end;
                    Intrinsics.checkNotNull((Object)xMLNodeCaret, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.mvc.XMLTextCaret");
                    message[0] = ((XMLTextCaret)xMLNodeCaret).getOffset();
                    List splitTextNode = XMLHandlerKt.splitNode((nu.xom.Text)text, (int[])message);
                    if (splitTextNode.size() > 1) {
                        ((nu.xom.Text)splitTextNode.get(0)).getParent().insertChild((Node)lineSpan, ((nu.xom.Text)splitTextNode.get(0)).getParent().indexOf((Node)splitTextNode.get(1)));
                    } else {
                        ParentNode parentNode = ((nu.xom.Text)splitTextNode.get(0)).getParent();
                        Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
                        Utils.insertChildCountSafe(parentNode, (Node)lineSpan, index + 1);
                    }
                    String string2 = ((nu.xom.Text)splitTextNode.get(0)).getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
                    if (((CharSequence)string2).length() == 0) {
                        ((nu.xom.Text)splitTextNode.get(0)).detach();
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            MessageBox message = new MessageBox(WPManager.Companion.getInstance().getShell());
            message.setMessage("Node was not recognized. Unable to add a line number.");
            message.open();
            return null;
        }
        return (Node)lineSpan;
    }

    private final void checkForSpace(Element span) {
        Node nodeBefore;
        ParentNode parent = span.getParent();
        int spanIndex = parent.indexOf((Node)span);
        int spacePresent = 0;
        if (spanIndex > 0 && (nodeBefore = parent.getChild(spanIndex - 1)) instanceof nu.xom.Text) {
            String text = ((nu.xom.Text)nodeBefore).getValue();
            Intrinsics.checkNotNull((Object)text);
            if (((CharSequence)text).length() > 0 && text.charAt(text.length() - 1) == ' ') {
                ++spacePresent;
            }
        }
        span.addAttribute(new Attribute("space", String.valueOf(spacePresent)));
    }

    private final void wrapSelectedElements() {
        Element div = BBX.CONTAINER.PROSE.create();
        div.addAttribute(new Attribute("class", "linedProse"));
        Manager manager = this.manager;
        Intrinsics.checkNotNull((Object)manager);
        this.startNode = manager.getSimpleManager().getCurrentSelection().start.getNode();
        Manager manager2 = this.manager;
        Intrinsics.checkNotNull((Object)manager2);
        Node endNode = manager2.getSimpleManager().getCurrentSelection().end.getNode();
        if (this.startNode instanceof nu.xom.Text || MathModuleUtils.isMath(this.startNode)) {
            this.startNode = this.getBlockParent(this.startNode);
        }
        if (endNode instanceof nu.xom.Text || MathModuleUtils.isMath(endNode)) {
            endNode = this.getBlockParent(endNode);
        }
        Node node = this.startNode;
        Intrinsics.checkNotNull((Object)node);
        if (this.unwrapProseParent(node) || this.unwrapProseParent(endNode)) {
            Manager manager3 = this.manager;
            Intrinsics.checkNotNull((Object)manager3);
            BBSimpleManager bBSimpleManager = manager3.getSimpleManager();
            Node[] nodeArray = new Node[1];
            Node node2 = this.startNode;
            Intrinsics.checkNotNull((Object)node2);
            Intrinsics.checkNotNullExpressionValue((Object)node2.getParent(), (String)"getParent(...)");
            bBSimpleManager.dispatchEvent(new ModifyEvent(Sender.NO_SENDER, true, nodeArray));
            return;
        }
        Node node3 = this.getCommonParent(this.startNode, endNode);
        Intrinsics.checkNotNull((Object)node3, (String)"null cannot be cast to non-null type nu.xom.ParentNode");
        ParentNode parent = (ParentNode)node3;
        Manager manager4 = this.manager;
        Intrinsics.checkNotNull((Object)manager4);
        if (manager4.getSimpleManager().getCurrentSelection().isSingleNode()) {
            Node node4 = this.startNode;
            Intrinsics.checkNotNull((Object)node4);
            div.appendChild(node4.copy());
            parent.replaceChild(this.startNode, (Node)div);
        } else {
            Node node5 = this.startNode;
            Intrinsics.checkNotNull((Object)node5);
            Nodes followingStart = node5.query("following-sibling::*");
            Nodes precedingEnd = endNode.query("preceding-sibling::*");
            Intrinsics.checkNotNull((Object)followingStart);
            Intrinsics.checkNotNull((Object)precedingEnd);
            List<Node> selection = this.getIntersection(followingStart, precedingEnd);
            selection.add(0, this.startNode);
            if (this.startNode != endNode) {
                selection.add(endNode);
            }
            int index = parent.indexOf(this.startNode);
            for (Node node6 : selection) {
                parent.removeChild(node6);
                div.appendChild(node6);
            }
            parent.insertChild((Node)div, index);
        }
        Manager manager5 = this.manager;
        Intrinsics.checkNotNull((Object)manager5);
        BBSimpleManager bBSimpleManager = manager5.getSimpleManager();
        Node[] nodeArray = new Node[1];
        Intrinsics.checkNotNullExpressionValue((Object)div.getParent(), (String)"getParent(...)");
        bBSimpleManager.dispatchEvent(new ModifyEvent(Sender.NO_SENDER, true, nodeArray));
    }

    private final void editLineNumber() {
        Node nextLineNum;
        Manager manager = this.manager;
        Intrinsics.checkNotNull((Object)manager);
        Node currentNode = manager.getSimpleManager().getCurrentSelection().start.getNode();
        Element lineNum = (Element)this.findNearestLineNumber(currentNode);
        if (lineNum == null && (nextLineNum = this.retrieveFollowingLineNumber(currentNode)) != null && this.getBlockParent(currentNode) == this.getBlockParent(nextLineNum)) {
            lineNum = (Element)nextLineNum;
        }
        if (lineNum == null) {
            MessageBox message = new MessageBox(WPManager.Companion.getInstance().getShell());
            message.setMessage("Found no line numbers on this line.");
            message.open();
        } else {
            this.openEditWindow(lineNum);
        }
    }

    private final Node findNearestLineNumber(Node node) {
        ParentNode parent = node.getParent();
        int index = parent.indexOf(node);
        if (node instanceof nu.xom.Text) {
            if (index > 0 && (BBX.SPAN.PROSE_LINE_NUMBER.isA(parent.getChild(index - 1)) || BBX.SPAN.POEM_LINE_NUMBER.isA(parent.getChild(index - 1)))) {
                return parent.getChild(index - 1);
            }
        } else if (node instanceof Element) {
            return this.findNearestLineNumber((Node)UTDHelper.getFirstTextDescendant((Element)((Element)node)));
        }
        return null;
    }

    @Nullable
    public final Element getActiveLineNum() {
        return this.activeLineNum;
    }

    public final void setActiveLineNum(@Nullable Element element) {
        this.activeLineNum = element;
    }

    private final void openEditWindow(Element lineNum) {
        this.activeLineNum = lineNum;
        if (this.shell != null) {
            Shell shell = this.shell;
            Intrinsics.checkNotNull((Object)shell);
            if (!shell.isDisposed()) {
                Shell shell2 = this.shell;
                Intrinsics.checkNotNull((Object)shell2);
                shell2.close();
            }
        }
        Manager manager = this.manager;
        Intrinsics.checkNotNull((Object)manager);
        Shell shell = this.shell = new Shell(manager.getWpManager().getShell(), 16448);
        Intrinsics.checkNotNull((Object)shell);
        shell.setSize(200, 125);
        Shell shell3 = this.shell;
        Intrinsics.checkNotNull((Object)shell3);
        shell3.setText("Edit Line Number");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        Shell shell4 = this.shell;
        Intrinsics.checkNotNull((Object)shell4);
        shell4.setLayout((Layout)gridLayout);
        Text editText = new Text((Composite)this.shell, 2048);
        editText.setLayoutData((Object)new GridData(768));
        if (this.isProseLineNumber(this.activeLineNum)) {
            Element element = this.activeLineNum;
            Intrinsics.checkNotNull((Object)element);
            editText.setText(element.getAttributeValue("printLineNum"));
        } else if (this.isPoemLineNumber(this.activeLineNum)) {
            Element element = this.activeLineNum;
            Intrinsics.checkNotNull((Object)element);
            editText.setText(element.getValue());
        }
        Button okButton = new Button((Composite)this.shell, 8);
        okButton.setText("Apply");
        okButton.setLayoutData((Object)new GridData(768));
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(this, editText){
            final /* synthetic */ ProseBuilder this$0;
            final /* synthetic */ Text $editText;
            {
                this.this$0 = $receiver;
                this.$editText = $editText;
            }

            public void widgetSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (ProseBuilder.access$isPoemLineNumber(this.this$0, this.this$0.getActiveLineNum())) {
                    Element element = this.this$0.getActiveLineNum();
                    String string = this.$editText.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    if (!ProseBuilder.access$editPoemLineNumber(this.this$0, element, string)) {
                        Shell shell = ProseBuilder.access$getShell$p(this.this$0);
                        Intrinsics.checkNotNull((Object)shell);
                        shell.setFocus();
                    }
                    if (this.this$0.getActiveLineNum() != null) {
                        Element element2 = this.this$0.getActiveLineNum();
                        Intrinsics.checkNotNull((Object)element2);
                        this.$editText.setText(element2.getValue());
                    } else {
                        this.$editText.setText("");
                    }
                } else if (ProseBuilder.access$isProseLineNumber(this.this$0, this.this$0.getActiveLineNum())) {
                    Element element = this.this$0.getActiveLineNum();
                    String string = this.$editText.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    if (!ProseBuilder.access$editProseLineNumber(this.this$0, element, string)) {
                        Shell shell = ProseBuilder.access$getShell$p(this.this$0);
                        Intrinsics.checkNotNull((Object)shell);
                        shell.setFocus();
                    }
                    if (this.this$0.getActiveLineNum() != null) {
                        Element element3 = this.this$0.getActiveLineNum();
                        Intrinsics.checkNotNull((Object)element3);
                        this.$editText.setText(element3.getAttributeValue("printLineNum"));
                    } else {
                        this.$editText.setText("");
                    }
                }
                if (this.this$0.getActiveLineNum() == null) {
                    String string = this.$editText.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    if (((CharSequence)string).length() == 0) {
                        Shell shell = ProseBuilder.access$getShell$p(this.this$0);
                        Intrinsics.checkNotNull((Object)shell);
                        shell.close();
                    }
                }
            }
        });
        Button prevButton = new Button((Composite)this.shell, 8);
        prevButton.setText("Previous");
        prevButton.setLayoutData((Object)new GridData(768));
        prevButton.addSelectionListener((SelectionListener)new SelectionAdapter(this, editText){
            final /* synthetic */ ProseBuilder this$0;
            final /* synthetic */ Text $editText;
            {
                this.this$0 = $receiver;
                this.$editText = $editText;
            }

            public void widgetSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ProseBuilder.access$openEditWindow$navigateNumLine(this.$editText, this.this$0, ProseBuilder.access$retrievePrecedingLineNumber(this.this$0, (Node)this.this$0.getActiveLineNum()), "Unable to find previous line number.");
            }
        });
        Button nextButton = new Button((Composite)this.shell, 8);
        nextButton.setText("Next");
        nextButton.setLayoutData((Object)new GridData(768));
        nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(this, editText){
            final /* synthetic */ ProseBuilder this$0;
            final /* synthetic */ Text $editText;
            {
                this.this$0 = $receiver;
                this.$editText = $editText;
            }

            public void widgetSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ProseBuilder.access$openEditWindow$navigateNumLine(this.$editText, this.this$0, ProseBuilder.access$retrieveFollowingLineNumber(this.this$0, (Node)this.this$0.getActiveLineNum()), "Unable to find next line number.");
            }
        });
        Button doneButton = new Button((Composite)this.shell, 8);
        doneButton.setText("DONE");
        doneButton.setLayoutData((Object)new GridData(768));
        doneButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ ProseBuilder this$0;
            {
                this.this$0 = $receiver;
            }

            public void widgetSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Shell shell = ProseBuilder.access$getShell$p(this.this$0);
                Intrinsics.checkNotNull((Object)shell);
                shell.close();
            }
        });
        Shell shell5 = this.shell;
        Intrinsics.checkNotNull((Object)shell5);
        shell5.open();
    }

    private final Node retrieveFollowingLineNumber(Node lineNumber) {
        Node node = lineNumber;
        Intrinsics.checkNotNull((Object)node);
        Nodes linenums = node.query("following-sibling::node()[@bb:type='PROSE_LINE_NUMBER' or @bb:type='POEM_LINE_NUMBER']", BBX.XPATH_CONTEXT);
        if (linenums.size() == 0) {
            linenums = lineNumber.query("following::node()[@bb:type='PROSE_LINE_NUMBER' or @bb:type='POEM_LINE_NUMBER']", BBX.XPATH_CONTEXT);
        }
        return linenums.size() > 0 ? linenums.get(0) : null;
    }

    private final Node retrievePrecedingLineNumber(Node lineNumber) {
        Node node = lineNumber;
        Intrinsics.checkNotNull((Object)node);
        Nodes linenums = node.query("preceding-sibling::node()[@bb:type='PROSE_LINE_NUMBER' or @bb:type='POEM_LINE_NUMBER']", BBX.XPATH_CONTEXT);
        if (linenums.size() == 0) {
            linenums = lineNumber.query("preceding::node()[@bb:type='PROSE_LINE_NUMBER' or @bb:type='POEM_LINE_NUMBER']", BBX.XPATH_CONTEXT);
        }
        return linenums.size() > 0 ? linenums.get(linenums.size() - 1) : null;
    }

    private final boolean editPoemLineNumber(Element lineNum, String newNum) {
        Element element = lineNum;
        Intrinsics.checkNotNull((Object)element);
        ParentNode parent = element.getParent();
        if (((CharSequence)newNum).length() == 0) {
            this.activeLineNum = (Element)this.retrieveFollowingLineNumber((Node)this.activeLineNum);
            lineNum.detach();
        } else {
            if (newNum.length() > 10) {
                this.lineNumberTooLong();
                return false;
            }
            lineNum.removeChild(0);
            lineNum.appendChild(newNum);
            this.activeLineNum = lineNum;
        }
        Manager manager = this.manager;
        Intrinsics.checkNotNull((Object)manager);
        BBSimpleManager bBSimpleManager = manager.getSimpleManager();
        Node[] nodeArray = new Node[1];
        Intrinsics.checkNotNull((Object)parent);
        nodeArray[0] = parent;
        bBSimpleManager.dispatchEvent(new ModifyEvent(Sender.NO_SENDER, true, nodeArray));
        return true;
    }

    private final boolean editProseLineNumber(Element lineNum, String newNum) {
        Element element = lineNum;
        Intrinsics.checkNotNull((Object)element);
        ParentNode parentNode = element.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
        Node parent = (Node)parentNode;
        if (((CharSequence)newNum).length() == 0) {
            this.activeLineNum = (Element)this.retrieveFollowingLineNumber((Node)this.activeLineNum);
            lineNum.detach();
        } else {
            if (newNum.length() > 10) {
                this.lineNumberTooLong();
                return false;
            }
            lineNum.addAttribute(new Attribute("printLineNum", newNum));
            Manager manager = this.manager;
            Intrinsics.checkNotNull((Object)manager);
            String newLineNum = TextTranslator.translateText$default((String)newNum, (ITranslationEngine)((ITranslationEngine)manager.getDocument().getEngine()), (short)0, null, (int)12, null);
            lineNum.addAttribute(new Attribute("linenum", newLineNum));
            this.activeLineNum = lineNum;
        }
        Manager manager = this.manager;
        Intrinsics.checkNotNull((Object)manager);
        Node[] nodeArray = new Node[]{parent};
        manager.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.NO_SENDER, false, nodeArray));
        return true;
    }

    private final boolean isProseLineNumber(Element lineNum) {
        Element element = lineNum;
        Intrinsics.checkNotNull((Object)element);
        return Intrinsics.areEqual((Object)element.getAttributeValue("type", "http://brailleblaster.org/ns/bb"), (Object)"PROSE_LINE_NUMBER");
    }

    private final boolean isPoemLineNumber(Element lineNum) {
        Element element = lineNum;
        Intrinsics.checkNotNull((Object)element);
        return Intrinsics.areEqual((Object)element.getAttributeValue("type", "http://brailleblaster.org/ns/bb"), (Object)"POEM_LINE_NUMBER");
    }

    private final Node getBlockParent(Node child) {
        Node node;
        Node node2 = child;
        Intrinsics.checkNotNull((Object)node2);
        if (BBX.BLOCK.isA((Node)node2.getParent())) {
            ParentNode parentNode = child.getParent();
            Intrinsics.checkNotNull((Object)parentNode);
            node = (Node)parentNode;
        } else {
            node = this.getBlockParent((Node)child.getParent());
        }
        return node;
    }

    private final Node getCommonParent(Node start, Node end) {
        Node node = start;
        Intrinsics.checkNotNull((Object)node);
        if (!Intrinsics.areEqual((Object)node.getParent(), (Object)end.getParent())) {
            List startAncestors = SequencesKt.toList((Sequence)FastXPath.ancestor((Node)start));
            List endAncestors = SequencesKt.toList((Sequence)FastXPath.ancestor((Node)end));
            for (int i = startAncestors.size() - 1; -1 < i; --i) {
                int n = endAncestors.size();
                for (int j = 0; j < n; ++j) {
                    if (!Intrinsics.areEqual(startAncestors.get(i), endAncestors.get(j))) continue;
                    this.startNode = (Node)startAncestors.get(i + 1);
                    return (Node)startAncestors.get(i);
                }
            }
        }
        ParentNode parentNode = start.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
        return (Node)parentNode;
    }

    private final boolean unwrapProseParent(Node node) {
        if (BBX.CONTAINER.PROSE.isA(node)) {
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            XMLHandler.Companion.unwrapElement((Element)node);
            return true;
        }
        Sequence ancestors = FastXPath.ancestor((Node)node);
        for (Element ancestor : ancestors) {
            if (!BBX.CONTAINER.PROSE.isA((Node)ancestor)) continue;
            XMLHandler.Companion.unwrapElement(ancestor);
            return true;
        }
        return false;
    }

    private final List<Node> getIntersection(Nodes start, Nodes end) {
        List intersection = new ArrayList();
        int n = start.size();
        for (int i = 0; i < n; ++i) {
            if (!end.contains(start.get(i))) continue;
            intersection.add(start.get(i));
        }
        return intersection;
    }

    private final void lineNumberTooLong() {
        MessageBox message = new MessageBox(WPManager.Companion.getInstance().getShell());
        message.setMessage("Line numbers must be 10 digits or less.");
        message.open();
    }

    private static final void addToolbar$lambda$0(ProseBuilder this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.wrapSelectedElements();
    }

    private static final void addToolbar$lambda$1(ProseBuilder this$0, CustomToolBarBuilder.CustomText $lineNumber, CustomToolBarBuilder.CustomText $increment, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.insertLineNumber($lineNumber, $increment);
    }

    private static final void addToolbar$lambda$2(ProseBuilder this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.editLineNumber();
    }

    private static final void addToolbar$lambda$3(ProseBuilder this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.close();
    }

    private static final void addKeyListener$lambda$0(ProseBuilder this$0, CustomToolBarBuilder.CustomText $lineNumber, CustomToolBarBuilder.CustomText $increment, VerifyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.stateMask == 262144 && event.keyCode == 0x100000B) {
            this$0.wrapSelectedElements();
            event.doit = false;
        } else if (event.stateMask == 393216 && event.keyCode == 0x100000B) {
            this$0.editLineNumber();
            event.doit = false;
        } else if (event.keyCode == 0x100000B) {
            this$0.insertLineNumber($lineNumber, $increment);
            event.doit = false;
        } else if (event.keyCode == 27) {
            this$0.close();
        }
    }

    private static final void openEditWindow$navigateNumLine(Text editText, ProseBuilder this$0, Node newLineNum, String msg) {
        block14: {
            block13: {
                if (newLineNum != null) break block13;
                String string = editText.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (!(((CharSequence)string).length() == 0)) break block14;
            }
            if (this$0.isProseLineNumber(this$0.activeLineNum)) {
                Element element = this$0.activeLineNum;
                String string = editText.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (!this$0.editProseLineNumber(element, string)) {
                    Shell shell = this$0.shell;
                    Intrinsics.checkNotNull((Object)shell);
                    shell.setFocus();
                }
                this$0.activeLineNum = (Element)newLineNum;
                if (this$0.activeLineNum != null) {
                    Element element2 = this$0.activeLineNum;
                    Intrinsics.checkNotNull((Object)element2);
                    editText.setText(element2.getAttributeValue("printLineNum"));
                } else {
                    editText.setText("");
                }
            } else if (this$0.isPoemLineNumber(this$0.activeLineNum)) {
                Element element = this$0.activeLineNum;
                String string = editText.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (!this$0.editPoemLineNumber(element, string)) {
                    Shell shell = this$0.shell;
                    Intrinsics.checkNotNull((Object)shell);
                    shell.setFocus();
                }
                this$0.activeLineNum = (Element)newLineNum;
                if (this$0.activeLineNum != null) {
                    Element element3 = this$0.activeLineNum;
                    Intrinsics.checkNotNull((Object)element3);
                    editText.setText(element3.getValue());
                } else {
                    editText.setText("");
                }
            }
        }
        if (newLineNum == null) {
            MessageBox message = new MessageBox(WPManager.Companion.getInstance().getShell());
            message.setMessage(msg);
            message.open();
            Shell shell = this$0.shell;
            Intrinsics.checkNotNull((Object)shell);
            shell.close();
        }
    }

    public static final /* synthetic */ boolean access$getToolbarEnabledChanged$p(ProseBuilder $this) {
        return $this.toolbarEnabledChanged;
    }

    public static final /* synthetic */ CustomToolBarBuilder.CustomButton access$getWrapButton$p(ProseBuilder $this) {
        return $this.wrapButton;
    }

    public static final /* synthetic */ void access$setToolbarEnabledChanged$p(ProseBuilder $this, boolean bl) {
        $this.toolbarEnabledChanged = bl;
    }

    public static final /* synthetic */ boolean access$isPoemLineNumber(ProseBuilder $this, Element lineNum) {
        return $this.isPoemLineNumber(lineNum);
    }

    public static final /* synthetic */ boolean access$editPoemLineNumber(ProseBuilder $this, Element lineNum, String newNum) {
        return $this.editPoemLineNumber(lineNum, newNum);
    }

    public static final /* synthetic */ Shell access$getShell$p(ProseBuilder $this) {
        return $this.shell;
    }

    public static final /* synthetic */ boolean access$isProseLineNumber(ProseBuilder $this, Element lineNum) {
        return $this.isProseLineNumber(lineNum);
    }

    public static final /* synthetic */ boolean access$editProseLineNumber(ProseBuilder $this, Element lineNum, String newNum) {
        return $this.editProseLineNumber(lineNum, newNum);
    }

    public static final /* synthetic */ void access$openEditWindow$navigateNumLine(Text editText, ProseBuilder this$0, Node newLineNum, String msg) {
        ProseBuilder.openEditWindow$navigateNumLine(editText, this$0, newLineNum, msg);
    }

    public static final /* synthetic */ Node access$retrievePrecedingLineNumber(ProseBuilder $this, Node lineNumber) {
        return $this.retrievePrecedingLineNumber(lineNumber);
    }

    public static final /* synthetic */ Node access$retrieveFollowingLineNumber(ProseBuilder $this, Node lineNumber) {
        return $this.retrieveFollowingLineNumber(lineNumber);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/brailleblaster/util/ProseBuilder$Companion;", "", "<init>", "()V", "localeHandler", "Lorg/brailleblaster/utils/localization/LocaleHandler;", "SETTING_ENABLED", "", "isEnabled", "", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isEnabled(@NotNull Manager m) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            ProseBuilder proseBuilder = m.getSimpleManager().getModule(ProseBuilder.class);
            Intrinsics.checkNotNull((Object)proseBuilder);
            return proseBuilder.toolbarEnabled;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

