/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.util.ui;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.BBXUtils;
import org.brailleblaster.bbx.BBXUtilsKt;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.LineBreakElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.properties.EmphasisType;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.utils.braille.BrailleUnicodeConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tJ\u0010\u0010\u000f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/brailleblaster/util/ui/SixKeyUtils;", "", "<init>", "()V", "SPACE", "", "saveBraille", "Lnu/xom/Element;", "inline", "", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "brailleText", "", "unicode", "formatPreviousImageDescription", "brailleString", "Lnu/xom/Node;", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nSixKeyUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SixKeyUtils.kt\norg/brailleblaster/util/ui/SixKeyUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,145:1\n742#2,9:146\n37#3,2:155\n*S KotlinDebug\n*F\n+ 1 SixKeyUtils.kt\norg/brailleblaster/util/ui/SixKeyUtils\n*L\n53#1:146,9\n53#1:155,2\n*E\n"})
public final class SixKeyUtils {
    @NotNull
    public static final SixKeyUtils INSTANCE = new SixKeyUtils();
    public static final char SPACE = '\u2800';

    private SixKeyUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Element saveBraille(boolean inline, @NotNull Manager m, @NotNull String brailleText, boolean unicode) {
        TextMapElement tme;
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Intrinsics.checkNotNullParameter((Object)brailleText, (String)"brailleText");
        EmphasisType[] emphasisTypeArray = new EmphasisType[]{EmphasisType.NO_TRANSLATE};
        Element direct = BBX.INLINE.EMPHASIS.create(emphasisTypeArray);
        Object object = brailleText;
        Regex regex = new Regex("\n");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] array = thisCollection$iv.toArray(new String[0]);
        int preceedingSpaceCount = 0;
        Object text = "";
        boolean beginning = false;
        int cursorOffset = m.getTextView().getCaretOffset();
        TextMapElement textMapElement = tme = m.getMapList().getCurrent();
        Intrinsics.checkNotNull((Object)textMapElement);
        if (textMapElement.getNode() != null && !(tme instanceof LineBreakElement)) {
            Node node = tme.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
            ParentNode currentBlock = (ParentNode)BBXUtilsKt.findBlock(node);
            while (tme != null && Intrinsics.areEqual((Object)currentBlock, (Object)m.getBlock(tme.getNode()))) {
                Node node2 = tme.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"getNode(...)");
                if (BBXUtils.INSTANCE.getIndexInBlock(node2) == 0) break;
                tme = m.getMapList().getPrevious(m.getMapList().indexOf(tme), true);
            }
            if (tme == null || tme.getStart(m.getMapList()) == cursorOffset) {
                beginning = true;
            }
        } else {
            beginning = true;
        }
        int n2 = array.length;
        for (int i = 0; i < n2; ++i) {
            String temp = array[i];
            for (int j = 0; j < temp.length(); ++j) {
                char c = temp.charAt(j);
                if (j == 0 && c == '\u2800' && beginning) {
                    while (preceedingSpaceCount < temp.length() - 1 && c == '\u2800') {
                        c = temp.charAt(++preceedingSpaceCount);
                    }
                    Element tab = BBX.SPAN.TAB.create();
                    int cellsPerLine = UTDManager.Companion.getCellsPerLine(m);
                    if (preceedingSpaceCount + 1 > cellsPerLine) {
                        while (preceedingSpaceCount + 1 > cellsPerLine) {
                            preceedingSpaceCount -= cellsPerLine;
                        }
                        if (direct.getChildCount() != 0) {
                            Element element = BBX.INLINE.LINE_BREAK.create();
                            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"create(...)");
                            Node newline = (Node)element;
                            direct.appendChild(newline);
                        }
                    }
                    Attribute att = BBX.SPAN.TAB.ATTRIB_VALUE.newAttribute(preceedingSpaceCount + 1);
                    tab.addAttribute(att);
                    direct.appendChild((Node)tab);
                    j = preceedingSpaceCount - 1;
                    preceedingSpaceCount = 0;
                    continue;
                }
                text = (String)text + c;
            }
            if (((CharSequence)text).length() > 0) {
                if (unicode) {
                    direct.appendChild((String)text);
                } else {
                    direct.appendChild(BrailleUnicodeConverter.INSTANCE.unicodeToAsciiLouis((String)text));
                }
            }
            text = "";
            if (i == array.length - 1 && inline) continue;
            Element element = BBX.INLINE.LINE_BREAK.create();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"create(...)");
            Node newline = (Node)element;
            direct.appendChild(newline);
        }
        Intrinsics.checkNotNull((Object)direct);
        return direct;
    }

    @NotNull
    public final String formatPreviousImageDescription(@Nullable Node brailleString) {
        return SequencesKt.joinToString$default((Sequence)SequencesKt.filter((Sequence)FastXPath.descendant((Node)brailleString), SixKeyUtils::formatPreviousImageDescription$lambda$0), (CharSequence)"", null, null, (int)0, null, SixKeyUtils::formatPreviousImageDescription$lambda$1, (int)30, null);
    }

    private static final boolean formatPreviousImageDescription$lambda$0$0(Element it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return UTDElements.BRL.isA((Node)it);
    }

    private static final boolean formatPreviousImageDescription$lambda$0(Node node) {
        return node instanceof Text && XMLHandler.Companion.ancestorElementNot(node, SixKeyUtils::formatPreviousImageDescription$lambda$0$0) || BBX.INLINE.LINE_BREAK.isA(node) || BBX.SPAN.TAB.isA(node);
    }

    private static final CharSequence formatPreviousImageDescription$lambda$1(Node node) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof Text) {
            String string = ((Text)node).getValue();
            Intrinsics.checkNotNull((Object)string);
            charSequence = string;
        } else {
            charSequence = BBX.SPAN.TAB.isA(node) ? (CharSequence)StringsKt.repeat((CharSequence)"\u2800", (int)(((Number)BBX.SPAN.TAB.ATTRIB_VALUE.get((Element)node)).intValue() - 1)) : (CharSequence)"\n";
        }
        return charSequence;
    }
}

