/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.wordprocessor;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.brailleblaster.BBIni;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\r\u001a\u00020\u000e2\u001e\u0010\u000f\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\t0\u0010J\u0006\u0010\u0011\u001a\u00020\u000eJ\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u0002J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0003J\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0003J\u0006\u0010\u0016\u001a\u00020\u000eJ\u0016\u0010\u0017\u001a\u00020\u000e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lorg/brailleblaster/wordprocessor/RecentDocs;", "", "path", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getPath", "()Ljava/nio/file/Path;", "value", "", "recentDocs", "getRecentDocs", "()Ljava/util/List;", "modify", "", "transform", "Lkotlin/Function1;", "readRecentFiles", "read", "addRecentDoc", "doc", "removeRecentDoc", "writeRecentFiles", "write", "files", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nRecentDocs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecentDocs.kt\norg/brailleblaster/wordprocessor/RecentDocs\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1586#2:70\n1661#2,3:71\n1586#2:74\n1661#2,3:75\n777#2:78\n873#2,2:79\n777#2:81\n873#2,2:82\n*S KotlinDebug\n*F\n+ 1 RecentDocs.kt\norg/brailleblaster/wordprocessor/RecentDocs\n*L\n41#1:70\n41#1:71,3\n58#1:74\n58#1:75,3\n47#1:78\n47#1:79,2\n51#1:81\n51#1:82,2\n*E\n"})
public final class RecentDocs {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path path;
    @NotNull
    private List<? extends Path> recentDocs;
    public static final int MAX_RECENT_FILES = 20;
    @NotNull
    private static final RecentDocs defaultRecentDocs = new RecentDocs(BBIni.INSTANCE.getRecentDocs());

    public RecentDocs(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.recentDocs = this.read();
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @NotNull
    public final List<Path> getRecentDocs() {
        return this.recentDocs;
    }

    /*
     * WARNING - void declaration
     */
    public final void modify(@NotNull Function1<? super List<? extends Path>, ? extends List<? extends Path>> transform) {
        void it;
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        Object object = transform.invoke(this.recentDocs);
        List list = (List)object;
        RecentDocs recentDocs = this;
        boolean bl = false;
        this.write((List<? extends Path>)it);
        recentDocs.recentDocs = (List)object;
    }

    public final void readRecentFiles() {
        this.recentDocs = this.read();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Path> read() {
        List list;
        try {
            void $this$mapTo$iv$iv;
            List<String> list2 = Files.readAllLines(this.path, BBIni.INSTANCE.getCharset());
            Intrinsics.checkNotNullExpressionValue(list2, (String)"readAllLines(...)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void first;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Path path = Paths.get((String)first, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                collection.add(path);
            }
            list = (List)destination$iv$iv;
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to load recent docs at " + this.path, ex);
        }
        return list;
    }

    public final void addRecentDoc(@NotNull Path doc) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        this.modify((Function1<? super List<? extends Path>, ? extends List<? extends Path>>)((Function1)arg_0 -> RecentDocs.addRecentDoc$lambda$0(doc, arg_0)));
    }

    public final void removeRecentDoc(@NotNull Path doc) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        this.modify((Function1<? super List<? extends Path>, ? extends List<? extends Path>>)((Function1)arg_0 -> RecentDocs.removeRecentDoc$lambda$0(doc, arg_0)));
    }

    public final void writeRecentFiles() {
        this.write(this.recentDocs);
    }

    /*
     * WARNING - void declaration
     */
    private final void write(List<? extends Path> files) {
        try {
            void $this$mapTo$iv$iv;
            Path path = this.path;
            OpenOption[] $this$map$iv = (OpenOption[])files;
            boolean $i$f$map = false;
            OpenOption[] openOptionArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void curPath;
                Path path2 = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)curPath.toAbsolutePath()).toString());
            }
            $this$map$iv = (List)destination$iv$iv;
            Charset charset = BBIni.INSTANCE.getCharset();
            openOptionArray = new OpenOption[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.write(path, (Iterable<? extends CharSequence>)$this$map$iv, charset, Arrays.copyOf(openOptionArray, openOptionArray.length)), (String)"write(...)");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to save recent docs file", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List addRecentDoc$lambda$0(Path $doc, List it) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable iterable = it;
        Collection collection = CollectionsKt.listOf((Object)$doc);
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path d = (Path)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)d, (Object)$doc))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.take((Iterable)((List)destination$iv$iv), (int)19));
    }

    /*
     * WARNING - void declaration
     */
    private static final List removeRecentDoc$lambda$0(Path $doc, List it) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$filter$iv = it;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path d = (Path)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)d, (Object)$doc))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/brailleblaster/wordprocessor/RecentDocs$Companion;", "", "<init>", "()V", "MAX_RECENT_FILES", "", "defaultRecentDocs", "Lorg/brailleblaster/wordprocessor/RecentDocs;", "getDefaultRecentDocs", "()Lorg/brailleblaster/wordprocessor/RecentDocs;", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RecentDocs getDefaultRecentDocs() {
            return defaultRecentDocs;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

