/*
 * Decompiled with CFR 0.152.
 */
package org.mwhapples.jlouis;

import com.sun.jna.FromNativeContext;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeMapped;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import org.mwhapples.jlouis.DefaultLogCallback;
import org.mwhapples.jlouis.JarResolver;
import org.mwhapples.jlouis.LogCallback;
import org.mwhapples.jlouis.LouisTypeMapper;
import org.mwhapples.jlouis.TableResolver;
import org.mwhapples.jlouis.TranslationException;
import org.mwhapples.jlouis.TranslationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Louis {
    private final int outRatio = 4 + encodingSize * 2;
    private static LogCallback callback;
    private static int encodingSize;
    private static Properties libConfig;
    private static final Logger logger;
    private static final Object THREAD_SAFE_LOCK;
    private static TableResolver tr;

    private static Properties loadConfig(String resourceName) throws IOException {
        InputStream configStream = ClassLoader.getSystemResourceAsStream(resourceName);
        Properties configProperties = new Properties();
        if (configStream != null) {
            configProperties.load(configStream);
        }
        return configProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersion() {
        Object object = THREAD_SAFE_LOCK;
        synchronized (object) {
            return Louis.lou_version();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEncodingSize() {
        Object object = THREAD_SAFE_LOCK;
        synchronized (object) {
            return Louis.lou_charSize();
        }
    }

    public String translateString(String tablesList, String inbuf, int mode) throws TranslationException {
        return this.translateString(tablesList, inbuf, null, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String translateString(String tablesList, String inbuf, @Nullable short[] typeforms, int mode) throws TranslationException {
        if (inbuf == null || inbuf.isEmpty()) {
            return "";
        }
        Object object = THREAD_SAFE_LOCK;
        synchronized (object) {
            IntByReference poutlen;
            WideChar wOutbuf;
            int inlen = inbuf.length();
            WideChar wInbuf = new WideChar(inbuf);
            int outlen = this.outRatio * inlen;
            short[] typeformsCopy = null;
            if (typeforms != null) {
                typeformsCopy = Arrays.copyOf(typeforms, outlen);
            }
            if (Louis.lou_translateString(tablesList, wInbuf, new IntByReference(inlen), wOutbuf = new WideChar(outlen), poutlen = new IntByReference(outlen), typeformsCopy, null, mode) == 0) {
                throw new TranslationException("Unable to complete translation");
            }
            return wOutbuf.getText(poutlen.getValue());
        }
    }

    public TranslationResult translate(String trantab, String inbuf, int cursorPos, int mode) throws TranslationException {
        return this.translate(trantab, inbuf, null, cursorPos, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TranslationResult translate(String trantab, String inbuf, @Nullable short[] typeForms, int cursorPos, int mode) throws TranslationException {
        Object object = THREAD_SAFE_LOCK;
        synchronized (object) {
            IntByReference pcursorPos;
            int[] inPos;
            int[] outPos;
            IntByReference poutlen;
            WideChar wOutbuf;
            if (inbuf == null || inbuf.isEmpty()) {
                return new TranslationResult("", new int[0], new int[0], 0);
            }
            WideChar wInbuf = new WideChar(inbuf);
            int inlen = wInbuf.length();
            int outlen = inlen * this.outRatio;
            short[] typeformsCopy = null;
            if (typeForms != null) {
                typeformsCopy = Arrays.copyOf(typeForms, outlen);
            }
            if (Louis.lou_translate(trantab, wInbuf, new IntByReference(inlen), wOutbuf = new WideChar(outlen), poutlen = new IntByReference(outlen), typeformsCopy, null, outPos = new int[inlen], inPos = new int[outlen], pcursorPos = new IntByReference(cursorPos), mode) == 0) {
                throw new TranslationException("Unable to complete translation");
            }
            String outbuf = wOutbuf.getText(poutlen.getValue());
            return new TranslationResult(outbuf, outPos, inPos, pcursorPos.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String backTranslateString(String trantab, String inbuf, @Nullable short[] typeforms, int mode) throws TranslationException {
        Object object = THREAD_SAFE_LOCK;
        synchronized (object) {
            IntByReference poutlen;
            WideChar wInbuf = new WideChar(inbuf);
            int inlen = wInbuf.length();
            int outlen = this.outRatio * inlen;
            WideChar wOutbuf = new WideChar(outlen);
            short[] typeformsCopy = null;
            if (typeforms != null) {
                typeformsCopy = Arrays.copyOf(typeforms, outlen);
            }
            if (Louis.lou_backTranslateString(trantab, wInbuf, new IntByReference(inlen), wOutbuf, poutlen = new IntByReference(outlen), typeformsCopy, null, mode) == 0) {
                throw new TranslationException("Unable to complete translation");
            }
            return wOutbuf.getText(poutlen.getValue());
        }
    }

    public TranslationResult backTranslate(String trantab, String inbuf, int cursorPos, int mode) throws TranslationException {
        return this.backTranslate(trantab, inbuf, null, cursorPos, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TranslationResult backTranslate(String trantab, String inbuf, @Nullable short[] typeForms, int cursorPos, int mode) throws TranslationException {
        Object object = THREAD_SAFE_LOCK;
        synchronized (object) {
            IntByReference pcursorPos;
            int[] inPos;
            int[] outPos;
            IntByReference poutlen;
            WideChar wOutbuf;
            WideChar wInbuf = new WideChar(inbuf);
            int inlen = wInbuf.length();
            int outlen = inlen * this.outRatio;
            short[] typeformsCopy = null;
            if (typeForms != null) {
                typeformsCopy = Arrays.copyOf(typeForms, outlen);
            }
            if (Louis.lou_backTranslate(trantab, wInbuf, new IntByReference(inlen), wOutbuf = new WideChar(outlen), poutlen = new IntByReference(outlen), typeformsCopy, null, outPos = new int[inlen], inPos = new int[outlen], pcursorPos = new IntByReference(cursorPos), mode) == 0) {
                throw new TranslationException("Unable to complete translation");
            }
            String outbuf = wOutbuf.getText(poutlen.getValue());
            return new TranslationResult(outbuf, outPos, inPos, pcursorPos.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] hyphenate(String trantab, String inbuf, int mode) throws TranslationException {
        Object object = THREAD_SAFE_LOCK;
        synchronized (object) {
            WideChar wInbuf = new WideChar(inbuf);
            int inlen = wInbuf.length();
            byte[] hyphens = new byte[inlen * this.outRatio];
            if (Louis.lou_hyphenate(trantab, wInbuf, inlen, hyphens, mode) == 0) {
                Arrays.fill(hyphens, (byte)32);
            }
            return Arrays.copyOf(hyphens, inlen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = THREAD_SAFE_LOCK;
        synchronized (object) {
            Louis.lou_free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogLevel(int level) {
        Object object = THREAD_SAFE_LOCK;
        synchronized (object) {
            Louis.lou_setLogLevel(level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataPath(String path) {
        Object object = THREAD_SAFE_LOCK;
        synchronized (object) {
            Louis.lou_setDataPath(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDataPath() {
        Object object = THREAD_SAFE_LOCK;
        synchronized (object) {
            return Louis.lou_getDataPath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerTableResolver(TableResolver resolver) {
        tr = resolver;
        Object object = THREAD_SAFE_LOCK;
        synchronized (object) {
            Louis.lou_registerTableResolver(tr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLogCallback(LogCallback cb) {
        callback = cb != null ? cb : new DefaultLogCallback();
        Object object = THREAD_SAFE_LOCK;
        synchronized (object) {
            Louis.lou_registerLogCallback(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dotsToChar(String trantab, WideChar inbuf, WideChar outbuf, int length, int mode) {
        Object object = THREAD_SAFE_LOCK;
        synchronized (object) {
            Louis.lou_dotsToChar(trantab, inbuf, outbuf, length, mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void charToDots(String trantab, WideChar inbuf, WideChar outbuf, int length, int mode) {
        Object object = THREAD_SAFE_LOCK;
        synchronized (object) {
            Louis.lou_charToDots(trantab, inbuf, outbuf, length, mode);
        }
    }

    private static native int lou_backTranslate(String var0, WideChar var1, IntByReference var2, WideChar var3, IntByReference var4, short[] var5, byte[] var6, int[] var7, int[] var8, IntByReference var9, int var10);

    private static native int lou_backTranslateString(String var0, WideChar var1, IntByReference var2, WideChar var3, IntByReference var4, short[] var5, byte[] var6, int var7);

    private static native int lou_charSize();

    private static native void lou_free();

    private static native void lou_getTable(String var0);

    private static native int lou_hyphenate(String var0, WideChar var1, int var2, byte[] var3, int var4);

    private static native int lou_translate(String var0, WideChar var1, IntByReference var2, WideChar var3, IntByReference var4, short[] var5, byte[] var6, int[] var7, int[] var8, IntByReference var9, int var10);

    private static native int lou_translateString(String var0, WideChar var1, IntByReference var2, WideChar var3, IntByReference var4, short[] var5, byte[] var6, int var7);

    private static native String lou_version();

    private static native void lou_setDataPath(String var0);

    private static native String lou_getDataPath();

    private static native void lou_registerTableResolver(TableResolver var0);

    private static native void lou_registerLogCallback(LogCallback var0);

    private static native void lou_setLogLevel(int var0);

    private static native void lou_dotsToChar(String var0, WideChar var1, WideChar var2, int var3, int var4);

    private static native void lou_charToDots(String var0, WideChar var1, WideChar var2, int var3, int var4);

    static {
        File libFile;
        String libName;
        logger = LoggerFactory.getLogger(Louis.class);
        THREAD_SAFE_LOCK = new Object();
        try {
            libConfig = Louis.loadConfig("jlouis.properties");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        tr = null;
        int platform = Platform.getOSType();
        switch (platform) {
            case 4: {
                libName = libConfig.getProperty("jlouis.library.name.freebsd", "liblouis.so");
                break;
            }
            case 1: {
                libName = libConfig.getProperty("jlouis.library.name.linux", "liblouis.so");
                break;
            }
            case 0: {
                libName = libConfig.getProperty("jlouis.library.name.mac", "liblouis.dylib");
                break;
            }
            case 5: {
                libName = libConfig.getProperty("jlouis.library.name.openbsd", "liblouis.so");
                break;
            }
            case 3: {
                libName = libConfig.getProperty("jlouis.library.name.solaris", "liblouis.so");
                break;
            }
            case 2: {
                libName = libConfig.getProperty("jlouis.library.name.windows", "liblouis.dll");
                break;
            }
            case 6: {
                libName = libConfig.getProperty("jlouis.library.name.windowsce", "liblouis.dll");
                break;
            }
            default: {
                libName = "liblouis.so";
            }
        }
        String libPath = System.getProperty("jlouis.library.path", libConfig.getProperty("jlouis.library.path"));
        if (libPath != null && !libPath.isEmpty()) {
            libFile = new File(libPath, libName);
        } else {
            try {
                libFile = Native.extractFromResourcePath((String)("/" + Platform.RESOURCE_PREFIX + "/" + libName));
                logger.info("libFile extract:  " + libFile);
            }
            catch (IOException e) {
                String errorMsg = "There is no bundled binary for your platform: " + Platform.RESOURCE_PREFIX + "/" + libName;
                logger.error(errorMsg);
                throw new RuntimeException(errorMsg);
            }
        }
        if (!libFile.exists() || !libFile.isFile()) {
            throw new UnsatisfiedLinkError(String.format("Library \"%s\" does not exist", libFile.getAbsolutePath()));
        }
        HashMap<String, LouisTypeMapper> options = new HashMap<String, LouisTypeMapper>();
        options.put("type-mapper", new LouisTypeMapper());
        NativeLibrary nativeLib = NativeLibrary.getInstance((String)libFile.getAbsolutePath(), options);
        Native.register((NativeLibrary)nativeLib);
        encodingSize = Louis.lou_charSize();
        callback = new DefaultLogCallback();
        Louis.lou_registerLogCallback(callback);
        if (System.getProperty("jlouis.data.path") != null) {
            Louis.lou_setDataPath(System.getProperty("jlouis.data.path"));
        }
        Louis.registerTableResolver(new JarResolver());
    }

    public static class WideChar
    implements NativeMapped {
        private static String encoding;
        private Memory buffer;
        private int length;

        private void setEncoding() {
            if (encoding != null) {
                return;
            }
            if (encodingSize == 2) {
                encoding = "utf-16le";
            } else if (encodingSize == 4) {
                encoding = "utf-32le";
            }
        }

        public WideChar(int length) {
            this.setEncoding();
            if (encodingSize == 0) {
                return;
            }
            this.length = length;
            this.buffer = new Memory((long)encodingSize * (long)length);
        }

        public WideChar(String text) {
            this.setEncoding();
            this.setText(text);
        }

        public WideChar() {
            this(1);
        }

        private void setText(String text) {
            try {
                this.length = text.length();
                this.buffer = new Memory((long)this.length * (long)encodingSize);
                this.buffer.write(0L, text.getBytes(encoding), 0, encodingSize * text.length());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }

        public String getText(int length) {
            int bufferLength = length * encodingSize;
            try {
                return new String(this.buffer.getByteArray(0L, bufferLength), 0, bufferLength, encoding);
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }

        public int length() {
            return this.length;
        }

        public Class<?> nativeType() {
            return Pointer.class;
        }

        public Object toNative() {
            return this.buffer;
        }

        public Object fromNative(Object nativeValue, FromNativeContext context) {
            byte[] nativeBytes = (byte[])nativeValue;
            WideChar javaValue = new WideChar();
            try {
                javaValue.setText(new String(nativeBytes, encoding));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return javaValue;
        }
    }

    public static interface TranslationModes {
        public static final int NO_CONTRACTIONS = 1;
        public static final int COMPBRL_AT_CURSOR = 2;
        public static final int DOTS_IO = 4;
        public static final int COMP8DOTS = 8;
        public static final int PASS1_ONLY = 16;
        public static final int COMPBRL_LEFT_CURSOR = 32;
        public static final int UC_BRL = 64;
        public static final int NO_UNDEFINED_DOTS = 128;
        public static final int PARTIAL_TRANS = 256;
    }

    public static interface TypeForms {
        public static final short PLAIN_TEXT = 0;
        public static final short ITALIC = 1;
        public static final short UNDERLINE = 2;
        public static final short BOLD = 4;
        public static final short SCRIPT = 8;
        public static final short TRANS_NOTE = 16;
        public static final short TRANS_1 = 32;
        public static final short TRANS_2 = 64;
        public static final short TRANS_3 = 128;
        public static final short TRANS_4 = 256;
        public static final short TRANS_5 = 512;
        public static final short COMPUTER_BRAILLE = 1024;
        public static final short NO_TRANSLATE = 2048;
        public static final short NO_CONTRACT = 4096;
    }
}

