/*
 * Decompiled with CFR 0.152.
 */
package org.mwhapples.jlouis.cli;

import org.mwhapples.jlouis.Louis;
import org.mwhapples.jlouis.TranslationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTranslate {
    private static final Logger logger = LoggerFactory.getLogger(SimpleTranslate.class);

    public static void main(String[] args) throws TranslationException {
        Louis translator = new Louis();
        if (args.length != 2) {
            System.out.println("LibLouis version:  " + translator.getVersion());
            System.out.println("Usage: <translation table> <text to translate>");
            System.exit(0);
        }
        logger.info("Getting liblouis version");
        logger.info("Using buffer size {}", (Object)translator.getEncodingSize());
        logger.info("Performing forward translation for string of length {} using mode {}", (Object)args[1].length(), (Object)0);
        String brailleStr = translator.translateString(args[0], args[1], null, 0);
        logger.info(brailleStr);
        byte[] hyphens = translator.hyphenate(args[0], brailleStr, 1);
        char[] hyphenChars = new char[hyphens.length];
        for (int i = 0; i < hyphens.length; ++i) {
            hyphenChars[i] = hyphens[i] == 49 ? 45 : 32;
        }
        logger.info(new String(hyphenChars));
        String backTranslationStr = translator.backTranslateString(args[0], brailleStr, null, 0);
        logger.info(backTranslationStr);
        hyphens = translator.hyphenate(args[0], backTranslationStr, 0);
        hyphenChars = new char[hyphens.length];
        for (int i = 0; i < hyphens.length; ++i) {
            hyphenChars[i] = hyphens[i] == 49 ? 45 : 32;
        }
        logger.info(new String(hyphenChars));
        translator.close();
    }
}

