/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.drivers.braillo;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import org.brailleblaster.libembosser.drivers.braillo.AbstractBrailloDocumentHandler;

public class Braillo200DocumentHandler
extends AbstractBrailloDocumentHandler {
    private ByteSource headerSource;

    private Braillo200DocumentHandler(int cellsPerLine, double sheetLength, int topMargin, int bottomMargin, int leftMargin, int rightMargin, boolean interpoint, boolean zfolding, int copies) {
        super(cellsPerLine, sheetLength, topMargin, bottomMargin, leftMargin, rightMargin, interpoint, copies);
        this.headerSource = ByteSource.wrap((byte[])String.format("\u001bS1\u001bJ0\u001bN0\u001bR0\u001bA%02d\u001bB%02d\u001bC%d\u001bH%d", (int)Math.ceil(sheetLength * 2.0), cellsPerLine, interpoint ? 1 : 0, zfolding ? 1 : 0).getBytes(Charsets.US_ASCII));
    }

    @Override
    protected ByteSource getHeader() {
        return this.headerSource;
    }

    public static class Builder {
        private int cellsPerLine = 40;
        private double sheetLength = 11.0;
        private int topMargin = 0;
        private int bottomMargin = 0;
        private int leftMargin = 0;
        private int rightMargin = 0;
        private boolean interpoint = false;
        private int copies = 1;
        private boolean zfolding;

        public Braillo200DocumentHandler build() {
            return new Braillo200DocumentHandler(this.cellsPerLine, this.sheetLength, this.topMargin, this.bottomMargin, this.leftMargin, this.rightMargin, this.interpoint, this.zfolding, this.copies);
        }

        public Builder setCellsperLine(int cellsPerLine) {
            Preconditions.checkArgument((10 <= cellsPerLine && cellsPerLine <= 42 ? 1 : 0) != 0);
            Preconditions.checkState((boolean)this.checkLine(cellsPerLine, this.leftMargin, this.rightMargin));
            this.cellsPerLine = cellsPerLine;
            return this;
        }

        public Builder setSheetLength(double inches) {
            Preconditions.checkArgument((3.5 < inches && inches <= 14.0 ? 1 : 0) != 0, (String)"Sheet length should be between 4 and 14 inches, given value is %d", (Object)inches);
            this.sheetLength = inches;
            return this;
        }

        public Builder setInterpoint(boolean interpoint) {
            this.interpoint = interpoint;
            return this;
        }

        public Builder setCopies(int copies) {
            Preconditions.checkArgument((copies > 0 ? 1 : 0) != 0);
            this.copies = copies;
            return this;
        }

        public Builder setLeftMargin(int leftMargin) {
            Preconditions.checkArgument((leftMargin >= 0 ? 1 : 0) != 0);
            Preconditions.checkState((boolean)this.checkLine(this.cellsPerLine, leftMargin, this.rightMargin));
            this.leftMargin = leftMargin;
            return this;
        }

        public Builder setTopMargin(int margin) {
            Preconditions.checkArgument((margin >= 0 ? 1 : 0) != 0);
            this.topMargin = margin;
            return this;
        }

        public Builder setBottomMargin(int bottomMargin) {
            Preconditions.checkArgument((bottomMargin >= 0 ? 1 : 0) != 0);
            this.bottomMargin = bottomMargin;
            return this;
        }

        public Builder setRightMargin(int rightMargin) {
            Preconditions.checkArgument((rightMargin >= 0 ? 1 : 0) != 0);
            Preconditions.checkState((boolean)this.checkLine(this.cellsPerLine, this.leftMargin, rightMargin));
            this.rightMargin = rightMargin;
            return this;
        }

        private boolean checkLine(int cellsPerLine, int leftMargin, int rightMargin) {
            return rightMargin + leftMargin < cellsPerLine;
        }

        public Builder setZFolding(boolean zfolding) {
            this.zfolding = zfolding;
            return this;
        }
    }
}

