/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.drivers.braillo;

import com.google.common.io.ByteSource;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;
import javax.print.attribute.IntegerSyntax;
import org.brailleblaster.libembosser.drivers.braillo.Braillo270DocumentHandler;
import org.brailleblaster.libembosser.drivers.utils.BaseTextEmbosser;
import org.brailleblaster.libembosser.drivers.utils.document.events.DocumentEvent;
import org.brailleblaster.libembosser.drivers.utils.document.filters.PageFilter;
import org.brailleblaster.libembosser.embossing.attribute.Copies;
import org.brailleblaster.libembosser.embossing.attribute.ObjectSyntax;
import org.brailleblaster.libembosser.embossing.attribute.PageRanges;
import org.brailleblaster.libembosser.embossing.attribute.PaperLayout;
import org.brailleblaster.libembosser.embossing.attribute.PaperMargins;
import org.brailleblaster.libembosser.embossing.attribute.PaperSize;
import org.brailleblaster.libembosser.spi.BrlCell;
import org.brailleblaster.libembosser.spi.EmbossingAttributeSet;
import org.brailleblaster.libembosser.spi.Layout;
import org.brailleblaster.libembosser.spi.Margins;
import org.brailleblaster.libembosser.spi.Rectangle;

public class Braillo270Embosser
extends BaseTextEmbosser {
    private boolean interpoint;
    private Braillo270DocumentHandler.Firmware firmware;

    Braillo270Embosser(String id, String model, Braillo270DocumentHandler.Firmware firmware, Rectangle maxPaper, Rectangle minPaper, boolean interpoint) {
        super(id, "Braillo", model, maxPaper, minPaper);
        this.firmware = firmware;
        this.interpoint = interpoint;
    }

    public boolean supportsInterpoint() {
        return this.interpoint;
    }

    protected Function<Iterator<DocumentEvent>, ByteSource> createHandler(EmbossingAttributeSet attributes) {
        boolean zfolding;
        BrlCell cell = BrlCell.NLS;
        Rectangle paperSize = Optional.ofNullable((PaperSize)attributes.get(PaperSize.class)).map(ObjectSyntax::getValue).orElse(org.brailleblaster.libembosser.spi.PaperSize.BRAILLE_11_5X11.getSize());
        Margins margins = Optional.ofNullable((PaperMargins)attributes.get(PaperMargins.class)).map(ObjectSyntax::getValue).orElse(Margins.NO_MARGINS);
        BigDecimal height = paperSize.getHeight();
        BigDecimal width = paperSize.getWidth();
        int leftMargin = Math.max(cell.getCellsForWidth(margins.getLeft()) - 5, 0);
        int rightMargin = 0;
        int topMargin = cell.getLinesForHeight(margins.getTop());
        int bottomMargin = cell.getLinesForHeight(margins.getBottom());
        int cellsPerLine = cell.getCellsForWidth(width.subtract(margins.getRight()));
        if (cellsPerLine > 42) {
            cellsPerLine = 42;
        } else if (cellsPerLine < 27) {
            rightMargin = 27 - cellsPerLine;
            cellsPerLine = 27;
        }
        Layout paperLayout = Optional.ofNullable((PaperLayout)attributes.get(PaperLayout.class)).map(ObjectSyntax::getValue).orElse(Layout.P1ONLY);
        switch (paperLayout) {
            case Z_FOLDING_DOUBLE_HORIZONTAL: 
            case Z_FOLDING_DOUBLE_VERTICAL: 
            case Z_FOLDING_SINGLE_HORIZONTAL: 
            case Z_FOLDING_SINGLE_VERTICAL: {
                zfolding = true;
                break;
            }
            default: {
                zfolding = false;
            }
        }
        int copies = Optional.ofNullable((Copies)attributes.get(Copies.class)).map(IntegerSyntax::getValue).orElse(1);
        Braillo270DocumentHandler handler = new Braillo270DocumentHandler.Builder(this.firmware).setCellsPerLine(cellsPerLine).setSheetlength(height.doubleValue() / 25.4).setLeftMargin(leftMargin).setTopMargin(topMargin).setRightMargin(rightMargin).setBottomMargin(bottomMargin).setZFolding(zfolding).setInterpoint(paperLayout.isDoubleSide()).setCopies(copies).build();
        PageRanges pages = Optional.ofNullable((PageRanges)attributes.get(PageRanges.class)).orElseGet(PageRanges::new);
        return new PageFilter(pages).andThen((Function)((Object)handler));
    }
}

