/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utils.swt;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u0018\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u0005H\u0016R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/brailleblaster/utils/swt/DebugStyledText;", "Lorg/eclipse/swt/custom/StyledText;", "parent", "Lorg/eclipse/swt/widgets/Composite;", "style", "", "<init>", "(Lorg/eclipse/swt/widgets/Composite;I)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLineAtOffset", "offset", "getLine", "", "lineIndex", "getText", "start", "end", "getTextRange", "length", "setSelection", "", "setSelectionRange", "setCaretOffset", "gui-utils"})
public final class DebugStyledText
extends StyledText {
    private final Logger logger = LoggerFactory.getLogger(DebugStyledText.class);

    public DebugStyledText(@Nullable Composite parent, int style) {
        super(parent, style);
    }

    public int getLineAtOffset(int offset) {
        int n;
        try {
            n = super.getLineAtOffset(offset);
        }
        catch (IllegalArgumentException e) {
            this.logger.error("Error whilst getting line for offset=" + offset, (Throwable)e);
            n = 0;
        }
        return n;
    }

    @NotNull
    public String getLine(int lineIndex) {
        String string;
        try {
            string = super.getLine(lineIndex);
            Intrinsics.checkNotNull((Object)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.logger.error("getLine cursor movement exception. lineIndex: " + lineIndex + " not found. charCount: " + this.getCharCount() + " lines: " + this.getLineCount() + ". returning empty string");
            string = "";
        }
        return string;
    }

    @NotNull
    public String getText(int start, int end) {
        String string;
        try {
            string = super.getText(start, end);
            Intrinsics.checkNotNull((Object)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.logger.error("getText cursor movement exception. start: " + start + " end: " + end + " charCount: " + this.getCharCount() + ". returning empty string");
            string = "";
        }
        return string;
    }

    @NotNull
    public String getTextRange(int start, int length) {
        String string;
        try {
            string = super.getTextRange(start, length);
            Intrinsics.checkNotNull((Object)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.logger.error("getTextRange cursor movement exception. start " + start + ": length: " + length + " charCount: " + this.getCharCount() + ". returning empty string");
            string = "";
        }
        return string;
    }

    public void setSelection(int start, int end) {
        try {
            super.setSelection(start, end);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.logger.error("setSelection cursor movement exception. start: " + start + " end: " + end + " charCount: " + this.getCharCount());
        }
    }

    public void setSelectionRange(int start, int length) {
        try {
            super.setSelectionRange(start, length);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.logger.error("setSelectionRange cursor movement exception. start: " + start + " length: " + length + " charCount: " + this.getCharCount());
        }
    }

    public void setCaretOffset(int offset) {
        try {
            super.setCaretOffset(offset);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.logger.error("setCaretOffset cursor movement exception. offset " + offset + " failed. charCount: " + this.getCharCount());
        }
    }
}

