/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.drivers.viewplus;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.awt.Color;
import java.awt.font.TextAttribute;
import java.util.Map;
import org.brailleblaster.libembosser.drivers.utils.DocumentToPrintableHandler;
import org.brailleblaster.libembosser.spi.BrlCell;

public class ViewPlusLayoutHelper
implements DocumentToPrintableHandler.InterpointLayoutHelper {
    private static final int[] CELL_OFFSETS = new int[]{1, 0, 1, 2, 0};
    private final Map<TextAttribute, Object> brailleAttributes = ImmutableMap.of((Object)TextAttribute.FAMILY, (Object)"Braille29", (Object)TextAttribute.SIZE, (Object)29, (Object)TextAttribute.FOREGROUND, (Object)new Color(6, 7, 8));

    public Map<TextAttribute, Object> getBrailleAttributes(BrlCell brailleCell) {
        return this.brailleAttributes;
    }

    public int getLineSpacing() {
        return 0;
    }

    public double calculateMargin(double desiredWidth) {
        Preconditions.checkArgument((desiredWidth >= 0.0 ? 1 : 0) != 0, (Object)"Desired width cannot be negative.");
        return (double)this.convertToWholeDots(desiredWidth) * 3.6;
    }

    private int convertToWholeDots(double desiredWidth) {
        return (int)Math.ceil(desiredWidth / 3.6);
    }

    public double calculateBackMargin(double desiredWidth, double frontMargin, double pageWidth) {
        int desiredDots = this.convertToWholeDots(desiredWidth);
        int marginOffset = (this.convertToWholeDots(pageWidth) - this.convertToWholeDots(frontMargin) - desiredDots) % 5;
        int cellOffset = CELL_OFFSETS[marginOffset];
        return (double)(desiredDots + cellOffset) * 3.6;
    }
}

