/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.drivers.enablingTechnologies;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import java.math.BigDecimal;
import java.util.Map;
import org.brailleblaster.libembosser.drivers.enablingTechnologies.Model;
import org.brailleblaster.libembosser.drivers.utils.document.ByteSourceHandlerToFunctionAdapter;
import org.brailleblaster.libembosser.drivers.utils.document.GenericTextDocumentHandler;
import org.brailleblaster.libembosser.drivers.utils.document.events.DocumentEvent;
import org.brailleblaster.libembosser.spi.BrlCell;
import org.brailleblaster.libembosser.spi.Layout;

public class EnablingTechnologiesDocumentHandler
implements ByteSourceHandlerToFunctionAdapter {
    private static final ImmutableMap<BrlCell, Byte> CELL_MAPPING = Maps.immutableEnumMap((Map)ImmutableMap.of((Object)BrlCell.NLS, (Object)64, (Object)BrlCell.CALIFORNIA_SIGN, (Object)65, (Object)BrlCell.JUMBO, (Object)66, (Object)BrlCell.ENHANCED_LINE_SPACING, (Object)67, (Object)BrlCell.MARBURG_MEDIUM, (Object)72));
    private static final ImmutableMap<Layout, Byte> DUPLEX_MAPPING = Maps.immutableEnumMap((Map)ImmutableMap.of((Object)Layout.INTERPOINT, (Object)64, (Object)Layout.P1ONLY, (Object)65, (Object)Layout.P2ONLY, (Object)66));
    private static final byte[] NUMBER_MAPPING = new byte[]{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123};
    private ByteSource headerSource;
    private GenericTextDocumentHandler handler;

    private static boolean isNumberArgValid(int value) {
        return value >= 0 && value < NUMBER_MAPPING.length;
    }

    private static void checkNumberArgument(int cellsPerLine) {
        Preconditions.checkArgument((boolean)EnablingTechnologiesDocumentHandler.isNumberArgValid(cellsPerLine), (String)"Argument not in valid range, must be between %s and %s but is %s", (Object)0, (Object)(NUMBER_MAPPING.length - 1), (Object)cellsPerLine);
    }

    public static ImmutableSet<Layout> supportedDuplexModes() {
        return DUPLEX_MAPPING.keySet();
    }

    public static ImmutableSet<BrlCell> supportedCellTypes() {
        return CELL_MAPPING.keySet();
    }

    private EnablingTechnologiesDocumentHandler(Model model, int leftMargin, int cellsPerLine, int topMargin, int pageLength, int linesPerPage, BrlCell cell2, Layout duplex2, int copies) {
        int totalLines = topMargin + linesPerPage;
        int totalCellsPerLine = leftMargin + cellsPerLine;
        int maxLines = cell2.getLinesForHeight(new BigDecimal(pageLength).multiply(new BigDecimal("25.4")));
        Preconditions.checkState((EnablingTechnologiesDocumentHandler.isNumberArgValid(totalLines) && totalLines <= maxLines ? 1 : 0) != 0, (String)"The sum of top margin and lines per page must be less than %s which is the maximum for page length %s, topMargin=%s, linesPerPage=%s, total=%s", (Object[])new Object[]{maxLines, pageLength, topMargin, linesPerPage, totalLines});
        this.handler = new GenericTextDocumentHandler.Builder().setLeftMargin(leftMargin).setCellsPerLine(cellsPerLine).setTopMargin(topMargin).setLinesPerPage(linesPerPage).setEndOfLine(model.getLineEnd()).setEndOfPage(model.getPageEnd()).setEopOnFullPage(false).setInterpoint(duplex2.isDoubleSide()).setCopies(copies).setFooter(model.getDocEnd()).padWithBlankLines(false).build();
        ByteArrayDataOutput headerOutput = ByteStreams.newDataOutput((int)100);
        headerOutput.write(new byte[]{27, 65, 64, 64});
        headerOutput.write(new byte[]{27, 75, 64});
        headerOutput.write(new byte[]{27, 87, 64});
        headerOutput.write(new byte[]{27, 105, (Byte)DUPLEX_MAPPING.get((Object)duplex2)});
        headerOutput.write(new byte[]{27, 115, (Byte)CELL_MAPPING.get((Object)cell2)});
        headerOutput.write(new byte[]{27, 76, 65});
        headerOutput.write(new byte[]{27, 82, NUMBER_MAPPING[totalCellsPerLine]});
        headerOutput.write(new byte[]{27, 84, NUMBER_MAPPING[pageLength]});
        headerOutput.write(new byte[]{27, 81, NUMBER_MAPPING[totalLines]});
        this.headerSource = ByteSource.wrap((byte[])headerOutput.toByteArray());
    }

    @Override
    public void onEvent(DocumentEvent event) {
        this.handler.onEvent(event);
    }

    @Override
    public ByteSource asByteSource() {
        return ByteSource.concat((ByteSource[])new ByteSource[]{this.headerSource, this.handler.asByteSource()});
    }

    public static class Builder {
        private int leftMargin = 0;
        private int cellsPerLine = 40;
        private int topMargin = 0;
        private int linesPerPage = 25;
        private int copies = 1;
        private int pageLength = 11;
        private Layout paperMode = Layout.INTERPOINT;
        private BrlCell cell = BrlCell.NLS;
        private final Model model;

        @Deprecated
        public Builder() {
            this(Model.PHOENIX_GOLD);
        }

        public Builder(Model model) {
            this.model = (Model)Preconditions.checkNotNull((Object)model);
        }

        public EnablingTechnologiesDocumentHandler build() {
            return new EnablingTechnologiesDocumentHandler(this.model, Math.min(this.leftMargin, this.model.getMaxCellsPerLine() - this.cellsPerLine), this.cellsPerLine, this.topMargin, this.pageLength, this.linesPerPage, this.cell, this.paperMode, this.copies);
        }

        public Builder setCopies(int copies) {
            this.copies = copies;
            return this;
        }

        public Builder setLeftMargin(int leftMargin) {
            Preconditions.checkArgument((leftMargin < this.model.getMaxCellsPerLine() ? 1 : 0) != 0, (String)"Too many cells, the margin must leave at least one cell for Braille. Maximum cells per line is %s", (int)this.model.getMaxCellsPerLine());
            this.leftMargin = leftMargin;
            return this;
        }

        public Builder setCellsPerLine(int cellsPerLine) {
            Preconditions.checkArgument((cellsPerLine <= this.model.getMaxCellsPerLine() ? 1 : 0) != 0, (String)"Too many cells per line, maximum cells per line is %s", (int)this.model.getMaxCellsPerLine());
            this.cellsPerLine = cellsPerLine;
            return this;
        }

        public Builder setLinesPerPage(int linesPerPage) {
            EnablingTechnologiesDocumentHandler.checkNumberArgument(linesPerPage);
            this.linesPerPage = linesPerPage;
            return this;
        }

        public Builder setTopMargin(int topMargin) {
            EnablingTechnologiesDocumentHandler.checkNumberArgument(topMargin);
            this.topMargin = topMargin;
            return this;
        }

        public Builder setPageLength(int inches) {
            EnablingTechnologiesDocumentHandler.checkNumberArgument(inches);
            this.pageLength = inches;
            return this;
        }

        public Builder setPapermode(Layout sides) {
            if (!DUPLEX_MAPPING.containsKey((Object)sides)) {
                throw new IllegalArgumentException("Side must be one of INTERPOINT, P1ONLY or P2ONLY but was " + sides);
            }
            this.paperMode = sides;
            return this;
        }

        public Builder setCell(BrlCell cell2) {
            if (!CELL_MAPPING.containsKey((Object)cell2)) {
                throw new IllegalArgumentException(String.format("Cell must be one of %s but was %s", String.join((CharSequence)", ", Iterables.transform((Iterable)CELL_MAPPING.keySet(), Enum::name)), cell2.name()));
            }
            this.cell = cell2;
            return this;
        }
    }
}

