/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.drivers.generic;

import com.google.common.io.ByteSource;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.print.attribute.Attribute;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.brailleblaster.libembosser.drivers.generic.GenericTextEmbosser;
import org.brailleblaster.libembosser.drivers.generic.GenericTextOptionIdentifier;
import org.brailleblaster.libembosser.drivers.utils.BaseTextEmbosser;
import org.brailleblaster.libembosser.drivers.utils.document.GenericTextDocumentHandler;
import org.brailleblaster.libembosser.drivers.utils.document.events.DocumentEvent;
import org.brailleblaster.libembosser.drivers.utils.document.filters.PageFilter;
import org.brailleblaster.libembosser.embossing.attribute.BrailleCellType;
import org.brailleblaster.libembosser.embossing.attribute.Copies;
import org.brailleblaster.libembosser.embossing.attribute.PageRanges;
import org.brailleblaster.libembosser.embossing.attribute.PaperLayout;
import org.brailleblaster.libembosser.embossing.attribute.PaperMargins;
import org.brailleblaster.libembosser.embossing.attribute.PaperSize;
import org.brailleblaster.libembosser.spi.BrlCell;
import org.brailleblaster.libembosser.spi.EmbosserOption;
import org.brailleblaster.libembosser.spi.EmbossingAttributeSet;
import org.brailleblaster.libembosser.spi.Margins;
import org.brailleblaster.libembosser.spi.OptionIdentifier;
import org.brailleblaster.libembosser.spi.Rectangle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bB/\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fBc\b\u0002\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0011\u001a\u00020\r\u0012\u0006\u0010\u0012\u001a\u00020\r\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0015J\"\u0010\u001a\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c\u0012\u0004\u0012\u00020\u001e0\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u001c\u0010!\u001a\u00020\u00002\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017H\u0016J\u0014\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0002J\b\u0010&\u001a\u00020\u000bH\u0016R\u000e\u0010\n\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/brailleblaster/libembosser/drivers/generic/GenericTextEmbosser;", "Lorg/brailleblaster/libembosser/drivers/utils/BaseTextEmbosser;", "manufacturer", "", "model", "maxPaper", "Lorg/brailleblaster/libembosser/spi/Rectangle;", "minPaper", "(Ljava/lang/String;Ljava/lang/String;Lorg/brailleblaster/libembosser/spi/Rectangle;Lorg/brailleblaster/libembosser/spi/Rectangle;)V", "id", "addMargins", "", "(Ljava/lang/String;Ljava/lang/String;Lorg/brailleblaster/libembosser/spi/Rectangle;Lorg/brailleblaster/libembosser/spi/Rectangle;Z)V", "Lorg/brailleblaster/libembosser/spi/EmbosserOption$BooleanOption;", "eol", "Lorg/brailleblaster/libembosser/spi/EmbosserOption$ByteArrayOption;", "eop", "padWithBlanks", "eopOnFullPage", "header", "footer", "(Ljava/lang/String;Ljava/lang/String;Lorg/brailleblaster/libembosser/spi/Rectangle;Lorg/brailleblaster/libembosser/spi/Rectangle;Lorg/brailleblaster/libembosser/spi/EmbosserOption$BooleanOption;Lorg/brailleblaster/libembosser/spi/EmbosserOption$ByteArrayOption;Lorg/brailleblaster/libembosser/spi/EmbosserOption$ByteArrayOption;Lorg/brailleblaster/libembosser/spi/EmbosserOption$BooleanOption;Lorg/brailleblaster/libembosser/spi/EmbosserOption$BooleanOption;Lorg/brailleblaster/libembosser/spi/EmbosserOption$ByteArrayOption;Lorg/brailleblaster/libembosser/spi/EmbosserOption$ByteArrayOption;)V", "options", "", "Lorg/brailleblaster/libembosser/spi/OptionIdentifier;", "Lorg/brailleblaster/libembosser/spi/EmbosserOption;", "createHandler", "Ljava/util/function/Function;", "", "Lorg/brailleblaster/libembosser/drivers/utils/document/events/DocumentEvent;", "Lcom/google/common/io/ByteSource;", "attributes", "Lorg/brailleblaster/libembosser/spi/EmbossingAttributeSet;", "customize", "getOptions", "getValidMargin", "Ljava/math/BigDecimal;", "margin", "supportsInterpoint", "libembosser-core-drivers"})
@SourceDebugExtension(value={"SMAP\nGenericTextEmbosser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenericTextEmbosser.kt\norg/brailleblaster/libembosser/drivers/generic/GenericTextEmbosser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
public final class GenericTextEmbosser
extends BaseTextEmbosser {
    @NotNull
    private final EmbosserOption.BooleanOption addMargins;
    @NotNull
    private final EmbosserOption.ByteArrayOption eol;
    @NotNull
    private final EmbosserOption.ByteArrayOption eop;
    @NotNull
    private final EmbosserOption.BooleanOption padWithBlanks;
    @NotNull
    private final EmbosserOption.BooleanOption eopOnFullPage;
    @NotNull
    private final EmbosserOption.ByteArrayOption header;
    @NotNull
    private final EmbosserOption.ByteArrayOption footer;
    @NotNull
    private final Map<OptionIdentifier, EmbosserOption> options;

    private GenericTextEmbosser(String id, String model, Rectangle maxPaper, Rectangle minPaper, EmbosserOption.BooleanOption addMargins, EmbosserOption.ByteArrayOption eol, EmbosserOption.ByteArrayOption eop, EmbosserOption.BooleanOption padWithBlanks, EmbosserOption.BooleanOption eopOnFullPage, EmbosserOption.ByteArrayOption header, EmbosserOption.ByteArrayOption footer) {
        super(id, "Generic", model, maxPaper, minPaper);
        this.addMargins = addMargins;
        this.eol = eol;
        this.eop = eop;
        this.padWithBlanks = padWithBlanks;
        this.eopOnFullPage = eopOnFullPage;
        this.header = header;
        this.footer = footer;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)GenericTextOptionIdentifier.ADD_MARGINS), (Object)this.addMargins), TuplesKt.to((Object)((Object)GenericTextOptionIdentifier.PAD_WITH_BLANKS), (Object)this.padWithBlanks), TuplesKt.to((Object)((Object)GenericTextOptionIdentifier.EOP_ON_FULL_PAGE), (Object)this.eopOnFullPage), TuplesKt.to((Object)((Object)GenericTextOptionIdentifier.EOL), (Object)this.eol), TuplesKt.to((Object)((Object)GenericTextOptionIdentifier.EOP), (Object)this.eop), TuplesKt.to((Object)((Object)GenericTextOptionIdentifier.HEADER), (Object)this.header), TuplesKt.to((Object)((Object)GenericTextOptionIdentifier.FOOTER), (Object)this.footer)};
        this.options = MapsKt.mapOf((Pair[])pairArray);
    }

    /* synthetic */ GenericTextEmbosser(String string, String string2, Rectangle rectangle, Rectangle rectangle2, EmbosserOption.BooleanOption booleanOption, EmbosserOption.ByteArrayOption byteArrayOption, EmbosserOption.ByteArrayOption byteArrayOption2, EmbosserOption.BooleanOption booleanOption2, EmbosserOption.BooleanOption booleanOption3, EmbosserOption.ByteArrayOption byteArrayOption3, EmbosserOption.ByteArrayOption byteArrayOption4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x200) != 0) {
            byteArrayOption3 = new EmbosserOption.ByteArrayOption(new byte[0]);
        }
        if ((n & 0x400) != 0) {
            byteArrayOption4 = new EmbosserOption.ByteArrayOption(new byte[0]);
        }
        this(string, string2, rectangle, rectangle2, booleanOption, byteArrayOption, byteArrayOption2, booleanOption2, booleanOption3, byteArrayOption3, byteArrayOption4);
    }

    public GenericTextEmbosser(@NotNull String manufacturer, @NotNull String model, @NotNull Rectangle maxPaper, @NotNull Rectangle minPaper) {
        Intrinsics.checkNotNullParameter((Object)manufacturer, (String)"manufacturer");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)maxPaper, (String)"maxPaper");
        Intrinsics.checkNotNullParameter((Object)minPaper, (String)"minPaper");
        this(manufacturer, model, maxPaper, minPaper, false);
    }

    public GenericTextEmbosser(@NotNull String id, @NotNull String model, @NotNull Rectangle maxPaper, @NotNull Rectangle minPaper, boolean addMargins) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)maxPaper, (String)"maxPaper");
        Intrinsics.checkNotNullParameter((Object)minPaper, (String)"minPaper");
        byte[] byArray = new byte[]{13, 10};
        EmbosserOption.ByteArrayOption byteArrayOption = new EmbosserOption.ByteArrayOption(byArray);
        byArray = new byte[]{12};
        this(id, model, maxPaper, minPaper, new EmbosserOption.BooleanOption(addMargins), byteArrayOption, new EmbosserOption.ByteArrayOption(byArray), new EmbosserOption.BooleanOption(false), new EmbosserOption.BooleanOption(true), null, null, 1536, null);
    }

    @NotNull
    public Map<OptionIdentifier, EmbosserOption> getOptions() {
        return this.options;
    }

    @NotNull
    public GenericTextEmbosser customize(@NotNull Map<OptionIdentifier, ? extends EmbosserOption> options) {
        EmbosserOption embosserOption;
        EmbosserOption.ByteArrayOption byteArrayOption;
        EmbosserOption.ByteArrayOption header;
        EmbosserOption embosserOption2;
        EmbosserOption.ByteArrayOption byteArrayOption2;
        EmbosserOption.ByteArrayOption eop;
        EmbosserOption embosserOption3;
        EmbosserOption.ByteArrayOption byteArrayOption3;
        EmbosserOption.ByteArrayOption eol;
        EmbosserOption embosserOption4;
        EmbosserOption.ByteArrayOption byteArrayOption4;
        EmbosserOption.BooleanOption eopOnFullPage;
        EmbosserOption embosserOption5;
        EmbosserOption.BooleanOption booleanOption;
        EmbosserOption.BooleanOption padWithBlanks;
        EmbosserOption embosserOption6;
        EmbosserOption.BooleanOption booleanOption2;
        EmbosserOption.BooleanOption addMargins;
        Intrinsics.checkNotNullParameter(options, (String)"options");
        EmbosserOption embosserOption7 = options.get((Object)GenericTextOptionIdentifier.ADD_MARGINS);
        EmbosserOption.BooleanOption booleanOption3 = embosserOption7 instanceof EmbosserOption.BooleanOption ? (EmbosserOption.BooleanOption)embosserOption7 : null;
        if (booleanOption3 == null) {
            booleanOption3 = addMargins = this.addMargins;
        }
        if ((booleanOption2 = (embosserOption6 = options.get((Object)GenericTextOptionIdentifier.PAD_WITH_BLANKS)) instanceof EmbosserOption.BooleanOption ? (EmbosserOption.BooleanOption)embosserOption6 : null) == null) {
            booleanOption2 = padWithBlanks = this.padWithBlanks;
        }
        if ((booleanOption = (embosserOption5 = options.get((Object)GenericTextOptionIdentifier.EOP_ON_FULL_PAGE)) instanceof EmbosserOption.BooleanOption ? (EmbosserOption.BooleanOption)embosserOption5 : null) == null) {
            booleanOption = eopOnFullPage = this.eopOnFullPage;
        }
        if ((byteArrayOption4 = (embosserOption4 = options.get((Object)GenericTextOptionIdentifier.EOL)) instanceof EmbosserOption.ByteArrayOption ? (EmbosserOption.ByteArrayOption)embosserOption4 : null) == null) {
            byteArrayOption4 = eol = this.eol;
        }
        if ((byteArrayOption3 = (embosserOption3 = options.get((Object)GenericTextOptionIdentifier.EOP)) instanceof EmbosserOption.ByteArrayOption ? (EmbosserOption.ByteArrayOption)embosserOption3 : null) == null) {
            byteArrayOption3 = eop = this.eop;
        }
        if ((byteArrayOption2 = (embosserOption2 = options.get((Object)GenericTextOptionIdentifier.HEADER)) instanceof EmbosserOption.ByteArrayOption ? (EmbosserOption.ByteArrayOption)embosserOption2 : null) == null) {
            byteArrayOption2 = header = this.header;
        }
        if ((byteArrayOption = (embosserOption = options.get((Object)GenericTextOptionIdentifier.FOOTER)) instanceof EmbosserOption.ByteArrayOption ? (EmbosserOption.ByteArrayOption)embosserOption : null) == null) {
            byteArrayOption = this.footer;
        }
        EmbosserOption.ByteArrayOption footer = byteArrayOption;
        return new GenericTextEmbosser(this.getId(), this.getModel(), this.getMaximumPaper(), this.getMinimumPaper(), addMargins, eol, eop, padWithBlanks, eopOnFullPage, header, footer);
    }

    @Override
    @NotNull
    protected Function<Iterator<DocumentEvent>, ByteSource> createHandler(@NotNull EmbossingAttributeSet attributes) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        BrlCell cell2 = Optional.ofNullable(attributes.get(BrailleCellType.class)).map(arg_0 -> GenericTextEmbosser.createHandler$lambda$0(createHandler.cell.1.INSTANCE, arg_0)).orElse(BrlCell.NLS);
        Rectangle paper2 = Optional.ofNullable(attributes.get(PaperSize.class)).map(arg_0 -> GenericTextEmbosser.createHandler$lambda$1(createHandler.paper.1.INSTANCE, arg_0)).orElse(this.getMaximumPaper());
        Margins margins2 = Optional.ofNullable(attributes.get(PaperMargins.class)).map(arg_0 -> GenericTextEmbosser.createHandler$lambda$2(createHandler.margins.1.INSTANCE, arg_0)).orElse(Margins.NO_MARGINS);
        BigDecimal bigDecimal = margins2.getLeft();
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"margins.left");
        BigDecimal leftMargin = this.getValidMargin(bigDecimal);
        BigDecimal bigDecimal2 = margins2.getRight();
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"margins.right");
        BigDecimal rightMargin = this.getValidMargin(bigDecimal2);
        BigDecimal bigDecimal3 = margins2.getTop();
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"margins.top");
        BigDecimal topMargin = this.getValidMargin(bigDecimal3);
        BigDecimal bigDecimal4 = margins2.getBottom();
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"margins.bottom");
        BigDecimal bottomMargin = this.getValidMargin(bigDecimal4);
        int cellsPerLine = cell2.getCellsForWidth(paper2.getWidth().subtract(leftMargin).subtract(rightMargin));
        int linesPerPage = cell2.getLinesForHeight(paper2.getHeight().subtract(topMargin).subtract(bottomMargin));
        int topMarginCells = 0;
        int leftMarginCells = 0;
        if (this.addMargins.getBoolean()) {
            topMarginCells = cell2.getLinesForHeight(topMargin);
            leftMarginCells = cell2.getCellsForWidth(leftMargin);
        }
        GenericTextDocumentHandler.Builder builder = new GenericTextDocumentHandler.Builder();
        builder.setTopMargin(topMarginCells).setLeftMargin(leftMarginCells).setCellsPerLine(cellsPerLine).setLinesPerPage(linesPerPage);
        Attribute attribute = attributes.get(Copies.class);
        if (attribute != null) {
            Attribute it = attribute;
            boolean bl = false;
            builder.setCopies(((Copies)it).getValue());
        }
        builder.setInterpoint(Optional.ofNullable(attributes.get(PaperLayout.class)).filter(arg_0 -> GenericTextEmbosser.createHandler$lambda$4(createHandler.2.INSTANCE, arg_0)).isPresent()).setEopOnFullPage(this.eopOnFullPage.getBoolean()).setEndOfPage(this.eop.getBytes()).setEndOfLine(this.eol.getBytes()).padWithBlankLines(this.padWithBlanks.getBoolean()).setHeader(this.header.getBytes()).setFooter(this.footer.getBytes());
        GenericTextDocumentHandler handler = builder.build();
        PageRanges pages = Optional.ofNullable((PageRanges)attributes.get(PageRanges.class)).orElseGet(GenericTextEmbosser::createHandler$lambda$5);
        Function<Iterator<DocumentEvent>, ByteSource> function = new PageFilter(pages).andThen(handler);
        Intrinsics.checkNotNullExpressionValue(function, (String)"PageFilter(pages).andThen(handler)");
        return function;
    }

    public boolean supportsInterpoint() {
        return false;
    }

    private final BigDecimal getValidMargin(BigDecimal margin) {
        BigDecimal bigDecimal;
        if (BigDecimal.ZERO.compareTo(margin) < 0) {
            bigDecimal = margin;
        } else {
            BigDecimal bigDecimal2 = BigDecimal.ZERO;
            bigDecimal = bigDecimal2;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"ZERO");
        }
        return bigDecimal;
    }

    private static final BrlCell createHandler$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BrlCell)$tmp0.invoke(p0);
    }

    private static final Rectangle createHandler$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Rectangle)$tmp0.invoke(p0);
    }

    private static final Margins createHandler$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Margins)$tmp0.invoke(p0);
    }

    private static final boolean createHandler$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final PageRanges createHandler$lambda$5() {
        return new PageRanges();
    }
}

