/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.drivers.utils;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.StreamPrintServiceFactory;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.libembosser.drivers.utils.DocumentHandler;
import org.brailleblaster.libembosser.drivers.utils.DocumentParser;
import org.brailleblaster.libembosser.drivers.utils.ThrowingBiConsumer;
import org.brailleblaster.libembosser.drivers.utils.document.events.DocumentEvent;
import org.brailleblaster.libembosser.spi.EmbossException;
import org.brailleblaster.libembosser.spi.Embosser;
import org.brailleblaster.libembosser.spi.EmbossingAttributeSet;
import org.brailleblaster.libembosser.spi.Rectangle;
import org.brailleblaster.libembosser.utils.EmbossToStreamPrintServiceFactory;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 02\u00020\u0001:\u00010B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\"\u0010\u000e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\u0004\u0012\u00020\u00120\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H$JW\u0010\u0015\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u0002H\u00162\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001b2\u0018\u0010\u001e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\u0004\u0012\u00020\u00120\u000fH\u0004\u00a2\u0006\u0002\u0010\u001fJ \u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010$\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010'\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010(\u001a\u00020#H\u0004J\b\u0010)\u001a\u00020\u0003H\u0016J\b\u0010*\u001a\u00020\u0003H\u0016J\b\u0010+\u001a\u00020\u0007H\u0016J\b\u0010,\u001a\u00020\u0007H\u0016J\b\u0010-\u001a\u00020\u0003H\u0016J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020\r0/H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/brailleblaster/libembosser/drivers/utils/BaseTextEmbosser;", "Lorg/brailleblaster/libembosser/spi/Embosser;", "id", "", "manufacturer", "model", "maximumPaper", "Lorg/brailleblaster/libembosser/spi/Rectangle;", "minimumPaper", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/brailleblaster/libembosser/spi/Rectangle;Lorg/brailleblaster/libembosser/spi/Rectangle;)V", "jobFinished", "", "streamPrintServiceFactory", "Ljavax/print/StreamPrintServiceFactory;", "createHandler", "Ljava/util/function/Function;", "", "Lorg/brailleblaster/libembosser/drivers/utils/document/events/DocumentEvent;", "Lcom/google/common/io/ByteSource;", "attributes", "Lorg/brailleblaster/libembosser/spi/EmbossingAttributeSet;", "emboss", "T", "embosserDevice", "Ljavax/print/PrintService;", "input", "parseMethod", "Lorg/brailleblaster/libembosser/drivers/utils/ThrowingBiConsumer;", "Lorg/brailleblaster/libembosser/drivers/utils/DocumentHandler;", "Lorg/brailleblaster/libembosser/drivers/utils/DocumentParser$ParseException;", "handler", "(Ljavax/print/PrintService;Ljava/lang/Object;Lorg/brailleblaster/libembosser/drivers/utils/ThrowingBiConsumer;Ljava/util/function/Function;)Z", "embossBrf", "", "brf", "Ljava/io/InputStream;", "embossPef", "pef", "Lorg/w3c/dom/Document;", "embossStream", "is", "getId", "getManufacturer", "getMaximumPaper", "getMinimumPaper", "getModel", "getStreamPrintServiceFactory", "Ljava/util/Optional;", "Companion", "libembosser-core-drivers"})
public abstract class BaseTextEmbosser
implements Embosser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final String manufacturer;
    @NotNull
    private final String model;
    @NotNull
    private final Rectangle maximumPaper;
    @NotNull
    private final Rectangle minimumPaper;
    @NotNull
    private final StreamPrintServiceFactory streamPrintServiceFactory;
    private boolean jobFinished;
    public static final byte ESC = 27;

    public BaseTextEmbosser(@NotNull String id, @NotNull String manufacturer, @NotNull String model, @NotNull Rectangle maximumPaper, @NotNull Rectangle minimumPaper) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)manufacturer, (String)"manufacturer");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)maximumPaper, (String)"maximumPaper");
        Intrinsics.checkNotNullParameter((Object)minimumPaper, (String)"minimumPaper");
        this.id = id;
        this.manufacturer = manufacturer;
        this.model = model;
        this.maximumPaper = maximumPaper;
        this.minimumPaper = minimumPaper;
        this.streamPrintServiceFactory = (StreamPrintServiceFactory)new EmbossToStreamPrintServiceFactory();
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getManufacturer() {
        return this.manufacturer;
    }

    @NotNull
    public String getModel() {
        return this.model;
    }

    @NotNull
    public Rectangle getMaximumPaper() {
        return this.maximumPaper;
    }

    @NotNull
    public Rectangle getMinimumPaper() {
        return this.minimumPaper;
    }

    @NotNull
    protected abstract Function<Iterator<DocumentEvent>, ByteSource> createHandler(@NotNull EmbossingAttributeSet var1);

    public void embossPef(@NotNull PrintService embosserDevice, @NotNull Document pef, @NotNull EmbossingAttributeSet attributes) throws EmbossException {
        Intrinsics.checkNotNullParameter((Object)embosserDevice, (String)"embosserDevice");
        Intrinsics.checkNotNullParameter((Object)pef, (String)"pef");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        DocumentParser parser = new DocumentParser();
        this.emboss(embosserDevice, pef, (arg_0, arg_1) -> BaseTextEmbosser.embossPef$lambda$0(parser, arg_0, arg_1), this.createHandler(attributes));
    }

    public void embossBrf(@NotNull PrintService embosserDevice, @NotNull InputStream brf, @NotNull EmbossingAttributeSet attributes) throws EmbossException {
        Intrinsics.checkNotNullParameter((Object)embosserDevice, (String)"embosserDevice");
        Intrinsics.checkNotNullParameter((Object)brf, (String)"brf");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        DocumentParser parser = new DocumentParser();
        this.emboss(embosserDevice, brf, (arg_0, arg_1) -> BaseTextEmbosser.embossBrf$lambda$1(parser, arg_0, arg_1), this.createHandler(attributes));
    }

    protected final <T> boolean emboss(@NotNull PrintService embosserDevice, T input, @NotNull ThrowingBiConsumer<T, DocumentHandler, DocumentParser.ParseException> parseMethod, @NotNull Function<Iterator<DocumentEvent>, ByteSource> handler) throws EmbossException {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)embosserDevice, (String)"embosserDevice");
        Intrinsics.checkNotNullParameter(parseMethod, (String)"parseMethod");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        List events = new LinkedList();
        try {
            parseMethod.accept(input, arg_0 -> BaseTextEmbosser.emboss$lambda$2(events, arg_0));
        }
        catch (DocumentParser.ParseException e) {
            throw new EmbossException((Throwable)e);
        }
        try {
            InputStream inputStream2 = handler.apply(events.iterator()).openStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"{\n            handler.ap\u2026)).openStream()\n        }");
            inputStream = inputStream2;
        }
        catch (IOException e) {
            throw new EmbossException((Throwable)e);
        }
        InputStream embosserStream = inputStream;
        return this.embossStream(embosserDevice, embosserStream);
    }

    protected final boolean embossStream(@NotNull PrintService embosserDevice, @NotNull InputStream is) throws EmbossException {
        Intrinsics.checkNotNullParameter((Object)embosserDevice, (String)"embosserDevice");
        Intrinsics.checkNotNullParameter((Object)is, (String)"is");
        Doc doc = new SimpleDoc(is, DocFlavor.INPUT_STREAM.AUTOSENSE, null);
        DocPrintJob dpj = embosserDevice.createPrintJob();
        try {
            dpj.print(doc, null);
        }
        catch (PrintException e) {
            throw new EmbossException("Problem sending document to printer device", (Throwable)e);
        }
        dpj.addPrintJobListener(new PrintJobListener(this){
            final /* synthetic */ BaseTextEmbosser this$0;
            {
                this.this$0 = $receiver;
            }

            public void printJobRequiresAttention(@NotNull PrintJobEvent pje) {
                Intrinsics.checkNotNullParameter((Object)pje, (String)"pje");
                BaseTextEmbosser.access$setJobFinished$p(this.this$0, false);
            }

            public void printJobNoMoreEvents(@NotNull PrintJobEvent pje) {
                Intrinsics.checkNotNullParameter((Object)pje, (String)"pje");
                BaseTextEmbosser.access$setJobFinished$p(this.this$0, true);
            }

            public void printJobFailed(@NotNull PrintJobEvent pje) {
                Intrinsics.checkNotNullParameter((Object)pje, (String)"pje");
                BaseTextEmbosser.access$setJobFinished$p(this.this$0, true);
            }

            public void printJobCompleted(@NotNull PrintJobEvent pje) {
                Intrinsics.checkNotNullParameter((Object)pje, (String)"pje");
                BaseTextEmbosser.access$setJobFinished$p(this.this$0, true);
            }

            public void printJobCanceled(@NotNull PrintJobEvent pje) {
                Intrinsics.checkNotNullParameter((Object)pje, (String)"pje");
                BaseTextEmbosser.access$setJobFinished$p(this.this$0, true);
            }

            public void printDataTransferCompleted(@NotNull PrintJobEvent pje) {
                Intrinsics.checkNotNullParameter((Object)pje, (String)"pje");
                BaseTextEmbosser.access$setJobFinished$p(this.this$0, true);
            }
        });
        return this.jobFinished;
    }

    @NotNull
    public Optional<StreamPrintServiceFactory> getStreamPrintServiceFactory() {
        Optional<StreamPrintServiceFactory> optional = Optional.of(this.streamPrintServiceFactory);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(streamPrintServiceFactory)");
        return optional;
    }

    private static final void embossPef$lambda$0(DocumentParser $parser, Document inputDoc, DocumentHandler handler) {
        Intrinsics.checkNotNullParameter((Object)$parser, (String)"$parser");
        Intrinsics.checkNotNullParameter((Object)inputDoc, (String)"inputDoc");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        $parser.parsePef(inputDoc, handler);
    }

    private static final void embossBrf$lambda$1(DocumentParser $parser, InputStream input, DocumentHandler handler) {
        Intrinsics.checkNotNullParameter((Object)$parser, (String)"$parser");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        $parser.parseBrf(input, handler);
    }

    private static final void emboss$lambda$2(List $events, DocumentEvent e) {
        Intrinsics.checkNotNullParameter((Object)$events, (String)"$events");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        $events.add(e);
    }

    public static final /* synthetic */ void access$setJobFinished$p(BaseTextEmbosser $this, boolean bl) {
        $this.jobFinished = bl;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/brailleblaster/libembosser/drivers/utils/BaseTextEmbosser$Companion;", "", "()V", "ESC", "", "libembosser-core-drivers"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

