/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.drivers.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.util.Map;
import org.brailleblaster.libembosser.drivers.generic.GenericGraphicsEmbosser;
import org.brailleblaster.libembosser.drivers.utils.DocumentToPrintableHandler;
import org.brailleblaster.libembosser.spi.BrlCell;

public class DefaultLayoutHelper
implements DocumentToPrintableHandler.LayoutHelper {
    private final Map<TextAttribute, Object> brailleAttributes;

    public DefaultLayoutHelper() {
        Font baseFont;
        try {
            baseFont = Font.createFont(0, GenericGraphicsEmbosser.class.getResourceAsStream("/org/brailleblaster/libembosser/drivers/fonts/APH_Braille_Font-6.otf"));
        }
        catch (FontFormatException | IOException e) {
            throw new RuntimeException("Problem creating font, should not occur", e);
        }
        Font font = baseFont.deriveFont(24.0f);
        this.brailleAttributes = ImmutableMap.of((Object)TextAttribute.FONT, (Object)font);
    }

    @Override
    public Map<TextAttribute, Object> getBrailleAttributes(BrlCell brailleCell) {
        return this.brailleAttributes;
    }

    @Override
    public int getLineSpacing() {
        return 3;
    }

    @Override
    public double calculateMargin(double desiredWidth) {
        Preconditions.checkArgument((desiredWidth >= 0.0 ? 1 : 0) != 0, (Object)"Desired width must not be negative.");
        return desiredWidth;
    }
}

