/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.drivers.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.TextAttribute;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.text.AttributedString;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.brailleblaster.libembosser.drivers.utils.ClassUtils;
import org.brailleblaster.libembosser.drivers.utils.DefaultLayoutHelper;
import org.brailleblaster.libembosser.drivers.utils.DocumentHandler;
import org.brailleblaster.libembosser.drivers.utils.document.events.BrailleEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.DocumentEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.EndDocumentEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.EndGraphicEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.EndLineEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.EndPageEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.EndSectionEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.EndVolumeEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.GraphicOption;
import org.brailleblaster.libembosser.drivers.utils.document.events.Option;
import org.brailleblaster.libembosser.drivers.utils.document.events.RowGap;
import org.brailleblaster.libembosser.drivers.utils.document.events.StartDocumentEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.StartGraphicEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.StartLineEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.StartPageEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.StartSectionEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.StartVolumeEvent;
import org.brailleblaster.libembosser.spi.BrlCell;
import org.brailleblaster.libembosser.utils.ImageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentToPrintableHandler
implements DocumentHandler,
Function<Iterator<DocumentEvent>, Printable> {
    private static final Logger log = LoggerFactory.getLogger(DocumentToPrintableHandler.class);
    private Deque<HandlerStates> stateStack = new LinkedList<HandlerStates>();
    private final Deque<Set<? extends Option>> optionStack = new LinkedList<Set<? extends Option>>();
    private int graphicHeight = 0;
    private List<Page> pages = new LinkedList<Page>();
    private List<PageElement> pageElements = new LinkedList<PageElement>();
    private StringBuilder braille = new StringBuilder();
    private final LayoutHelper layoutHelper;
    private final boolean duplex;

    private static void throwInvalidStateException(DocumentEvent event, String state) {
        throw new IllegalStateException(String.format("Invalid event %s for state %s", event.getClass().getName(), state));
    }

    private DocumentToPrintableHandler(LayoutHelper layoutHelper, boolean duplex2) {
        this.layoutHelper = layoutHelper;
        this.duplex = duplex2;
        this.stateStack.push(HandlerStates.READY);
    }

    @Override
    public void onEvent(DocumentEvent event) {
        this.stateStack.peek().accept(this, event);
    }

    public Printable asPrintable() {
        return new DocPrintable(this.pages.stream(), this.layoutHelper);
    }

    int getpageCount() {
        return this.pages.size();
    }

    Page getPage(int index) {
        return this.pages.get(index);
    }

    private void startDocument(StartDocumentEvent event) {
        this.stateStack.push(HandlerStates.DOCUMENT);
        this.optionStack.clear();
        this.optionStack.push(event.getOptions());
        this.pages.clear();
    }

    private void startVolume(StartVolumeEvent event) {
        this.stateStack.push(HandlerStates.VOLUME);
        this.optionStack.push(event.getOptions());
        if (this.duplex && this.getpageCount() % 2 != 0) {
            this.pages.add(new Page());
        }
    }

    private void startPage(StartPageEvent event) {
        this.stateStack.push(HandlerStates.PAGE);
        this.optionStack.push(event.getOptions());
        this.pageElements.clear();
    }

    private void endPage(EndPageEvent event) {
        this.pages.add(new Page(this.pageElements.stream()));
        this.optionStack.pop();
        this.stateStack.pop();
    }

    private void startLine(StartLineEvent event) {
        this.stateStack.push(HandlerStates.LINE);
        this.optionStack.push(event.getOptions());
        if (!this.isInGraphic()) {
            this.braille.delete(0, this.braille.length());
        }
    }

    private void addBraille(BrailleEvent event) {
        if (!this.isInGraphic()) {
            this.braille.append(event.getBraille());
        }
    }

    private void endLine() {
        int rowgap = this.optionStack.parallelStream().flatMap(Collection::stream).filter(o -> o instanceof RowGap).mapToInt(o -> (Integer)((RowGap)o).getValue()).findFirst().orElse(0);
        if (this.isInGraphic()) {
            this.graphicHeight += rowgap + 1;
        } else {
            this.pageElements.add(new Row(this.braille.toString(), rowgap));
        }
        this.optionStack.pop();
        this.stateStack.pop();
    }

    private void startGraphic(StartGraphicEvent event) {
        this.graphicHeight = 0;
        this.stateStack.push(HandlerStates.GRAPHIC);
        this.optionStack.push(event.getOptions());
    }

    private void endGraphic() {
        Optional<Image> graphic = this.optionStack.peek().stream().filter(o -> o instanceof GraphicOption.ImageData).map(o -> (Image)((GraphicOption.ImageData)o).getValue()).findFirst();
        if (graphic.isPresent()) {
            int indent2 = this.optionStack.peek().stream().filter(o -> o instanceof GraphicOption.Indent).mapToInt(o -> (Integer)((GraphicOption.Indent)o).getValue()).findFirst().orElse(0);
            int height2 = this.optionStack.peek().stream().filter(o -> o instanceof GraphicOption.Height).mapToInt(o -> (Integer)((GraphicOption.Height)o).getValue()).findFirst().orElse(this.graphicHeight);
            int width2 = this.optionStack.peek().stream().filter(o -> o instanceof GraphicOption.Width).mapToInt(o -> (Integer)((GraphicOption.Width)o).getValue()).findFirst().orElse(0);
            this.pageElements.add(new Graphic(graphic.get(), width2, height2, indent2));
        }
        this.optionStack.pop();
        this.stateStack.pop();
    }

    private boolean isInGraphic() {
        return this.optionStack.stream().flatMap(Collection::stream).anyMatch(o -> o instanceof GraphicOption.ImageData);
    }

    @Override
    public Printable apply(Iterator<DocumentEvent> doc) {
        while (doc.hasNext()) {
            this.onEvent(doc.next());
        }
        return this.asPrintable();
    }

    private static enum HandlerStates {
        READY{

            @Override
            void accept(DocumentToPrintableHandler h, DocumentEvent e) {
                if (e instanceof StartDocumentEvent) {
                    h.startDocument((StartDocumentEvent)e);
                } else {
                    DocumentToPrintableHandler.throwInvalidStateException(e, "READY");
                }
            }
        }
        ,
        DOCUMENT{

            @Override
            void accept(DocumentToPrintableHandler h, DocumentEvent e) {
                if (e instanceof StartVolumeEvent) {
                    h.startVolume((StartVolumeEvent)e);
                } else if (e instanceof EndDocumentEvent) {
                    h.optionStack.pop();
                    h.stateStack.pop();
                } else if (ClassUtils.isInstanceOf((Object)e, StartDocumentEvent.class, StartSectionEvent.class, StartPageEvent.class, StartLineEvent.class, BrailleEvent.class, EndLineEvent.class, StartGraphicEvent.class, EndGraphicEvent.class, EndPageEvent.class, EndSectionEvent.class, EndVolumeEvent.class)) {
                    DocumentToPrintableHandler.throwInvalidStateException(e, "DOCUMENT");
                }
            }
        }
        ,
        VOLUME{

            @Override
            void accept(DocumentToPrintableHandler h, DocumentEvent e) {
                if (e instanceof StartSectionEvent) {
                    h.stateStack.push(SECTION);
                    h.optionStack.push(((StartSectionEvent)e).getOptions());
                } else if (e instanceof EndVolumeEvent) {
                    h.optionStack.pop();
                    h.stateStack.pop();
                } else if (ClassUtils.isInstanceOf((Object)e, StartDocumentEvent.class, StartVolumeEvent.class, StartPageEvent.class, StartLineEvent.class, BrailleEvent.class, EndLineEvent.class, StartGraphicEvent.class, EndGraphicEvent.class, EndPageEvent.class, EndSectionEvent.class, EndDocumentEvent.class)) {
                    DocumentToPrintableHandler.throwInvalidStateException(e, "VOLUME");
                }
            }
        }
        ,
        SECTION{

            @Override
            void accept(DocumentToPrintableHandler h, DocumentEvent e) {
                if (e instanceof StartPageEvent) {
                    h.startPage((StartPageEvent)e);
                } else if (e instanceof EndSectionEvent) {
                    h.optionStack.pop();
                    h.stateStack.pop();
                } else if (ClassUtils.isInstanceOf((Object)e, StartDocumentEvent.class, StartVolumeEvent.class, StartSectionEvent.class, StartLineEvent.class, BrailleEvent.class, EndLineEvent.class, StartGraphicEvent.class, EndGraphicEvent.class, EndPageEvent.class, EndVolumeEvent.class, EndDocumentEvent.class)) {
                    DocumentToPrintableHandler.throwInvalidStateException(e, "SECTION");
                }
            }
        }
        ,
        PAGE{

            @Override
            void accept(DocumentToPrintableHandler h, DocumentEvent e) {
                if (e instanceof StartLineEvent) {
                    h.startLine((StartLineEvent)e);
                } else if (e instanceof StartGraphicEvent) {
                    h.startGraphic((StartGraphicEvent)e);
                } else if (e instanceof EndPageEvent) {
                    h.endPage((EndPageEvent)e);
                } else if (ClassUtils.isInstanceOf((Object)e, StartDocumentEvent.class, StartVolumeEvent.class, StartSectionEvent.class, StartPageEvent.class, BrailleEvent.class, EndLineEvent.class, EndGraphicEvent.class, EndSectionEvent.class, EndVolumeEvent.class, EndDocumentEvent.class)) {
                    DocumentToPrintableHandler.throwInvalidStateException(e, "PAGE");
                }
            }
        }
        ,
        GRAPHIC{

            @Override
            void accept(DocumentToPrintableHandler h, DocumentEvent e) {
                if (e instanceof StartLineEvent) {
                    h.startLine((StartLineEvent)e);
                } else if (e instanceof EndGraphicEvent) {
                    h.endGraphic();
                } else {
                    DocumentToPrintableHandler.throwInvalidStateException(e, "GRAPHIC");
                }
            }
        }
        ,
        LINE{

            @Override
            void accept(DocumentToPrintableHandler h, DocumentEvent e) {
                if (e instanceof BrailleEvent) {
                    h.addBraille((BrailleEvent)e);
                } else if (e instanceof EndLineEvent) {
                    h.endLine();
                } else if (ClassUtils.isInstanceOf((Object)e, StartDocumentEvent.class, StartVolumeEvent.class, StartSectionEvent.class, StartPageEvent.class, StartLineEvent.class, StartGraphicEvent.class, EndGraphicEvent.class, EndPageEvent.class, EndSectionEvent.class, EndVolumeEvent.class, EndDocumentEvent.class)) {
                    DocumentToPrintableHandler.throwInvalidStateException(e, "LINE");
                }
            }
        };


        abstract void accept(DocumentToPrintableHandler var1, DocumentEvent var2);
    }

    private static class DocPrintable
    implements Printable {
        private final List<Page> pages;
        private final LayoutHelper layoutHelper;

        public DocPrintable(Stream<Page> pages, LayoutHelper layoutHelper) {
            this.pages = (List)pages.collect(ImmutableList.toImmutableList());
            this.layoutHelper = layoutHelper;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            if (pageIndex < 0 || pageIndex >= this.pages.size()) {
                return 1;
            }
            Map<TextAttribute, Object> brailleAttributes = this.layoutHelper.getBrailleAttributes(BrlCell.NLS);
            Font font = Font.getFont(brailleAttributes);
            Graphics2D g2d = (Graphics2D)graphics;
            double desiredMargin = pageFormat.getImageableX();
            FontMetrics brailleMetrics = g2d.getFontMetrics(font);
            Page curPage = this.pages.get(pageIndex);
            double xPos = 0.0;
            double yPos = (double)brailleMetrics.getAscent() + pageFormat.getImageableY();
            double lineHeight = brailleMetrics.getHeight() + this.layoutHelper.getLineSpacing();
            double cellWidth = brailleMetrics.charWidth('\u2800');
            if (this.layoutHelper instanceof InterpointLayoutHelper && pageIndex % 2 == 1) {
                xPos = ((InterpointLayoutHelper)this.layoutHelper).calculateBackMargin(desiredMargin, desiredMargin, pageFormat.getWidth());
                log.debug("Changed xPos to {} for back side", (Object)xPos);
            } else {
                xPos = this.layoutHelper.calculateMargin(desiredMargin);
            }
            log.debug("xPos={} desiredMargin={} page width={}", new Object[]{xPos, desiredMargin, pageFormat.getWidth()});
            for (PageElement element : curPage.getElements()) {
                if (element instanceof Row) {
                    String brlStr = ((Row)element).getBraille();
                    if (!brlStr.isEmpty()) {
                        AttributedString braille = new AttributedString(brlStr, brailleAttributes);
                        g2d.drawString(braille.getIterator(), (float)xPos, (float)yPos);
                    }
                    yPos += lineHeight * (double)(1 + ((Row)element).getRowgap());
                    continue;
                }
                if (!(element instanceof Graphic)) continue;
                Graphic graphic = (Graphic)element;
                double height2 = lineHeight * (double)graphic.getHeight();
                double width2 = cellWidth * (double)graphic.getWidth();
                Image image = graphic.getImage();
                int imgWidth = image.getWidth(null);
                int imgHeight = image.getHeight(null);
                double scalingRatio = Math.min(width2 / (double)imgWidth, height2 / (double)imgHeight);
                g2d.drawImage(image, (int)xPos, (int)yPos - brailleMetrics.getAscent(), (int)((double)imgWidth * scalingRatio), (int)((double)imgHeight * scalingRatio), null);
                yPos += height2;
            }
            return 0;
        }
    }

    static class Graphic
    implements PageElement {
        private final Image image;
        private final int width;
        private final int height;
        private final int indent;

        public Graphic(Image image, int width2, int height2) {
            this(image, width2, height2, 0);
        }

        public Graphic(Image image, int width2, int height2, int indent2) {
            this.image = image;
            this.height = height2;
            this.indent = indent2;
            this.width = width2;
        }

        public Image getImage() {
            return this.image;
        }

        public int getHeight() {
            return this.height;
        }

        public int getIndent() {
            return this.indent;
        }

        public int getWidth() {
            return this.width;
        }

        public int hashCode() {
            return 31 + this.height + this.indent + this.width;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Graphic other = (Graphic)obj;
            if (this.height != other.height || this.indent != other.indent || this.width != other.width) {
                return false;
            }
            return ImageUtils.imageEquals((Image)this.image, (Image)other.image);
        }
    }

    static final class Row
    implements PageElement {
        private final String braille;
        private final int rowgap;

        Row(String braille) {
            this(braille, 0);
        }

        Row(String braille, int rowgap) {
            this.braille = braille;
            this.rowgap = rowgap;
        }

        String getBraille() {
            return this.braille;
        }

        int getRowgap() {
            return this.rowgap;
        }

        public int hashCode() {
            return this.braille.hashCode() + this.rowgap;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Row)) {
                return false;
            }
            Row otherRow = (Row)obj;
            return this.braille.equals(otherRow.braille) && this.rowgap == otherRow.rowgap;
        }
    }

    static interface PageElement {
    }

    static final class Page {
        private ImmutableList<PageElement> elements;

        Page() {
            this(Stream.empty());
        }

        Page(PageElement ... elements) {
            this(Arrays.stream(elements));
        }

        Page(Stream<PageElement> elements) {
            this.elements = (ImmutableList)elements.collect(ImmutableList.toImmutableList());
        }

        ImmutableList<PageElement> getElements() {
            return this.elements;
        }

        public int hashCode() {
            return this.elements.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Page)) {
                return false;
            }
            Page otherPage = (Page)obj;
            if (this.elements.size() != otherPage.elements.size()) {
                return false;
            }
            for (int i = 0; i < this.elements.size(); ++i) {
                PageElement e2;
                PageElement e1 = (PageElement)this.elements.get(i);
                if (Objects.equals(e1, e2 = (PageElement)otherPage.elements.get(i))) continue;
                return false;
            }
            return true;
        }
    }

    public static interface InterpointLayoutHelper
    extends LayoutHelper {
        public double calculateBackMargin(double var1, double var3, double var5);
    }

    public static interface LayoutHelper {
        public Map<TextAttribute, Object> getBrailleAttributes(BrlCell var1);

        public int getLineSpacing();

        public double calculateMargin(double var1);
    }

    public static class Builder {
        private LayoutHelper layoutHelper = new DefaultLayoutHelper();
        private boolean duplex = false;

        public Builder setLayoutHelper(LayoutHelper layoutHelper) {
            this.layoutHelper = (LayoutHelper)Preconditions.checkNotNull((Object)layoutHelper);
            return this;
        }

        public Builder setDuplex(boolean duplex2) {
            this.duplex = duplex2;
            return this;
        }

        public DocumentToPrintableHandler build() {
            return new DocumentToPrintableHandler(this.layoutHelper, this.duplex);
        }
    }
}

