/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utils;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.brailleblaster.utils.OS;
import org.brailleblaster.utils.Platform;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\b\u001a\u00020\u00072\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u000eH\u0002J\u001f\u0010 \u001a\u00020\u00072\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0007H\u0002J)\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u000e2\u0012\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010'J)\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u00072\u0012\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010(R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0010\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001f\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u000b\u001a\u0004\b \u0010\t\u00a8\u0006)"}, d2={"Lorg/brailleblaster/utils/BBData;", "", "<init>", "()V", "USERDATA_VERSION", "", "brailleblasterPath", "Ljava/io/File;", "getBrailleblasterPath", "()Ljava/io/File;", "brailleblasterPath$delegate", "Lkotlin/Lazy;", "pathParts", "", "", "([Ljava/lang/String;)Ljava/io/File;", "USERDATA_VERSION_FILE", "BB_USERDATA_NAME", "userHome", "getUserHome", "()Ljava/lang/String;", "moveUserDataEnabled", "", "getMoveUserDataEnabled", "()Z", "setMoveUserDataEnabled", "(Z)V", "makeUserDataFolder", "", "path", "reason", "userDataPath", "getUserDataPath", "userDataPath$delegate", "moveOldUserDataFolder", "userData", "newFile", "first", "parts", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/io/File;", "(Ljava/io/File;[Ljava/lang/String;)Ljava/io/File;", "utils"})
@SourceDebugExtension(value={"SMAP\nBBData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BBData.kt\norg/brailleblaster/utils/BBData\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n128#2,2:108\n1#3:110\n*S KotlinDebug\n*F\n+ 1 BBData.kt\norg/brailleblaster/utils/BBData\n*L\n100#1:108,2\n*E\n"})
public final class BBData {
    @NotNull
    public static final BBData INSTANCE = new BBData();
    private static final int USERDATA_VERSION = 7;
    @NotNull
    private static final Lazy brailleblasterPath$delegate = LazyKt.lazy(BBData::brailleblasterPath_delegate$lambda$0);
    @NotNull
    public static final String USERDATA_VERSION_FILE = ".bb_userdata_version";
    @NotNull
    private static final String BB_USERDATA_NAME = "brlblst";
    @NotNull
    private static final String userHome;
    private static boolean moveUserDataEnabled;
    @NotNull
    private static final Lazy userDataPath$delegate;

    private BBData() {
    }

    @NotNull
    public final File getBrailleblasterPath() {
        Lazy lazy = brailleblasterPath$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (File)object;
    }

    @NotNull
    public final File getBrailleblasterPath(String ... pathParts) {
        Intrinsics.checkNotNullParameter((Object)pathParts, (String)"pathParts");
        return this.newFile(this.getBrailleblasterPath(), Arrays.copyOf(pathParts, pathParts.length));
    }

    @NotNull
    public final String getUserHome() {
        return userHome;
    }

    public final boolean getMoveUserDataEnabled() {
        return moveUserDataEnabled;
    }

    public final void setMoveUserDataEnabled(boolean bl) {
        moveUserDataEnabled = bl;
    }

    private final void makeUserDataFolder(File path, String reason) {
        if (!moveUserDataEnabled) {
            throw new RuntimeException("Unexpected make user data" + reason);
        }
        path.mkdirs();
    }

    @NotNull
    public final File getUserDataPath() {
        Lazy lazy = userDataPath$delegate;
        return (File)lazy.getValue();
    }

    @NotNull
    public final File getUserDataPath(String ... pathParts) {
        Intrinsics.checkNotNullParameter((Object)pathParts, (String)"pathParts");
        return this.newFile(this.getUserDataPath(), Arrays.copyOf(pathParts, pathParts.length));
    }

    private final File moveOldUserDataFolder(File userData) {
        Object element$iv2;
        block1: {
            Sequence $this$first$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)new IntRange(0, Integer.MAX_VALUE))), arg_0 -> BBData.moveOldUserDataFolder$lambda$0(userData, arg_0));
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                File it = (File)element$iv2;
                boolean bl = false;
                if (!(!it.exists())) continue;
                break block1;
            }
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        File oldDataDir = (File)element$iv2;
        Files.move(userData.toPath(), oldDataDir.toPath(), new CopyOption[0]);
        return oldDataDir;
    }

    private final File newFile(String first, String ... parts) {
        String[] stringArray = Arrays.copyOf(parts, parts.length);
        Path path = Paths.get(first, Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        File file = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    private final File newFile(File first, String ... parts) {
        String string = first.getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalPath(...)");
        return this.newFile(string, Arrays.copyOf(parts, parts.length));
    }

    private static final File brailleblasterPath_delegate$lambda$0() {
        String string = System.getenv("BBLASTER_WORK");
        if (string == null && (string = System.getProperty("org.brailleblaster.distdir")) == null) {
            string = System.getProperty("app.dir", "");
        }
        return new File(string).getAbsoluteFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final File userDataPath_delegate$lambda$0() {
        File settingsDir;
        File utdDir;
        Object root;
        File file;
        if (Platform.getOs() == OS.Windows) {
            String string = System.getenv("APPDATA");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getenv(...)");
            String[] stringArray = new String[]{BB_USERDATA_NAME};
            file = INSTANCE.newFile(string, stringArray);
        } else {
            File oldPath = new File(userHome, ".brlblst");
            if (!oldPath.exists()) {
                if (Platform.getOs() == OS.Mac) {
                    File root2 = new File(userHome, "Library/Application Support");
                    file = new File(root2, BB_USERDATA_NAME);
                } else {
                    String xdgHome;
                    String string = System.getenv("XDG_CONFIG_HOME");
                    if (string == null) {
                        string = "";
                    }
                    root = !StringsKt.isBlank((CharSequence)(xdgHome = string)) ? new File(xdgHome) : new File(userHome, ".config");
                    file = new File((File)root, BB_USERDATA_NAME);
                }
            } else {
                file = oldPath;
            }
        }
        File userData = file;
        File versionFile = new File(userData, USERDATA_VERSION_FILE);
        if (!userData.exists()) {
            INSTANCE.makeUserDataFolder(userData, "User data folder does not exist.");
        } else if (!versionFile.exists()) {
            INSTANCE.moveOldUserDataFolder(userData);
            INSTANCE.makeUserDataFolder(userData, "User data too old");
        } else {
            int it22;
            root = new BufferedReader(new FileReader(versionFile));
            Throwable throwable = null;
            try {
                BufferedReader it22 = (BufferedReader)root;
                boolean bl = false;
                String string = it22.readLine();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readLine(...)");
                it22 = Integer.parseInt(string);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)root, (Throwable)throwable);
            }
            int version = it22;
            if (version < 7) {
                INSTANCE.moveOldUserDataFolder(userData);
                INSTANCE.makeUserDataFolder(userData, "User data too old");
            }
        }
        File programData = new File(userData, "programData");
        if (!programData.exists()) {
            programData.mkdir();
        }
        if (!(utdDir = new File(programData, "utd")).exists()) {
            utdDir.mkdir();
        }
        if (!(settingsDir = new File(programData, "settings")).exists()) {
            settingsDir.mkdir();
            String[] stringArray = new String[]{"programData", "settings", "user_settings.properties"};
            File defaultUserSettings = INSTANCE.getBrailleblasterPath(stringArray);
            FilesKt.copyTo$default((File)defaultUserSettings, (File)FilesKt.resolve((File)settingsDir, (String)"usr_settings.properties"), (boolean)false, (int)0, (int)6, null);
        }
        if (!versionFile.exists()) {
            Closeable closeable = new FileWriter(versionFile);
            Throwable throwable = null;
            try {
                FileWriter it = (FileWriter)closeable;
                boolean bl = false;
                it.append("7");
                it.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return userData;
    }

    private static final File moveOldUserDataFolder$lambda$0(File $userData, int it) {
        return new File($userData.getAbsolutePath() + ".old" + it);
    }

    static {
        String string = System.getProperty("user.home");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        userHome = string;
        moveUserDataEnabled = true;
        userDataPath$delegate = LazyKt.lazy(BBData::userDataPath_delegate$lambda$0);
    }
}

