/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007\u00a8\u0006\u000e"}, d2={"Lorg/brailleblaster/utils/LengthUtils;", "", "<init>", "()V", "inchesToMM", "", "inches", "mmToInches", "mm", "toLengthBigDecimal", "Ljava/math/BigDecimal;", "length", "", "Units", "utils"})
public final class LengthUtils {
    @NotNull
    public static final LengthUtils INSTANCE = new LengthUtils();

    private LengthUtils() {
    }

    @JvmStatic
    public static final double inchesToMM(double inches) {
        double denominator = 0.03937;
        return (double)MathKt.roundToInt((double)(inches / denominator * 10.0)) / 10.0;
    }

    @JvmStatic
    public static final double mmToInches(double mm) {
        double multiplier = 0.03937;
        return (double)MathKt.roundToInt((double)(mm * multiplier * 10000.0)) / 10000.0;
    }

    @JvmStatic
    @NotNull
    public static final BigDecimal toLengthBigDecimal(double length) {
        BigDecimal bigDecimal = new BigDecimal(length).setScale(2, RoundingMode.HALF_UP);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"setScale(...)");
        return bigDecimal;
    }

    @JvmStatic
    @NotNull
    public static final BigDecimal toLengthBigDecimal(@Nullable String length) {
        BigDecimal bigDecimal = new BigDecimal(length).setScale(2, RoundingMode.HALF_UP);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"setScale(...)");
        return bigDecimal;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\r"}, d2={"Lorg/brailleblaster/utils/LengthUtils$Units;", "", "multiplier", "", "<init>", "(Ljava/lang/String;II)V", "MILLIMETRES", "INCHES", "asUnits", "", "micrometres", "fromUnits", "measure", "utils"})
    public static final class Units
    extends Enum<Units> {
        private final int multiplier;
        public static final /* enum */ Units MILLIMETRES = new Units(1000);
        public static final /* enum */ Units INCHES = new Units(25400);
        private static final /* synthetic */ Units[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Units(int multiplier) {
            this.multiplier = multiplier;
        }

        public final double asUnits(int micrometres) {
            return (double)micrometres / (double)this.multiplier;
        }

        public final int fromUnits(double measure) {
            return (int)(measure * (double)this.multiplier);
        }

        public static Units[] values() {
            return (Units[])$VALUES.clone();
        }

        public static Units valueOf(String value) {
            return Enum.valueOf(Units.class, value);
        }

        @NotNull
        public static EnumEntries<Units> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = unitsArray = new Units[]{Units.MILLIMETRES, Units.INCHES};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

