/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utils;

import java.io.FilterInputStream;
import java.io.InputStream;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u0007H\u0016J \u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/brailleblaster/utils/PageFilterInputStream;", "Ljava/io/FilterInputStream;", "inputStream", "Ljava/io/InputStream;", "<init>", "(Ljava/io/InputStream;)V", "pageNumber", "", "getPageNumber", "()I", "setPageNumber", "(I)V", "markPageNumber", "read", "b", "", "off", "len", "skip", "", "n", "mark", "", "readlimit", "reset", "utils"})
@SourceDebugExtension(value={"SMAP\nPageFilterStreams.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PageFilterStreams.kt\norg/brailleblaster/utils/PageFilterInputStream\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1834#2,4:84\n*S KotlinDebug\n*F\n+ 1 PageFilterStreams.kt\norg/brailleblaster/utils/PageFilterInputStream\n*L\n36#1:84,4\n*E\n"})
public final class PageFilterInputStream
extends FilterInputStream {
    private int pageNumber;
    private int markPageNumber;

    public PageFilterInputStream(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        super(inputStream);
    }

    public final int getPageNumber() {
        return this.pageNumber;
    }

    public final void setPageNumber(int n) {
        this.pageNumber = n;
    }

    @Override
    public int read() {
        int c = super.read();
        if (c == 12) {
            int n = this.pageNumber;
            this.pageNumber = n + 1;
        }
        return c;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        int n;
        void $this$count$iv;
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int i = super.read(b, off, len);
        Iterable iterable = ArraysKt.slice((byte[])b, (IntRange)RangesKt.until((int)off, (int)(off + i)));
        int n2 = this.pageNumber;
        PageFilterInputStream pageFilterInputStream = this;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                byte it = ((Number)element$iv).byteValue();
                boolean bl = false;
                if (!(it == 12) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n3 = n;
        pageFilterInputStream.pageNumber = n2 + n3;
        return i;
    }

    @Override
    public long skip(long n) {
        long remaining;
        if (n <= 0L) {
            return 0L;
        }
        long chunk = 2048L;
        byte[] data = new byte[(int)chunk];
        int nr = 0;
        for (remaining = n; remaining > 0L && (nr = this.read(data, 0, (int)RangesKt.coerceAtMost((long)remaining, (long)chunk))) >= 0; remaining -= (long)nr) {
        }
        return n - remaining;
    }

    @Override
    public void mark(int readlimit) {
        this.markPageNumber = this.pageNumber;
        super.mark(readlimit);
    }

    @Override
    public void reset() {
        this.pageNumber = this.markPageNumber;
        super.reset();
    }
}

